/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.RoundChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.MultipleCategorySeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DefaultRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import java.util.ArrayList;

public class DoughnutChart
extends RoundChart {
    private MultipleCategorySeries mDataset;
    private int mStep;

    public DoughnutChart(MultipleCategorySeries dataset, DefaultRenderer renderer) {
        super(null, renderer);
        this.mDataset = dataset;
    }

    @Override
    public void draw(Canvas canvas, IControl control, int x, int y, int width, int height, Paint paint) {
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int legendSize = this.mRenderer.getLegendHeight();
        if (this.mRenderer.isShowLegend() && legendSize == 0) {
            legendSize = height / 5;
        }
        int left = x;
        int top = y;
        int right = x + width;
        int cLength = this.mDataset.getCategoriesCount();
        String[] categories = new String[cLength];
        for (int category = 0; category < cLength; ++category) {
            categories[category] = this.mDataset.getCategory(category);
        }
        if (this.mRenderer.isFitLegend()) {
            legendSize = this.drawLegend(canvas, this.mRenderer, categories, left, y, width, height, paint, true);
        }
        int bottom = y + height - legendSize;
        this.drawBackground(this.mRenderer, canvas, x, y, width, height, paint, false, 0);
        this.mStep = 7;
        int mRadius = Math.min(Math.abs(right - left), Math.abs(bottom - top));
        double rCoef = 0.35 * (double)this.mRenderer.getScale();
        double decCoef = 0.2 / (double)cLength;
        int radius = (int)((double)mRadius * rCoef);
        int centerX = (left + right) / 2;
        int centerY = (bottom + top) / 2;
        float shortRadius = (float)radius * 0.9f;
        float longRadius = (float)radius * 1.1f;
        ArrayList<RectF> prevLabelsBounds = new ArrayList<RectF>();
        for (int category = 0; category < cLength; ++category) {
            int sLength = this.mDataset.getItemCount(category);
            double total = 0.0;
            String[] titles = new String[sLength];
            for (int i = 0; i < sLength; ++i) {
                total += this.mDataset.getValues(category)[i];
                titles[i] = this.mDataset.getTitles(category)[i];
            }
            float currentAngle = 0.0f;
            RectF oval = new RectF((float)(centerX - radius), (float)(centerY - radius), (float)(centerX + radius), (float)(centerY + radius));
            for (int i = 0; i < sLength; ++i) {
                paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
                float value = (float)this.mDataset.getValues(category)[i];
                float angle = (float)((double)value / total * 360.0);
                canvas.drawArc(oval, currentAngle, angle, true, paint);
                this.drawLabel(canvas, this.mDataset.getTitles(category)[i], this.mRenderer, prevLabelsBounds, centerX, centerY, shortRadius, longRadius, currentAngle, angle, left, right, paint);
                currentAngle += angle;
            }
            radius = (int)((double)radius - (double)mRadius * decCoef);
            shortRadius = (float)((double)shortRadius - ((double)mRadius * decCoef - 2.0));
            if (this.mRenderer.getBackgroundColor() != 0) {
                paint.setColor(this.mRenderer.getBackgroundColor());
            } else {
                paint.setColor(-1);
            }
            paint.setStyle(Paint.Style.FILL);
            oval = new RectF((float)(centerX - radius), (float)(centerY - radius), (float)(centerX + radius), (float)(centerY + radius));
            canvas.drawArc(oval, 0.0f, 360.0f, true, paint);
            --radius;
        }
        prevLabelsBounds.clear();
        this.drawLegend(canvas, this.mRenderer, categories, left, y, width, height, paint, false);
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        --this.mStep;
        canvas.drawCircle(x + 10.0f - (float)this.mStep, y, (float)this.mStep, paint);
    }
}

