/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.RoundChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.CategorySeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DialRenderer;

public class DialChart
extends RoundChart {
    private static final int NEEDLE_RADIUS = 10;
    private DialRenderer mRenderer;

    public DialChart(CategorySeries dataset, DialRenderer renderer) {
        super(dataset, renderer);
        this.mRenderer = renderer;
    }

    @Override
    public void draw(Canvas canvas, IControl control, int x, int y, int width, int height, Paint paint) {
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int legendSize = this.mRenderer.getLegendHeight();
        if (this.mRenderer.isShowLegend() && legendSize == 0) {
            legendSize = height / 5;
        }
        int left = x;
        int top = y;
        int right = x + width;
        int sLength = this.mDataset.getItemCount();
        double total = 0.0;
        String[] titles = new String[sLength];
        for (int i = 0; i < sLength; ++i) {
            total += this.mDataset.getValue(i);
            titles[i] = this.mDataset.getCategory(i);
        }
        if (this.mRenderer.isFitLegend()) {
            legendSize = this.drawLegend(canvas, this.mRenderer, titles, left, y, width, height, paint, true);
        }
        int bottom = y + height - legendSize;
        this.drawBackground(this.mRenderer, canvas, x, y, width, height, paint, false, 0);
        int mRadius = Math.min(Math.abs(right - left), Math.abs(bottom - top));
        int radius = (int)((double)mRadius * 0.35 * (double)this.mRenderer.getScale());
        int centerX = (left + right) / 2;
        int centerY = (bottom + top) / 2;
        float shortRadius = (float)radius * 0.9f;
        float longRadius = (float)radius * 1.1f;
        double min = this.mRenderer.getMinValue();
        double max = this.mRenderer.getMaxValue();
        double angleMin = this.mRenderer.getAngleMin();
        double angleMax = this.mRenderer.getAngleMax();
        if (!this.mRenderer.isMinValueSet() || !this.mRenderer.isMaxValueSet()) {
            int count = this.mRenderer.getSeriesRendererCount();
            for (int i = 0; i < count; ++i) {
                double value = this.mDataset.getValue(i);
                if (!this.mRenderer.isMinValueSet()) {
                    min = Math.min(min, value);
                }
                if (this.mRenderer.isMaxValueSet()) continue;
                max = Math.max(max, value);
            }
        }
        if (min == max) {
            min *= 0.5;
            max *= 1.5;
        }
        paint.setColor(this.mRenderer.getLabelsColor());
        double minorTicks = this.mRenderer.getMinorTicksSpacing();
        double majorTicks = this.mRenderer.getMajorTicksSpacing();
        if (minorTicks == Double.MAX_VALUE) {
            minorTicks = (max - min) / 30.0;
        }
        if (majorTicks == Double.MAX_VALUE) {
            majorTicks = (max - min) / 10.0;
        }
        this.drawTicks(canvas, min, max, angleMin, angleMax, centerX, centerY, longRadius, radius, minorTicks, paint, false);
        this.drawTicks(canvas, min, max, angleMin, angleMax, centerX, centerY, longRadius, shortRadius, majorTicks, paint, true);
        int count = this.mRenderer.getSeriesRendererCount();
        for (int i = 0; i < count; ++i) {
            double angle = this.getAngleForValue(this.mDataset.getValue(i), angleMin, angleMax, min, max);
            paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
            boolean type = this.mRenderer.getVisualTypeForIndex(i) == DialRenderer.Type.ARROW;
            this.drawNeedle(canvas, angle, centerX, centerY, shortRadius, type, paint);
        }
        this.drawLegend(canvas, this.mRenderer, titles, left, y, width, height, paint, false);
    }

    private double getAngleForValue(double value, double minAngle, double maxAngle, double min, double max) {
        double angleDiff = maxAngle - minAngle;
        double diff = max - min;
        return Math.toRadians(minAngle + (value - min) * angleDiff / diff);
    }

    private void drawTicks(Canvas canvas, double min, double max, double minAngle, double maxAngle, int centerX, int centerY, double longRadius, double shortRadius, double ticks, Paint paint, boolean labels) {
        for (double i = min; i <= max; i += ticks) {
            double angle = this.getAngleForValue(i, minAngle, maxAngle, min, max);
            double sinValue = Math.sin(angle);
            double cosValue = Math.cos(angle);
            int x1 = Math.round((float)centerX + (float)(shortRadius * sinValue));
            int y1 = Math.round((float)centerY + (float)(shortRadius * cosValue));
            int x2 = Math.round((float)centerX + (float)(longRadius * sinValue));
            int y2 = Math.round((float)centerY + (float)(longRadius * cosValue));
            canvas.drawLine((float)x1, (float)y1, (float)x2, (float)y2, paint);
            if (!labels) continue;
            paint.setTextAlign(Paint.Align.LEFT);
            if (x1 <= x2) {
                paint.setTextAlign(Paint.Align.RIGHT);
            }
            String text = i + "";
            if (Math.round(i) == (long)i) {
                text = (long)i + "";
            }
            canvas.drawText(text, (float)x1, (float)y1, paint);
        }
    }

    private void drawNeedle(Canvas canvas, double angle, int centerX, int centerY, double radius, boolean arrow, Paint paint) {
        float[] points;
        double diff = Math.toRadians(90.0);
        int needleSinValue = (int)(10.0 * Math.sin(angle - diff));
        int needleCosValue = (int)(10.0 * Math.cos(angle - diff));
        int needleX = (int)(radius * Math.sin(angle));
        int needleY = (int)(radius * Math.cos(angle));
        int needleCenterX = centerX + needleX;
        int needleCenterY = centerY + needleY;
        if (arrow) {
            int arrowBaseX = centerX + (int)(radius * 0.85 * Math.sin(angle));
            int arrowBaseY = centerY + (int)(radius * 0.85 * Math.cos(angle));
            points = new float[]{arrowBaseX - needleSinValue, arrowBaseY - needleCosValue, needleCenterX, needleCenterY, arrowBaseX + needleSinValue, arrowBaseY + needleCosValue};
            float width = paint.getStrokeWidth();
            paint.setStrokeWidth(5.0f);
            canvas.drawLine((float)centerX, (float)centerY, (float)needleCenterX, (float)needleCenterY, paint);
            paint.setStrokeWidth(width);
        } else {
            points = new float[]{centerX - needleSinValue, centerY - needleCosValue, needleCenterX, needleCenterY, centerX + needleSinValue, centerY + needleCosValue};
        }
        this.drawPath(canvas, points, paint, true);
    }
}

