/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.XYChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYMultipleSeriesDataset;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYValueSeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYSeriesRenderer;

public class BubbleChart
extends XYChart {
    public static final String TYPE = "Bubble";
    private static final int SHAPE_WIDTH = 10;
    private static final int MIN_BUBBLE_SIZE = 2;
    private static final int MAX_BUBBLE_SIZE = 20;

    BubbleChart() {
    }

    public BubbleChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] points, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex) {
        XYSeriesRenderer renderer = (XYSeriesRenderer)seriesRenderer;
        paint.setColor(renderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        int length = points.length;
        XYValueSeries series = (XYValueSeries)this.mDataset.getSeriesAt(seriesIndex);
        double max = series.getMaxValue();
        double coef = 20.0 / max;
        for (int i = 0; i < length; i += 2) {
            double size = series.getValue(i / 2) * coef + 2.0;
            this.drawCircle(canvas, paint, points[i], points[i + 1], (float)size);
        }
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        this.drawCircle(canvas, paint, x + 10.0f, y, 3.0f);
    }

    private void drawCircle(Canvas canvas, Paint paint, float x, float y, float radius) {
        canvas.drawCircle(x, y, radius, paint);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

