/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.BackgroundDrawer;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DefaultRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;
import java.util.List;

public abstract class AbstractChart {
    public static final short CHART_AREA = 0;
    public static final short CHART_BAR = 1;
    public static final short CHART_LINE = 2;
    public static final short CHART_PIE = 3;
    public static final short CHART_SCATTER = 4;
    public static final short CHART_STOCK = 5;
    public static final short CHART_SURFACE = 6;
    public static final short CHART_DOUGHNUT = 7;
    public static final short CHART_BUBBLE = 8;
    public static final short CHART_RADAR = 9;
    public static final short CHART_UNKOWN = 10;
    public static final byte LegendPosition_Left = 0;
    public static final byte LegendPosition_Top = 1;
    public static final byte LegendPosition_Right = 2;
    public static final byte LegendPosition_Bottom = 3;
    private int categoryAxisTextColor = -16777216;
    protected byte legendPos = (byte)2;
    private Rectangle legendArea = null;

    public int getCategoryAxisTextColor() {
        return this.categoryAxisTextColor;
    }

    public void setCategoryAxisTextColor(int categoryAxisTextColor) {
        this.categoryAxisTextColor = categoryAxisTextColor;
    }

    public byte getLegendPosition() {
        return this.legendPos;
    }

    public void setLegendPosition(byte legendPos) {
        this.legendPos = legendPos;
    }

    public abstract void draw(Canvas var1, IControl var2, int var3, int var4, int var5, int var6, Paint var7);

    public abstract void setZoomRate(float var1);

    public abstract float getZoomRate();

    protected void drawBackground(DefaultRenderer renderer, Canvas canvas, int x, int y, int width, int height, Paint paint, boolean newColor, int color2) {
        if (renderer.isApplyBackgroundColor() || newColor) {
            if (newColor) {
                paint.setColor(color2);
            } else {
                paint.setColor(renderer.getBackgroundColor());
            }
            paint.setStyle(Paint.Style.FILL);
            canvas.drawRect((float)x, (float)y, (float)(x + width), (float)(y + height), paint);
        }
    }

    protected void drawBackgroundAndFrame(DefaultRenderer renderer, Canvas canvas, IControl control, Rect rect, Paint paint) {
        Line frame;
        int alpha = paint.getAlpha();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CCW);
        BackgroundAndFill fill = renderer.getBackgroundAndFill();
        if (fill != null) {
            paint.setStyle(Paint.Style.FILL);
            BackgroundDrawer.drawPathBackground(canvas, control, 1, fill, rect, null, 1.0f, path, paint);
            paint.setAlpha(alpha);
        }
        if ((frame = renderer.getChartFrame()) != null) {
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(2.0f);
            if (frame.isDash()) {
                DashPathEffect dashPathEffect = new DashPathEffect(new float[]{5.0f, 5.0f}, 10.0f);
                paint.setPathEffect((PathEffect)dashPathEffect);
            }
            BackgroundDrawer.drawPathBackground(canvas, null, 1, frame.getBackgroundAndFill(), rect, null, 1.0f, path, paint);
            paint.setStyle(Paint.Style.FILL);
            paint.setAlpha(alpha);
        }
        paint.reset();
        paint.setAntiAlias(true);
    }

    public Rectangle getMaxTitleAreaSize(int chartWidth, int chartHeight) {
        return new Rectangle((int)((float)chartWidth * 0.8f), chartHeight / 2);
    }

    public Rectangle getTitleTextAreaSize(DefaultRenderer renderer, int chartWidth, int chartHeight, Paint paint) {
        if (renderer.isShowChartTitle()) {
            float maxWidth = (float)chartWidth * 0.8f;
            float maxHeight = (float)chartHeight * 0.5f;
            return this.getTextSize(renderer.getChartTitle(), renderer.getChartTitleTextSize() * renderer.getZoomRate(), maxWidth, maxHeight, paint);
        }
        return null;
    }

    public Rectangle getTextSize(String text, float fontSize, float maxWidth, float maxHeight, Paint paint) {
        if (text == null || text.length() <= 0) {
            return null;
        }
        float titleHeight = 0.0f;
        paint.setTextSize(fontSize);
        Paint.FontMetrics fm = paint.getFontMetrics();
        float lineHeight = (float)Math.ceil(fm.descent - fm.ascent);
        float textWidth = paint.measureText(text);
        if (textWidth < maxWidth) {
            return new Rectangle((int)Math.ceil(textWidth), (int)Math.ceil(lineHeight));
        }
        String title = text;
        float[] charWidth = new float[]{};
        while (title.length() > 0 && titleHeight + lineHeight <= maxHeight) {
            int cnt = paint.breakText(title, true, maxWidth, charWidth);
            if (cnt == 0) {
                cnt = 1;
            }
            String drawedText = title.substring(0, cnt);
            if ((title = title.substring(cnt, title.length())).length() > 0 && titleHeight + lineHeight * 2.0f > maxHeight) {
                titleHeight += lineHeight;
                break;
            }
            titleHeight += lineHeight;
        }
        return new Rectangle((int)Math.ceil(maxWidth), (int)Math.ceil(titleHeight));
    }

    protected void drawTitle(Canvas canvas, String title, float zoom, float x, float y, float maxWidth, float maxHeight, Paint paint, float angle) {
        maxWidth *= zoom;
        maxHeight *= zoom;
        float initX = x *= zoom;
        float initY = y *= zoom;
        if (angle != 0.0f) {
            canvas.rotate(angle, initX, initY);
        }
        Paint.FontMetrics fm = paint.getFontMetrics();
        float lineHeight = (float)Math.ceil(fm.descent - fm.ascent);
        float textWidth = paint.measureText(title);
        if (textWidth < maxWidth) {
            canvas.drawText(title, x, y, paint);
        } else {
            float[] charWidth = new float[]{};
            float sum = 0.0f;
            while (title.length() > 0 && sum + lineHeight <= maxHeight) {
                int cnt = paint.breakText(title, true, maxWidth, charWidth);
                if (cnt == 0) {
                    cnt = 1;
                }
                String drawedText = title.substring(0, cnt);
                if ((title = title.substring(cnt, title.length())).length() > 0 && sum + lineHeight * 2.0f > maxHeight) {
                    drawedText = drawedText.substring(0, drawedText.length() - 1) + "...";
                    canvas.drawText(drawedText, x, y + fm.descent, paint);
                    y += lineHeight;
                    sum += lineHeight;
                    break;
                }
                canvas.drawText(drawedText, x, y + fm.descent, paint);
                y += lineHeight;
                sum += lineHeight;
            }
        }
        if (angle != 0.0f) {
            canvas.rotate(-angle, initX, initY);
        }
    }

    public int getMaxLegendWidth(float chartWidth) {
        if (this.legendPos == 0 || this.legendPos == 2) {
            return Math.round(chartWidth * 0.35f);
        }
        return Math.round(chartWidth * 0.9f);
    }

    public int getMaxLegendHeight(float chartHeight) {
        if (this.legendPos == 0 || this.legendPos == 2) {
            return Math.round(chartHeight * 0.9f);
        }
        return Math.round(chartHeight * 0.35f);
    }

    public Rectangle getLegendAutoSize(DefaultRenderer renderer, String[] titles, int chartWidth, int chartHeight, Paint paint) {
        if (!renderer.isShowLegend()) {
            return null;
        }
        float width = -1.0f;
        float height = -1.0f;
        paint.setTextSize(renderer.getLegendTextSize() * renderer.getZoomRate());
        int seriesCnt = Math.min(titles.length, renderer.getSeriesRendererCount());
        for (int i = 0; i < seriesCnt; ++i) {
            String text = titles[i].replace("\n", " ");
            Paint.FontMetrics fm = paint.getFontMetrics();
            height = Math.max((float)Math.ceil(fm.descent - fm.ascent), height);
            width = Math.max(paint.measureText(text), width);
        }
        float textOffset = (float)this.getLegendShapeWidth(0) * renderer.getZoomRate() * 2.0f;
        int maxLegendHeight = this.getMaxLegendHeight(chartHeight);
        int maxLegendWidth = this.getMaxLegendWidth(chartWidth);
        float maxLegendTextWidth = (float)maxLegendWidth - textOffset;
        int singleWidth = (int)Math.ceil(width + textOffset);
        int singleHeight = (int)Math.ceil(height);
        if (width > maxLegendTextWidth) {
            int lines = (int)Math.ceil(width / maxLegendTextWidth);
            this.legendArea = new Rectangle(maxLegendWidth, Math.min(singleHeight * lines * seriesCnt, maxLegendHeight));
        } else {
            switch (this.legendPos) {
                case 0: 
                case 2: {
                    this.legendArea = new Rectangle(singleWidth, Math.min(singleHeight * seriesCnt, maxLegendHeight));
                    break;
                }
                case 1: 
                case 3: {
                    int maxLineCnt = (int)((float)maxLegendWidth / (float)singleWidth);
                    if (seriesCnt > maxLineCnt) {
                        int lines = 2;
                        int lineCnt = (int)Math.ceil((float)seriesCnt / (float)lines);
                        while (lineCnt * singleWidth > maxLegendWidth) {
                            lineCnt = (int)Math.ceil((float)seriesCnt / (float)(++lines));
                        }
                        int lastCnt = seriesCnt - seriesCnt / lineCnt * lineCnt;
                        while (lastCnt < lineCnt - 1 && (int)Math.ceil((float)seriesCnt / (float)(lineCnt - 1)) == lines) {
                            --lineCnt;
                            lastCnt = lines - 1;
                        }
                        this.legendArea = new Rectangle(singleWidth * lineCnt, Math.min(singleHeight * lines, maxLegendHeight));
                        break;
                    }
                    this.legendArea = new Rectangle(singleWidth * seriesCnt, singleHeight);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return this.legendArea;
    }

    public Rectangle getSingleAutoLegendSize(DefaultRenderer renderer, String[] titles, Paint paint, int legendWidth) {
        float width = -1.0f;
        float height = -1.0f;
        paint.setTextSize(renderer.getLegendTextSize() * renderer.getZoomRate());
        int seriesCnt = Math.min(titles.length, renderer.getSeriesRendererCount());
        for (int i = 0; i < seriesCnt; ++i) {
            String text = titles[i].replace("\n", " ");
            Paint.FontMetrics fm = paint.getFontMetrics();
            height = Math.max((float)Math.ceil(fm.descent - fm.ascent), height);
            width = Math.max(paint.measureText(text), width);
        }
        float maxLegendTextWidth = (float)legendWidth - (float)this.getLegendShapeWidth(0) * renderer.getZoomRate() * 2.0f;
        if (width > maxLegendTextWidth) {
            int lines = (int)Math.ceil(width / maxLegendTextWidth);
            return new Rectangle(legendWidth, (int)Math.ceil(height) * lines);
        }
        return new Rectangle((int)Math.ceil(width + (float)this.getLegendShapeWidth(0) * renderer.getZoomRate() * 2.0f), (int)Math.ceil(height));
    }

    private float getLegendTextOffset(DefaultRenderer renderer) {
        return (float)(this.getLegendShapeWidth(0) * 2) * renderer.getZoomRate();
    }

    protected int drawLegend(Canvas canvas, DefaultRenderer renderer, String[] titles, int left, int top, int width, int height, Paint paint, boolean calculate) {
        if (renderer.isShowLegend()) {
            Rectangle singleLegendSize = this.getSingleAutoLegendSize(renderer, titles, paint, width);
            float currentX = left;
            float currentY = top;
            float right = left + width;
            paint.setTextAlign(Paint.Align.LEFT);
            paint.setTextSize(renderer.getLegendTextSize() * renderer.getZoomRate());
            Paint.FontMetrics fm = paint.getFontMetrics();
            int sLength = Math.min(titles.length, renderer.getSeriesRendererCount());
            block4: for (int i = 0; i < sLength; ++i) {
                float shapeWidth = (float)this.getLegendShapeWidth(i) * renderer.getZoomRate();
                String text = titles[i].replace("\n", " ");
                float sum = paint.measureText(text);
                float textOffset = this.getLegendTextOffset(renderer);
                float extraSize = textOffset + sum;
                switch (this.legendPos) {
                    case 0: 
                    case 2: {
                        String drawedText;
                        int cnt;
                        float[] charWidth;
                        float textWidth;
                        if (titles.length == renderer.getSeriesRendererCount()) {
                            paint.setColor(renderer.getSeriesRendererAt(i).getColor());
                        } else {
                            paint.setColor(-3355444);
                        }
                        this.drawLegendShape(canvas, renderer.getSeriesRendererAt(i), currentX, currentY, i, paint);
                        paint.setColor(this.categoryAxisTextColor);
                        if (extraSize > (float)width) {
                            textWidth = (float)width - textOffset;
                            charWidth = new float[]{};
                            while (text.length() > 0) {
                                cnt = paint.breakText(text, true, textWidth, charWidth);
                                if (cnt == 0) {
                                    cnt = 1;
                                }
                                drawedText = text.substring(0, cnt);
                                text = text.substring(cnt, text.length());
                                canvas.drawText(drawedText, currentX + 2.0f * shapeWidth, currentY + fm.descent, paint);
                                currentY = (float)((double)currentY + Math.ceil(fm.descent - fm.ascent));
                            }
                            continue block4;
                        }
                        canvas.drawText(text, currentX + 2.0f * shapeWidth, currentY + fm.descent, paint);
                        currentY += (float)singleLegendSize.height;
                        continue block4;
                    }
                    case 1: 
                    case 3: {
                        String drawedText;
                        int cnt;
                        if (extraSize <= (float)singleLegendSize.width) {
                            if (currentX + (float)singleLegendSize.width > right) {
                                currentY += (float)singleLegendSize.height;
                                currentX = (float)left * renderer.getZoomRate();
                                if (titles.length == renderer.getSeriesRendererCount()) {
                                    paint.setColor(renderer.getSeriesRendererAt(i).getColor());
                                } else {
                                    paint.setColor(-3355444);
                                }
                                this.drawLegendShape(canvas, renderer.getSeriesRendererAt(i), currentX, currentY, i, paint);
                                paint.setColor(this.categoryAxisTextColor);
                                canvas.drawText(text, currentX + 2.0f * shapeWidth, currentY + fm.descent, paint);
                                currentX += (float)singleLegendSize.width;
                                continue block4;
                            }
                            if (titles.length == renderer.getSeriesRendererCount()) {
                                paint.setColor(renderer.getSeriesRendererAt(i).getColor());
                            } else {
                                paint.setColor(-3355444);
                            }
                            this.drawLegendShape(canvas, renderer.getSeriesRendererAt(i), currentX, currentY, i, paint);
                            paint.setColor(this.categoryAxisTextColor);
                            canvas.drawText(text, currentX + 2.0f * shapeWidth, currentY + fm.descent, paint);
                            currentX += (float)singleLegendSize.width;
                            continue block4;
                        }
                        currentY += (float)singleLegendSize.height;
                        currentX = left;
                        if (titles.length == renderer.getSeriesRendererCount()) {
                            paint.setColor(renderer.getSeriesRendererAt(i).getColor());
                        } else {
                            paint.setColor(-3355444);
                        }
                        this.drawLegendShape(canvas, renderer.getSeriesRendererAt(i), currentX, currentY, i, paint);
                        paint.setColor(this.categoryAxisTextColor);
                        float textWidth = (float)width - textOffset;
                        float[] charWidth = new float[]{};
                        while (text.length() > 0) {
                            cnt = paint.breakText(text, true, textWidth, charWidth);
                            if (cnt == 0) {
                                cnt = 1;
                            }
                            drawedText = text.substring(0, cnt);
                            text = text.substring(cnt, text.length());
                            canvas.drawText(drawedText, currentX + 2.0f * shapeWidth, currentY + fm.descent, paint);
                            currentY = (float)((double)currentY + Math.ceil(fm.descent - fm.ascent));
                        }
                        continue block4;
                    }
                }
            }
        }
        return Math.round(renderer.getLegendTextSize() * renderer.getZoomRate());
    }

    protected boolean getExceed(float currentWidth, DefaultRenderer renderer, int right, int width) {
        boolean exceed;
        boolean bl = exceed = currentWidth > (float)right;
        if (this.isVertical(renderer)) {
            exceed = currentWidth > (float)width;
        }
        return exceed;
    }

    protected boolean isVertical(DefaultRenderer renderer) {
        return renderer instanceof XYMultipleSeriesRenderer && ((XYMultipleSeriesRenderer)renderer).getOrientation() == XYMultipleSeriesRenderer.Orientation.VERTICAL;
    }

    protected void drawPath(Canvas canvas, float[] points, Paint paint, boolean circular) {
        Path path = new Path();
        path.moveTo(points[0], points[1]);
        for (int i = 2; i < points.length; i += 2) {
            path.lineTo(points[i], points[i + 1]);
        }
        if (circular) {
            path.lineTo(points[0], points[1]);
        }
        canvas.drawPath(path, paint);
    }

    public abstract int getLegendShapeWidth(int var1);

    public abstract void drawLegendShape(Canvas var1, SimpleSeriesRenderer var2, float var3, float var4, int var5, Paint var6);

    private String getFitText(String text, float width, Paint paint) {
        String newText = text;
        int length = text.length();
        int diff = 0;
        while (paint.measureText(newText) > width && diff < length) {
            newText = text.substring(0, length - ++diff) + "...";
        }
        if (diff == length) {
            newText = "...";
        }
        return newText;
    }

    protected void drawLabel(Canvas canvas, String labelText, DefaultRenderer renderer, List<RectF> prevLabelsBounds, int centerX, int centerY, float shortRadius, float longRadius, float currentAngle, float angle, int left, int right, Paint paint) {
        if (renderer.isShowLabels()) {
            paint.setColor(renderer.getLabelsColor());
            double rAngle = Math.toRadians(90.0f - (currentAngle + angle / 2.0f));
            double sinValue = Math.sin(rAngle);
            double cosValue = Math.cos(rAngle);
            int x1 = Math.round((float)centerX + (float)((double)shortRadius * sinValue));
            int y1 = Math.round((float)centerY + (float)((double)shortRadius * cosValue));
            int x2 = Math.round((float)centerX + (float)((double)longRadius * sinValue));
            int y2 = Math.round((float)centerY + (float)((double)longRadius * cosValue));
            float size = renderer.getLabelsTextSize();
            float extra = Math.max(size / 2.0f, 10.0f);
            paint.setTextAlign(Paint.Align.LEFT);
            if (x1 > x2) {
                extra = -extra;
                paint.setTextAlign(Paint.Align.RIGHT);
            }
            float xLabel = (float)x2 + extra;
            float yLabel = y2;
            float width = (float)right - xLabel;
            if (x1 > x2) {
                width = xLabel - (float)left;
            }
            labelText = this.getFitText(labelText, width, paint);
            float widthLabel = paint.measureText(labelText);
            boolean okBounds = false;
            while (!okBounds) {
                boolean intersects = false;
                int length = prevLabelsBounds.size();
                for (int j = 0; j < length && !intersects; ++j) {
                    RectF prevLabelBounds = prevLabelsBounds.get(j);
                    if (!prevLabelBounds.intersects(xLabel, yLabel, xLabel + widthLabel, yLabel + size)) continue;
                    intersects = true;
                    yLabel = Math.max(yLabel, prevLabelBounds.bottom);
                }
                okBounds = !intersects;
            }
            y2 = (int)(yLabel - size / 2.0f);
            canvas.drawLine((float)x1, (float)y1, (float)x2, (float)y2, paint);
            canvas.drawLine((float)x2, (float)y2, (float)x2 + extra, (float)y2, paint);
            canvas.drawText(labelText, xLabel, yLabel, paint);
            prevLabelsBounds.add(new RectF(xLabel, yLabel, xLabel + widthLabel, yLabel + size));
        }
    }
}

