/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.Adapter;
import android.widget.AdapterView;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListAdapter;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListEventManage;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListItem;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.IPageListViewListener;
import java.util.LinkedList;

public class APageListView
extends AdapterView<Adapter> {
    private static final int GAP = 20;
    private boolean isDoRequestLayout = true;
    private boolean isConfigurationChanged;
    private boolean isInit;
    private boolean isInitZoom;
    private boolean isResetLayout;
    private float zoom = 1.0f;
    private int currentIndex;
    private IPageListViewListener pageListViewListener;
    private Adapter pageAdapter;
    private APageListEventManage eventManage;
    private SparseArray<APageListItem> childViewsCache = new SparseArray(3);
    private LinkedList<APageListItem> pageViewCache = new LinkedList();

    public APageListView(Context context) {
        super(context);
    }

    public APageListView(Context context, IPageListViewListener listener) {
        super(context);
        this.pageListViewListener = listener;
        this.eventManage = new APageListEventManage(this);
        this.pageAdapter = new APageListAdapter(this);
        this.setLongClickable(true);
        this.post(new Runnable(){

            @Override
            public void run() {
                if (APageListView.this.pageListViewListener != null && APageListView.this.pageListViewListener.isInit()) {
                    APageListView.this.init();
                }
            }
        });
    }

    public void init() {
        this.isInit = true;
        this.requestLayout();
    }

    public void requestLayout() {
        if (this.isDoRequestLayout) {
            super.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof APageListItem)) continue;
            APageListItem pv = (APageListItem)view;
            pv.measure(0x40000000 | (int)((float)pv.getPageWidth() * this.zoom), 0x40000000 | (int)((float)pv.getPageHeight() * this.zoom));
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float fitZoom;
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.isConfigurationChanged && this.zoom < (fitZoom = this.getFitZoom())) {
            this.setZoom(fitZoom, false);
            this.isInit = false;
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    APageListView.this.isInit = true;
                    APageListView.this.isResetLayout = true;
                    APageListView.this.requestLayout();
                }
            }, 1L);
            this.pageListViewListener.changeZoom();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        APageListItem pageView = this.getCurrentPageView();
        if (pageView != null && pageView.getControl().getSysKit().getCalloutManager().getDrawingMode() != 0) {
            return false;
        }
        this.eventManage.processOnTouch(event);
        this.pageListViewListener.onEventMethod((View)this, event, null, -1.0f, -1.0f, (byte)0);
        return true;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.isInit) {
            return;
        }
        if (this.pageListViewListener.getPageListViewMovingPosition() == 0) {
            this.layout_Horizontal();
        } else {
            this.layout_Vertical();
        }
        this.invalidate();
        if (this.isConfigurationChanged) {
            this.isConfigurationChanged = false;
            APageListItem pageView = this.getCurrentPageView();
            if (pageView != null) {
                this.postRepaint(pageView);
            }
        }
    }

    private void layout_Horizontal() {
        int gap;
        int cvTop;
        int cvLeft;
        Point cvOffset;
        APageListItem currentView = (APageListItem)this.childViewsCache.get(this.currentIndex);
        if (!this.isResetLayout) {
            int i;
            if (currentView != null && Math.abs(currentView.getLeft()) < currentView.getWidth()) {
                cvOffset = this.getScreenSizeOffset((View)currentView);
                if (currentView.getLeft() + currentView.getMeasuredWidth() + cvOffset.x + 10 + this.eventManage.getScrollX() < this.getWidth() / 2 && this.currentIndex + 1 < this.pageAdapter.getCount() && !this.eventManage.isOnFling()) {
                    this.postUnRepaint(currentView);
                    this.post(this.eventManage);
                    ++this.currentIndex;
                } else if (currentView.getLeft() - cvOffset.x - 10 + this.eventManage.getScrollX() >= this.getWidth() / 2 && this.currentIndex > 0 && !this.eventManage.isOnFling()) {
                    this.postUnRepaint(currentView);
                    this.post(this.eventManage);
                    --this.currentIndex;
                }
            }
            int numChildren = this.childViewsCache.size();
            int[] pIndexs = new int[numChildren];
            for (i = 0; i < numChildren; ++i) {
                pIndexs[i] = this.childViewsCache.keyAt(i);
            }
            for (i = 0; i < numChildren; ++i) {
                if (pIndexs[i] >= this.currentIndex - 1 && pIndexs[i] <= this.currentIndex + 1) continue;
                APageListItem pv = (APageListItem)this.childViewsCache.get(pIndexs[i]);
                pv.releaseResources();
                this.pageViewCache.add(pv);
                this.removeViewInLayout((View)pv);
                this.childViewsCache.remove(pIndexs[i]);
            }
        } else {
            int i;
            this.isResetLayout = false;
            boolean isRepaint = false;
            this.eventManage.setScrollAxisValue(0, 0);
            int numChildren = this.childViewsCache.size();
            int[] pIndexs = new int[numChildren];
            for (i = 0; i < numChildren; ++i) {
                pIndexs[i] = this.childViewsCache.keyAt(i);
            }
            for (i = 0; i < numChildren; ++i) {
                if (pIndexs[i] >= this.currentIndex - 1 && pIndexs[i] <= this.currentIndex + 1) continue;
                APageListItem pv = (APageListItem)this.childViewsCache.get(pIndexs[i]);
                pv.releaseResources();
                this.pageViewCache.add(pv);
                this.removeViewInLayout((View)pv);
                this.childViewsCache.remove(pIndexs[i]);
                isRepaint = pIndexs[i] == this.currentIndex;
            }
            if ((int)(this.zoom * 100.0f) != 100 || !isRepaint) {
                this.post(this.eventManage);
            }
        }
        boolean notPresent = currentView == null;
        currentView = this.createPageView(this.currentIndex);
        cvOffset = this.getScreenSizeOffset((View)currentView);
        if (notPresent) {
            cvLeft = cvOffset.x;
            cvTop = cvOffset.y;
        } else {
            cvLeft = currentView.getLeft() + this.eventManage.getScrollX();
            cvTop = currentView.getTop() + this.eventManage.getScrollY();
        }
        this.eventManage.setScrollAxisValue(0, 0);
        int cvRight = cvLeft + currentView.getMeasuredWidth();
        int cvBottom = cvTop + currentView.getMeasuredHeight();
        if (!this.eventManage.isTouchEventIn() && this.eventManage.isScrollerFinished()) {
            corr = this.getCorrection(this.getScrollBounds(cvLeft, cvTop, cvRight, cvBottom));
            cvRight += corr.x;
            cvLeft += corr.x;
            cvTop += corr.y;
            cvBottom += corr.y;
        } else if (currentView.getMeasuredHeight() <= this.getHeight()) {
            corr = this.getCorrection(this.getScrollBounds(cvLeft, cvTop, cvRight, cvBottom));
            cvTop += corr.y;
            cvBottom += corr.y;
        }
        currentView.layout(cvLeft, cvTop, cvRight, cvBottom);
        if (this.currentIndex > 0) {
            APageListItem preView = this.createPageView(this.currentIndex - 1);
            Point leftOffset = this.getScreenSizeOffset((View)preView);
            gap = leftOffset.x + 20 + cvOffset.x;
            preView.layout(cvLeft - preView.getMeasuredWidth() - gap, (cvBottom + cvTop - preView.getMeasuredHeight()) / 2, cvLeft - gap, (cvBottom + cvTop + preView.getMeasuredHeight()) / 2);
        }
        if (this.currentIndex + 1 < this.pageAdapter.getCount()) {
            APageListItem nextView = this.createPageView(this.currentIndex + 1);
            Point rightOffset = this.getScreenSizeOffset((View)nextView);
            gap = cvOffset.x + 20 + rightOffset.x;
            nextView.layout(cvRight + gap, (cvBottom + cvTop - nextView.getMeasuredHeight()) / 2, cvRight + nextView.getMeasuredWidth() + gap, (cvBottom + cvTop + nextView.getMeasuredHeight()) / 2);
        }
    }

    private void layout_Vertical() {
        int gap;
        int cvTop;
        int cvLeft;
        Point cvOffset;
        APageListItem currentView = (APageListItem)this.childViewsCache.get(this.currentIndex);
        if (!this.isResetLayout) {
            int i;
            if (currentView != null) {
                cvOffset = this.getScreenSizeOffset((View)currentView);
                if (currentView.getTop() + currentView.getMeasuredHeight() + cvOffset.y + 10 + this.eventManage.getScrollY() < this.getHeight() / 2 && this.currentIndex + 1 < this.pageAdapter.getCount() && !this.eventManage.isOnFling()) {
                    this.postUnRepaint(currentView);
                    this.post(this.eventManage);
                    ++this.currentIndex;
                    Log.e((String)"current ++", (String)String.valueOf(this.currentIndex));
                } else if (currentView.getTop() - cvOffset.y - 10 + this.eventManage.getScrollY() >= this.getHeight() / 2 && this.currentIndex > 0 && !this.eventManage.isOnFling()) {
                    this.postUnRepaint(currentView);
                    this.post(this.eventManage);
                    --this.currentIndex;
                    Log.e((String)"current --", (String)String.valueOf(this.currentIndex));
                }
            }
            int numChildren = this.childViewsCache.size();
            int[] pIndexs = new int[numChildren];
            for (i = 0; i < numChildren; ++i) {
                pIndexs[i] = this.childViewsCache.keyAt(i);
            }
            for (i = 0; i < numChildren; ++i) {
                if (pIndexs[i] >= this.currentIndex - 1 && pIndexs[i] <= this.currentIndex + 1) continue;
                APageListItem pv = (APageListItem)this.childViewsCache.get(pIndexs[i]);
                pv.releaseResources();
                this.pageViewCache.add(pv);
                this.removeViewInLayout((View)pv);
                this.childViewsCache.remove(pIndexs[i]);
            }
        } else {
            int i;
            this.isResetLayout = false;
            boolean isRepaint = false;
            this.eventManage.setScrollAxisValue(0, 0);
            int numChildren = this.childViewsCache.size();
            int[] pIndexs = new int[numChildren];
            for (i = 0; i < numChildren; ++i) {
                pIndexs[i] = this.childViewsCache.keyAt(i);
            }
            for (i = 0; i < numChildren; ++i) {
                if (pIndexs[i] >= this.currentIndex - 1 && pIndexs[i] <= this.currentIndex + 1) continue;
                APageListItem pv = (APageListItem)this.childViewsCache.get(pIndexs[i]);
                pv.releaseResources();
                this.pageViewCache.add(pv);
                this.removeViewInLayout((View)pv);
                this.childViewsCache.remove(pIndexs[i]);
                isRepaint = pIndexs[i] == this.currentIndex;
            }
            if ((int)(this.zoom * 100.0f) != 100 || !isRepaint) {
                this.post(this.eventManage);
            }
        }
        boolean notPresent = currentView == null;
        currentView = this.createPageView(this.currentIndex);
        cvOffset = this.getScreenSizeOffset((View)currentView);
        if (notPresent) {
            cvLeft = cvOffset.x;
            cvTop = cvOffset.y;
        } else {
            cvLeft = currentView.getLeft() + this.eventManage.getScrollX();
            cvTop = currentView.getTop() + this.eventManage.getScrollY();
        }
        this.eventManage.setScrollAxisValue(0, 0);
        int cvRight = cvLeft + currentView.getMeasuredWidth();
        int cvBottom = cvTop + currentView.getMeasuredHeight();
        if (!this.eventManage.isTouchEventIn() && this.eventManage.isScrollerFinished()) {
            corr = this.getCorrection(this.getScrollBounds(cvLeft, cvTop, cvRight, cvBottom));
            cvRight += corr.x;
            cvLeft += corr.x;
            cvTop += corr.y;
            cvBottom += corr.y;
        } else if (currentView.getMeasuredWidth() <= this.getWidth()) {
            corr = this.getCorrection(this.getScrollBounds(cvLeft, cvTop, cvRight, cvBottom));
            cvRight += corr.x;
            cvLeft += corr.x;
        }
        currentView.layout(cvLeft, cvTop, cvRight, cvBottom);
        if (this.currentIndex > 0) {
            APageListItem preView = this.createPageView(this.currentIndex - 1);
            Point leftOffset = this.getScreenSizeOffset((View)preView);
            gap = leftOffset.y + 20 + cvOffset.y;
            preView.layout(cvLeft, cvTop - gap - preView.getMeasuredHeight(), cvRight, cvBottom - gap - preView.getMeasuredHeight());
        }
        if (this.currentIndex + 1 < this.pageAdapter.getCount()) {
            APageListItem nextView = this.createPageView(this.currentIndex + 1);
            Point rightOffset = this.getScreenSizeOffset((View)nextView);
            gap = cvOffset.y + 20 + rightOffset.y;
            nextView.layout(cvLeft, cvTop + gap + nextView.getMeasuredHeight(), cvRight, cvBottom + gap + nextView.getMeasuredHeight());
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.isConfigurationChanged = true;
    }

    public void showPDFPageForIndex(final int index) {
        if (index < 0 || index >= this.pageAdapter.getCount()) {
            return;
        }
        this.currentIndex = index;
        this.postDelayed(new Runnable(){
            int gotoIndex;
            {
                this.gotoIndex = index;
            }

            @Override
            public void run() {
                if (this.gotoIndex == APageListView.this.currentIndex) {
                    APageListView.this.isResetLayout = true;
                    APageListView.this.requestLayout();
                }
            }
        }, 1L);
        this.pageListViewListener.updateStutus(null);
    }

    public void nextPageView() {
        if (this.currentIndex + 1 >= this.pageAdapter.getCount()) {
            return;
        }
        APageListItem pageView = (APageListItem)this.childViewsCache.get(this.currentIndex + 1);
        if (pageView != null) {
            ++this.currentIndex;
            this.eventManage.slideViewOntoScreen(pageView);
        } else {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    APageListView.this.isResetLayout = true;
                    APageListView.this.requestLayout();
                }
            }, 1L);
            this.pageListViewListener.updateStutus(null);
        }
    }

    public void previousPageview() {
        if (this.currentIndex == 0) {
            return;
        }
        APageListItem pageView = (APageListItem)this.childViewsCache.get(this.currentIndex - 1);
        if (pageView != null) {
            --this.currentIndex;
            this.eventManage.slideViewOntoScreen(pageView);
        }
    }

    public void exportImage(APageListItem view, Bitmap srcBitmap) {
        if (view.getPageIndex() != this.currentIndex || this.eventManage.isTouchEventIn() || !this.eventManage.isScrollerFinished()) {
            return;
        }
        this.pageListViewListener.exportImage(view, srcBitmap);
    }

    public boolean isPointVisibleOnScreen(int x, int y) {
        x = (int)((float)x * this.zoom);
        y = (int)((float)y * this.zoom);
        APageListItem item = this.getCurrentPageView();
        if (item == null) {
            return false;
        }
        int left = Math.max(item.getLeft(), 0) - item.getLeft();
        int top = Math.max(item.getTop(), 0) - item.getTop();
        return left < left + this.getWidth() && top < top + this.getHeight() && x >= left && x < left + this.getWidth() && y >= top && y < top + this.getHeight();
    }

    public void setItemPointVisibleOnScreen(int x, int y) {
        if (x < 0 && y < 0) {
            return;
        }
        APageListItem item = this.getCurrentPageView();
        if (item != null && !this.isPointVisibleOnScreen(x, y)) {
            View nextView;
            int gap;
            View preView;
            x = (int)((float)x * this.zoom);
            y = (int)((float)y * this.zoom);
            int cvLeft = 0;
            int cvRight = 0;
            int cvTop = 0;
            int cvBottom = 0;
            if (x > 0) {
                cvLeft = x + this.getWidth() > item.getMeasuredWidth() ? -(item.getMeasuredWidth() - this.getWidth()) : -x;
            }
            if (y > 0) {
                cvTop = y + this.getHeight() > item.getMeasuredHeight() ? -(item.getMeasuredHeight() - this.getHeight()) : -y;
            }
            Point cvOffset = this.getScreenSizeOffset((View)item);
            cvRight = cvLeft + item.getMeasuredWidth();
            cvBottom = cvTop + item.getMeasuredHeight();
            if (item.getMeasuredHeight() <= this.getHeight()) {
                Point corr = this.getCorrection(this.getScrollBounds(cvLeft, cvTop, cvRight, cvBottom));
                cvTop += corr.y;
                cvBottom += corr.y;
            }
            item.layout(cvLeft, cvTop, cvRight, cvBottom);
            if (this.currentIndex > 0 && (preView = (View)this.childViewsCache.get(this.currentIndex - 1)) != null) {
                Point leftOffset = this.getScreenSizeOffset(preView);
                gap = leftOffset.x + 20 + cvOffset.x;
                preView.layout(cvLeft - preView.getMeasuredWidth() - gap, (cvBottom + cvTop - preView.getMeasuredHeight()) / 2, cvLeft - gap, (cvBottom + cvTop + preView.getMeasuredHeight()) / 2);
            }
            if (this.currentIndex + 1 < this.pageAdapter.getCount() && (nextView = (View)this.childViewsCache.get(this.currentIndex + 1)) != null) {
                Point rightOffset = this.getScreenSizeOffset(nextView);
                gap = cvOffset.x + 20 + rightOffset.x;
                nextView.layout(cvRight + gap, (cvBottom + cvTop - nextView.getMeasuredHeight()) / 2, cvRight + nextView.getMeasuredWidth() + gap, (cvBottom + cvTop + nextView.getMeasuredHeight()) / 2);
            }
            this.postRepaint(item);
        }
    }

    public Object getModel() {
        return this.pageListViewListener.getModel();
    }

    public int getDisplayedPageIndex() {
        return this.currentIndex;
    }

    public void setZoom(float zoom, int pointX, int pointY) {
        this.setZoom(zoom, pointX, pointY, true);
    }

    public void setZoom(float zoomValue, boolean isRepaint) {
        this.setZoom(zoomValue, Integer.MIN_VALUE, Integer.MIN_VALUE, isRepaint);
    }

    public void setZoom(float zoomValue, int pointX, int pointY, final boolean isRepaint) {
        if ((int)(zoomValue * 1.0E7f) == (int)(this.zoom * 1.0E7f)) {
            return;
        }
        this.isInitZoom = true;
        if (pointX == Integer.MIN_VALUE && pointY == Integer.MIN_VALUE) {
            pointX = this.getWidth() / 2;
            pointY = this.getHeight() / 2;
        }
        float oldZoom = this.zoom;
        this.zoom = zoomValue;
        this.pageListViewListener.changeZoom();
        this.post(new Runnable(){

            @Override
            public void run() {
                APageListItem pageView;
                if (isRepaint && (pageView = APageListView.this.getCurrentPageView()) != null) {
                    APageListView.this.postRepaint(pageView);
                }
            }
        });
        if (isRepaint) {
            APageListItem v = this.getCurrentPageView();
            int left = 0;
            int top = 0;
            if (v != null) {
                left = v.getLeft();
                top = v.getTop();
            }
            float factor = this.zoom / oldZoom;
            int viewFocusX = pointX - (left + this.eventManage.getScrollX());
            int viewFocusY = pointY - (top + this.eventManage.getScrollY());
            this.eventManage.setScrollAxisValue((int)((float)viewFocusX - (float)viewFocusX * factor), (int)((float)viewFocusY - (float)viewFocusY * factor));
            this.requestLayout();
        }
    }

    public void setFitSize(int value) {
        this.setZoom(this.getFitZoom(value), true);
        this.postInvalidate();
    }

    public int getFitSizeState() {
        int state = 0;
        APageListItem item = this.getCurrentPageView();
        if (item != null) {
            int w = Math.abs(item.getWidth() - this.getWidth());
            int h = Math.abs(item.getHeight() - this.getHeight());
            if (w < 2 && h < 2) {
                state = 3;
            } else if (w < 2 && h >= 2) {
                state = 2;
            } else if (w >= 2 && h < 2) {
                state = 1;
            }
        }
        return state;
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getFitZoom() {
        return this.getFitZoom(0);
    }

    public float getFitZoom(int value) {
        if (this.currentIndex < 0 || this.currentIndex >= this.pageListViewListener.getPageCount()) {
            return 1.0f;
        }
        Rect rect = this.pageListViewListener.getPageSize(this.currentIndex);
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        for (ViewParent v = this.getParent(); viewWidth == 0 && v != null && v != null && v instanceof View; v = v.getParent()) {
            viewWidth = ((View)v).getWidth();
            viewHeight = ((View)v).getHeight();
        }
        if (viewWidth == 0 || viewHeight == 0) {
            return 1.0f;
        }
        float maxZoom = 3.0f;
        if (value == 0) {
            if (!this.pageListViewListener.isIgnoreOriginalSize()) {
                return Math.min(Math.min((float)viewWidth / (float)rect.width(), (float)viewHeight / (float)rect.height()), 1.0f);
            }
            return Math.min(Math.min((float)viewWidth / (float)rect.width(), (float)viewHeight / (float)rect.height()), maxZoom);
        }
        if (value == 1) {
            return Math.min((float)viewWidth / (float)rect.width(), maxZoom);
        }
        if (value == 2) {
            return Math.min((float)viewHeight / (float)rect.height(), maxZoom);
        }
        return 1.0f;
    }

    public int getCurrentPageNumber() {
        return this.currentIndex + 1;
    }

    public Adapter getAdapter() {
        return this.pageAdapter;
    }

    public void setAdapter(Adapter adapter) {
        this.pageAdapter = adapter;
    }

    public View getSelectedView() {
        return null;
    }

    public void setSelection(int position) {
    }

    protected void postUnRepaint(final APageListItem view) {
        if (view == null) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                view.removeRepaintImageView();
            }
        });
    }

    public void postRepaint(final APageListItem view) {
        if (view == null) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                view.addRepaintImageView(null);
            }
        });
    }

    public APageListItem getCurrentPageView() {
        if (this.childViewsCache != null) {
            return (APageListItem)this.childViewsCache.get(this.currentIndex);
        }
        return null;
    }

    protected IPageListViewListener getPageListViewListener() {
        return this.pageListViewListener;
    }

    private APageListItem createPageView(int pageIndex) {
        APageListItem pageView = (APageListItem)this.childViewsCache.get(pageIndex);
        if (pageView == null) {
            pageView = (APageListItem)this.pageAdapter.getView(pageIndex, this.pageViewCache.size() == 0 ? null : (View)this.pageViewCache.removeFirst(), (ViewGroup)this);
            ViewGroup.LayoutParams params = pageView.getLayoutParams();
            if (params == null) {
                params = new ViewGroup.LayoutParams(-2, -2);
            }
            this.addViewInLayout((View)pageView, 0, params, true);
            this.childViewsCache.append(pageIndex, (Object)pageView);
            pageView.measure(0x40000000 | (int)((float)pageView.getPageWidth() * this.zoom), 0x40000000 | (int)((float)pageView.getPageHeight() * this.zoom));
        }
        return pageView;
    }

    protected Rect getScrollBounds(int left, int top, int right, int bottom) {
        int xmin = this.getWidth() - right;
        int xmax = -left;
        int ymin = this.getHeight() - bottom;
        int ymax = -top;
        if (xmin > xmax) {
            xmin = xmax = (xmin + xmax) / 2;
        }
        if (ymin > ymax) {
            ymin = ymax = (ymin + ymax) / 2;
        }
        return new Rect(xmin, ymin, xmax, ymax);
    }

    protected Rect getScrollBounds(View v) {
        return this.getScrollBounds(v.getLeft() + this.eventManage.getScrollX(), v.getTop() + this.eventManage.getScrollY(), v.getLeft() + v.getMeasuredWidth() + this.eventManage.getScrollX(), v.getTop() + v.getMeasuredHeight() + this.eventManage.getScrollY());
    }

    protected Point getCorrection(Rect bounds) {
        return new Point(Math.min(Math.max(0, bounds.left), bounds.right), Math.min(Math.max(0, bounds.top), bounds.bottom));
    }

    protected Point getScreenSizeOffset(View v) {
        return new Point(Math.max((this.getWidth() - v.getMeasuredWidth()) / 2, 0), Math.max((this.getHeight() - v.getMeasuredHeight()) / 2, 0));
    }

    public int getPageCount() {
        return this.pageListViewListener.getPageCount();
    }

    protected APageListItem getPageListItem(int position, View convertView, ViewGroup parent) {
        return this.pageListViewListener.getPageListItem(position, convertView, parent);
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void setDoRequstLayout(boolean b) {
        this.isDoRequestLayout = b;
    }

    public boolean isInitZoom() {
        return this.isInitZoom;
    }

    public void setInitZoom(boolean isInitZoom) {
        this.isInitZoom = isInitZoom;
    }

    public void dispose() {
        this.pageListViewListener = null;
        if (this.eventManage != null) {
            this.eventManage.dispose();
            this.eventManage = null;
        }
        if (this.pageAdapter instanceof APageListAdapter) {
            ((APageListAdapter)this.pageAdapter).dispose();
            this.pageAdapter = null;
        }
        if (this.childViewsCache != null) {
            int size = this.childViewsCache.size();
            for (int i = 0; i < size; ++i) {
                ((APageListItem)this.childViewsCache.valueAt(i)).dispose();
            }
            this.childViewsCache.clear();
            this.childViewsCache = null;
        }
        if (this.pageViewCache != null) {
            for (APageListItem page : this.pageViewCache) {
                page.dispose();
            }
            this.pageViewCache.clear();
            this.pageViewCache = null;
        }
    }
}

