/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.Scroller;
import android.widget.Toast;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListItem;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListView;
import java.util.NoSuchElementException;

public class APageListEventManage
implements ScaleGestureDetector.OnScaleGestureListener,
GestureDetector.OnGestureListener,
Runnable,
View.OnTouchListener,
GestureDetector.OnDoubleTapListener,
View.OnClickListener {
    private static final int MOVING_DIAGONALLY = 0;
    private static final int MOVING_LEFT = 1;
    private static final int MOVING_RIGHT = 2;
    private static final int MOVING_UP = 3;
    private static final int MOVING_DOWN = 4;
    private static final float MAX_ZOOM = 3.0f;
    private boolean isOnFling;
    private boolean isOnScroll;
    private boolean isDoubleTap;
    private boolean isProcessOnScroll = true;
    private boolean isTouchEventIn;
    private boolean isScaling;
    private int mScrollerLastX;
    private int mScrollerLastY;
    private int mXScroll;
    private int mYScroll;
    private int eventPointerCount;
    private APageListView listView;
    private ScaleGestureDetector mScaleGestureDetector;
    protected GestureDetector gesture;
    protected Scroller mScroller;
    protected Toast toast = null;

    public APageListEventManage(APageListView listView) {
        this.listView = listView;
        this.gesture = new GestureDetector(listView.getContext(), (GestureDetector.OnGestureListener)this);
        this.mScroller = new Scroller(listView.getContext());
        this.mScaleGestureDetector = new ScaleGestureDetector(listView.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this);
        this.toast = Toast.makeText((Context)listView.getContext(), (CharSequence)"", (int)0);
    }

    protected boolean zoom(MotionEvent event) {
        return false;
    }

    protected boolean processOnTouch(MotionEvent event) {
        this.eventPointerCount = event.getPointerCount();
        if (event.getActionMasked() == 0) {
            this.isOnFling = false;
            this.isTouchEventIn = true;
        }
        if (this.mScaleGestureDetector != null) {
            this.mScaleGestureDetector.onTouchEvent(event);
        }
        if (!this.isScaling && this.gesture != null) {
            this.gesture.onTouchEvent(event);
        }
        if (event.getActionMasked() == 1) {
            this.isProcessOnScroll = true;
            this.isTouchEventIn = false;
            APageListItem pageView = this.listView.getCurrentPageView();
            if (pageView != null) {
                if (this.mScroller.isFinished() && !this.isDoubleTap) {
                    this.slideViewOntoScreen(pageView);
                }
                if (this.mScroller.isFinished() && this.isOnScroll) {
                    this.listView.getPageListViewListener().setDrawPictrue(true);
                    this.listView.postRepaint(pageView);
                }
            }
            this.isDoubleTap = false;
            this.isOnScroll = false;
            this.toast.cancel();
        }
        return true;
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.listView.getPageListViewListener().onEventMethod(v, event, null, -1.0f, -1.0f, (byte)0);
        return false;
    }

    public boolean onDown(MotionEvent e) {
        this.mScroller.forceFinished(true);
        this.listView.getPageListViewListener().onEventMethod((View)this.listView, e, null, -1.0f, -1.0f, (byte)1);
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        this.listView.getPageListViewListener().onEventMethod((View)this.listView, e1, e2, velocityX, velocityY, (byte)6);
        if (!this.isProcessOnScroll || this.isDoubleTap) {
            return true;
        }
        APageListItem pageView = this.listView.getCurrentPageView();
        if (pageView != null) {
            Rect bounds = this.listView.getScrollBounds((View)pageView);
            if (this.listView.getPageListViewListener().getPageListViewMovingPosition() == 0) {
                if (pageView.getWidth() <= this.listView.getWidth() || this.listView.getPageListViewListener().isChangePage()) {
                    switch (this.directionOfTravel(velocityX, velocityY)) {
                        case 1: {
                            if (bounds.left < 0) break;
                            this.isOnFling = true;
                            this.listView.nextPageView();
                            return true;
                        }
                        case 2: {
                            if (bounds.right > 0) break;
                            this.isOnFling = true;
                            this.listView.previousPageview();
                            return true;
                        }
                    }
                }
            } else if (pageView.getHeight() <= this.listView.getHeight() || this.listView.getPageListViewListener().isChangePage()) {
                switch (this.directionOfTravel(velocityX, velocityY)) {
                    case 3: {
                        if (bounds.top < 0) break;
                        this.isOnFling = true;
                        this.listView.nextPageView();
                        return true;
                    }
                    case 4: {
                        if (bounds.bottom > 0) break;
                        this.isOnFling = true;
                        this.listView.previousPageview();
                        return true;
                    }
                }
            }
            this.mScrollerLastY = 0;
            this.mScrollerLastX = 0;
            Rect expandedBounds = new Rect(bounds);
            expandedBounds.inset(-100, -100);
            if (this.withinBoundsInDirectionOfTravel(bounds, velocityX, velocityY) && expandedBounds.contains(0, 0)) {
                this.mScroller.fling(0, 0, (int)velocityX, (int)velocityY, bounds.left, bounds.right, bounds.top, bounds.bottom);
                this.listView.post(this);
            }
        }
        return true;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.listView.getPageListViewListener().onEventMethod((View)this.listView, e1, e2, distanceX, distanceY, (byte)4);
        if (this.isProcessOnScroll && !this.isDoubleTap) {
            APageListItem item;
            this.listView.getPageListViewListener().setDrawPictrue(false);
            this.isOnScroll = true;
            this.mXScroll = (int)((float)this.mXScroll - distanceX);
            this.mYScroll = (int)((float)this.mYScroll - distanceY);
            if (!this.listView.getPageListViewListener().isChangePage() && (item = this.listView.getCurrentPageView()) != null && item.getWidth() > this.listView.getWidth()) {
                if (distanceX > 0.0f) {
                    if (this.listView.getWidth() - this.mXScroll - item.getLeft() > item.getWidth() && item.getPageIndex() < this.listView.getPageCount() - 1) {
                        this.mXScroll = -(item.getWidth() - this.listView.getWidth() + item.getLeft());
                    }
                } else if (distanceX < 0.0f && this.mXScroll + item.getLeft() > 0 && item.getPageIndex() != 0) {
                    this.mXScroll = 0;
                }
            }
            this.listView.requestLayout();
        }
        return true;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        if (this.eventPointerCount <= 1 || !this.listView.getPageListViewListener().isTouchZoom()) {
            return true;
        }
        this.isTouchEventIn = true;
        float previousScale = this.listView.getZoom();
        float zoom = Math.min(Math.max(this.listView.getZoom() * detector.getScaleFactor(), this.listView.getFitZoom()), 3.0f);
        if ((int)(zoom * 1.0E7f) != (int)(previousScale * 1.0E7f)) {
            this.isOnScroll = true;
            float factor = zoom / previousScale;
            this.listView.setZoom(zoom, false);
            APageListItem v = this.listView.getCurrentPageView();
            if (v != null) {
                int viewFocusX = (int)detector.getFocusX() - (v.getLeft() + this.mXScroll);
                int viewFocusY = (int)detector.getFocusY() - (v.getTop() + this.mYScroll);
                this.mXScroll = (int)((float)this.mXScroll + ((float)viewFocusX - (float)viewFocusX * factor));
                this.mYScroll = (int)((float)this.mYScroll + ((float)viewFocusY - (float)viewFocusY * factor));
                this.listView.requestLayout();
            }
        }
        if (this.listView.getPageListViewListener().isShowZoomingMsg()) {
            this.toast.setText((CharSequence)(Math.round(zoom * 100.0f) + "%"));
            this.toast.show();
        }
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        if (this.eventPointerCount <= 1 || !this.listView.getPageListViewListener().isTouchZoom()) {
            return true;
        }
        this.isScaling = true;
        this.mYScroll = 0;
        this.mXScroll = 0;
        this.isProcessOnScroll = false;
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        if (this.eventPointerCount <= 1 || !this.listView.getPageListViewListener().isTouchZoom()) {
            return;
        }
        this.isScaling = false;
    }

    public void onShowPress(MotionEvent e) {
        this.listView.getPageListViewListener().onEventMethod((View)this.listView, e, null, -1.0f, -1.0f, (byte)2);
    }

    public boolean onSingleTapUp(MotionEvent e) {
        this.listView.getPageListViewListener().onEventMethod((View)this.listView, e, null, -1.0f, -1.0f, (byte)3);
        return false;
    }

    public void onLongPress(MotionEvent e) {
        this.listView.getPageListViewListener().onEventMethod((View)this.listView, e, null, -1.0f, -1.0f, (byte)5);
    }

    public void onClick(View v) {
        this.listView.getPageListViewListener().onEventMethod((View)this.listView, null, null, -1.0f, -1.0f, (byte)10);
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        this.listView.getPageListViewListener().onEventMethod((View)this.listView, e, null, -1.0f, -1.0f, (byte)7);
        return false;
    }

    public boolean onDoubleTap(MotionEvent e) {
        this.isProcessOnScroll = true;
        this.isTouchEventIn = false;
        this.isDoubleTap = true;
        this.listView.getPageListViewListener().onEventMethod((View)this.listView, e, null, -1.0f, -1.0f, (byte)8);
        return false;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        this.isTouchEventIn = false;
        this.isDoubleTap = true;
        this.listView.getPageListViewListener().onEventMethod((View)this.listView, e, null, -1.0f, -1.0f, (byte)9);
        return false;
    }

    @Override
    public void run() {
        if (!this.mScroller.isFinished()) {
            this.listView.getPageListViewListener().setDrawPictrue(false);
            this.mScroller.computeScrollOffset();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            this.mXScroll += x - this.mScrollerLastX;
            this.mYScroll += y - this.mScrollerLastY;
            this.mScrollerLastX = x;
            this.mScrollerLastY = y;
            this.listView.requestLayout();
            this.listView.post(this);
        } else if (!this.isTouchEventIn) {
            this.listView.postRepaint(this.listView.getCurrentPageView());
            this.listView.getPageListViewListener().updateStutus(null);
            this.listView.getPageListViewListener().setDrawPictrue(true);
        }
    }

    protected void slideViewOntoScreen(APageListItem pageItem) {
        Point corr = this.listView.getCorrection(this.listView.getScrollBounds((View)pageItem));
        if (corr.x != 0 || corr.y != 0) {
            this.mScrollerLastY = 0;
            this.mScrollerLastX = 0;
            this.mScroller.startScroll(0, 0, corr.x, corr.y, 400);
            this.listView.post(this);
        }
        this.listView.getPageListViewListener().resetSearchResult(pageItem);
    }

    protected int getScrollX() {
        return this.mXScroll;
    }

    protected int getScrollY() {
        return this.mYScroll;
    }

    protected void setScrollAxisValue(int x, int y) {
        this.mXScroll = x;
        this.mYScroll = y;
    }

    protected boolean isTouchEventIn() {
        return this.isTouchEventIn;
    }

    protected boolean isScrollerFinished() {
        return this.mScroller.isFinished();
    }

    protected boolean isOnFling() {
        return this.isOnFling;
    }

    protected int directionOfTravel(float vx, float vy) {
        if (Math.abs(vx) > 2.0f * Math.abs(vy)) {
            return vx > 0.0f ? 2 : 1;
        }
        if (Math.abs(vy) > 2.0f * Math.abs(vx)) {
            return vy > 0.0f ? 4 : 3;
        }
        return 0;
    }

    protected boolean withinBoundsInDirectionOfTravel(Rect bounds, float vx, float vy) {
        switch (this.directionOfTravel(vx, vy)) {
            case 0: {
                return bounds.contains(0, 0);
            }
            case 1: {
                return bounds.left <= 0;
            }
            case 2: {
                return bounds.right >= 0;
            }
            case 3: {
                return bounds.top <= 0;
            }
            case 4: {
                return bounds.bottom >= 0;
            }
        }
        throw new NoSuchElementException();
    }

    public void dispose() {
    }
}

