/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.system.beans;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import android.widget.Toast;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public abstract class AEventManage
implements View.OnTouchListener,
GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
View.OnClickListener {
    protected boolean isFling;
    protected boolean isScroll;
    protected boolean singleTabup = false;
    protected boolean zoomChange;
    protected int mMinimumVelocity;
    protected int mMaximumVelocity;
    protected int midXDoublePoint;
    protected int midYDoublePoint;
    protected int mActivePointerId = -1;
    protected float distance = 0.0f;
    protected IControl control;
    protected GestureDetector gesture;
    protected VelocityTracker mVelocityTracker;
    protected Scroller mScroller;
    protected Toast toast = null;

    public AEventManage(Context context, IControl control) {
        this.control = control;
        this.gesture = new GestureDetector(context, (GestureDetector.OnGestureListener)this, null, true);
        this.mScroller = new Scroller(context);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.toast = Toast.makeText((Context)context, (CharSequence)"", (int)0);
    }

    public boolean onTouch(View v, MotionEvent event) {
        boolean ret = false;
        try {
            if (this.gesture == null) {
                return false;
            }
            this.control.getMainFrame().onEventMethod(v, event, null, -1.0f, -1.0f, (byte)0);
            if (event.getPointerCount() == 2) {
                return this.zoom(event);
            }
            this.gesture.onTouchEvent(event);
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(event);
            int action = event.getAction();
            switch (action) {
                case 0: {
                    this.stopFling();
                    this.mActivePointerId = event.getPointerId(0);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (!this.singleTabup) {
                        VelocityTracker velocityTracker = this.mVelocityTracker;
                        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                        int initialYVelocity = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                        int initialXVelocity = (int)velocityTracker.getXVelocity(this.mActivePointerId);
                        if (Math.abs(initialYVelocity) > this.mMinimumVelocity || Math.abs(initialXVelocity) > this.mMinimumVelocity) {
                            if (!this.isScroll) {
                                boolean bl = this.isScroll = this.control.getApplicationType() == 2;
                            }
                            if (!this.zoomChange) {
                                this.fling(-initialXVelocity, -initialYVelocity);
                            }
                            ret = true;
                        }
                        this.midXDoublePoint = -1;
                        this.midYDoublePoint = -1;
                        this.mActivePointerId = -1;
                        if (this.mVelocityTracker != null) {
                            this.mVelocityTracker.recycle();
                            this.mVelocityTracker = null;
                        }
                        this.toast.cancel();
                        if (this.isScroll) {
                            this.isScroll = false;
                            if (this.control.getApplicationType() == 0 && this.zoomChange && !this.control.getMainFrame().isZoomAfterLayoutForWord()) {
                                this.control.actionEvent(0x2000000A, null);
                            }
                            if (this.control.getApplicationType() == 2) {
                                if (!this.control.isSlideShow()) {
                                    this.control.actionEvent(0x2000000A, null);
                                }
                            } else {
                                this.control.actionEvent(0x2000000A, null);
                            }
                            this.control.actionEvent(20, null);
                        }
                        if (this.control.getApplicationType() != 0) {
                            this.zoomChange = false;
                        }
                    }
                    this.singleTabup = false;
                    break;
                }
                case 3: {
                    this.mActivePointerId = -1;
                    if (this.mVelocityTracker == null) break;
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
            }
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
        }
        return ret;
    }

    protected boolean zoom(MotionEvent event) {
        float fitZoom;
        if (!this.control.getMainFrame().isTouchZoom()) {
            return true;
        }
        float zoom = ((Float)this.control.getActionValue(0x20000005, null)).floatValue();
        boolean isMinZoom = (int)(zoom * 10000.0f) == (int)((fitZoom = ((Float)this.control.getActionValue(0x20000006, null)).floatValue()) * 10000.0f);
        boolean zoomRateChanged = false;
        float dist = this.distance;
        int action = event.getActionMasked();
        switch (action) {
            case 5: {
                float x1 = event.getX(0);
                float y1 = event.getY(0);
                float x2 = event.getX(1);
                float y2 = event.getY(1);
                float min = Math.min(x1, x2);
                this.midXDoublePoint = (int)(min + Math.abs(x1 - x2) / 2.0f);
                min = Math.min(y1, y2);
                this.midYDoublePoint = (int)(min + Math.abs(y1 - y2) / 2.0f);
                this.distance = (float)(Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2)) / 2.0);
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                boolean increased;
                float tx1 = event.getX(0);
                float ty1 = event.getY(0);
                float tx2 = event.getX(1);
                float ty2 = event.getY(1);
                dist = (float)(Math.sqrt((tx1 - tx2) * (tx1 - tx2) + (ty1 - ty2) * (ty1 - ty2)) / 2.0);
                if (!(Math.abs(this.distance - dist) > 8.0f)) break;
                boolean bl = increased = dist > this.distance;
                if ((double)Math.abs(zoom - fitZoom) < 0.01 && !increased && isMinZoom) {
                    zoomRateChanged = false;
                } else if ((double)Math.abs(zoom - 3.0f) < 0.001 && increased) {
                    zoomRateChanged = false;
                } else {
                    float f = zoom = increased ? zoom + 0.1f : zoom - 0.1f;
                    if (zoom > 3.0f) {
                        zoom = 3.0f;
                    } else if (zoom < fitZoom) {
                        zoom = fitZoom;
                    }
                    if (increased && isMinZoom) {
                        zoom = (float)((int)(zoom * 10.0f)) / 10.0f;
                    }
                    zoomRateChanged = true;
                }
                this.distance = zoomRateChanged ? dist : this.distance;
                break;
            }
        }
        if (zoomRateChanged) {
            this.isScroll = true;
            this.zoomChange = true;
            this.control.actionEvent(0x20000005, new int[]{(int)(zoom * 10000.0f), this.midXDoublePoint, this.midYDoublePoint});
            this.control.getView().postInvalidate();
            if (this.control.getMainFrame().isShowZoomingMsg()) {
                if (this.control.getApplicationType() == 2 && this.control.isSlideShow()) {
                    return true;
                }
                this.toast.setText((CharSequence)(Math.round(zoom * 100.0f) + "%"));
                this.toast.show();
            }
        }
        return true;
    }

    public boolean onDown(MotionEvent e) {
        return this.control.getMainFrame().onEventMethod(this.control.getView(), e, null, -1.0f, -1.0f, (byte)1);
    }

    public void onShowPress(MotionEvent e) {
        this.control.getMainFrame().onEventMethod(this.control.getView(), e, null, -1.0f, -1.0f, (byte)2);
    }

    public boolean onSingleTapUp(MotionEvent e) {
        if (!this.isScroll) {
            this.singleTabup = true;
        }
        return this.control.getMainFrame().onEventMethod(this.control.getView(), e, null, -1.0f, -1.0f, (byte)3);
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.isScroll = true;
        return this.control.getMainFrame().onEventMethod(this.control.getView(), e1, e2, distanceX, distanceY, (byte)4);
    }

    public void onLongPress(MotionEvent e) {
        this.control.getMainFrame().onEventMethod(this.control.getView(), e, null, -1.0f, -1.0f, (byte)5);
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return this.control.getMainFrame().onEventMethod(this.control.getView(), e1, e2, velocityX, velocityY, (byte)6);
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return this.control.getMainFrame().onEventMethod(this.control.getView(), e, null, -1.0f, -1.0f, (byte)7);
    }

    public boolean onDoubleTap(MotionEvent e) {
        return this.control.getMainFrame().onEventMethod(this.control.getView(), e, null, -1.0f, -1.0f, (byte)8);
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        return this.control.getMainFrame().onEventMethod(this.control.getView(), e, null, -1.0f, -1.0f, (byte)9);
    }

    public void onClick(View v) {
        this.control.getMainFrame().onEventMethod(this.control.getView(), null, null, -1.0f, -1.0f, (byte)10);
    }

    public void computeScroll() {
        if (this.isFling && this.mScroller.isFinished()) {
            this.isFling = false;
            this.control.actionEvent(0x2000000A, null);
            this.control.actionEvent(20, null);
        }
    }

    public void fling(int velocityX, int velocityY) {
    }

    public void stopFling() {
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.isFling = true;
            this.mScroller.abortAnimation();
        }
    }

    public int getMiddleXOfDoublePoint() {
        return this.midXDoublePoint;
    }

    public int getMiddleYOfDoublePoint() {
        return this.midYDoublePoint;
    }

    public void dispose() {
        this.control = null;
        this.gesture = null;
        this.mVelocityTracker = null;
        this.toast = null;
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
        this.mScroller = null;
    }
}

