/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTable;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.TableFormatManager;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ModelUtil;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;

public class TableFormatView {
    private SheetView sheetView;

    public TableFormatView(SheetView sheetView) {
        this.sheetView = sheetView;
    }

    public void draw(Canvas canvas) {
        Paint paint = PaintKit.instance().getPaint();
        int oldColor = paint.getColor();
        canvas.save();
        TableFormatManager formatMgr = this.sheetView.getCurrentSheet().getWorkbook().getTableFormatManager();
        SSTable[] tables = this.sheetView.getCurrentSheet().getTables();
        if (tables != null && formatMgr != null) {
            for (SSTable table : tables) {
                if (table.isHeaderRowShown() && (table.getHeaderRowDxfId() >= 0 || table.getHeaderRowBorderDxfId() >= 0)) {
                    this.drawHeaderRowFormat(canvas, formatMgr, table, paint);
                }
                if (table.isTotalRowShown() && (table.getTotalsRowDxfId() >= 0 || table.getTotalsRowBorderDxfId() >= 0)) {
                    this.drawTotalRowFormat(canvas, formatMgr, table, paint);
                }
                if (table.getTableBorderDxfId() < 0) continue;
                this.drawTableBorders(canvas, formatMgr, table, paint);
            }
        }
        paint.setColor(oldColor);
        canvas.restore();
    }

    private void drawHeaderRowFormat(Canvas canvas, TableFormatManager formatMgr, SSTable table, Paint paint) {
        Workbook book = this.sheetView.getCurrentSheet().getWorkbook();
        CellRangeAddress ref = table.getTableReference();
        CellStyle headerRowDxf = formatMgr.getFormat(table.getHeaderRowDxfId());
        CellStyle headerRowBorderDxf = formatMgr.getFormat(table.getHeaderRowBorderDxfId());
        RectF rect = ModelUtil.instance().getCellAnchor(this.sheetView, ref.getFirstRow(), ref.getFirstColumn(), ref.getLastColumn());
        if (headerRowDxf != null) {
            this.drawFormatBorders(canvas, paint, book, headerRowDxf, rect);
        }
        if (headerRowBorderDxf != null) {
            this.drawFormatBorders(canvas, paint, book, headerRowBorderDxf, rect);
        }
    }

    private void drawTotalRowFormat(Canvas canvas, TableFormatManager formatMgr, SSTable table, Paint paint) {
        Workbook book = this.sheetView.getCurrentSheet().getWorkbook();
        CellRangeAddress ref = table.getTableReference();
        CellStyle totalsRowDxf = formatMgr.getFormat(table.getTotalsRowDxfId());
        CellStyle totalsRowBorderDxf = formatMgr.getFormat(table.getTotalsRowBorderDxfId());
        RectF rect = ModelUtil.instance().getCellAnchor(this.sheetView, ref.getLastRow(), ref.getFirstColumn(), ref.getLastColumn());
        if (totalsRowDxf != null) {
            this.drawFormatBorders(canvas, paint, book, totalsRowDxf, rect);
        }
        if (totalsRowBorderDxf != null) {
            this.drawFormatBorders(canvas, paint, book, totalsRowBorderDxf, rect);
        }
    }

    private void drawTableBorders(Canvas canvas, TableFormatManager formatMgr, SSTable table, Paint paint) {
        RectF rect = ModelUtil.instance().getCellRangeAddressAnchor(this.sheetView, table.getTableReference());
        this.drawFormatBorders(canvas, paint, this.sheetView.getCurrentSheet().getWorkbook(), formatMgr.getFormat(table.getTableBorderDxfId()), rect);
    }

    private void drawFormatBorders(Canvas canvas, Paint paint, Workbook book, CellStyle headerRowDxf, RectF rect) {
        if (rect.left > (float)this.sheetView.getRowHeaderWidth() && headerRowDxf.getBorderLeft() != 0) {
            paint.setColor(book.getColor(headerRowDxf.getBorderLeftColorIdx()));
            canvas.drawRect(rect.left, rect.top, rect.left + 1.0f, rect.bottom, paint);
        }
        if (rect.top > (float)this.sheetView.getColumnHeaderHeight() && headerRowDxf.getBorderTop() != 0) {
            paint.setColor(book.getColor(headerRowDxf.getBorderTopColorIdx()));
            canvas.drawRect(rect.left, rect.top, rect.right, rect.top + 1.0f, paint);
        }
        if (rect.right > (float)this.sheetView.getRowHeaderWidth() && headerRowDxf.getBorderRight() != 0) {
            paint.setColor(book.getColor(headerRowDxf.getBorderRightColorIdx()));
            canvas.drawRect(rect.right, rect.top, rect.right + 1.0f, rect.bottom, paint);
        }
        if (rect.bottom > (float)this.sheetView.getColumnHeaderHeight() && headerRowDxf.getBorderBottom() != 0) {
            paint.setColor(book.getColor(headerRowDxf.getBorderBottomColorIdx()));
            canvas.drawRect(rect.left, rect.bottom, rect.right, rect.bottom + 1.0f, paint);
        }
    }
}

