/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.FontKit;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElementCollection;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.STDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.STRoot;
import com.ahmadullahpk.alldocumentreader.xs.ss.control.Spreadsheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty.ColumnInfo;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTable;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTableCellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.DrawingCell;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.ExpandedCellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.FindingMgr;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.FocusCell;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.SheetScroller;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ModelUtil;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.CellView;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.ColumnHeader;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.RowHeader;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.ShapeView;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.TableFormatView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SheetView {
    public static final int MAXROW_03 = 65536;
    public static final int MAXCOLUMN_03 = 256;
    public static final int MAXROW_07 = 0x100000;
    public static final int MAXCOLUMN_07 = 16384;
    private Sheet sheet;
    private RowHeader rowHeader;
    private ColumnHeader columnHeader;
    private Spreadsheet spreadsheet;
    private float zoom = 1.0f;
    private Rect clipRect;
    private float scrollX;
    private float scrollY;
    private ShapeView shapeView;
    private TableFormatView tableFormatView;
    private CellView cellView = null;
    private SheetScroller sheetScroller = new SheetScroller();
    private DrawingCell cellInfor;
    private CellRangeAddress selecetedCellsRange;
    private boolean isDrawMovingHeaderLine;
    private FocusCell selectedHeaderInfor;
    private PathEffect effects = new DashPathEffect(new float[]{5.0f, 5.0f, 5.0f, 5.0f}, 1.0f);
    private FindingMgr findingMgr;
    private List<ExtendCell> extendCell = new ArrayList<ExtendCell>();

    public SheetView(Spreadsheet spreadsheet, Sheet sheet) {
        this.spreadsheet = spreadsheet;
        this.sheet = sheet;
        this.rowHeader = new RowHeader(this);
        this.columnHeader = new ColumnHeader(this);
        this.shapeView = new ShapeView(this);
        this.tableFormatView = new TableFormatView(this);
        this.cellView = new CellView(this);
        this.selecetedCellsRange = new CellRangeAddress(0, 0, 0, 0);
        this.cellInfor = new DrawingCell();
        this.initForDrawing();
    }

    private void initForDrawing() {
        this.scrollX = this.sheet.getScrollX();
        this.scrollY = this.sheet.getScrollY();
        this.sheetScroller.update(this.sheet, Math.round(this.scrollX), Math.round(this.scrollY));
        this.setZoom(this.sheet.getZoom(), true);
        this.selectedCell(this.sheet.getActiveCellRow(), this.sheet.getActiveCellColumn());
        this.spreadsheet.getControl().actionEvent(0x20000007, this.cellInfor);
    }

    private void resizeCalloutView() {
        if (this.spreadsheet.getCalloutView() != null) {
            this.spreadsheet.getCalloutView().setZoom(this.zoom);
            int left = (int)(this.scrollX * this.zoom);
            int top = (int)(this.scrollY * this.zoom);
            this.spreadsheet.getCalloutView().layout(this.getRowHeaderWidth() - left, this.getColumnHeaderHeight() - top, this.spreadsheet.getCalloutView().getRight(), this.spreadsheet.getCalloutView().getBottom());
            this.spreadsheet.getCalloutView().setClip(left, top);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSheet(Sheet sheet) {
        SheetView sheetView = this;
        synchronized (sheetView) {
            this.sheet.removeSTRoot();
            this.sheet = sheet;
            this.initForDrawing();
            this.resizeCalloutView();
            this.spreadsheet.post(new Runnable(){

                @Override
                public void run() {
                    SheetView.this.spreadsheet.getControl().actionEvent(0x2000000A, null);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getThumbnail(Sheet sheet, int width, int height, float zoomValue) {
        SheetView sheetView = this;
        synchronized (sheetView) {
            Bitmap bitmap = Bitmap.createBitmap((int)((int)((float)width * zoomValue)), (int)((int)((float)height * zoomValue)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (bitmap == null) {
                return null;
            }
            boolean b = PictureKit.instance().isDrawPictrue();
            PictureKit.instance().setDrawPictrue(true);
            Canvas picCanvas = new Canvas(bitmap);
            picCanvas.drawColor(-1);
            int oldScrollX = sheet.getScrollX();
            int oldScrollY = sheet.getScrollY();
            float oldZoom = sheet.getZoom();
            Sheet oldSheet = this.sheet;
            this.sheet = sheet;
            this.scrollX = 0.0f;
            this.scrollY = 0.0f;
            sheet.setScroll(0, 0);
            this.setZoom(zoomValue, true);
            this.sheetScroller.update(sheet, Math.round(this.scrollX), Math.round(this.scrollY));
            this.drawThumbnail(picCanvas);
            sheet.setScroll(oldScrollX, oldScrollY);
            sheet.setZoom(oldZoom);
            this.sheet = oldSheet;
            this.scrollX = oldSheet.getScrollX();
            this.scrollY = oldSheet.getScrollY();
            this.setZoom(oldSheet.getZoom(), true);
            this.sheetScroller.update(sheet, Math.round(this.scrollX), Math.round(this.scrollY));
            PictureKit.instance().setDrawPictrue(b);
            return bitmap;
        }
    }

    private void drawThumbnail(Canvas canvas) {
        this.spreadsheet.startDrawing();
        this.clipRect = canvas.getClipBounds();
        int colRightBound = this.columnHeader.getColumnRightBound(canvas, this.zoom);
        int rowBottomBound = this.rowHeader.getRowBottomBound(canvas, this.zoom);
        int rightPos = this.clipRect.right + 10;
        if (colRightBound < this.clipRect.right) {
            rightPos = colRightBound;
        }
        int bottomPos = this.clipRect.bottom + 50;
        if (rowBottomBound < this.clipRect.bottom) {
            bottomPos = rowBottomBound;
        }
        this.rowHeader.draw(canvas, rightPos, this.zoom);
        this.columnHeader.draw(canvas, bottomPos, this.zoom);
        float rowWidth = this.rowHeader.getRowHeaderWidth();
        float columnHeight = this.columnHeader.getColumnHeaderHeight();
        canvas.save();
        canvas.clipRect(rowWidth, columnHeight, (float)rightPos, (float)bottomPos);
        this.drawRows(canvas);
        this.tableFormatView.draw(canvas);
        this.shapeView.draw(canvas);
        canvas.restore();
    }

    public int getMaxScrollY() {
        return Math.round(this.sheet.getMaxScrollY() * this.zoom);
    }

    public int getMaxScrollX() {
        return Math.round(this.sheet.getMaxScrollX() * this.zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSheet(Canvas canvas) {
        SheetView sheetView = this;
        synchronized (sheetView) {
            this.spreadsheet.startDrawing();
            this.clipRect = canvas.getClipBounds();
            int colRightBound = this.columnHeader.getColumnRightBound(canvas, this.zoom);
            int rowBottomBound = this.rowHeader.getRowBottomBound(canvas, this.zoom);
            int rightPos = this.clipRect.right + 10;
            if (colRightBound < this.clipRect.right) {
                rightPos = colRightBound;
            }
            int bottomPos = this.clipRect.bottom + 50;
            if (rowBottomBound < this.clipRect.bottom) {
                bottomPos = rowBottomBound;
            }
            this.rowHeader.draw(canvas, rightPos, this.zoom);
            this.columnHeader.draw(canvas, bottomPos, this.zoom);
            float rowWidth = this.rowHeader.getRowHeaderWidth();
            float columnHeight = this.columnHeader.getColumnHeaderHeight();
            canvas.save();
            canvas.clipRect(rowWidth, columnHeight, (float)rightPos, (float)bottomPos);
            this.drawRows(canvas);
            this.tableFormatView.draw(canvas);
            this.drawActiveCellBorder(canvas);
            this.shapeView.draw(canvas);
            this.drawMovingHeaderLine(canvas);
            canvas.restore();
        }
    }

    private void drawActiveCellBorder(Canvas canvas) {
        RectF area = ModelUtil.instance().getCellAnchor(this, this.sheet.getActiveCellRow(), this.sheet.getActiveCellColumn());
        this.cellView.drawActiveCellBorder(canvas, area, this.sheet.getActiveCellType());
    }

    private void drawMovingHeaderLine(Canvas canvas) {
        if (this.isDrawMovingHeaderLine && this.selectedHeaderInfor != null) {
            Paint paint = PaintKit.instance().getPaint();
            int oldColor = paint.getColor();
            PathEffect oldPathEffect = paint.getPathEffect();
            Rect clipRect = canvas.getClipBounds();
            paint.setColor(-16777216);
            paint.setStyle(Paint.Style.STROKE);
            Path path = new Path();
            if (this.selectedHeaderInfor.getType() == 1) {
                path.moveTo(0.0f, (float)this.selectedHeaderInfor.getRect().bottom);
                path.lineTo((float)clipRect.right, (float)this.selectedHeaderInfor.getRect().bottom);
            } else if (this.selectedHeaderInfor.getType() == 2) {
                path.moveTo((float)this.selectedHeaderInfor.getRect().right, 0.0f);
                path.lineTo((float)this.selectedHeaderInfor.getRect().right, (float)clipRect.bottom);
            }
            paint.setPathEffect(this.effects);
            canvas.drawPath(path, paint);
            paint.setPathEffect(oldPathEffect);
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(oldColor);
        }
    }

    private int getExtendTextRightBound(Row row, int currentCol, float textWidth) {
        int columnIndex = currentCol + 1;
        while (textWidth > 0.0f) {
            String content;
            Cell cell = row.getCell(columnIndex, false);
            if (cell == null || cell.getRangeAddressIndex() < 0 && ((content = ModelUtil.instance().getFormatContents(this.sheet.getWorkbook(), cell)) == null || content.length() == 0)) {
                textWidth -= this.sheet.getColumnPixelWidth(columnIndex) * this.zoom;
            } else {
                return columnIndex - 1;
            }
            ++columnIndex;
        }
        return columnIndex - 1;
    }

    private int getExtendTextLeftBound(Row row, int currentCol, float textWidth) {
        int columnIndex;
        for (columnIndex = currentCol - 1; columnIndex >= 0 && textWidth > 0.0f; textWidth -= this.sheet.getColumnPixelWidth(columnIndex) * this.zoom, --columnIndex) {
            String content;
            Cell cell = row.getCell(columnIndex, false);
            if (cell == null || cell.getRangeAddressIndex() < 0 && ((content = ModelUtil.instance().getFormatContents(this.sheet.getWorkbook(), cell)) == null || content.length() == 0)) {
                continue;
            }
            return columnIndex + 1;
        }
        return columnIndex + 1;
    }

    public int getIndentWidth(int indent) {
        double fontSize = this.sheet.getWorkbook().getFont(0).getFontSize();
        return (int)Math.round(2.0 * fontSize * (double)indent * 1.3333333730697632);
    }

    public int getIndentWidthWithZoom(int indent) {
        double fontSize = this.sheet.getWorkbook().getFont(0).getFontSize();
        return (int)Math.round(2.0 * fontSize * (double)indent * 1.3333333730697632 * (double)this.zoom);
    }

    private void initRowExtendedRangeAddress(Row row) {
        Collection<Cell> cells = row.cellCollection();
        for (Cell cell : cells) {
            float indent;
            float colsWidth = this.sheet.getColumnPixelWidth(cell.getColNumber()) * this.zoom;
            if (cell.getCellStyle() != null && cell.getCellStyle().isWrapText() || cell.getCellType() == 4 || cell.getCellNumericType() == 10 || cell.getCellType() == 0 && cell.getCellNumericType() != 11) continue;
            float restWidth = 0.0f;
            CellStyle style2 = cell.getCellStyle();
            float f = indent = style2 != null ? (float)this.getIndentWidth(style2.getIndent()) : 0.0f;
            if (CellView.isComplexText(cell)) {
                Rect rect = ModelUtil.instance().getCellAnchor(this.sheet, cell.getRowNumber(), cell.getColNumber());
                SectionElement elem = (SectionElement)cell.getSheet().getWorkbook().getSharedItem(cell.getStringCellValueIndex());
                if (elem == null || elem.getEndOffset() - elem.getStartOffset() == 0L) continue;
                IElementCollection elemCollection = elem.getParaCollection();
                ArrayList<Integer> paraHorAlignList = new ArrayList<Integer>(elemCollection.size());
                for (int i = 0; i < elemCollection.size(); ++i) {
                    paraHorAlignList.add(AttrManage.instance().getParaHorizontalAlign(elemCollection.getElementForIndex(i).getAttribute()));
                    AttrManage.instance().setParaHorizontalAlign(elemCollection.getElementForIndex(i).getAttribute(), 0);
                }
                IAttributeSet attr = elem.getAttribute();
                AttrManage.instance().setPageWidth(attr, Math.round(3.2212255E10f));
                AttrManage.instance().setPageHeight(attr, Math.round((float)rect.height() * 15.0f));
                STDocument doc = new STDocument();
                doc.appendSection(elem);
                STRoot root = new STRoot(this.spreadsheet.getEditor(), doc);
                root.setWrapLine(false);
                root.doLayout();
                IView paraView = root.getChildView();
                int lineWidth = paraView.getLayoutSpan((byte)0);
                root.dispose();
                AttrManage.instance().setPageWidth(attr, Math.round(((float)lineWidth + indent + 4.0f) * 15.0f));
                root = new STRoot(this.spreadsheet.getEditor(), doc);
                root.doLayout();
                for (int i = 0; i < elemCollection.size(); ++i) {
                    AttrManage.instance().setParaHorizontalAlign(elemCollection.getElementForIndex(i).getAttribute(), (Integer)paraHorAlignList.get(i));
                }
                restWidth = (float)((int)(((float)lineWidth + indent + 4.0f) * this.zoom)) - colsWidth;
                cell.setSTRoot(root);
            } else if (cell.getRangeAddressIndex() < 0) {
                String content = ModelUtil.instance().getFormatContents(this.sheet.getWorkbook(), cell);
                if (content == null || content.length() == 0) continue;
                Paint paint = FontKit.instance().getCellPaint(cell, this.sheet.getWorkbook(), null);
                float textSize = paint.getTextSize();
                paint.setTextSize(textSize * this.zoom);
                restWidth = paint.measureText(content) + indent + 2.0f - colsWidth;
                paint.setTextSize(textSize);
            }
            if (!(restWidth > 0.0f) || cell.getRangeAddressIndex() >= 0) continue;
            int right = cell.getColNumber();
            int left = cell.getColNumber();
            switch (style2.getHorizontalAlign()) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    right = this.getExtendTextRightBound(row, cell.getColNumber(), restWidth);
                    break;
                }
                case 3: {
                    left = this.getExtendTextLeftBound(row, cell.getColNumber(), restWidth);
                    break;
                }
                case 2: {
                    left = this.getExtendTextLeftBound(row, cell.getColNumber(), restWidth / 2.0f);
                    right = this.getExtendTextRightBound(row, cell.getColNumber(), restWidth / 2.0f);
                    break;
                }
            }
            if (left == right) continue;
            ExpandedCellRangeAddress rangeAddr = new ExpandedCellRangeAddress(cell, row.getRowNumber(), left, row.getRowNumber(), right);
            int rangeAddrIndex = row.getExpandedCellCount();
            row.addExpandedRangeAddress(rangeAddrIndex, rangeAddr);
        }
        int cnt = row.getExpandedCellCount();
        for (int i = 0; i < cnt; ++i) {
            ExpandedCellRangeAddress rangeAddr = row.getExpandedRangeAddress(i);
            for (int j = rangeAddr.getRangedAddress().getFirstColumn(); j <= rangeAddr.getRangedAddress().getLastColumn(); ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    cell = new Cell(3);
                    cell.setColNumber(j);
                    cell.setRowNumber(row.getRowNumber());
                    cell.setSheet(this.sheet);
                    cell.setCellStyle(row.getRowStyle());
                    row.addCell(cell);
                }
                cell.setExpandedRangeAddressIndex(i);
            }
        }
    }

    private void drawCells(Canvas canvas, Row row) {
        float height = row == null ? (float)this.sheet.getDefaultRowHeight() : row.getRowPixelHeight();
        this.cellInfor.setHeight(height * this.zoom);
        if (this.cellInfor.getRowIndex() != this.sheetScroller.getMinRowIndex() || this.sheetScroller.isRowAllVisible()) {
            this.cellInfor.setVisibleHeight(this.cellInfor.getHeight());
        } else {
            this.cellInfor.setVisibleHeight((float)this.sheetScroller.getVisibleRowHeight() * this.zoom);
        }
        if (row == null && this.sheet.isAccomplished()) {
            row = this.sheet.getRowByColumnsStyle(this.cellInfor.getRowIndex());
        }
        if (row == null || !this.sheet.isAccomplished() && !row.isCompleted()) {
            return;
        }
        this.cellInfor.setLeft(this.rowHeader.getRowHeaderWidth());
        this.cellInfor.setColumnIndex(this.sheetScroller.getMinColumnIndex());
        Iterator<ExtendCell> iter = this.extendCell.iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
        this.extendCell.clear();
        if (this.sheet.isAccomplished() && !row.isInitExpandedRangeAddress()) {
            this.initRowExtendedRangeAddress(row);
            row.setInitExpandedRangeAddress(true);
        }
        Rect clip = canvas.getClipBounds();
        int maxColumn = this.sheet.getWorkbook().getMaxColumn();
        while (this.cellInfor.getLeft() <= (float)clip.right && this.cellInfor.getColumnIndex() < maxColumn) {
            ColumnInfo columnInfo = this.sheet.getColumnInfo(this.cellInfor.getColumnIndex());
            if (columnInfo != null && columnInfo.isHidden()) {
                this.cellInfor.increaseColumn();
                continue;
            }
            float colWidth = columnInfo != null ? columnInfo.getColWidth() : (float)this.sheet.getDefaultColWidth();
            this.cellInfor.setWidth(colWidth * this.zoom);
            if (this.cellInfor.getColumnIndex() != this.sheetScroller.getMinColumnIndex() || this.sheetScroller.isColumnAllVisible()) {
                this.cellInfor.setVisibleWidth(this.cellInfor.getWidth());
            } else {
                this.cellInfor.setVisibleWidth((float)this.sheetScroller.getVisibleColumnWidth() * this.zoom);
            }
            this.cellView.draw(canvas, row.getCell(this.cellInfor.getColumnIndex()), this.cellInfor);
            this.cellInfor.increaseLeftWithVisibleWidth();
            this.cellInfor.increaseColumn();
        }
        for (ExtendCell extendCell : this.extendCell) {
            Cell cell = extendCell.getCell();
            SSTable table = cell.getTableInfo();
            SSTableCellStyle tableCellStyle = null;
            if (table != null) {
                tableCellStyle = this.cellView.getTableCellStyle(table, this.sheet.getWorkbook(), cell.getRowNumber(), cell.getColNumber());
            }
            Paint paint = FontKit.instance().getCellPaint(cell, this.getSpreadsheet().getWorkbook(), tableCellStyle);
            canvas.save();
            canvas.clipRect(extendCell.getRect());
            Object content = extendCell.getContent();
            if (content instanceof String) {
                float textSize = paint.getTextSize();
                paint.setTextSize(textSize * this.zoom);
                canvas.drawText((String)content, extendCell.getX(), extendCell.getY(), paint);
                paint.setTextSize(textSize);
            } else {
                ((STRoot)content).draw(canvas, (int)extendCell.getX(), (int)extendCell.getY(), this.zoom);
            }
            canvas.restore();
        }
    }

    private void drawRows(Canvas canvas) {
        Rect clip = canvas.getClipBounds();
        this.cellInfor.setTop(this.columnHeader.getColumnHeaderHeight());
        this.cellInfor.setRowIndex(this.sheetScroller.getMinRowIndex());
        int maxRow = this.sheet.getWorkbook().getMaxRow();
        while (!this.spreadsheet.isAbortDrawing() && this.cellInfor.getTop() <= (float)clip.bottom && this.cellInfor.getRowIndex() < maxRow) {
            Row row = this.sheet.getRow(this.cellInfor.getRowIndex());
            if (row != null && row.isZeroHeight()) {
                this.cellInfor.increaseRow();
                continue;
            }
            this.drawCells(canvas, row);
            this.cellInfor.increaseTopWithVisibleHeight();
            this.cellInfor.increaseRow();
        }
    }

    public Sheet getCurrentSheet() {
        return this.sheet;
    }

    public int getColumnHeaderHeight() {
        return this.columnHeader.getColumnHeaderHeight();
    }

    public int getRowHeaderWidth() {
        return this.getRowHeader().getRowHeaderWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollBy(float x, float y) {
        SheetView sheetView = this;
        synchronized (sheetView) {
            this.scrollX += x / this.zoom;
            this.scrollX = Math.min(this.sheet.getMaxScrollX(), Math.max(0.0f, this.scrollX));
            this.scrollY += y / this.zoom;
            this.scrollY = Math.min(this.sheet.getMaxScrollY(), Math.max(0.0f, this.scrollY));
            this.sheet.setScroll(Math.round(this.scrollX), Math.round(this.scrollY));
            this.sheetScroller.update(this.sheet, Math.round(this.scrollX), Math.round(this.scrollY));
            this.resizeCalloutView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollTo(float x, float y) {
        SheetView sheetView = this;
        synchronized (sheetView) {
            this.scrollX = x;
            this.scrollX = Math.min(this.sheet.getMaxScrollX(), Math.max(0.0f, this.scrollX));
            this.scrollY = y;
            this.scrollY = Math.min(this.sheet.getMaxScrollY(), Math.max(0.0f, this.scrollY));
            this.sheet.setScroll(Math.round(this.scrollX), Math.round(this.scrollY));
            this.sheetScroller.update(this.sheet, Math.round(this.scrollX), Math.round(this.scrollY));
        }
    }

    public void updateMinRowAndColumnInfo() {
        this.sheetScroller.update(this.sheet, Math.round(this.scrollX), Math.round(this.scrollY));
    }

    public SheetScroller getMinRowAndColumnInformation() {
        return this.sheetScroller;
    }

    public float getScrollX() {
        return this.scrollX;
    }

    public float getScrollY() {
        return this.scrollY;
    }

    public float getZoom() {
        return this.zoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoom(float zoom) {
        SheetView sheetView = this;
        synchronized (sheetView) {
            this.setZoom(zoom, false);
            this.resizeCalloutView();
        }
    }

    public synchronized void setZoom(float zoom, boolean isInit) {
        int bottom = 0;
        boolean checkActiveCellVisible = false;
        if (this.zoom < zoom && !isInit) {
            bottom = this.clipRect.bottom - this.spreadsheet.getBottomBarHeight();
            switch (this.sheet.getActiveCellType()) {
                case 1: {
                    float yPostion = ModelUtil.instance().getValueY(this, this.sheet.getActiveCellRow() + 1, (float)this.sheetScroller.getVisibleRowHeight());
                    if (!(yPostion < (float)bottom)) break;
                    checkActiveCellVisible = true;
                    break;
                }
                case 2: {
                    float xPostion = ModelUtil.instance().getValueX(this, this.sheet.getActiveCellColumn() + 1, (float)this.sheetScroller.getVisibleColumnWidth());
                    if (!(xPostion < (float)this.clipRect.right)) break;
                    checkActiveCellVisible = true;
                    break;
                }
                case 0: {
                    RectF activeArea = ModelUtil.instance().getCellAnchor(this, this.sheet.getActiveCellRow(), this.sheet.getActiveCellColumn());
                    if (!(activeArea.width() > 1.0f) || !(activeArea.height() > 1.0f) || !activeArea.intersect((float)this.clipRect.left, (float)this.clipRect.top, (float)this.clipRect.right, (float)bottom)) break;
                    checkActiveCellVisible = true;
                }
            }
        }
        this.zoom = zoom;
        this.sheet.setZoom(zoom);
        this.rowHeader.calculateRowHeaderWidth(zoom);
        this.columnHeader.calculateColumnHeaderHeight(zoom);
        if (checkActiveCellVisible && this.clipRect != null) {
            float bodyWidth = this.clipRect.right - this.rowHeader.getRowHeaderWidth();
            float bodyHeight = bottom - this.columnHeader.getColumnHeaderHeight();
            block5 : switch (this.sheet.getActiveCellType()) {
                case 1: {
                    float yPostion = ModelUtil.instance().getValueY(this, this.sheet.getActiveCellRow() + 1, Math.round(this.sheetScroller.getVisibleRowHeight()));
                    while (yPostion > (float)bottom && Math.abs(yPostion - (float)bottom) > 1.0f) {
                        float h;
                        Row row = this.sheet.getRow(this.sheetScroller.getMinRowIndex());
                        float f = h = row == null ? (float)this.getCurrentSheet().getDefaultRowHeight() : row.getRowPixelHeight();
                        if (h * zoom > bodyHeight) break block5;
                        this.scrollY += h;
                        this.sheetScroller.setMinRowIndex(this.sheetScroller.getMinRowIndex() + 1);
                        yPostion = ModelUtil.instance().getValueY(this, this.sheet.getActiveCellRow() + 1, Math.round(this.sheetScroller.getVisibleRowHeight()));
                    }
                    break;
                }
                case 2: {
                    float columnWidth;
                    float xPostion = ModelUtil.instance().getValueX(this, this.sheet.getActiveCellColumn() + 1, Math.round(this.sheetScroller.getVisibleColumnWidth()));
                    while (xPostion > (float)this.clipRect.right && Math.abs(xPostion - (float)this.clipRect.right) > 1.0f && !((columnWidth = this.sheet.getColumnPixelWidth(this.sheetScroller.getMinColumnIndex())) * zoom > bodyWidth)) {
                        this.scrollX += columnWidth;
                        this.sheetScroller.setMinColumnIndex(this.sheetScroller.getMinColumnIndex() + 1);
                        xPostion = ModelUtil.instance().getValueX(this, this.sheet.getActiveCellColumn() + 1, Math.round(this.sheetScroller.getVisibleColumnWidth()));
                    }
                    break;
                }
                case 0: {
                    RectF activeArea = ModelUtil.instance().getCellAnchor(this, this.sheet.getActiveCellRow(), this.sheet.getActiveCellColumn());
                    while (Math.abs(activeArea.right - (float)this.rowHeader.getRowHeaderWidth()) < 1.0f || activeArea.right > (float)this.clipRect.right || Math.abs(activeArea.bottom - (float)this.columnHeader.getColumnHeaderHeight()) < 1.0f || activeArea.bottom > (float)bottom) {
                        if (Math.abs(activeArea.right - (float)this.rowHeader.getRowHeaderWidth()) < 1.0f) {
                            float columnWidth = this.sheet.getColumnPixelWidth(this.sheetScroller.getMinColumnIndex());
                            if (columnWidth * zoom > bodyWidth) break block5;
                            this.scrollX -= columnWidth;
                            this.sheetScroller.setMinColumnIndex(this.sheetScroller.getMinColumnIndex() - 1);
                        } else if (activeArea.right > (float)this.clipRect.right) {
                            float columnWidth = this.sheet.getColumnPixelWidth(this.sheetScroller.getMinColumnIndex());
                            if (columnWidth * zoom > bodyWidth) break block5;
                            this.scrollX += columnWidth;
                            this.sheetScroller.setMinColumnIndex(this.sheetScroller.getMinColumnIndex() + 1);
                        }
                        if (Math.abs(activeArea.bottom - (float)this.columnHeader.getColumnHeaderHeight()) < 1.0f) {
                            Row row = this.sheet.getRow(this.sheetScroller.getMinRowIndex());
                            float f = h = row == null ? (float)this.getCurrentSheet().getDefaultRowHeight() : row.getRowPixelHeight();
                            if (h * zoom > bodyHeight) break block5;
                            this.scrollY -= h;
                            this.sheetScroller.setMinRowIndex(this.sheetScroller.getMinRowIndex() - 1);
                        } else if (activeArea.bottom > (float)bottom) {
                            Row row = this.sheet.getRow(this.sheetScroller.getMinRowIndex());
                            float f = h = row == null ? (float)this.getCurrentSheet().getDefaultRowHeight() : row.getRowPixelHeight();
                            if (h * zoom > bodyHeight) break block5;
                            this.scrollY += h;
                            this.sheetScroller.setMinRowIndex(this.sheetScroller.getMinRowIndex() + 1);
                        }
                        activeArea = ModelUtil.instance().getCellAnchor(this, this.sheet.getActiveCellRow(), this.sheet.getActiveCellColumn());
                        boolean stop = false;
                        if (Math.abs(activeArea.left - (float)this.rowHeader.getRowHeaderWidth()) < 1.0f && activeArea.right >= (float)this.clipRect.right) {
                            stop = true;
                        } else if (activeArea.right != (float)this.rowHeader.getRowHeaderWidth() && Math.abs(activeArea.right - activeArea.left) < 1.0f) {
                            this.sheetScroller.setMinColumnIndex(this.sheetScroller.getMinColumnIndex() - 1);
                            stop = true;
                        }
                        if (Math.abs(activeArea.top - (float)this.columnHeader.getColumnHeaderHeight()) < 1.0f && activeArea.bottom >= (float)this.clipRect.bottom) {
                            stop = true;
                        } else if (activeArea.bottom != (float)this.columnHeader.getColumnHeaderHeight() && activeArea.bottom < activeArea.top) {
                            this.sheetScroller.setMinRowIndex(this.sheetScroller.getMinRowIndex() - 1);
                            stop = true;
                        }
                        if (!stop) continue;
                        return;
                    }
                    break;
                }
            }
            this.sheet.setScroll((int)this.scrollX, (int)this.scrollY);
        }
    }

    public void setZoom(float zoom, float pointX, float pointY) {
        int viewWidth = this.spreadsheet.getWidth();
        int viewHeight = this.spreadsheet.getHeight();
        float normalizedX = (pointX - (float)this.rowHeader.getRowHeaderWidth()) / this.zoom;
        float normalizedY = (pointY - (float)this.columnHeader.getColumnHeaderHeight()) / this.zoom;
        normalizedX = Math.min(this.sheet.getMaxScrollX(), normalizedX + (float)this.sheet.getScrollX());
        normalizedY = Math.min(this.sheet.getMaxScrollY(), normalizedY + (float)this.sheet.getScrollY());
        this.zoom = zoom;
        this.sheet.setZoom(zoom);
        this.rowHeader.calculateRowHeaderWidth(zoom);
        this.columnHeader.calculateColumnHeaderHeight(zoom);
        normalizedX = (normalizedX * zoom - (float)(viewWidth / 2)) / zoom;
        normalizedY = (normalizedY * zoom - (float)(viewHeight / 2)) / zoom;
        this.scrollTo((int)normalizedX, (int)normalizedY);
    }

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public void setSpreadsheet(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
    }

    public RowHeader getRowHeader() {
        return this.rowHeader;
    }

    public int getCurrentMinRow() {
        return this.sheetScroller.getMinRowIndex();
    }

    public int getCurrentMinColumn() {
        return this.sheetScroller.getMinColumnIndex();
    }

    public void selectedCell(int rowIndex, int colIndex) {
        Row row = this.sheet.getRow(rowIndex);
        if (row != null && row.getCell(colIndex) != null && row.getCell(colIndex).getRangeAddressIndex() >= 0) {
            CellRangeAddress cellRangeAddress = this.sheet.getMergeRange(row.getCell(colIndex).getRangeAddressIndex());
            this.selecetedCellsRange.setFirstRow(cellRangeAddress.getFirstRow());
            this.selecetedCellsRange.setLastRow(cellRangeAddress.getLastRow());
            this.selecetedCellsRange.setFirstColumn(cellRangeAddress.getFirstColumn());
            this.selecetedCellsRange.setLastColumn(cellRangeAddress.getLastColumn());
        } else {
            this.selecetedCellsRange.setFirstRow(rowIndex);
            this.selecetedCellsRange.setLastRow(rowIndex);
            this.selecetedCellsRange.setFirstColumn(colIndex);
            this.selecetedCellsRange.setLastColumn(colIndex);
        }
        this.getCurrentSheet().setActiveCellRowCol(this.selecetedCellsRange.getFirstRow(), this.selecetedCellsRange.getFirstColumn());
    }

    public void setDrawMovingHeaderLine(boolean draw) {
        this.isDrawMovingHeaderLine = draw;
    }

    public void changeHeaderArea(FocusCell headerInfor) {
        this.selectedHeaderInfor = headerInfor;
    }

    public void goToFindedCell(Cell cell) {
        if (cell == null) {
            return;
        }
        int col = cell.getColNumber();
        int row = cell.getRowNumber();
        if (cell.getColNumber() > 0) {
            col = cell.getColNumber() - 1;
        }
        if (cell.getRowNumber() > 0) {
            row = cell.getRowNumber() - 1;
        }
        this.sheet.setActiveCellRowCol(cell.getRowNumber(), cell.getColNumber());
        this.selectedCell(cell.getRowNumber(), cell.getColNumber());
        this.goToCell(row, col);
        this.spreadsheet.postInvalidate();
        this.spreadsheet.getControl().actionEvent(20, null);
        this.spreadsheet.getControl().actionEvent(0x2000000A, null);
    }

    public void goToCell(int row, int column) {
        Rect area = ModelUtil.instance().getCellAnchor(this.sheet, row, column, true);
        this.scrollTo(area.left, area.top);
    }

    public boolean find(String findValue) {
        Cell cell;
        if (this.findingMgr == null) {
            this.findingMgr = new FindingMgr();
        }
        if ((cell = this.findingMgr.findCell(this.sheet, findValue)) != null) {
            this.goToFindedCell(cell);
            return true;
        }
        return false;
    }

    public boolean findBackward() {
        if (this.findingMgr == null) {
            return false;
        }
        Cell cell = this.findingMgr.findBackward();
        if (cell != null) {
            this.goToFindedCell(cell);
            return true;
        }
        return false;
    }

    public boolean findForward() {
        if (this.findingMgr == null) {
            return false;
        }
        Cell cell = this.findingMgr.findForward();
        if (cell != null) {
            this.goToFindedCell(cell);
            return true;
        }
        return false;
    }

    public void addExtendCell(Cell cell, RectF rect, float x, float y, Object content) {
        this.extendCell.add(new ExtendCell(cell, rect, x, y, content));
    }

    public int getSheetIndex() {
        return this.sheet.getWorkbook().getSheetIndex(this.sheet) + 1;
    }

    public void dispose() {
        this.spreadsheet = null;
        this.sheet = null;
        if (this.rowHeader != null) {
            this.rowHeader.dispose();
            this.rowHeader = null;
        }
        if (this.columnHeader != null) {
            this.columnHeader.dispose();
            this.columnHeader = null;
        }
        if (this.cellView != null) {
            this.cellView.dispose();
            this.cellView = null;
        }
        if (this.shapeView != null) {
            this.shapeView.dispose();
            this.shapeView = null;
        }
        if (this.sheetScroller != null) {
            this.sheetScroller.dispose();
            this.sheetScroller = null;
        }
        if (this.cellInfor != null) {
            this.cellInfor.dispose();
            this.cellInfor = null;
        }
        if (this.findingMgr != null) {
            this.findingMgr.dispose();
            this.findingMgr = null;
        }
        if (this.extendCell != null) {
            this.extendCell.clear();
            this.extendCell = null;
        }
        this.selectedHeaderInfor = null;
        this.clipRect = null;
        this.effects = null;
    }

    public class ExtendCell {
        private Cell cell;
        private RectF rect;
        private float x;
        private float y;
        private Object content;

        public ExtendCell(Cell cell, RectF rect, float x, float y, Object content) {
            this.cell = cell;
            this.setRect(rect);
            this.x = x;
            this.y = y;
            this.content = content instanceof String ? ((String)content).intern() : content;
        }

        public Cell getCell() {
            return this.cell;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public Object getContent() {
            return this.content;
        }

        private RectF getRect() {
            return this.rect;
        }

        private void setRect(RectF rect) {
            this.rect = rect;
        }

        public void dispose() {
            this.cell = null;
            this.rect = null;
            this.content = null;
        }
    }
}

