/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.view;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import com.ahmadullahpk.alldocumentreader.xs.common.BackgroundDrawer;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AChart;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.GroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.SmartArt;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.STDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.STRoot;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class ShapeView {
    private SheetView sheetView;
    private Rect shapeRect;
    private Rect temRect;

    public ShapeView(SheetView sheetView) {
        this.sheetView = sheetView;
        this.shapeRect = new Rect();
        this.temRect = new Rect();
    }

    public void panzoomViewRect(Rectangle shapePostion, IShape parent) {
        float zoom = this.sheetView.getZoom();
        if (parent != null && parent instanceof SmartArt) {
            this.shapeRect.left = Math.round((float)shapePostion.x * zoom);
            this.shapeRect.right = Math.round((float)(shapePostion.x + shapePostion.width) * zoom);
            this.shapeRect.top = Math.round((float)shapePostion.y * zoom);
            this.shapeRect.bottom = Math.round((float)(shapePostion.y + shapePostion.height) * zoom);
        } else {
            int x = this.sheetView.getRowHeaderWidth();
            int y = this.sheetView.getColumnHeaderHeight();
            float scrollX = this.sheetView.getScrollX();
            float scrollY = this.sheetView.getScrollY();
            this.shapeRect.left = x + Math.round(((float)shapePostion.x - scrollX) * zoom);
            this.shapeRect.right = x + Math.round(((float)(shapePostion.x + shapePostion.width) - scrollX) * zoom);
            this.shapeRect.top = y + Math.round(((float)shapePostion.y - scrollY) * zoom);
            this.shapeRect.bottom = y + Math.round(((float)(shapePostion.y + shapePostion.height) - scrollY) * zoom);
        }
        this.temRect.set(this.shapeRect.left, this.shapeRect.top, this.shapeRect.right, this.shapeRect.bottom);
    }

    public void draw(Canvas canvas) {
        Rect clip = canvas.getClipBounds();
        clip.left = this.sheetView.getRowHeaderWidth();
        clip.top = this.sheetView.getColumnHeaderHeight();
        int cnt = this.sheetView.getCurrentSheet().getShapeCount();
        IControl control = this.sheetView.getSpreadsheet().getControl();
        for (int i = 0; i < cnt && !this.sheetView.getSpreadsheet().isAbortDrawing(); ++i) {
            IShape shape = this.sheetView.getCurrentSheet().getShape(i);
            this.drawShape(canvas, clip, control, null, shape);
        }
    }

    private void drawShape(Canvas canvas, Rect clip, IControl control, IShape parent, IShape shape) {
        canvas.save();
        Rectangle bounds = shape.getBounds();
        if (bounds == null && shape.getType() == 5) {
            DisplayMetrics display = this.sheetView.getSpreadsheet().getControl().getMainFrame().getActivity().getResources().getDisplayMetrics();
            int width = Math.max(display.widthPixels, display.heightPixels);
            int height = Math.min(display.widthPixels, display.heightPixels);
            bounds = new Rectangle(0, 0, Math.round(width), Math.round(height));
            shape.setBounds(bounds);
        }
        this.panzoomViewRect(bounds, parent);
        if (!this.temRect.intersect(clip) && parent == null) {
            return;
        }
        if (shape instanceof GroupShape) {
            if (shape.getFlipVertical()) {
                canvas.translate((float)this.shapeRect.left, (float)this.shapeRect.bottom);
                canvas.scale(1.0f, -1.0f);
                canvas.translate((float)(-this.shapeRect.left), (float)(-this.shapeRect.top));
            }
            if (shape.getFlipHorizontal()) {
                canvas.translate((float)this.shapeRect.right, (float)this.shapeRect.top);
                canvas.scale(-1.0f, 1.0f);
                canvas.translate((float)(-this.shapeRect.left), (float)(-this.shapeRect.top));
            }
            IShape[] shapes = ((GroupShape)shape).getShapes();
            for (int i = 0; i < shapes.length; ++i) {
                IShape childShape = shapes[i];
                if (shape.isHidden()) continue;
                this.drawShape(canvas, clip, control, shape, childShape);
            }
        } else {
            switch (shape.getType()) {
                case 0: {
                    PictureShape pictureShape = (PictureShape)shape;
                    this.processRotation(canvas, pictureShape, this.shapeRect);
                    BackgroundDrawer.drawLineAndFill(canvas, control, this.sheetView.getSheetIndex(), pictureShape, this.shapeRect, this.sheetView.getZoom());
                    Picture pic = control.getSysKit().getPictureManage().getPicture(((PictureShape)shape).getPictureIndex());
                    PictureKit.instance().drawPicture(canvas, this.sheetView.getSpreadsheet().getControl(), this.sheetView.getSheetIndex(), pic, this.shapeRect.left, this.shapeRect.top, this.sheetView.getZoom(), this.shapeRect.width(), this.shapeRect.height(), ((PictureShape)shape).getPictureEffectInfor());
                    break;
                }
                case 1: {
                    this.drawTextbox(canvas, this.shapeRect, (TextBox)shape);
                    break;
                }
                case 5: {
                    AChart achart = (AChart)shape;
                    if (achart.getAChart() == null) break;
                    this.processRotation(canvas, shape, this.shapeRect);
                    achart.getAChart().setZoomRate(this.sheetView.getZoom());
                    achart.getAChart().draw(canvas, control, this.shapeRect.left, this.shapeRect.top, this.shapeRect.width(), this.shapeRect.height(), PaintKit.instance().getPaint());
                    break;
                }
                case 2: 
                case 4: {
                    AutoShapeKit.instance().drawAutoShape(canvas, control, this.sheetView.getSheetIndex(), (AutoShape)shape, this.shapeRect, this.sheetView.getZoom());
                    break;
                }
                case 8: {
                    IShape[] shapes;
                    SmartArt smartArt = (SmartArt)shape;
                    BackgroundDrawer.drawLineAndFill(canvas, control, this.sheetView.getSheetIndex(), smartArt, this.shapeRect, this.sheetView.getZoom());
                    canvas.translate((float)this.shapeRect.left, (float)this.shapeRect.top);
                    for (IShape item : shapes = smartArt.getShapes()) {
                        this.drawShape(canvas, clip, control, smartArt, item);
                    }
                    break;
                }
            }
        }
        canvas.restore();
    }

    private void drawTextbox(Canvas canvas, Rect shapeRect, TextBox textbox) {
        SectionElement elem = textbox.getElement();
        if (elem.getEndOffset() - elem.getStartOffset() == 0L) {
            return;
        }
        if (textbox.isEditor()) {
            return;
        }
        this.processRotation(canvas, textbox, shapeRect);
        STRoot root = textbox.getRootView();
        if (root == null) {
            STDocument doc = new STDocument();
            doc.appendSection(elem);
            IAttributeSet attr = elem.getAttribute();
            AttrManage.instance().setPageWidth(attr, (int)Math.round(textbox.getBounds().getWidth() * 15.0));
            AttrManage.instance().setPageHeight(attr, (int)Math.round(textbox.getBounds().getHeight() * 15.0));
            root = new STRoot(this.sheetView.getSpreadsheet().getEditor(), doc);
            root.setWrapLine(textbox.isWrapLine());
            root.doLayout();
            textbox.setRootView(root);
        }
        if (root != null) {
            root.draw(canvas, shapeRect.left, shapeRect.top, this.sheetView.getZoom());
        }
    }

    private void processRotation(Canvas canvas, IShape shape, Rect shapeRect) {
        float angle = shape.getRotation();
        if (shape.getFlipVertical()) {
            angle += 180.0f;
        }
        if (angle != 0.0f) {
            canvas.rotate(angle, (float)shapeRect.centerX(), (float)shapeRect.centerY());
        }
    }

    public void dispose() {
        this.sheetView = null;
        this.shapeRect = null;
        this.temRect = null;
    }
}

