/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.util.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;

public class FractionalFormat
extends Format {
    private short ONE_DIGIT = 1;
    private short TWO_DIGIT = (short)2;
    private short THREE_DIGIT = (short)3;
    private short UNITS = (short)4;
    private int units = 1;
    private short mode = (short)-1;

    public FractionalFormat(String formatStr) {
        if ("# ?/?".equals(formatStr)) {
            this.mode = this.ONE_DIGIT;
        } else if ("# ??/??".equals(formatStr)) {
            this.mode = this.TWO_DIGIT;
        } else if ("# ???/???".equals(formatStr)) {
            this.mode = this.THREE_DIGIT;
        } else if ("# ?/2".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 2;
        } else if ("# ?/4".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 4;
        } else if ("# ?/8".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 8;
        } else if ("# ??/16".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 16;
        } else if ("# ?/10".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 10;
        } else if ("# ??/100".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 100;
        }
    }

    private String format(double f, int maxDen) {
        double frac;
        double precision;
        long whole = (long)f;
        int sign = 1;
        if (f < 0.0) {
            sign = -1;
        }
        double allowedError = precision = 1.0E-5;
        double d = Math.abs(f);
        double diff = frac = (d -= (double)whole);
        long num = 1L;
        long den = 0L;
        long a = 0L;
        long b = 0L;
        long i = 0L;
        if (frac > precision) {
            while (true) {
                d = 1.0 / d;
                i = (long)(d + precision);
                d -= (double)i;
                if (a > 0L) {
                    num = i * num + b;
                }
                den = (long)((double)num / frac + 0.5);
                diff = Math.abs((double)num / (double)den - frac);
                if (den > (long)maxDen) {
                    if (a > 0L) {
                        num = a;
                        den = (long)((double)num / frac + 0.5);
                        diff = Math.abs((double)num / (double)den - frac);
                        break;
                    }
                    num = 1L;
                    den = maxDen;
                    diff = Math.abs((double)num / (double)den - frac);
                    if (!(diff > frac)) break;
                    num = 0L;
                    den = 1L;
                    diff = frac;
                    break;
                }
                if (diff <= allowedError || d < precision) break;
                precision = allowedError / diff;
                b = a;
                a = num;
            }
        }
        if (num == den) {
            ++whole;
            num = 0L;
            den = 0L;
        } else if (den == 0L) {
            num = 0L;
        }
        if (sign < 0) {
            if (whole == 0L) {
                num = -num;
            } else {
                whole = -whole;
            }
        }
        String value = "";
        if (whole != 0L) {
            value = value.concat(String.valueOf(whole));
        }
        if (num != 0L && den != 0L) {
            value = value.concat(" " + num + "/" + den);
        }
        return value;
    }

    private String formatUnit(double f, int units) {
        long whole = (long)f;
        long num = Math.round((f -= (double)whole) * (double)units);
        String value = "";
        if (whole != 0L) {
            value = value.concat(String.valueOf(whole));
        }
        if (num != 0L) {
            value = value.concat(" " + num + "/" + units);
        }
        return value;
    }

    public final String format(double val) {
        if (this.mode == this.ONE_DIGIT) {
            return this.format(val, 9);
        }
        if (this.mode == this.TWO_DIGIT) {
            return this.format(val, 99);
        }
        if (this.mode == this.THREE_DIGIT) {
            return this.format(val, 999);
        }
        if (this.mode == this.UNITS) {
            return this.formatUnit(val, this.units);
        }
        throw new RuntimeException("Unexpected Case");
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            toAppendTo.append(this.format(((Number)obj).doubleValue()));
            return toAppendTo;
        }
        throw new IllegalArgumentException("Can only handle Numbers");
    }

    @Override
    public Object parseObject(String source, ParsePosition status) {
        return null;
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        return null;
    }

    @Override
    public Object clone() {
        return null;
    }
}

