/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.util.format;

import com.ahmadullahpk.alldocumentreader.xs.ss.util.format.FractionalFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;

public class CellFormatter {
    private static CellFormatter cf = new CellFormatter();
    private Format[] textFormatter;
    private DecimalFormat generalNumberFormat = new DecimalFormat("0");

    public CellFormatter() {
        this.textFormatter = new Format[49];
        this.textFormatter[1] = new DecimalFormat("0");
        this.textFormatter[2] = new DecimalFormat("0.00");
        this.textFormatter[3] = new DecimalFormat("#,##0");
        this.textFormatter[4] = new DecimalFormat("#,##0.00");
        this.textFormatter[5] = new DecimalFormat("$#,##0;$#,##0");
        this.textFormatter[6] = new DecimalFormat("$#,##0;$#,##0");
        this.textFormatter[7] = new DecimalFormat("$#,##0.00;$#,##0.00");
        this.textFormatter[8] = new DecimalFormat("$#,##0.00;$#,##0.00");
        this.textFormatter[9] = new DecimalFormat("0%");
        this.textFormatter[10] = new DecimalFormat("0.00%");
        this.textFormatter[11] = new DecimalFormat("0.00E0");
        this.textFormatter[12] = new FractionalFormat("# ?/?");
        this.textFormatter[13] = new FractionalFormat("# ??/??");
        this.textFormatter[14] = new SimpleDateFormat("M/d/yy");
        this.textFormatter[15] = new SimpleDateFormat("d-MMM-yy");
        this.textFormatter[16] = new SimpleDateFormat("d-MMM");
        this.textFormatter[17] = new SimpleDateFormat("MMM-yy");
        this.textFormatter[18] = new SimpleDateFormat("h:mm a");
        this.textFormatter[19] = new SimpleDateFormat("h:mm:ss a");
        this.textFormatter[20] = new SimpleDateFormat("h:mm");
        this.textFormatter[21] = new SimpleDateFormat("h:mm:ss");
        this.textFormatter[22] = new SimpleDateFormat("M/d/yy h:mm");
        this.textFormatter[38] = new DecimalFormat("#,##0;#,##0");
        this.textFormatter[39] = new DecimalFormat("#,##0.00;#,##0.00");
        this.textFormatter[40] = new DecimalFormat("#,##0.00;#,##0.00");
        this.textFormatter[45] = new SimpleDateFormat("mm:ss");
        this.textFormatter[47] = new SimpleDateFormat("mm:ss.0");
        this.textFormatter[48] = new DecimalFormat("##0.0E0");
    }

    public static CellFormatter instance() {
        return cf;
    }

    public String format(short index, Object value) {
        if (index == 0) {
            return value.toString();
        }
        if (this.textFormatter[index] == null) {
            throw new RuntimeException("Sorry. I cant handle the format code :" + Integer.toHexString(index));
        }
        return this.textFormatter[index].format(value);
    }

    public String format(short index, double value) {
        if (index <= 0 || index >= this.textFormatter.length) {
            return this.generalNumberFormat.format(value);
        }
        if (this.textFormatter[index] == null) {
            return this.generalNumberFormat.format(value);
        }
        if (this.textFormatter[index] instanceof DecimalFormat) {
            return ((DecimalFormat)this.textFormatter[index]).format(value);
        }
        if (this.textFormatter[index] instanceof FractionalFormat) {
            return ((FractionalFormat)this.textFormatter[index]).format(value);
        }
        return String.valueOf(value);
    }

    public boolean useRedColor(short index, double value) {
        return (index == 6 || index == 8 || index == 38 || index == 39) && value < 0.0;
    }

    public void dispose() {
        this.textFormatter = null;
        this.generalNumberFormat = null;
    }
}

