/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.util.format;

import java.text.DecimalFormat;

public class AccountFormat {
    private static final double ZERO = 1.0E-6;
    private static AccountFormat af = new AccountFormat();

    private AccountFormat() {
    }

    public static AccountFormat instance() {
        return af;
    }

    public String format(String pattern, double value) {
        String[] subFormat = pattern.split(";");
        String contents = "";
        switch (subFormat.length) {
            case 1: {
                contents = this.parse(subFormat[0], value, false);
                break;
            }
            case 2: {
                contents = this.parse(subFormat[0] + ";" + subFormat[1], value, false);
                break;
            }
            case 3: 
            case 4: {
                contents = Math.abs(value) > 1.0E-6 ? this.parse(subFormat[0] + ";" + subFormat[1], value, false) : this.parse(subFormat[2], 0.0, true);
            }
        }
        return contents;
    }

    private String parse(String pattern, double value, boolean isZero) {
        String contents = "";
        String[] subFormat = pattern.split(";");
        int index = pattern.indexOf("*");
        if (Math.abs(value) < 1.0E-6 && subFormat.length == 1) {
            String header = pattern.substring(0, index + 1);
            index = pattern.indexOf(45);
            pattern = pattern.replace("#", "");
            pattern = pattern.replace("?", " ");
            contents = header + pattern.substring(index - 1, pattern.length());
        } else {
            pattern = pattern.replace("*", "");
            DecimalFormat format = new DecimalFormat(pattern);
            contents = format.format((Object)value);
            if (value > 0.0) {
                value += 1.0E-9;
            } else if (value < 0.0) {
                value -= 1.0E-9;
            }
            contents = format.format((Object)value);
            contents = contents.substring(0, index) + "*" + contents.substring(index, contents.length());
        }
        return contents;
    }
}

