/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.util;

import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.drawing.CellAnchor;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.SheetScroller;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.format.NumericFormatter;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;

public class ModelUtil {
    private static ModelUtil mu = new ModelUtil();
    private RectF area = new RectF();

    public static ModelUtil instance() {
        return mu;
    }

    public static Rectangle processRect(Rectangle rect, float angle) {
        if ((angle %= 360.0f) > 45.0f && angle <= 135.0f || angle > 225.0f && angle < 315.0f) {
            double centerX = rect.getCenterX();
            double centerY = rect.getCenterY();
            rect.x = (int)Math.round(centerX - (double)(rect.height / 2));
            rect.y = (int)Math.round(centerY - (double)(rect.width / 2));
            int temp = rect.width;
            rect.width = rect.height;
            rect.height = temp;
        }
        return rect;
    }

    public int getCellRangeAddressIndex(Sheet sheet, int row, int column) {
        int len = sheet.getMergeRangeCount();
        for (int i = 0; i < len; ++i) {
            CellRangeAddress cra = sheet.getMergeRange(i);
            if (!this.containsCell(cra, row, column)) continue;
            return i;
        }
        return -1;
    }

    public CellRangeAddress getCellRangeAddress(Sheet sheet, int row, int column) {
        int len = sheet.getMergeRangeCount();
        for (int i = 0; i < len; ++i) {
            CellRangeAddress cra = sheet.getMergeRange(i);
            if (!this.containsCell(cra, row, column)) continue;
            return cra;
        }
        return null;
    }

    public boolean containsCell(CellRangeAddress cr, int row, int col) {
        return row >= cr.getFirstRow() && row <= cr.getLastRow() && col >= cr.getFirstColumn() && col <= cr.getLastColumn();
    }

    public RectF getCellRangeAddressAnchor(SheetView sheetview, CellRangeAddress cellRangeAddress) {
        this.area.left = this.getValueX(sheetview, cellRangeAddress.getFirstColumn(), 0.0f);
        this.area.top = this.getValueY(sheetview, cellRangeAddress.getFirstRow(), 0.0f);
        this.area.right = this.getValueX(sheetview, cellRangeAddress.getLastColumn() + 1, 0.0f);
        this.area.bottom = this.getValueY(sheetview, cellRangeAddress.getLastRow() + 1, 0.0f);
        return this.area;
    }

    private Rect getCellRangeAddressAnchor(Sheet sheet, CellRangeAddress cellRangeAddress) {
        Rect area = new Rect();
        area.left = Math.round(this.getValueX(sheet, cellRangeAddress.getFirstColumn(), 0));
        area.top = Math.round(this.getValueY(sheet, cellRangeAddress.getFirstRow(), 0));
        area.right = Math.round(this.getValueX(sheet, cellRangeAddress.getLastColumn() + 1, 0));
        area.bottom = Math.round(this.getValueY(sheet, cellRangeAddress.getLastRow() + 1, 0));
        return area;
    }

    public Rectangle getCellAnchor(Sheet sheet, CellAnchor cellAnchor) {
        Rectangle area = new Rectangle();
        if (cellAnchor == null) {
            return null;
        }
        area.x = Math.round(this.getValueX(sheet, (int)cellAnchor.getStart().getColumn(), cellAnchor.getStart().getDX()));
        area.y = Math.round(this.getValueY(sheet, cellAnchor.getStart().getRow(), cellAnchor.getStart().getDY()));
        if (cellAnchor.getType() == 1) {
            area.width = Math.round(this.getValueX(sheet, (int)cellAnchor.getEnd().getColumn(), cellAnchor.getEnd().getDX()) - (float)area.x);
            area.height = Math.round(this.getValueY(sheet, cellAnchor.getEnd().getRow(), cellAnchor.getEnd().getDY()) - (float)area.y);
        } else if (cellAnchor.getType() == 0) {
            area.width = cellAnchor.getWidth();
            area.height = cellAnchor.getHeight();
        }
        return area;
    }

    public RectF getCellAnchor(SheetView sheetview, Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getRangeAddressIndex() >= 0) {
            return this.getCellRangeAddressAnchor(sheetview, sheetview.getCurrentSheet().getMergeRange(cell.getRangeAddressIndex()));
        }
        this.area.left = this.getValueX(sheetview, cell.getColNumber(), 0.0f);
        this.area.top = this.getValueY(sheetview, cell.getRowNumber(), 0.0f);
        this.area.right = this.getValueX(sheetview, cell.getColNumber() + 1, 0.0f);
        this.area.bottom = this.getValueY(sheetview, cell.getRowNumber() + 1, 0.0f);
        return this.area;
    }

    public RectF getCellAnchor(SheetView sheetview, int row, int column) {
        Cell cell;
        Sheet sheet = sheetview.getCurrentSheet();
        if (sheet.getRow(row) != null && sheet.getRow(row).getCell(column) != null && (cell = sheet.getRow(row).getCell(column)).getRangeAddressIndex() >= 0) {
            return this.getCellRangeAddressAnchor(sheetview, sheet.getMergeRange(cell.getRangeAddressIndex()));
        }
        this.area.left = this.getValueX(sheetview, column, 0.0f);
        this.area.top = this.getValueY(sheetview, row, 0.0f);
        this.area.right = this.getValueX(sheetview, column + 1, 0.0f);
        this.area.bottom = this.getValueY(sheetview, row + 1, 0.0f);
        return this.area;
    }

    public RectF getCellAnchor(SheetView sheetview, int row, int column1, int column2) {
        Cell cell;
        Sheet sheet = sheetview.getCurrentSheet();
        if (sheet.getRow(row) != null && sheet.getRow(row).getCell(column1) != null && sheet.getRow(row).getCell(column2) != null && (cell = sheet.getRow(row).getCell(column2)).getRangeAddressIndex() >= 0) {
            column2 = sheet.getMergeRange(cell.getRangeAddressIndex()).getLastColumn();
        }
        this.area.left = this.getValueX(sheetview, column1, 0.0f);
        this.area.top = this.getValueY(sheetview, row, 0.0f);
        this.area.right = this.getValueX(sheetview, column2 + 1, 0.0f);
        this.area.bottom = this.getValueY(sheetview, row + 1, 0.0f);
        return this.area;
    }

    public Rect getCellAnchor(Sheet sheet, int row, int column) {
        Cell cell;
        if (sheet.getRow(row) != null && sheet.getRow(row).getCell(column) != null && (cell = sheet.getRow(row).getCell(column)).getRangeAddressIndex() >= 0) {
            return this.getCellRangeAddressAnchor(sheet, sheet.getMergeRange(cell.getRangeAddressIndex()));
        }
        Rect area = new Rect();
        area.left = Math.round(this.getValueX(sheet, column, 0));
        area.top = Math.round(this.getValueY(sheet, row, 0));
        area.right = Math.round(this.getValueX(sheet, column + 1, 0));
        area.bottom = Math.round(this.getValueY(sheet, row + 1, 0));
        return area;
    }

    public Rect getCellAnchor(Sheet sheet, int row, int column, boolean ignoreMergerCell) {
        if (!ignoreMergerCell && sheet.getRow(row) != null && sheet.getRow(row).getCell(column) != null) {
            Cell cell = sheet.getRow(row).getCell(column);
            if (cell.getRangeAddressIndex() >= 0) {
                return this.getCellRangeAddressAnchor(sheet, sheet.getMergeRange(cell.getRangeAddressIndex()));
            }
            return null;
        }
        Rect area = new Rect();
        area.left = Math.round(this.getValueX(sheet, column, 0));
        area.top = Math.round(this.getValueY(sheet, row, 0));
        area.right = Math.round(this.getValueX(sheet, column + 1, 0));
        area.bottom = Math.round(this.getValueY(sheet, row + 1, 0));
        return area;
    }

    private float getValueX(Sheet sheet, int columnIndex, int dx) {
        float x = 0.0f;
        for (int i = 0; i < columnIndex; ++i) {
            if (sheet.isColumnHidden(i)) continue;
            x += sheet.getColumnPixelWidth(i);
        }
        return (float)dx + x;
    }

    private float getValueY(Sheet sheet, int rowIndex, int dy) {
        float y = 0.0f;
        float h = 0.0f;
        for (int i = 0; i < rowIndex; ++i) {
            Row row = sheet.getRow(i);
            if (row != null && row.isZeroHeight()) continue;
            h = row == null ? (float)sheet.getDefaultRowHeight() : row.getRowPixelHeight();
            y += h;
        }
        return y + (float)dy;
    }

    public float getValueX(SheetView sheetview, int columnIndex, float dx) {
        int maxColumns;
        int colStart;
        float x = sheetview.getRowHeaderWidth();
        float w = 0.0f;
        Sheet sheet = sheetview.getCurrentSheet();
        SheetScroller minRowAndColumnInformation = sheetview.getMinRowAndColumnInformation();
        int n = colStart = minRowAndColumnInformation.getMinColumnIndex() > 0 ? minRowAndColumnInformation.getMinColumnIndex() : 0;
        if (colStart < columnIndex && !minRowAndColumnInformation.isColumnAllVisible()) {
            ++colStart;
            x = (float)((double)x + minRowAndColumnInformation.getVisibleColumnWidth() * (double)sheetview.getZoom());
        }
        int n2 = maxColumns = sheet.getWorkbook().isBefore07Version() ? 256 : 16384;
        while (colStart < columnIndex && colStart <= maxColumns) {
            if (sheet.isColumnHidden(colStart)) {
                ++colStart;
                continue;
            }
            w = sheet.getColumnPixelWidth(colStart) * sheetview.getZoom();
            x += w;
            ++colStart;
        }
        return dx + x;
    }

    public float getValueY(SheetView sheetview, int rowIndex, float dy) {
        int maxRows;
        int rowStart;
        float y = 30.0f * sheetview.getZoom();
        float h = 0.0f;
        Sheet sheet = sheetview.getCurrentSheet();
        SheetScroller minRowAndColumnInformation = sheetview.getMinRowAndColumnInformation();
        int n = rowStart = minRowAndColumnInformation.getMinRowIndex() > 0 ? minRowAndColumnInformation.getMinRowIndex() : 0;
        if (rowStart < rowIndex && !minRowAndColumnInformation.isRowAllVisible()) {
            ++rowStart;
            y = (float)((double)y + minRowAndColumnInformation.getVisibleRowHeight() * (double)sheetview.getZoom());
        }
        int n2 = maxRows = sheet.getWorkbook().isBefore07Version() ? 65536 : 0x100000;
        while (rowStart < rowIndex && rowStart <= maxRows) {
            Row row = sheet.getRow(rowStart);
            if (row != null && row.isZeroHeight()) {
                ++rowStart;
                continue;
            }
            h = row == null ? (float)sheetview.getCurrentSheet().getDefaultRowHeight() : row.getRowPixelHeight();
            y += (h *= sheetview.getZoom());
            ++rowStart;
        }
        return y + dy;
    }

    public String getFormatContents(Workbook book, Cell cell) {
        if (!cell.hasValidValue()) {
            return null;
        }
        CellStyle style2 = cell.getCellStyle();
        String value = "";
        switch (cell.getCellType()) {
            case 4: {
                value = String.valueOf(cell.getBooleanValue()).toUpperCase();
                break;
            }
            case 0: {
                short numericType;
                String key = style2.getFormatCode();
                if (key == null) {
                    key = "General";
                    numericType = 6;
                } else if (cell.getCellNumericType() > 0) {
                    numericType = cell.getCellNumericType();
                } else {
                    numericType = NumericFormatter.instance().getNumericCellType(key);
                    cell.setCellNumericType(numericType);
                }
                try {
                    if (numericType == 10) {
                        value = NumericFormatter.instance().getFormatContents(key, cell.getDateCellValue(book.isUsing1904DateWindowing()));
                        cell.setCellType((short)1);
                        cell.setCellValue(book.addSharedString(value));
                        break;
                    }
                    value = NumericFormatter.instance().getFormatContents(key, cell.getNumberValue(), numericType);
                }
                catch (Exception ex) {
                    value = String.valueOf(cell.getNumberValue());
                }
                break;
            }
            case 1: {
                if (cell.getStringCellValueIndex() < 0) break;
                value = book.getSharedString(cell.getStringCellValueIndex());
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                value = ErrorEval.getText(cell.getErrorValue());
                break;
            }
        }
        return value;
    }
}

