/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.sheetbar;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.ahmadullahpk.alldocumentreader.R;

public class SheetButton
extends LinearLayout {
    private static final int FONT_SIZE = 16;
    private static final int SHEET_BUTTON_MIN_WIDTH = 120;
    private boolean active;
    Context context;
    private View left;
    private View right;
    private int sheetIndex;
    private TextView textView;

    public SheetButton(Context context, String sheetName, int sheetIndex) {
        super(context);
        this.context = context;
        this.setOrientation(0);
        this.sheetIndex = sheetIndex;
        this.init(context, sheetName);
    }

    private void init(Context context, String sheetName) {
        View view2;
        TextView textView2;
        View view;
        this.left = view = new View(context);
        this.addView(view);
        this.textView = textView2 = new TextView(context);
        textView2.setBackground(ContextCompat.getDrawable((Context)context, (int)R.drawable.sheet_bg));
        this.textView.setText((CharSequence)sheetName);
        this.textView.setTextSize(16.0f);
        this.textView.setGravity(17);
        this.textView.setTextColor(Color.parseColor((String)"#444444"));
        this.textView.setPadding(5, 0, 5, 0);
        this.addView((View)this.textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(Math.max((int)this.textView.getPaint().measureText(sheetName), 120), -1));
        this.right = view2 = new View(context);
        view2.setBackgroundColor(-16776961);
        this.addView(this.right);
    }

    public void changeFocus(boolean z) {
        this.active = z;
        this.textView.setBackground(ContextCompat.getDrawable((Context)this.context, (int)(z ? R.drawable.sheet_bg_pressed : R.drawable.sheet_bg)));
        this.textView.setTextColor(Color.parseColor((String)(z ? "#217346" : "#444444")));
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public void dispose() {
        this.left = null;
        this.textView = null;
        this.right = null;
    }
}

