/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.sheetbar;

import android.content.Context;
import android.content.res.Configuration;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import com.ahmadullahpk.alldocumentreader.xs.ss.sheetbar.SheetButton;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.util.Vector;

public class SheetBar
extends HorizontalScrollView
implements View.OnClickListener {
    private int minimumWidth;
    private int sheetbarHeight;
    private SheetButton currentSheet;
    private IControl control;
    private LinearLayout sheetbarFrame;

    public SheetBar(Context context) {
        super(context);
    }

    public SheetBar(Context context, IControl control, int minimumWidth) {
        super(context);
        this.control = control;
        this.setVerticalFadingEdgeEnabled(false);
        this.setFadingEdgeLength(0);
        this.minimumWidth = minimumWidth == this.getResources().getDisplayMetrics().widthPixels ? -1 : minimumWidth;
        this.init();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.sheetbarFrame.setMinimumWidth(this.minimumWidth == -1 ? this.getResources().getDisplayMetrics().widthPixels : this.minimumWidth);
    }

    private void init() {
        LinearLayout linearLayout;
        Context context = this.getContext();
        this.sheetbarFrame = linearLayout = new LinearLayout(context);
        linearLayout.setGravity(80);
        this.sheetbarFrame.setBackgroundColor(-7829368);
        this.sheetbarFrame.setOrientation(0);
        LinearLayout linearLayout2 = this.sheetbarFrame;
        int i = this.minimumWidth;
        if (i == -1) {
            i = this.getResources().getDisplayMetrics().widthPixels;
        }
        linearLayout2.setMinimumWidth(i);
        this.sheetbarHeight = 100;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, 100);
        this.sheetbarFrame.addView(new View(context), (ViewGroup.LayoutParams)layoutParams);
        Vector vector = (Vector)this.control.getActionValue(0x40000002, null);
        FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(-2, 100);
        int size = vector.size();
        for (int i2 = 0; i2 < size; ++i2) {
            SheetButton sheetButton = new SheetButton(context, (String)vector.get(i2), i2);
            if (this.currentSheet == null) {
                this.currentSheet = sheetButton;
                sheetButton.changeFocus(true);
            }
            sheetButton.setOnClickListener(this);
            this.sheetbarFrame.addView((View)sheetButton, (ViewGroup.LayoutParams)layoutParams2);
            if (i2 >= size - 1) continue;
            this.sheetbarFrame.addView(new View(context), (ViewGroup.LayoutParams)layoutParams2);
        }
        this.sheetbarFrame.addView(new View(context), (ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.sheetbarFrame, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, this.sheetbarHeight));
    }

    public void onClick(View v) {
        this.currentSheet.changeFocus(false);
        SheetButton sb = (SheetButton)v;
        sb.changeFocus(true);
        this.currentSheet = sb;
        this.control.actionEvent(0x40000001, this.currentSheet.getSheetIndex());
    }

    public void setFocusSheetButton(int index) {
        if (this.currentSheet.getSheetIndex() == index) {
            return;
        }
        int count = this.sheetbarFrame.getChildCount();
        View view = null;
        for (int i = 0; i < count; ++i) {
            view = this.sheetbarFrame.getChildAt(i);
            if (!(view instanceof SheetButton) || ((SheetButton)view).getSheetIndex() != index) continue;
            this.currentSheet.changeFocus(false);
            this.currentSheet = (SheetButton)view;
            this.currentSheet.changeFocus(true);
            break;
        }
        int screenWidth = this.control.getActivity().getWindowManager().getDefaultDisplay().getWidth();
        int barWidth = this.sheetbarFrame.getWidth();
        if (barWidth > screenWidth) {
            int left = view.getLeft();
            int right = view.getRight();
            int off = (screenWidth - (right - left)) / 2;
            if ((off = left - off) < 0) {
                off = 0;
            } else if (off + screenWidth > barWidth) {
                off = barWidth - screenWidth;
            }
            this.scrollTo(off, 0);
        }
    }

    public int getSheetbarHeight() {
        return this.sheetbarHeight;
    }

    public void dispose() {
        this.currentSheet = null;
        if (this.sheetbarFrame != null) {
            int count = this.sheetbarFrame.getChildCount();
            for (int i = 0; i < count; ++i) {
                View v = this.sheetbarFrame.getChildAt(i);
                if (!(v instanceof SheetButton)) continue;
                ((SheetButton)v).dispose();
            }
            this.sheetbarFrame = null;
        }
    }
}

