/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty;

import java.util.ArrayList;
import java.util.List;

public final class Palette {
    public static final byte STANDARD_PALETTE_SIZE = 56;
    public static final short FIRST_COLOR_INDEX = 8;
    private final List<PColor> _colors;

    public Palette() {
        PColor[] defaultPalette = Palette.createDefaultPalette();
        this._colors = new ArrayList<PColor>(defaultPalette.length);
        for (int i = 0; i < defaultPalette.length; ++i) {
            this._colors.add(defaultPalette[i]);
        }
    }

    public byte[] getColor(int byteIndex) {
        int i = byteIndex - 8;
        if (i < 0 || i >= this._colors.size()) {
            return null;
        }
        return this._colors.get(i).getTriplet();
    }

    public void setColor(short byteIndex, byte red, byte green, byte blue) {
        int i = byteIndex - 8;
        if (i < 0 || i >= 56) {
            return;
        }
        while (this._colors.size() <= i) {
            this._colors.add(new PColor(0, 0, 0));
        }
        PColor custColor = new PColor(red, green, blue);
        this._colors.set(i, custColor);
    }

    private static PColor[] createDefaultPalette() {
        return new PColor[]{Palette.pc(0, 0, 0), Palette.pc(255, 255, 255), Palette.pc(255, 0, 0), Palette.pc(0, 255, 0), Palette.pc(0, 0, 255), Palette.pc(255, 255, 0), Palette.pc(255, 0, 255), Palette.pc(0, 255, 255), Palette.pc(128, 0, 0), Palette.pc(0, 128, 0), Palette.pc(0, 0, 128), Palette.pc(128, 128, 0), Palette.pc(128, 0, 128), Palette.pc(0, 128, 128), Palette.pc(192, 192, 192), Palette.pc(128, 128, 128), Palette.pc(153, 153, 255), Palette.pc(153, 51, 102), Palette.pc(255, 255, 204), Palette.pc(204, 255, 255), Palette.pc(102, 0, 102), Palette.pc(255, 128, 128), Palette.pc(0, 102, 204), Palette.pc(204, 204, 255), Palette.pc(0, 0, 128), Palette.pc(255, 0, 255), Palette.pc(255, 255, 0), Palette.pc(0, 255, 255), Palette.pc(128, 0, 128), Palette.pc(128, 0, 0), Palette.pc(0, 128, 128), Palette.pc(0, 0, 255), Palette.pc(0, 204, 255), Palette.pc(204, 255, 255), Palette.pc(204, 255, 204), Palette.pc(255, 255, 153), Palette.pc(153, 204, 255), Palette.pc(255, 153, 204), Palette.pc(204, 153, 255), Palette.pc(255, 204, 153), Palette.pc(51, 102, 255), Palette.pc(51, 204, 204), Palette.pc(153, 204, 0), Palette.pc(255, 204, 0), Palette.pc(255, 153, 0), Palette.pc(255, 102, 0), Palette.pc(102, 102, 153), Palette.pc(150, 150, 150), Palette.pc(0, 51, 102), Palette.pc(51, 153, 102), Palette.pc(0, 51, 0), Palette.pc(51, 51, 0), Palette.pc(153, 51, 0), Palette.pc(153, 51, 102), Palette.pc(51, 51, 153), Palette.pc(51, 51, 51)};
    }

    private static PColor pc(int r, int g, int b) {
        return new PColor(r, g, b);
    }

    public void dispose() {
        if (this._colors != null) {
            this._colors.clear();
        }
    }

    private static final class PColor {
        private int _red;
        private int _green;
        private int _blue;

        public PColor(int red, int green, int blue) {
            this._red = red;
            this._green = green;
            this._blue = blue;
        }

        public byte[] getTriplet() {
            return new byte[]{(byte)this._red, (byte)this._green, (byte)this._blue};
        }
    }
}

