/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel;

import android.os.Message;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.Font;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.TableFormatManager;
import com.ahmadullahpk.alldocumentreader.xs.system.ReaderHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Workbook {
    public static final int MAXROW_03 = 65536;
    public static final int MAXCOLUMN_03 = 256;
    public static final int MAXROW_07 = 0x100000;
    public static final int MAXCOLUMN_07 = 16384;
    protected ReaderHandler readerHandler;
    protected boolean isUsing1904DateWindowing;
    protected Map<Integer, Sheet> sheets = new HashMap<Integer, Sheet>(5);
    protected Map<Integer, Font> fonts = new HashMap<Integer, Font>(20);
    protected Map<Integer, Integer> colors = new HashMap<Integer, Integer>(20);
    private Map<Integer, Picture> pictures;
    protected Map<Integer, CellStyle> cellStyles = new HashMap<Integer, CellStyle>(80);
    protected Map<Integer, Object> sharedString = new HashMap<Integer, Object>(20);
    private Map<Integer, Integer> themeColor;
    private Map<String, Integer> schemeColor = new HashMap<String, Integer>(20);
    private TableFormatManager tableFormatManager;
    private boolean before07;

    public Workbook(boolean before07) {
        this.themeColor = new HashMap<Integer, Integer>(20);
        this.pictures = new HashMap<Integer, Picture>();
        this.before07 = before07;
    }

    public static boolean isValidateStyle(CellStyle cellStyle) {
        if (cellStyle == null) {
            return false;
        }
        if (cellStyle.getBorderLeft() > 0 || cellStyle.getBorderTop() > 0 || cellStyle.getBorderRight() > 0 || cellStyle.getBorderBottom() > 0) {
            return true;
        }
        return cellStyle.getFillPatternType() != -1;
    }

    public void addSheet(int index, Sheet sheet) {
        this.sheets.put(index, sheet);
    }

    public void setReaderHandler(ReaderHandler readerHandler) {
        this.readerHandler = readerHandler;
    }

    public ReaderHandler getReaderHandler() {
        return this.readerHandler;
    }

    public Sheet getSheet(String sheetName) {
        Collection<Sheet> sheetCol = this.sheets.values();
        for (Sheet sheet : sheetCol) {
            if (!sheet.getSheetName().equals(sheetName)) continue;
            return sheet;
        }
        return null;
    }

    public int getSheetIndex(Sheet sheet) {
        for (int index : this.sheets.keySet()) {
            if (!this.sheets.get(index).equals(sheet)) continue;
            return index;
        }
        return -1;
    }

    public Sheet getSheet(int index) {
        if (index < 0 || index >= this.sheets.size()) {
            return null;
        }
        return this.sheets.get(index);
    }

    public int getSheetCount() {
        return this.sheets.size();
    }

    public void addFont(int index, Font font) {
        this.fonts.put(index, font);
    }

    public Font getFont(int index) {
        return this.fonts.get(index);
    }

    public synchronized int addColor(int argb) {
        if (this.colors.containsValue(argb)) {
            Iterator<Integer> iter = this.colors.keySet().iterator();
            int index = 0;
            while (iter.hasNext() && this.colors.get(index = iter.next().intValue()) != argb) {
            }
            return index;
        }
        int index = this.colors.size() - 1;
        while (this.colors.get(index) != null) {
            ++index;
        }
        this.colors.put(index, argb);
        return index;
    }

    public synchronized void addColor(int index, int rgba) {
        this.colors.put(index, rgba);
    }

    public int getColor(int index) {
        return this.getColor(index, false);
    }

    public synchronized int getColor(int index, boolean line) {
        Integer t = this.colors.get(index);
        if (t == null && index >= 0 && index <= 7) {
            t = this.colors.get(8);
        }
        if (t == null) {
            if (line) {
                return -16777216;
            }
            return -1;
        }
        return t;
    }

    public void addCellStyle(int index, CellStyle cellStyle) {
        this.cellStyles.put(index, cellStyle);
    }

    public int getNumStyles() {
        return this.cellStyles.size();
    }

    public CellStyle getCellStyle(int index) {
        return this.cellStyles.get(index);
    }

    public int addSharedString(Object item) {
        if (item == null) {
            return -1;
        }
        this.sharedString.put(this.sharedString.size(), item);
        return this.sharedString.size() - 1;
    }

    public void addSharedString(int index, Object item) {
        this.sharedString.put(index, item);
    }

    public String getSharedString(int index) {
        Object si = this.sharedString.get(index);
        String value = null;
        if (si instanceof SectionElement) {
            value = ((SectionElement)si).getText(null);
        } else if (si instanceof String) {
            value = (String)si;
        }
        return value;
    }

    public Object getSharedItem(int index) {
        return this.sharedString.get(index);
    }

    public synchronized void addThemeColorIndex(int index, int colorIndex) {
        this.themeColor.put(index, colorIndex);
    }

    public synchronized int getThemeColorIndex(int index) {
        Integer t = this.themeColor.get(index);
        if (t != null) {
            return t;
        }
        return -1;
    }

    public synchronized int getThemeColor(int index) {
        Integer t = this.colors.get(this.themeColor.get(index));
        if (t != null) {
            return t;
        }
        return -16777216;
    }

    public synchronized void addSchemeColorIndex(String key, int colorIndex) {
        this.schemeColor.put(key, colorIndex);
    }

    public synchronized int getSchemeColorIndex(String key) {
        Integer t = this.schemeColor.get(key);
        if (t != null) {
            return t;
        }
        return -1;
    }

    public synchronized int getSchemeColor(String key) {
        Integer t = this.colors.get(this.schemeColor.get(key));
        if (t != null) {
            return t;
        }
        return -16777216;
    }

    public boolean isUsing1904DateWindowing() {
        return this.isUsing1904DateWindowing;
    }

    public void setUsing1904DateWindowing(boolean isUsing1904DateWindowing) {
        this.isUsing1904DateWindowing = isUsing1904DateWindowing;
    }

    public void addPicture(int index, Picture pic) {
        this.pictures.put(index, pic);
    }

    public int addPicture(Picture pic) {
        Iterator<Integer> iter = this.pictures.keySet().iterator();
        int index = 0;
        while (iter.hasNext()) {
            index = iter.next();
            if (!this.pictures.get(index).getTempFilePath().equals(pic.getTempFilePath())) continue;
            return index;
        }
        this.pictures.put(index + 1, pic);
        return index + 1;
    }

    public Picture getPicture(int index) {
        return this.pictures.get(index);
    }

    public boolean isBefore07Version() {
        return this.before07;
    }

    public int getMaxRow() {
        if (this.before07) {
            return 65536;
        }
        return 0x100000;
    }

    public int getMaxColumn() {
        if (this.before07) {
            return 256;
        }
        return 16384;
    }

    public void setTableFormatManager(TableFormatManager tableFormatManager) {
        this.tableFormatManager = tableFormatManager;
    }

    public TableFormatManager getTableFormatManager() {
        return this.tableFormatManager;
    }

    public void destroy() {
        if (this.readerHandler != null) {
            Message msg = new Message();
            msg.what = 4;
            this.readerHandler.handleMessage(msg);
            this.readerHandler = null;
        }
        if (this.sheets != null) {
            Collection<Sheet> sheetCollection = this.sheets.values();
            for (Sheet sheet : sheetCollection) {
                sheet.dispose();
            }
            this.sheets.clear();
            this.sheets = null;
        }
        if (this.fonts != null) {
            Collection<Font> fontCollection = this.fonts.values();
            for (Font font : fontCollection) {
                font.dispose();
            }
            this.fonts.clear();
            this.fonts = null;
        }
        if (this.colors != null) {
            this.colors.clear();
            this.colors = null;
        }
        if (this.pictures != null) {
            this.pictures.clear();
            this.pictures = null;
        }
        if (this.cellStyles != null) {
            Collection<CellStyle> styleCollection = this.cellStyles.values();
            for (CellStyle cellStyle : styleCollection) {
                cellStyle.dispose();
            }
            this.cellStyles.clear();
            this.cellStyles = null;
        }
        if (this.sharedString != null) {
            this.sharedString.clear();
            this.sharedString = null;
        }
        if (this.themeColor != null) {
            this.themeColor.clear();
            this.themeColor = null;
        }
        if (this.schemeColor != null) {
            this.schemeColor.clear();
            this.schemeColor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Workbook workbook = this;
        synchronized (workbook) {
            this.destroy();
        }
    }
}

