/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel;

import android.os.Message;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.OldExcelFormatException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.udf.UDFFinder;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.RecordStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.ExtendedFormatRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.FontRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.LabelRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.NameRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.PaletteRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFDataFormat;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFName;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DirectoryNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DocumentInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.POIFSFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.SSReader;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.Font;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ASheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractReader;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.ReaderHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AWorkbook
extends Workbook
implements com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Workbook {
    public static final int INITIAL_CAPACITY = 3;
    public static final int AUTOMATIC_COLOR = 64;
    private static final String[] WORKBOOK_DIR_ENTRY_NAMES = new String[]{"Workbook", "WORKBOOK"};
    private UDFFinder _udfFinder = UDFFinder.DEFAULT;
    private InternalWorkbook workbook;
    private ArrayList<HSSFName> names;
    private int currentSheet;
    private SSReader iAbortListener;

    public AWorkbook(InputStream s, SSReader iAbortListener) throws IOException {
        super(true);
        this.iAbortListener = iAbortListener;
        DirectoryNode directory = new POIFSFileSystem(s).getRoot();
        String workbookName = AWorkbook.getWorkbookDirEntryName(directory);
        DocumentInputStream stream = directory.createDocumentInputStream(workbookName);
        List<Record> records = RecordFactory.createRecords(stream, iAbortListener);
        this.workbook = InternalWorkbook.createWorkbook(records, iAbortListener);
        int recOffset = this.workbook.getNumRecords();
        int size = this.workbook.getSSTUniqueStringSize();
        for (int i = 0; i < size; ++i) {
            this.addSharedString(i, this.workbook.getSSTString(i));
        }
        this.convertLabelRecords(records, recOffset);
        this.isUsing1904DateWindowing = this.workbook.isUsing1904DateWindowing();
        PaletteRecord palette = this.workbook.getCustomPalette();
        int index = 8;
        this.addColor(index++, ColorUtil.rgb(0, 0, 0));
        byte[] color2 = palette.getColor(index);
        while (color2 != null) {
            this.addColor(index++, ColorUtil.rgb(color2[0], color2[1], color2[2]));
            color2 = palette.getColor(index);
        }
        this.processCellStyle(this.workbook);
        RecordStream rs = new RecordStream(records, recOffset);
        int sheetIndex = 0;
        while (rs.hasNext()) {
            InternalSheet internalSheet = InternalSheet.createSheet(rs, iAbortListener);
            ASheet sheet = new ASheet(this, internalSheet);
            sheet.setSheetName(this.workbook.getSheetName(sheetIndex));
            if (internalSheet.isChartSheet()) {
                sheet.setSheetType((short)1);
            }
            this.sheets.put(sheetIndex++, sheet);
        }
        records.clear();
        records = null;
        this.names = new ArrayList(3);
        for (int i = 0; i < this.workbook.getNumNames(); ++i) {
            NameRecord nameRecord = this.workbook.getNameRecord(i);
            HSSFName name = new HSSFName(this, nameRecord, this.workbook.getNameCommentRecord(nameRecord));
            this.names.add(name);
        }
        this.processSheet();
    }

    private void processShapesBySheetIndex(IControl control, int sheetIndex) {
        ASheet sheet = (ASheet)this.sheets.get(sheetIndex);
        try {
            if (sheet.getState() != 2) {
                sheet.processSheetShapes(control);
                sheet.setState((short)2);
            }
        }
        catch (Exception e) {
            sheet.setState((short)2);
        }
    }

    private void processSheet() {
        class WorkbookReaderHandler
        extends ReaderHandler {
            private AWorkbook book;

            public WorkbookReaderHandler(AWorkbook book) {
                this.book = book;
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        AWorkbook.this.currentSheet = (Integer)msg.obj;
                        if (((Sheet)AWorkbook.this.sheets.get(AWorkbook.this.currentSheet)).getState() == 2) break;
                        new ShapesThread(this.book, AWorkbook.this.sheets, AWorkbook.this.currentSheet, AWorkbook.this.iAbortListener).start();
                        break;
                    }
                    case 1: 
                    case 4: {
                        this.book = null;
                    }
                }
            }
        }
        this.readerHandler = new WorkbookReaderHandler(this);
        Message msg = new Message();
        msg.what = 0;
        msg.obj = 0;
        this.readerHandler.handleMessage(msg);
    }

    public static String getWorkbookDirEntryName(DirectoryNode directory) {
        String[] potentialNames = WORKBOOK_DIR_ENTRY_NAMES;
        for (int i = 0; i < potentialNames.length; ++i) {
            String wbName = potentialNames[i];
            try {
                directory.getEntry(wbName);
                return wbName;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
        }
        try {
            directory.getEntry("Book");
            throw new OldExcelFormatException("The supplied spreadsheet seems to be Excel 5.0/7.0 (BIFF5) format. POI only supports BIFF8 format (from Excel versions 97/2000/XP/2003)");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("The supplied POIFSFileSystem does not contain a BIFF8 'Workbook' entry. Is it really an excel file?");
        }
    }

    private void convertLabelRecords(List records, int offset) {
        for (int k = offset; k < records.size(); ++k) {
            Record rec = (Record)records.get(k);
            if (rec.getSid() != 516) continue;
            LabelRecord oldrec = (LabelRecord)rec;
            this.sharedString.put(this.sharedString.size(), oldrec.getValue());
        }
    }

    private void processCellStyle(InternalWorkbook workbook) {
        this.processFont(workbook);
        short styleIndex = 0;
        short cellStyleCnt = (short)workbook.getNumExFormats();
        while (styleIndex < cellStyleCnt) {
            ExtendedFormatRecord format = workbook.getExFormatAt(styleIndex);
            if (format == null) continue;
            CellStyle style2 = new CellStyle();
            style2.setIndex(styleIndex);
            style2.setNumberFormatID(format.getFormatIndex());
            style2.setFormatCode(HSSFDataFormat.getFormatCode(workbook, format.getFormatIndex()));
            style2.setFontIndex(format.getFontIndex());
            style2.setHidden(format.isHidden());
            style2.setLocked(format.isLocked());
            style2.setWrapText(format.getWrapText());
            style2.setHorizontalAlign(format.getAlignment());
            style2.setVerticalAlign(format.getVerticalAlignment());
            style2.setRotation(format.getRotation());
            style2.setIndent(format.getIndent());
            style2.setBorderLeft(format.getBorderLeft());
            int colorIndex = format.getLeftBorderPaletteIdx();
            if (colorIndex == 64) {
                colorIndex = 8;
            }
            style2.setBorderLeftColorIdx((short)colorIndex);
            style2.setBorderRight(format.getBorderRight());
            colorIndex = format.getRightBorderPaletteIdx();
            if (colorIndex == 64) {
                colorIndex = 8;
            }
            style2.setBorderRightColorIdx((short)colorIndex);
            style2.setBorderTop(format.getBorderTop());
            colorIndex = format.getTopBorderPaletteIdx();
            if (colorIndex == 64) {
                colorIndex = 8;
            }
            style2.setBorderTopColorIdx((short)colorIndex);
            style2.setBorderBottom(format.getBorderBottom());
            colorIndex = format.getBottomBorderPaletteIdx();
            if (colorIndex == 64) {
                colorIndex = 8;
            }
            style2.setBorderBottomColorIdx((short)colorIndex);
            colorIndex = format.getFillBackground();
            style2.setBgColor(this.getColor(colorIndex));
            colorIndex = format.getFillForeground();
            if (colorIndex == 64) {
                colorIndex = 9;
            }
            style2.setFgColor(this.getColor(colorIndex));
            style2.setFillPatternType((byte)(format.getAdtlFillPattern() - 1));
            short s = styleIndex;
            styleIndex = (short)(styleIndex + 1);
            this.addCellStyle(s, style2);
        }
    }

    private void processFont(InternalWorkbook workbook) {
        int numFont = workbook.getNumberOfFontRecords();
        if (numFont <= 4) {
            --numFont;
        }
        int idx = 0;
        while (idx <= numFont) {
            FontRecord fontRec = workbook.getFontRecordAt(idx);
            Font font = new Font();
            font.setIndex(idx);
            font.setName(fontRec.getFontName());
            font.setFontSize((short)(fontRec.getFontHeight() / 20));
            int index = fontRec.getColorPaletteIndex();
            if (index == Short.MAX_VALUE) {
                index = 8;
            }
            font.setColorIndex(index);
            font.setItalic(fontRec.isItalic());
            font.setBold(fontRec.getBoldWeight() > 400);
            font.setSuperSubScript((byte)fontRec.getSuperSubScript());
            font.setStrikeline(fontRec.isStruckout());
            font.setUnderline(fontRec.getUnderline());
            this.addFont(idx++, font);
        }
    }

    public InternalWorkbook getInternalWorkbook() {
        return this.workbook;
    }

    public UDFFinder getUDFFinder() {
        return this._udfFinder;
    }

    @Override
    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    @Override
    public ASheet getSheetAt(int index) {
        if (index < 0 || index >= this.sheets.size()) {
            return null;
        }
        return (ASheet)this.sheets.get(index);
    }

    public int getSheetIndex(String name) {
        return this.workbook.getSheetIndex(name);
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        for (int i = 0; i < this.sheets.size(); ++i) {
            if (this.sheets.get(i) != sheet) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfNames() {
        int result = this.names.size();
        return result;
    }

    public int getNameIndex(String name) {
        for (int k = 0; k < this.names.size(); ++k) {
            String nameName = this.getNameName(k);
            if (!nameName.equalsIgnoreCase(name)) continue;
            return k;
        }
        return -1;
    }

    public HSSFName getName(String name) {
        int nameIndex = this.getNameIndex(name);
        if (nameIndex < 0) {
            return null;
        }
        return this.names.get(nameIndex);
    }

    public HSSFName getNameAt(int nameIndex) {
        int nNames = this.names.size();
        if (nNames < 1) {
            throw new IllegalStateException("There are no defined names in this workbook");
        }
        if (nameIndex < 0 || nameIndex > nNames) {
            throw new IllegalArgumentException("Specified name index " + nameIndex + " is outside the allowable range (0.." + (nNames - 1) + ").");
        }
        return this.names.get(nameIndex);
    }

    public NameRecord getNameRecord(int nameIndex) {
        return this.workbook.getNameRecord(nameIndex);
    }

    public String getNameName(int index) {
        String result = this.getNameAt(index).getNameName();
        return result;
    }

    public AbstractReader getAbstractReader() {
        return this.iAbortListener;
    }

    @Override
    public void dispose() {
        this.destroy();
        this.workbook = null;
        if (this.names != null && this.names.size() > 0) {
            Iterator<HSSFName> iter = this.names.iterator();
            while (iter.hasNext()) {
                iter.next().dispose();
            }
            this.names.clear();
            this.names = null;
        }
        this._udfFinder = null;
        this.iAbortListener = null;
    }

    static class ShapesThread
    extends Thread {
        private AWorkbook book;
        private Map<Integer, Sheet> sheets;
        private SSReader iAbortListener;
        private int sheetIndex;
        private IControl control;

        public ShapesThread(AWorkbook book, Map<Integer, Sheet> sheets, int sheetIndex, SSReader iAbortListener) {
            this.book = book;
            this.sheets = sheets;
            this.sheetIndex = sheetIndex;
            this.iAbortListener = iAbortListener;
            this.control = iAbortListener.getControl();
        }

        @Override
        public void run() {
            try {
                if (this.sheetIndex >= 0 && this.iAbortListener != null) {
                    this.iAbortListener.abortCurrentReading();
                    ShapesThread.sleep(50L);
                    ((ASheet)this.book.getSheet(this.sheetIndex)).processSheet(this.iAbortListener);
                    this.processOtherSheets();
                }
            }
            catch (OutOfMemoryError e) {
                this.book.dispose();
                this.iAbortListener.dispose();
                this.iAbortListener.getControl().getSysKit().getErrorKit().writerLog(e, true);
            }
            catch (Exception e) {
                this.book.dispose();
                this.iAbortListener.dispose();
                this.iAbortListener.getControl().getSysKit().getErrorKit().writerLog(e, true);
            }
            finally {
                this.book = null;
                this.sheets = null;
                this.iAbortListener = null;
                this.control = null;
            }
        }

        private void processOtherSheets() {
            Iterator<Integer> iter = this.sheets.keySet().iterator();
            while (iter.hasNext()) {
                ((ASheet)this.book.getSheet(iter.next())).processSheet(this.iAbortListener);
            }
            iter = this.sheets.keySet().iterator();
            while (iter.hasNext()) {
                this.book.processShapesBySheetIndex(this.control, iter.next());
            }
        }
    }
}

