/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.Ptg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.BlankRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.BoolErrRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CellValueRecordInterface;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.FormulaRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.LabelRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.LabelSSTRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.NumberRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.StringRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.aggregates.FormulaRecordAggregate;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.common.UnicodeString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFRichTextString;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.SpreadsheetVersion;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ASheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.SectionElementFactory;

public class ACell
extends Cell {
    private CellValueRecordInterface record;

    public ACell(Sheet sheet, CellValueRecordInterface cval) {
        super((short)3);
        this.record = cval;
        this.cellType = (short)ACell.determineType(cval);
        this.sheet = sheet;
        this.rowNumber = cval.getRow();
        this.colNumber = cval.getColumn();
        this.styleIndex = cval.getXFIndex();
        switch (this.cellType) {
            case 0: {
                this.value = this.getNumericCellValue();
                break;
            }
            case 1: {
                if (cval instanceof LabelSSTRecord) {
                    this.value = ((LabelSSTRecord)cval).getSSTIndex();
                    this.processSST();
                    break;
                }
                if (!(cval instanceof LabelRecord)) break;
                this.value = sheet.getWorkbook().addSharedString(((LabelRecord)cval).getValue());
                break;
            }
            case 2: {
                this.procellFormulaCellValue((FormulaRecordAggregate)cval);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.value = this.getBooleanCellValue();
                break;
            }
            case 5: {
                this.value = this.getErrorCellValue();
            }
        }
    }

    private void processSST() {
        Workbook book = this.sheet.getWorkbook();
        Object obj = book.getSharedItem((Integer)this.value);
        if (obj instanceof UnicodeString) {
            UnicodeString unicodeString = (UnicodeString)obj;
            this.value = book.addSharedString(SectionElementFactory.getSectionElement(book, unicodeString, this));
        }
    }

    private void procellFormulaCellValue(FormulaRecordAggregate cval) {
        StringRecord strRec = cval.getStringRecord();
        if (strRec != null) {
            this.cellType = 1;
            this.value = this.sheet.getWorkbook().addSharedString(strRec.getString());
        } else {
            FormulaRecord formulaRec = cval.getFormulaRecord();
            this.cellType = (short)formulaRec.getCachedResultType();
            switch (this.cellType) {
                case 0: {
                    this.value = formulaRec.getValue();
                    break;
                }
                case 1: {
                    break;
                }
                case 4: {
                    this.value = formulaRec.getCachedBooleanValue();
                    break;
                }
                case 5: {
                    this.value = (byte)formulaRec.getCachedErrorValue();
                }
            }
        }
    }

    public ACell(AWorkbook book, ASheet sheet, int row, short col) {
        super((short)5);
        this.sheet = sheet;
        short xfindex = sheet.getInternalSheet().getXFIndexForColAt(col);
        this.setCellType(3, false, row, col, xfindex);
    }

    public void setCellFormula(Ptg[] ptgs) {
        int row = this.record.getRow();
        short col = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        this.setCellType(2, false, row, col, styleIndex);
        FormulaRecordAggregate agg = (FormulaRecordAggregate)this.record;
        FormulaRecord frec = agg.getFormulaRecord();
        frec.setOptions((short)2);
        frec.setValue(0.0);
        if (agg.getXFIndex() == 0) {
            agg.setXFIndex((short)15);
        }
        agg.setParsedExpression(ptgs);
    }

    public String getStringCellValue() {
        switch (this.cellType) {
            case 3: {
                return "";
            }
            case 1: {
                if (!(this.record instanceof LabelSSTRecord)) break;
                return this.sheet.getWorkbook().getSharedString(((LabelSSTRecord)this.record).getSSTIndex());
            }
            default: {
                throw ACell.typeMismatch(1, this.cellType, false);
            }
            case 2: 
        }
        FormulaRecordAggregate fra = (FormulaRecordAggregate)this.record;
        ACell.checkFormulaCachedValueType(1, fra.getFormulaRecord());
        String strVal = fra.getStringValue();
        return strVal;
    }

    public double getNumericCellValue() {
        switch (this.cellType) {
            case 3: {
                return 0.0;
            }
            case 0: {
                return ((NumberRecord)this.record).getValue();
            }
            default: {
                throw ACell.typeMismatch(0, this.cellType, false);
            }
            case 2: 
        }
        FormulaRecord fr = ((FormulaRecordAggregate)this.record).getFormulaRecord();
        ACell.checkFormulaCachedValueType(0, fr);
        return fr.getValue();
    }

    public boolean getBooleanCellValue() {
        switch (this.cellType) {
            case 3: {
                return false;
            }
            case 4: {
                return ((BoolErrRecord)this.record).getBooleanValue();
            }
            default: {
                throw ACell.typeMismatch(4, this.cellType, false);
            }
            case 2: 
        }
        FormulaRecord fr = ((FormulaRecordAggregate)this.record).getFormulaRecord();
        ACell.checkFormulaCachedValueType(4, fr);
        return fr.getCachedBooleanValue();
    }

    public byte getErrorCellValue() {
        switch (this.cellType) {
            case 5: {
                return ((BoolErrRecord)this.record).getErrorValue();
            }
            default: {
                throw ACell.typeMismatch(5, this.cellType, false);
            }
            case 2: 
        }
        FormulaRecord fr = ((FormulaRecordAggregate)this.record).getFormulaRecord();
        ACell.checkFormulaCachedValueType(5, fr);
        return (byte)fr.getCachedErrorValue();
    }

    private static String getCellTypeName(int cellTypeCode) {
        switch (cellTypeCode) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + cellTypeCode + ")#";
    }

    public int getFormulaCachedValueType() {
        return ((FormulaRecordAggregate)this.record).getFormulaRecord().getCachedResultType();
    }

    private static RuntimeException typeMismatch(int expectedTypeCode, int actualTypeCode, boolean isFormulaCell) {
        String msg = "Cannot get a " + ACell.getCellTypeName(expectedTypeCode) + " value from a " + ACell.getCellTypeName(actualTypeCode) + " " + (isFormulaCell ? "formula " : "") + "cell";
        return new IllegalStateException(msg);
    }

    private static void checkFormulaCachedValueType(int expectedTypeCode, FormulaRecord fr) {
        int cachedValueType = fr.getCachedResultType();
        if (cachedValueType != expectedTypeCode) {
            throw ACell.typeMismatch(expectedTypeCode, cachedValueType, true);
        }
    }

    public static int determineType(CellValueRecordInterface cval) {
        if (cval instanceof FormulaRecordAggregate) {
            return 2;
        }
        Record record = (Record)((Object)cval);
        switch (record.getSid()) {
            case 515: {
                return 0;
            }
            case 513: {
                return 3;
            }
            case 253: 
            case 516: {
                return 1;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                return boolErrRecord.isBoolean() ? 4 : 5;
            }
        }
        throw new RuntimeException("Bad cell value rec (" + cval.getClass().getName() + ")");
    }

    public CellValueRecordInterface getCellValueRecord() {
        return this.record;
    }

    public void setCellType(int cellType, boolean setValue) {
        int row = this.record.getRow();
        short col = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        this.setCellType(cellType, setValue, row, col, styleIndex);
    }

    private void setCellType(int cellType, boolean setValue, int row, short col, short styleIndex) {
        if (cellType > 5) {
            throw new RuntimeException("I have no idea what type that is!");
        }
        switch (cellType) {
            case 2: {
                FormulaRecordAggregate frec;
                if (this.cellType != cellType) {
                    frec = ((ASheet)this.sheet).getInternalSheet().getRowsAggregate().createFormula(row, col);
                } else {
                    frec = (FormulaRecordAggregate)this.record;
                    frec.setRow(row);
                    frec.setColumn(col);
                }
                frec.setXFIndex(styleIndex);
                this.record = frec;
                break;
            }
            case 0: {
                NumberRecord nrec = null;
                nrec = cellType != this.cellType ? new NumberRecord() : (NumberRecord)this.record;
                nrec.setColumn(col);
                nrec.setXFIndex(styleIndex);
                nrec.setRow(row);
                this.record = nrec;
                break;
            }
            case 1: {
                LabelSSTRecord lrec;
                if (cellType == this.cellType) {
                    lrec = (LabelSSTRecord)this.record;
                } else {
                    lrec = new LabelSSTRecord();
                    lrec.setColumn(col);
                    lrec.setRow(row);
                    lrec.setXFIndex(styleIndex);
                }
                this.record = lrec;
                break;
            }
            case 3: {
                BlankRecord brec = null;
                brec = this.cellType != cellType ? new BlankRecord() : (BlankRecord)this.record;
                brec.setColumn(col);
                brec.setXFIndex(styleIndex);
                brec.setRow(row);
                this.record = brec;
                break;
            }
            case 4: {
                BoolErrRecord boolRec = null;
                boolRec = cellType != this.cellType ? new BoolErrRecord() : (BoolErrRecord)this.record;
                boolRec.setColumn(col);
                boolRec.setXFIndex(styleIndex);
                boolRec.setRow(row);
                this.record = boolRec;
                break;
            }
            case 5: {
                BoolErrRecord errRec = null;
                errRec = cellType != this.cellType ? new BoolErrRecord() : (BoolErrRecord)this.record;
                errRec.setColumn(col);
                errRec.setXFIndex(styleIndex);
                errRec.setRow(row);
                this.record = errRec;
            }
        }
        this.cellType = (short)cellType;
    }

    public void setCellValue(double value) {
        switch (this.cellType) {
            case 1: {
                this.value = Math.round((float)value);
                break;
            }
            case 0: {
                ((NumberRecord)this.record).setValue(value);
                this.value = value;
                break;
            }
        }
    }

    public void setCellValue(boolean value) {
        switch (this.cellType) {
            case 4: {
                ((BoolErrRecord)this.record).setValue(value);
                this.value = value;
                break;
            }
        }
    }

    public void setCellValue(String value) {
        HSSFRichTextString richString = value == null ? null : new HSSFRichTextString(value);
        int row = this.record.getRow();
        short col = this.record.getColumn();
        short styleIndex = this.record.getXFIndex();
        if (richString == null) {
            this.setCellType(3, false, row, col, styleIndex);
            return;
        }
        if (richString.length() > SpreadsheetVersion.EXCEL97.getMaxTextLength()) {
            throw new IllegalArgumentException("The maximum length of cell contents (text) is 32,767 characters");
        }
        int index = 0;
        UnicodeString str = richString.getUnicodeString();
        index = ((AWorkbook)this.sheet.getWorkbook()).getInternalWorkbook().addSSTString(str);
        ((LabelSSTRecord)this.record).setSSTIndex(index);
        this.value = index;
    }

    public void setCellErrorValue(byte errorCode) {
        switch (this.cellType) {
            case 5: {
                ((BoolErrRecord)this.record).setValue(errorCode);
                this.value = errorCode;
                break;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.record = null;
    }
}

