/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.control;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Message;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.ahmadullahpk.alldocumentreader.xs.common.IOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IWord;
import com.ahmadullahpk.alldocumentreader.xs.ss.control.ExcelView;
import com.ahmadullahpk.alldocumentreader.xs.ss.control.SSEditor;
import com.ahmadullahpk.alldocumentreader.xs.ss.control.SSEventManage;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.interfacePart.IReaderListener;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ModelUtil;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IFind;
import com.ahmadullahpk.alldocumentreader.xs.system.ReaderHandler;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.AEventManage;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.CalloutView;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.IExportListener;
import java.io.File;

public class Spreadsheet
extends LinearLayout
implements IFind,
IReaderListener,
IExportListener {
    private ExcelView parent;
    private boolean isConfigurationChanged;
    private boolean isDefaultSheetBar = true;
    private boolean abortDrawing;
    private boolean initFinish;
    private int preShowSheetIndex = -1;
    private int currentSheetIndex;
    private String currentSheetName;
    private int sheetbarHeight;
    private String fileName;
    private IControl control;
    private Workbook workbook;
    private SheetView sheetview;
    private SSEventManage eventManage;
    private SSEditor editor;
    private CalloutView callouts;

    public Spreadsheet(Context context, String filepath, Workbook book, IControl control, ExcelView parent) {
        super(context);
        this.parent = parent;
        this.fileName = filepath;
        this.setBackgroundColor(-1);
        this.workbook = book;
        this.control = control;
        this.eventManage = new SSEventManage(this, control);
        this.editor = new SSEditor(this);
        this.setOnTouchListener(this.eventManage);
        this.setLongClickable(true);
    }

    public CalloutView getCalloutView() {
        return this.callouts;
    }

    public void initCalloutView() {
        if (this.callouts == null) {
            this.callouts = new CalloutView(this.getContext(), this.control, this);
            this.callouts.setIndex(this.currentSheetIndex);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
            params.leftMargin = 50;
            params.topMargin = 30;
            this.addView(this.callouts, (ViewGroup.LayoutParams)params);
        }
    }

    @Override
    public void exportImage() {
        this.control.actionEvent(0x2000000A, null);
    }

    public void init() {
        int index = this.fileName.lastIndexOf(File.separator);
        if (index > 0) {
            this.fileName = this.fileName.substring(index + 1);
        }
        this.control.actionEvent(0x40000000, this.fileName + " : " + this.workbook.getSheet(0).getSheetName());
        if (this.sheetview == null) {
            this.sheetview = new SheetView(this, this.workbook.getSheet(0));
        }
        this.initFinish = true;
        short state = this.workbook.getSheet(0).getState();
        if (state != 2) {
            this.workbook.getSheet(0).setReaderListener(this);
            this.control.actionEvent(26, true);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                Spreadsheet.this.control.actionEvent(0x2000000A, null);
            }
        });
    }

    private void initSheetbar() {
    }

    public void removeSheetBar() {
        this.isDefaultSheetBar = false;
    }

    public int getSheetCount() {
        return this.workbook.getSheetCount();
    }

    public void showSheet(String sheetName) {
        if (this.currentSheetName != null && this.currentSheetName.equals(sheetName)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            return;
        }
        this.currentSheetName = sheetName;
        this.currentSheetIndex = this.workbook.getSheetIndex(sheet);
        this.showSheet(sheet);
    }

    public void showSheet(int sheetIndex) {
        if (this.currentSheetIndex == sheetIndex || sheetIndex >= this.getSheetCount()) {
            return;
        }
        Sheet sheet = this.workbook.getSheet(sheetIndex);
        this.currentSheetIndex = sheetIndex;
        this.currentSheetName = sheet.getSheetName();
        this.control.actionEvent(20, null);
        if (this.callouts != null) {
            this.callouts.setIndex(this.currentSheetIndex);
        }
        this.showSheet(sheet);
    }

    private void showSheet(Sheet sheet) {
        try {
            this.eventManage.stopFling();
            this.control.getMainFrame().setFindBackForwardState(false);
            this.control.actionEvent(0x40000000, this.fileName + " : " + sheet.getSheetName());
            this.sheetview.changeSheet(sheet);
            this.postInvalidate();
            if (sheet.getState() != 2) {
                sheet.setReaderListener(this);
                this.control.actionEvent(26, true);
                this.control.actionEvent(0x20000009, null);
            } else {
                this.control.actionEvent(26, false);
            }
            ReaderHandler readerHandler = this.workbook.getReaderHandler();
            if (readerHandler != null) {
                Message msg = new Message();
                msg.what = 0;
                msg.obj = this.currentSheetIndex;
                readerHandler.handleMessage(msg);
            }
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (!this.initFinish) {
            return;
        }
        try {
            this.sheetview.drawSheet(canvas);
            if (this.control.isAutoTest()) {
                if (this.currentSheetIndex < this.workbook.getSheetCount() - 1) {
                    try {
                        while (this.sheetview.getCurrentSheet().getState() != 2) {
                            Thread.sleep(50L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.showSheet(this.currentSheetIndex + 1);
                } else {
                    this.control.actionEvent(22, true);
                }
            } else {
                IOfficeToPicture otp = this.control.getOfficeToPicture();
                if (otp != null && otp.getModeType() == 0) {
                    this.toPicture(otp);
                }
            }
            if (this.sheetview.getCurrentSheet().getState() != 2) {
                this.invalidate();
            }
            if (this.preShowSheetIndex != this.currentSheetIndex) {
                this.control.getMainFrame().changePage();
                this.preShowSheetIndex = this.currentSheetIndex;
            }
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
        }
    }

    public void createPicture() {
        IOfficeToPicture otp = this.control.getOfficeToPicture();
        if (otp != null && otp.getModeType() == 1) {
            try {
                this.toPicture(otp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void toPicture(IOfficeToPicture otp) {
        boolean b = PictureKit.instance().isDrawPictrue();
        PictureKit.instance().setDrawPictrue(true);
        Bitmap bitmap = otp.getBitmap(this.getWidth(), this.getHeight());
        if (bitmap == null) {
            return;
        }
        Canvas picCanvas = new Canvas(bitmap);
        float oldPaintZoom = this.sheetview.getZoom();
        if (bitmap.getWidth() != this.getWidth() || bitmap.getHeight() != this.getHeight()) {
            float zoom = Math.min((float)bitmap.getWidth() / (float)this.getWidth(), (float)bitmap.getHeight() / (float)this.getHeight()) * oldPaintZoom;
            this.sheetview.setZoom(zoom, true);
        }
        picCanvas.drawColor(-1);
        this.sheetview.drawSheet(picCanvas);
        this.control.getSysKit().getCalloutManager().drawPath(picCanvas, this.currentSheetIndex, oldPaintZoom);
        otp.callBack(bitmap);
        this.sheetview.setZoom(oldPaintZoom, true);
        PictureKit.instance().setDrawPictrue(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getSnapshot(Bitmap destBitmap) {
        if (destBitmap == null) {
            return null;
        }
        SheetView sheetView = this.sheetview;
        synchronized (sheetView) {
            Canvas picCanvas = new Canvas(destBitmap);
            float oldPaintZoom = this.sheetview.getZoom();
            if (destBitmap.getWidth() != this.getWidth() || destBitmap.getHeight() != this.getHeight()) {
                float zoom = Math.min((float)destBitmap.getWidth() / (float)this.getWidth(), (float)destBitmap.getHeight() / (float)this.getHeight()) * oldPaintZoom;
                this.sheetview.setZoom(zoom, true);
            }
            picCanvas.drawColor(-1);
            this.sheetview.drawSheet(picCanvas);
            this.sheetview.setZoom(oldPaintZoom, true);
            return destBitmap;
        }
    }

    public Bitmap getThumbnail(int width, int height, float zoomValue) {
        Sheet sheet = this.workbook.getSheet(0);
        if (sheet == null || sheet.getState() != 2) {
            return null;
        }
        if (this.sheetview == null) {
            this.sheetview = new SheetView(this, this.workbook.getSheet(0));
        }
        return this.sheetview.getThumbnail(sheet, width, height, zoomValue);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.isConfigurationChanged = true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.isConfigurationChanged) {
            this.isConfigurationChanged = false;
            this.post(new Runnable(){

                @Override
                public void run() {
                    Spreadsheet.this.control.actionEvent(0x2000000A, null);
                }
            });
        }
    }

    public void computeScroll() {
        this.eventManage.computeScroll();
    }

    public IControl getControl() {
        return this.control;
    }

    public SheetView getSheetView() {
        return this.sheetview;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public String getActiveCellContent() {
        if (this.sheetview.getCurrentSheet().getActiveCell() != null) {
            return ModelUtil.instance().getFormatContents(this.workbook, this.sheetview.getCurrentSheet().getActiveCell());
        }
        return "";
    }

    public Hyperlink getActiveCellHyperlink() {
        Cell cell = this.sheetview.getCurrentSheet().getActiveCell();
        if (cell != null && cell.getHyperLink() != null) {
            return cell.getHyperLink();
        }
        return null;
    }

    @Override
    public boolean find(String value) {
        return this.sheetview.find(value);
    }

    @Override
    public boolean findBackward() {
        return this.sheetview.findBackward();
    }

    @Override
    public boolean findForward() {
        return this.sheetview.findForward();
    }

    @Override
    public void resetSearchResult() {
    }

    @Override
    public int getPageIndex() {
        return -1;
    }

    public float getZoom() {
        if (this.sheetview == null) {
            this.sheetview = new SheetView(this, this.workbook.getSheet(0));
        }
        return this.sheetview.getZoom();
    }

    public void setZoom(float zoom) {
        if (this.sheetview == null) {
            this.sheetview = new SheetView(this, this.workbook.getSheet(0));
        }
        this.sheetview.setZoom(zoom);
    }

    public float getFitZoom() {
        return 0.5f;
    }

    public AEventManage getEventManage() {
        return this.eventManage;
    }

    @Override
    public void OnReadingFinished() {
        if (this.control != null && this.control.getMainFrame().getActivity() != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    Sheet sheet = Spreadsheet.this.workbook.getSheet(Spreadsheet.this.currentSheetIndex);
                    Spreadsheet.this.control.actionEvent(0x40000000, Spreadsheet.this.fileName + " : " + sheet.getSheetName());
                    Spreadsheet.this.control.actionEvent(26, false);
                    Spreadsheet.this.control.actionEvent(0x2000000A, null);
                    Spreadsheet.this.postInvalidate();
                }
            });
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void abortDrawing() {
        this.abortDrawing = true;
    }

    public void startDrawing() {
        this.abortDrawing = false;
    }

    public boolean isAbortDrawing() {
        return this.abortDrawing;
    }

    public int getCurrentSheetNumber() {
        return this.currentSheetIndex + 1;
    }

    public int getBottomBarHeight() {
        return this.parent.getBottomBarHeight();
    }

    public IWord getEditor() {
        return this.editor;
    }

    @Override
    public void dispose() {
        this.parent = null;
        this.fileName = null;
        this.control = null;
        this.workbook = null;
        if (this.sheetview != null) {
            this.sheetview.dispose();
            this.sheetview = null;
        }
        if (this.eventManage != null) {
            this.eventManage.dispose();
            this.eventManage = null;
        }
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
    }
}

