/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.control;

import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.xs.ss.control.Spreadsheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.DrawingCell;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.FocusCell;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.ITimerListener;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.AEventManage;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.ATimer;

public class SSEventManage
extends AEventManage
implements ITimerListener {
    private static final int MINDISTANCE = 10;
    private boolean longPress;
    private int oldX;
    private int oldY;
    private Spreadsheet spreadsheet;
    private FocusCell oldHeaderArea;
    private FocusCell newHeaderArea;
    private boolean actionDown;
    private boolean scrolling;
    private ATimer timer;

    public SSEventManage(Spreadsheet spreadsheet, IControl control) {
        super(spreadsheet.getContext(), control);
        this.spreadsheet = spreadsheet;
        this.timer = new ATimer(1000, this);
    }

    @Override
    public void actionPerformed() {
        this.timer.stop();
        this.control.actionEvent(0x2000000A, null);
    }

    private void changingHeader(MotionEvent event) {
        if (this.newHeaderArea == null) {
            return;
        }
        this.scrolling = true;
        float x = event.getX();
        float y = event.getY();
        switch (this.newHeaderArea.getType()) {
            case 1: {
                Rect area = this.newHeaderArea.getRect();
                area.bottom = Math.round((float)this.oldHeaderArea.getRect().bottom + (y - (float)this.oldY));
                if (area.bottom > area.top + 10) break;
                area.bottom = area.top + 10;
                break;
            }
            case 2: {
                Rect area = this.newHeaderArea.getRect();
                area.right = Math.round((float)this.oldHeaderArea.getRect().right + (x - (float)this.oldX));
                if (area.right > area.left + 10) break;
                area.right = area.left + 10;
                break;
            }
        }
        this.spreadsheet.getSheetView().changeHeaderArea(this.newHeaderArea);
    }

    private boolean checkClickedCell(MotionEvent event) {
        int maxColumns;
        int maxRows;
        float x = event.getX();
        float y = event.getY();
        if ((float)this.spreadsheet.getSheetView().getColumnHeaderHeight() > y || (float)this.spreadsheet.getSheetView().getRowHeaderWidth() > x) {
            return false;
        }
        SheetView sheetView = this.spreadsheet.getSheetView();
        DrawingCell cellInfor = new DrawingCell();
        cellInfor.setLeft(sheetView.getRowHeaderWidth());
        cellInfor.setTop(sheetView.getColumnHeaderHeight());
        cellInfor.setRowIndex(sheetView.getMinRowAndColumnInformation().getMinRowIndex());
        cellInfor.setColumnIndex(sheetView.getMinRowAndColumnInformation().getMinColumnIndex());
        int n = maxRows = sheetView.getCurrentSheet().getWorkbook().isBefore07Version() ? 65536 : 0x100000;
        while (cellInfor.getTop() <= y && cellInfor.getRowIndex() <= maxRows) {
            Row row = sheetView.getCurrentSheet().getRow(cellInfor.getRowIndex());
            if (row != null && row.isZeroHeight()) {
                cellInfor.setRowIndex(cellInfor.getRowIndex() + 1);
                continue;
            }
            cellInfor.setHeight(row == null ? (float)sheetView.getCurrentSheet().getDefaultRowHeight() : row.getRowPixelHeight());
            cellInfor.setHeight(Math.round(cellInfor.getHeight() * sheetView.getZoom()));
            if (cellInfor.getRowIndex() == sheetView.getMinRowAndColumnInformation().getMinRowIndex() && !sheetView.getMinRowAndColumnInformation().isRowAllVisible()) {
                cellInfor.setVisibleHeight(Math.round(sheetView.getMinRowAndColumnInformation().getVisibleRowHeight() * (double)sheetView.getZoom()));
            } else {
                cellInfor.setVisibleHeight(cellInfor.getHeight());
            }
            cellInfor.setTop(cellInfor.getTop() + cellInfor.getVisibleHeight());
            cellInfor.setRowIndex(cellInfor.getRowIndex() + 1);
        }
        int n2 = maxColumns = sheetView.getCurrentSheet().getWorkbook().isBefore07Version() ? 256 : 16384;
        while (cellInfor.getLeft() <= x && cellInfor.getColumnIndex() <= maxColumns) {
            if (sheetView.getCurrentSheet().isColumnHidden(cellInfor.getColumnIndex())) {
                cellInfor.setColumnIndex(cellInfor.getColumnIndex() + 1);
                continue;
            }
            cellInfor.setWidth(Math.round(sheetView.getCurrentSheet().getColumnPixelWidth(cellInfor.getColumnIndex()) * sheetView.getZoom()));
            if (cellInfor.getColumnIndex() == sheetView.getMinRowAndColumnInformation().getMinColumnIndex() && !sheetView.getMinRowAndColumnInformation().isColumnAllVisible()) {
                cellInfor.setVisibleWidth(Math.round(sheetView.getMinRowAndColumnInformation().getVisibleColumnWidth() * (double)sheetView.getZoom()));
            } else {
                cellInfor.setVisibleWidth(cellInfor.getWidth());
            }
            cellInfor.setLeft(cellInfor.getLeft() + cellInfor.getVisibleWidth());
            cellInfor.setColumnIndex(cellInfor.getColumnIndex() + 1);
        }
        this.spreadsheet.getSheetView().getCurrentSheet().setActiveCellType((short)0);
        this.spreadsheet.getSheetView().selectedCell(cellInfor.getRowIndex() - 1, cellInfor.getColumnIndex() - 1);
        this.spreadsheet.getControl().actionEvent(0x20000007, null);
        this.spreadsheet.abortDrawing();
        this.spreadsheet.postInvalidate();
        return true;
    }

    private boolean changeHeaderEnd() {
        boolean ret = false;
        this.scrolling = false;
        if (this.oldHeaderArea != null) {
            Sheet sheet = this.spreadsheet.getSheetView().getCurrentSheet();
            switch (this.oldHeaderArea.getType()) {
                case 1: {
                    ret = true;
                    int index = this.newHeaderArea.getRow();
                    Row row = sheet.getRow(index);
                    if (row == null) {
                        row = new Row(0);
                        row.setRowNumber(index);
                        row.setSheet(sheet);
                        sheet.addRow(row);
                    } else {
                        while (sheet.getRow(index) != null && sheet.getRow(index).isZeroHeight()) {
                            --index;
                        }
                        row = sheet.getRow(index);
                        if (row == null) {
                            row = new Row(0);
                            row.setRowNumber(index);
                            row.setSheet(sheet);
                            sheet.addRow(row);
                        }
                    }
                    float off = (float)(this.newHeaderArea.getRect().bottom - this.newHeaderArea.getRect().top) - (float)(this.oldHeaderArea.getRect().bottom - this.oldHeaderArea.getRect().top);
                    row.setRowPixelHeight(Math.round(row.getRowPixelHeight() + off / this.spreadsheet.getSheetView().getZoom()));
                    index = row.getRowNumber();
                    while (index <= sheet.getLastRowNum()) {
                        if ((row = sheet.getRow(index++)) == null) continue;
                        for (int i = row.getFirstCol(); i <= row.getLastCol(); ++i) {
                            Cell cell = row.getCell(i);
                            if (cell == null) continue;
                            if (cell.getRangeAddressIndex() >= 0) {
                                CellRangeAddress cr = sheet.getMergeRange(cell.getRangeAddressIndex());
                                Row tRow = sheet.getRow(cr.getFirstRow());
                                cell = tRow.getCell(cr.getFirstColumn());
                            }
                            cell.removeSTRoot();
                        }
                        row.setInitExpandedRangeAddress(false);
                    }
                    break;
                }
                case 2: {
                    ret = true;
                    float off = this.newHeaderArea.getRect().right - this.newHeaderArea.getRect().left - (this.oldHeaderArea.getRect().right - this.oldHeaderArea.getRect().left);
                    int index = this.newHeaderArea.getColumn();
                    while (sheet.isColumnHidden(index)) {
                        --index;
                    }
                    int width = Math.round(sheet.getColumnPixelWidth(index) + off / this.spreadsheet.getSheetView().getZoom());
                    sheet.setColumnPixelWidth(index, width);
                    index = sheet.getFirstRowNum();
                    while (index <= sheet.getLastRowNum()) {
                        Row row;
                        if ((row = sheet.getRow(index++)) == null) continue;
                        for (int i = Math.max(row.getFirstCol(), this.oldHeaderArea.getColumn()); i <= row.getLastCol(); ++i) {
                            Cell cell = row.getCell(i);
                            if (cell == null) continue;
                            if (cell.getRangeAddressIndex() >= 0) {
                                CellRangeAddress cr = sheet.getMergeRange(cell.getRangeAddressIndex());
                                Row tRow = sheet.getRow(cr.getFirstRow());
                                cell = tRow.getCell(cr.getFirstColumn());
                            }
                            cell.removeSTRoot();
                        }
                        row.setInitExpandedRangeAddress(false);
                    }
                    break;
                }
            }
            this.spreadsheet.getSheetView().updateMinRowAndColumnInfo();
            this.spreadsheet.getSheetView().setDrawMovingHeaderLine(false);
            this.oldHeaderArea = null;
            this.newHeaderArea = null;
        }
        return ret;
    }

    private int findClickedRowHeader(MotionEvent event) {
        int maxRows;
        float y = event.getY();
        SheetView sheetView = this.spreadsheet.getSheetView();
        DrawingCell cellInfor = new DrawingCell();
        cellInfor.setTop(sheetView.getColumnHeaderHeight());
        cellInfor.setRowIndex(sheetView.getMinRowAndColumnInformation().getMinRowIndex());
        int n = maxRows = sheetView.getCurrentSheet().getWorkbook().isBefore07Version() ? 65536 : 0x100000;
        while (cellInfor.getTop() <= y && cellInfor.getRowIndex() <= maxRows) {
            Row row = sheetView.getCurrentSheet().getRow(cellInfor.getRowIndex());
            if (row != null && row.isZeroHeight()) {
                cellInfor.setRowIndex(cellInfor.getRowIndex() + 1);
                continue;
            }
            cellInfor.setHeight(row == null ? (float)sheetView.getCurrentSheet().getDefaultRowHeight() : row.getRowPixelHeight());
            cellInfor.setHeight(Math.round(cellInfor.getHeight() * sheetView.getZoom()));
            if (cellInfor.getRowIndex() == sheetView.getMinRowAndColumnInformation().getMinRowIndex() && !sheetView.getMinRowAndColumnInformation().isRowAllVisible()) {
                cellInfor.setVisibleHeight(Math.round(sheetView.getMinRowAndColumnInformation().getVisibleRowHeight() * (double)sheetView.getZoom()));
            } else {
                cellInfor.setVisibleHeight(cellInfor.getHeight());
            }
            cellInfor.setTop(cellInfor.getTop() + cellInfor.getVisibleHeight());
            cellInfor.setRowIndex(cellInfor.getRowIndex() + 1);
        }
        return cellInfor.getRowIndex() - 1;
    }

    private int findClickedColumnHeader(MotionEvent event) {
        int maxColumns;
        float x = event.getX();
        SheetView sheetView = this.spreadsheet.getSheetView();
        DrawingCell cellInfor = new DrawingCell();
        cellInfor.setLeft(sheetView.getRowHeaderWidth());
        cellInfor.setColumnIndex(sheetView.getMinRowAndColumnInformation().getMinColumnIndex());
        int n = maxColumns = sheetView.getCurrentSheet().getWorkbook().isBefore07Version() ? 256 : 16384;
        while (cellInfor.getLeft() <= x && cellInfor.getColumnIndex() <= maxColumns) {
            if (sheetView.getCurrentSheet().isColumnHidden(cellInfor.getColumnIndex())) {
                cellInfor.setColumnIndex(cellInfor.getColumnIndex() + 1);
                continue;
            }
            cellInfor.setWidth(Math.round(sheetView.getCurrentSheet().getColumnPixelWidth(cellInfor.getColumnIndex()) * sheetView.getZoom()));
            if (cellInfor.getColumnIndex() == sheetView.getMinRowAndColumnInformation().getMinColumnIndex() && !sheetView.getMinRowAndColumnInformation().isColumnAllVisible()) {
                cellInfor.setVisibleWidth(Math.round(sheetView.getMinRowAndColumnInformation().getVisibleColumnWidth() * (double)sheetView.getZoom()));
            } else {
                cellInfor.setVisibleWidth(cellInfor.getWidth());
            }
            cellInfor.setLeft(cellInfor.getLeft() + cellInfor.getVisibleWidth());
            cellInfor.setColumnIndex(cellInfor.getColumnIndex() + 1);
        }
        return cellInfor.getColumnIndex() - 1;
    }

    private boolean checkClickedHeader(MotionEvent event) {
        boolean ret = false;
        float x = event.getX();
        float y = event.getY();
        SheetView sheetView = this.spreadsheet.getSheetView();
        if ((float)sheetView.getRowHeaderWidth() > x && (float)sheetView.getColumnHeaderHeight() < y) {
            ret = true;
            sheetView.getCurrentSheet().setActiveCellType((short)1);
            sheetView.getCurrentSheet().setActiveCellRow(this.findClickedRowHeader(event));
        } else if ((float)sheetView.getRowHeaderWidth() < x && (float)sheetView.getColumnHeaderHeight() > y) {
            ret = true;
            sheetView.getCurrentSheet().setActiveCellType((short)2);
            sheetView.getCurrentSheet().setActiveCellColumn(this.findClickedColumnHeader(event));
        }
        this.spreadsheet.getControl().actionEvent(0x20000007, null);
        return ret;
    }

    private void actionUp(MotionEvent event) {
        if (!this.actionDown) {
            return;
        }
        this.actionDown = false;
        boolean ret = false;
        ret = this.scrolling ? this.changeHeaderEnd() : (!this.longPress && this.checkClickedCell(event) ? true : this.checkClickedHeader(event));
        this.longPress = false;
        if (ret) {
            if (!this.timer.isRunning()) {
                this.timer.start();
            } else {
                this.timer.restart();
            }
        }
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        if (this.spreadsheet == null) {
            return false;
        }
        super.onTouch(v, event);
        int action = event.getAction();
        if (event.getPointerCount() == 2) {
            this.scrolling = true;
            this.actionDown = false;
            if (this.newHeaderArea != null) {
                this.spreadsheet.getSheetView().setDrawMovingHeaderLine(false);
                this.oldHeaderArea = null;
                this.newHeaderArea = null;
            }
            return true;
        }
        switch (action) {
            case 0: {
                this.actionDown = true;
                break;
            }
            case 2: {
                this.changingHeader(event);
                this.spreadsheet.abortDrawing();
                this.spreadsheet.postInvalidate();
                break;
            }
            case 1: {
                this.actionUp(event);
                this.scrolling = false;
                this.actionDown = false;
                this.spreadsheet.postInvalidate();
                break;
            }
        }
        return false;
    }

    private void findChangingRowHeader(MotionEvent event) {
        int maxRows;
        float y = event.getY();
        SheetView sheetView = this.spreadsheet.getSheetView();
        DrawingCell cellInfor = new DrawingCell();
        cellInfor.setTop(sheetView.getColumnHeaderHeight());
        cellInfor.setRowIndex(sheetView.getMinRowAndColumnInformation().getMinRowIndex());
        int oldTop = Math.round(cellInfor.getTop());
        Rect rect = new Rect();
        rect.top = rect.bottom = oldTop;
        int n = maxRows = sheetView.getCurrentSheet().getWorkbook().isBefore07Version() ? 65536 : 0x100000;
        while (cellInfor.getTop() <= y && cellInfor.getRowIndex() <= maxRows) {
            Row row = sheetView.getCurrentSheet().getRow(cellInfor.getRowIndex());
            if (row != null && row.isZeroHeight()) {
                cellInfor.setRowIndex(cellInfor.getRowIndex() + 1);
                continue;
            }
            cellInfor.setHeight(row == null ? (float)sheetView.getCurrentSheet().getDefaultRowHeight() : row.getRowPixelHeight());
            cellInfor.setHeight(Math.round(cellInfor.getHeight() * sheetView.getZoom()));
            if (cellInfor.getRowIndex() == sheetView.getMinRowAndColumnInformation().getMinRowIndex() && !sheetView.getMinRowAndColumnInformation().isRowAllVisible()) {
                cellInfor.setVisibleHeight(Math.round(sheetView.getMinRowAndColumnInformation().getVisibleRowHeight() * (double)sheetView.getZoom()));
            } else {
                cellInfor.setVisibleHeight(cellInfor.getHeight());
            }
            rect.top = rect.bottom;
            rect.bottom = Math.round(cellInfor.getTop());
            oldTop = Math.round(cellInfor.getTop());
            cellInfor.setTop(cellInfor.getTop() + cellInfor.getVisibleHeight());
            cellInfor.setRowIndex(cellInfor.getRowIndex() + 1);
        }
        if (this.oldHeaderArea == null) {
            this.oldHeaderArea = new FocusCell();
        }
        this.oldHeaderArea.setType((short)1);
        int row = 0;
        if (y > ((float)oldTop + cellInfor.getTop()) / 2.0f) {
            this.oldHeaderArea.setRow(cellInfor.getRowIndex() - 1);
            rect.top = rect.bottom;
            rect.bottom = Math.round(cellInfor.getTop());
            this.oldHeaderArea.setRect(rect);
        } else {
            row = cellInfor.getRowIndex() - 2;
            this.oldHeaderArea.setRow(row >= 0 ? row : 0);
            this.oldHeaderArea.setRect(rect);
        }
    }

    private void findChangingColumnHeader(MotionEvent event) {
        int maxColumns;
        float x = event.getX();
        SheetView sheetView = this.spreadsheet.getSheetView();
        DrawingCell cellInfor = new DrawingCell();
        cellInfor.setLeft(sheetView.getRowHeaderWidth());
        cellInfor.setColumnIndex(sheetView.getMinRowAndColumnInformation().getMinColumnIndex());
        int oldLeft = Math.round(cellInfor.getLeft());
        Rect rect = new Rect();
        rect.left = rect.right = Math.round(cellInfor.getLeft());
        int n = maxColumns = sheetView.getCurrentSheet().getWorkbook().isBefore07Version() ? 256 : 16384;
        while (cellInfor.getLeft() <= x && cellInfor.getColumnIndex() <= maxColumns) {
            if (sheetView.getCurrentSheet().isColumnHidden(cellInfor.getColumnIndex())) {
                cellInfor.setColumnIndex(cellInfor.getColumnIndex() + 1);
                continue;
            }
            cellInfor.setWidth(Math.round(sheetView.getCurrentSheet().getColumnPixelWidth(cellInfor.getColumnIndex()) * sheetView.getZoom()));
            if (cellInfor.getColumnIndex() == sheetView.getMinRowAndColumnInformation().getMinColumnIndex() && !sheetView.getMinRowAndColumnInformation().isColumnAllVisible()) {
                cellInfor.setVisibleWidth(Math.round(sheetView.getMinRowAndColumnInformation().getVisibleColumnWidth() * (double)sheetView.getZoom()));
            } else {
                cellInfor.setVisibleWidth(cellInfor.getWidth());
            }
            rect.left = rect.right;
            rect.right = Math.round(cellInfor.getLeft());
            oldLeft = Math.round(cellInfor.getLeft());
            cellInfor.setLeft(cellInfor.getLeft() + cellInfor.getVisibleWidth());
            cellInfor.setColumnIndex(cellInfor.getColumnIndex() + 1);
        }
        if (this.oldHeaderArea == null) {
            this.oldHeaderArea = new FocusCell();
        }
        this.oldHeaderArea.setType((short)2);
        if (x > ((float)oldLeft + cellInfor.getLeft()) / 2.0f) {
            this.oldHeaderArea.setColumn(cellInfor.getColumnIndex() - 1);
            rect.left = rect.right;
            rect.right = Math.round(cellInfor.getLeft());
            this.oldHeaderArea.setRect(rect);
        } else {
            int col = cellInfor.getColumnIndex() - 2;
            this.oldHeaderArea.setColumn(col >= 0 ? col : 0);
            this.oldHeaderArea.setRect(rect);
        }
    }

    @Override
    public void onLongPress(MotionEvent e) {
        super.onLongPress(e);
        this.longPress = true;
        float x = e.getX();
        float y = e.getY();
        this.oldY = Math.round(y);
        this.oldX = Math.round(x);
        SheetView sheetView = this.spreadsheet.getSheetView();
        if ((float)sheetView.getRowHeaderWidth() > x && (float)sheetView.getColumnHeaderHeight() < y) {
            this.findChangingRowHeader(e);
        } else if ((float)sheetView.getRowHeaderWidth() < x && (float)sheetView.getColumnHeaderHeight() > y) {
            this.findChangingColumnHeader(e);
        }
        if (this.oldHeaderArea != null) {
            this.newHeaderArea = this.oldHeaderArea.clone();
            this.spreadsheet.getSheetView().changeHeaderArea(this.newHeaderArea);
            this.spreadsheet.getSheetView().setDrawMovingHeaderLine(true);
            this.spreadsheet.abortDrawing();
            this.spreadsheet.postInvalidate();
        }
    }

    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        super.onScroll(e1, e2, distanceX, distanceY);
        SheetView sheetview = this.spreadsheet.getSheetView();
        boolean change = false;
        if (Math.abs(distanceX) > 2.0f) {
            change = true;
        } else {
            distanceX = 0.0f;
        }
        if (Math.abs(distanceY) > 2.0f) {
            change = true;
        } else {
            distanceY = 0.0f;
        }
        if (change) {
            this.isScroll = true;
            this.scrolling = true;
            sheetview.getRowHeader().calculateRowHeaderWidth(sheetview.getZoom());
            sheetview.scrollBy(Math.round(distanceX), Math.round(distanceY));
            this.spreadsheet.abortDrawing();
            this.spreadsheet.postInvalidate();
        }
        return true;
    }

    @Override
    public void fling(int velocityX, int velocityY) {
        super.fling(velocityX, velocityY);
        float zoom = this.spreadsheet.getSheetView().getZoom();
        int scrollX = Math.round(this.spreadsheet.getSheetView().getScrollX() * zoom);
        int scrollY = Math.round(this.spreadsheet.getSheetView().getScrollY() * zoom);
        this.oldY = 0;
        this.oldX = 0;
        if (Math.abs(velocityY) > Math.abs(velocityX)) {
            this.oldY = scrollY;
            this.mScroller.fling(scrollX, scrollY, 0, velocityY, 0, 0, 0, this.spreadsheet.getSheetView().getMaxScrollY());
        } else {
            this.oldX = scrollX;
            this.mScroller.fling(scrollX, scrollY, velocityX, 0, 0, this.spreadsheet.getSheetView().getMaxScrollX(), 0, 0);
        }
        this.spreadsheet.abortDrawing();
        this.spreadsheet.postInvalidate();
    }

    @Override
    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            this.isFling = true;
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (x == this.oldX && this.oldY == y) {
                this.mScroller.abortAnimation();
                this.spreadsheet.abortDrawing();
                this.spreadsheet.postInvalidate();
                return;
            }
            SheetView sheetview = this.spreadsheet.getSheetView();
            boolean isDraw = false;
            if (x != this.oldX && this.oldY == 0) {
                if (Math.abs(x - this.oldX) > 2) {
                    isDraw = true;
                } else {
                    this.oldX = x;
                }
            }
            if (y != this.oldY && this.oldX == 0) {
                if (Math.abs(this.oldY - y) > 2) {
                    isDraw = true;
                } else {
                    this.oldY = y;
                }
            }
            if (isDraw) {
                this.scrolling = true;
                sheetview.getRowHeader().calculateRowHeaderWidth(sheetview.getZoom());
                sheetview.scrollBy(Math.round(x - this.oldX), Math.round(y - this.oldY));
            }
            this.spreadsheet.abortDrawing();
            this.spreadsheet.postInvalidate();
            this.oldX = x;
            this.oldY = y;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.spreadsheet = null;
        if (this.oldHeaderArea != null) {
            this.oldHeaderArea.dispose();
            this.oldHeaderArea = null;
        }
        if (this.newHeaderArea != null) {
            this.newHeaderArea.dispose();
            this.newHeaderArea = null;
        }
        if (this.timer != null) {
            this.timer.dispose();
            this.timer = null;
        }
    }
}

