/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.control;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.ClipboardManager;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.xs.common.ICustomDialog;
import com.ahmadullahpk.alldocumentreader.xs.common.IOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.ss.control.ExcelView;
import com.ahmadullahpk.alldocumentreader.xs.ss.control.Spreadsheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ReferenceUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IFind;
import com.ahmadullahpk.alldocumentreader.xs.system.IMainFrame;
import com.ahmadullahpk.alldocumentreader.xs.system.SysKit;
import java.util.List;
import java.util.Vector;

public class SSControl
extends AbstractControl {
    private IControl mainControl;
    private boolean isDispose;
    private Spreadsheet spreadSheet;
    private ExcelView excelView;

    public SSControl(IControl mainControl, Workbook book, String filepath) {
        this.mainControl = mainControl;
        this.excelView = new ExcelView((Context)this.getMainFrame().getActivity(), filepath, book, this);
        this.spreadSheet = this.excelView.getSpreadsheet();
    }

    @Override
    public void layoutView(int x, int y, int w, int h) {
    }

    @Override
    public void actionEvent(int actionID, final Object obj) {
        switch (actionID) {
            case 26: {
                if (this.spreadSheet.getParent() == null) break;
                this.spreadSheet.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!SSControl.this.isDispose) {
                            SSControl.this.mainControl.getMainFrame().showProgressBar((Boolean)obj);
                        }
                    }
                });
                break;
            }
            case 27: {
                if (this.spreadSheet.getParent() != null) {
                    this.spreadSheet.post(new Runnable(){

                        @Override
                        public void run() {
                            if (!SSControl.this.isDispose) {
                                SSControl.this.mainControl.getMainFrame().updateViewImages((List)obj);
                            }
                        }
                    });
                    break;
                }
                new Thread(){

                    @Override
                    public void run() {
                        if (!SSControl.this.isDispose) {
                            SSControl.this.mainControl.getMainFrame().updateViewImages((List)obj);
                        }
                    }
                }.start();
                break;
            }
            case 19: {
                this.excelView.init();
                break;
            }
            case 0x40000001: {
                this.excelView.showSheet((Integer)obj);
                break;
            }
            case -268435456: {
                this.spreadSheet.postInvalidate();
                break;
            }
            case 0x40000000: {
                break;
            }
            case 0x20000005: {
                int[] params = (int[])obj;
                this.spreadSheet.setZoom((float)params[0] / 10000.0f);
                this.spreadSheet.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!SSControl.this.isDispose) {
                            SSControl.this.getMainFrame().changeZoom();
                            SSControl.this.updateStatus();
                        }
                    }
                });
                break;
            }
            case 0x20000007: {
                this.updateStatus();
                break;
            }
            case 0x10000002: {
                ClipboardManager clip = (ClipboardManager)this.getMainFrame().getActivity().getSystemService("clipboard");
                clip.setText((CharSequence)this.spreadSheet.getActiveCellContent());
                break;
            }
            case 0x20000008: {
                Hyperlink hyperlink = this.spreadSheet.getActiveCellHyperlink();
                if (hyperlink == null) break;
                try {
                    if (hyperlink.getLinkType() == 2) {
                        String addr = hyperlink.getAddress();
                        int index = addr.indexOf("!");
                        String sheetName = addr.substring(0, index).replace("'", "");
                        String ref = addr.substring(index + 1, addr.length());
                        int rowIndex = ReferenceUtil.instance().getRowIndex(ref);
                        int columnIndex = ReferenceUtil.instance().getColumnIndex(ref);
                        Sheet sheet = this.spreadSheet.getWorkbook().getSheet(sheetName);
                        sheet.setActiveCellRowCol(rowIndex, columnIndex);
                        this.excelView.showSheet(sheetName);
                        this.spreadSheet.getSheetView().goToCell(--rowIndex >= 0 ? rowIndex : 0, columnIndex >= 0 ? --columnIndex : 0);
                        this.getMainFrame().doActionEvent(20, null);
                        this.spreadSheet.postInvalidate();
                        break;
                    }
                    if (hyperlink.getLinkType() == 3 || hyperlink.getLinkType() == 1) {
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)hyperlink.getAddress()));
                        this.getMainFrame().getActivity().startActivity(intent);
                        break;
                    }
                    this.mainControl.actionEvent(17, "not supported hyperlink!");
                }
                catch (Exception exception) {}
                break;
            }
            case 0x20000002: {
                this.getSysKit().internetSearch(this.spreadSheet.getActiveCellContent(), this.getMainFrame().getActivity());
                break;
            }
            case 22: {
                if (!this.mainControl.isAutoTest()) break;
                this.getMainFrame().getActivity().onBackPressed();
                break;
            }
            case 0x2000000A: {
                this.exportImage();
                break;
            }
            case 0x20000009: {
                if (this.mainControl.getReader() == null) break;
                this.mainControl.getReader().abortReader();
                break;
            }
            case 0x2000000D: {
                if (this.spreadSheet.getEventManage() == null) break;
                this.spreadSheet.getEventManage().onScroll(null, null, 0.0f, -this.spreadSheet.getHeight() + 10);
                this.exportImage();
                this.spreadSheet.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!SSControl.this.isDispose) {
                            SSControl.this.updateStatus();
                        }
                    }
                });
                break;
            }
            case 0x2000000E: {
                if (this.spreadSheet.getEventManage() == null) break;
                this.spreadSheet.getEventManage().onScroll(null, null, 0.0f, this.spreadSheet.getHeight() - 10);
                this.exportImage();
                this.spreadSheet.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!SSControl.this.isDispose) {
                            SSControl.this.updateStatus();
                        }
                    }
                });
                break;
            }
            case 0x40000005: {
                this.excelView.removeSheetBar();
                break;
            }
            case 536870942: {
                this.spreadSheet.initCalloutView();
                break;
            }
        }
    }

    @Override
    public Object getActionValue(int actionID, Object obj) {
        switch (actionID) {
            case 0x20000005: {
                return Float.valueOf(this.spreadSheet.getZoom());
            }
            case 0x20000006: {
                return Float.valueOf(this.spreadSheet.getFitZoom());
            }
            case 0x2000000B: {
                return this.spreadSheet.getSheetCount();
            }
            case 0x2000000C: {
                return this.spreadSheet.getCurrentSheetNumber();
            }
            case 0x40000002: {
                Vector<String> vec = new Vector<String>();
                Workbook book = this.spreadSheet.getWorkbook();
                int cnt = book.getSheetCount();
                for (int i = 0; i < cnt; ++i) {
                    vec.add(book.getSheet(i).getSheetName());
                }
                return vec;
            }
            case 0x40000003: {
                int number = (Integer)obj;
                if (number == -1) {
                    return null;
                }
                Sheet sheet = this.spreadSheet.getWorkbook().getSheet(number - 1);
                if (sheet != null) {
                    return sheet.getSheetName();
                }
                return null;
            }
            case 0x20000010: {
                int[] paraArr;
                if (obj instanceof int[] && (paraArr = (int[])obj) != null && paraArr.length == 3) {
                    return this.spreadSheet.getThumbnail(paraArr[0], paraArr[1], (float)paraArr[2] / 10000.0f);
                }
            }
            case 536870936: {
                if (this.spreadSheet == null) break;
                return this.spreadSheet.getSnapshot((Bitmap)obj);
            }
        }
        return null;
    }

    private void updateStatus() {
        this.spreadSheet.post(new Runnable(){

            @Override
            public void run() {
                if (!SSControl.this.isDispose) {
                    SSControl.this.getMainFrame().updateToolsbarStatus();
                }
            }
        });
    }

    private void exportImage() {
        this.spreadSheet.post(new Runnable(){

            @Override
            public void run() {
                if (!SSControl.this.isDispose) {
                    SSControl.this.spreadSheet.createPicture();
                }
            }
        });
    }

    @Override
    public int getCurrentViewIndex() {
        return this.excelView.getCurrentViewIndex();
    }

    @Override
    public View getView() {
        return this.excelView;
    }

    @Override
    public Dialog getDialog(Activity activity, int id2) {
        return null;
    }

    @Override
    public IMainFrame getMainFrame() {
        return this.mainControl.getMainFrame();
    }

    @Override
    public Activity getActivity() {
        return this.mainControl.getMainFrame().getActivity();
    }

    @Override
    public IFind getFind() {
        return this.spreadSheet;
    }

    @Override
    public boolean isAutoTest() {
        return this.mainControl.isAutoTest();
    }

    @Override
    public IOfficeToPicture getOfficeToPicture() {
        return this.mainControl.getOfficeToPicture();
    }

    @Override
    public ICustomDialog getCustomDialog() {
        return this.mainControl.getCustomDialog();
    }

    @Override
    public byte getApplicationType() {
        return 1;
    }

    @Override
    public SysKit getSysKit() {
        return this.mainControl.getSysKit();
    }

    @Override
    public void dispose() {
        this.isDispose = true;
        this.mainControl = null;
        this.spreadSheet = null;
        if (this.excelView == null) {
            this.excelView.dispose();
            this.excelView = null;
        }
    }
}

