/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.simpletext.view;

import android.graphics.Canvas;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.IAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.ShapeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IWord;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.AbstractView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IRoot;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewContainer;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewKit;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LineView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ParagraphView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ViewFactory;
import java.util.ArrayList;

public class STRoot
extends AbstractView
implements IRoot {
    private boolean isWrapLine;
    private IDocument doc;
    private PageAttr pageAttr;
    private ParaAttr paraAttr;
    private DocAttr docAttr;
    private IWord container;

    public STRoot(IWord container, IDocument doc) {
        this.doc = doc;
        this.container = container;
        this.docAttr = new DocAttr();
        this.paraAttr = new ParaAttr();
        this.pageAttr = new PageAttr();
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public IWord getContainer() {
        return this.container;
    }

    @Override
    public IDocument getDocument() {
        return this.doc;
    }

    @Override
    public IControl getControl() {
        return this.container.getControl();
    }

    public void doLayout() {
        IElement sec = this.doc.getSection(0L);
        AttrManage.instance().fillPageAttr(this.pageAttr, sec.getAttribute());
        int dx = this.pageAttr.leftMargin;
        int dy = this.pageAttr.topMargin;
        this.setTopIndent(this.pageAttr.topMargin);
        this.setLeftIndent(this.pageAttr.leftMargin);
        int spanW = (this.isWrapLine ? this.pageAttr.pageWidth : Integer.MAX_VALUE) - this.pageAttr.leftMargin - this.pageAttr.rightMargin;
        spanW = Math.max(5, spanW);
        int spanH = Integer.MAX_VALUE;
        int flag = ViewKit.instance().setBitValue(0, 0, true);
        flag = ViewKit.instance().setBitValue(0, 3, !this.isWrapLine || this.pageAttr.horizontalAlign == 1);
        long maxEnd = this.doc.getAreaEnd(0L);
        int currentParaIndex = 0;
        long currentLayoutOffset = 0L;
        IElement elem = this.doc.getParagraphForIndex(currentParaIndex++, 0L);
        ParagraphView para = (ParagraphView)ViewFactory.createView(this.container.getControl(), elem, null, 5);
        this.appendChlidView(para);
        para.setStartOffset(currentLayoutOffset);
        para.setEndOffset(elem.getEndOffset());
        int maxParaWidth = 0;
        int contentHeight = 0;
        boolean firstPara = true;
        int paraCount = this.doc.getParaCount(maxEnd);
        while (spanH > 0 && currentLayoutOffset < maxEnd) {
            para.setLocation(dx, dy);
            AttrManage.instance().fillParaAttr(this.container.getControl(), this.paraAttr, elem.getAttribute());
            if (this.container.getEditType() == 2) {
                if (firstPara) {
                    this.paraAttr.beforeSpace = 0;
                }
                if (paraCount == currentParaIndex) {
                    this.paraAttr.afterSpace = 0;
                }
            }
            LayoutKit.instance().layoutPara(this.container.getControl(), this.doc, this.docAttr, this.pageAttr, this.paraAttr, para, currentLayoutOffset, dx, dy, spanW, Integer.MAX_VALUE, flag);
            int paraHeight = para.getLayoutSpan((byte)1);
            dy += paraHeight;
            currentLayoutOffset = para.getEndOffset(null);
            contentHeight += paraHeight;
            maxParaWidth = Math.max(maxParaWidth, para.getLayoutSpan((byte)0));
            if ((spanH -= paraHeight) > 0 && currentLayoutOffset < maxEnd) {
                if ((elem = this.doc.getParagraphForIndex(currentParaIndex++, 0L)) == null) break;
                para = (ParagraphView)ViewFactory.createView(this.container.getControl(), elem, null, 5);
                para.setStartOffset(currentLayoutOffset);
                this.appendChlidView(para);
            }
            firstPara = false;
        }
        if (this.pageAttr.horizontalAlign == 0) {
            this.paraAlign(this.pageAttr.horizontalAlign == 1 ? maxParaWidth : this.pageAttr.pageWidth - this.pageAttr.leftMargin - this.pageAttr.rightMargin);
        }
        this.layoutPageAlign(contentHeight, maxParaWidth);
    }

    private void paraAlign(int maxParaWidth) {
        if (this.isWrapLine) {
            return;
        }
        for (IView paraView = this.getChildView(); paraView != null; paraView = paraView.getNextView()) {
            this.paraAttr.horizontalAlignment = (byte)AttrManage.instance().getParaHorizontalAlign(paraView.getElement().getAttribute());
            for (IView line = paraView.getChildView(); line != null; line = line.getNextView()) {
                if (line.getType() != 6) continue;
                ((LineView)line).layoutAlignment(this.docAttr, this.pageAttr, this.paraAttr, ((ParagraphView)paraView).getBNView(), maxParaWidth, 0, false);
            }
        }
    }

    private void layoutPageAlign(int contentHeight, int maxParaWidth) {
        int spanHeight = this.pageAttr.pageHeight - this.pageAttr.topMargin - this.pageAttr.bottomMargin;
        int addSpan = 0;
        switch (this.pageAttr.verticalAlign) {
            case 1: {
                addSpan = (spanHeight - contentHeight) / 2;
                break;
            }
            case 2: {
                addSpan = spanHeight - contentHeight;
                break;
            }
        }
        this.setY(addSpan);
        this.setTopIndent(addSpan);
        if (this.pageAttr.horizontalAlign == 1) {
            int pageWidth = this.pageAttr.pageWidth - this.pageAttr.leftMargin - this.pageAttr.rightMargin;
            addSpan = (pageWidth - maxParaWidth) / 2;
            for (IView view = this.getChildView(); view != null; view = view.getNextView()) {
                this.paraAttr.horizontalAlignment = (byte)AttrManage.instance().getParaHorizontalAlign(view.getElement().getAttribute());
                for (IView line = view.getChildView(); line != null && line.getType() == 6; line = line.getNextView()) {
                    ((LineView)line).layoutAlignment(this.docAttr, this.pageAttr, this.paraAttr, ((ParagraphView)view).getBNView(), maxParaWidth, 0, false);
                    line.setX(line.getX() + addSpan);
                }
            }
        }
    }

    public String getText() {
        String text = "";
        for (IView view = this.getChildView(); view != null; view = view.getNextView()) {
            text = text + ((ParagraphView)view).getText();
        }
        return text;
    }

    @Override
    public void draw(Canvas canvas, int originX, int originY, float zoom) {
        ArrayList linesHeight = new ArrayList(10);
        if (this.container != null) {
            int dX = (int)((float)this.x * zoom) + originX;
            int dY = (int)((float)this.y * zoom) + originY;
            Rect clip = canvas.getClipBounds();
            int paraID = 0;
            for (IView view = this.getChildView(); view != null; view = view.getNextView()) {
                if (view.intersection(clip, dX, dY, zoom)) {
                    IAnimation animation = this.container.getParagraphAnimation(paraID);
                    if (animation != null) {
                        ShapeAnimation shapeAnim = animation.getShapeAnimation();
                        int paraBegin = shapeAnim.getParagraphBegin();
                        int paraEnd = shapeAnim.getParagraphEnd();
                        if (paraBegin == -2 && paraEnd == -2 || paraBegin == -1 && paraEnd == -1 || paraBegin >= 0 && paraEnd >= 0 && paraID >= paraBegin && paraID <= paraEnd) {
                            Rect area = view.getViewRect(dX, dY, zoom);
                            int frameCnt = (int)((float)(animation.getFPS() * animation.getDuration()) / 1000.0f);
                            float progress = animation.getCurrentAnimationInfor().getProgress();
                            if (shapeAnim.getAnimationType() == 0) {
                                a = (double)((area.bottom + 5) * 2) / Math.pow(frameCnt, 2.0);
                                y = (int)((double)(dY - (area.bottom + 5)) + 0.5 * a * Math.pow((float)frameCnt * progress, 2.0));
                                if (view.intersection(clip, dX, y, zoom) && view.intersection(clip, dX, y, zoom)) {
                                    view.draw(canvas, dX, y, zoom);
                                }
                            } else if (shapeAnim.getAnimationType() == 1) {
                                canvas.save();
                                canvas.rotate((float)animation.getCurrentAnimationInfor().getAngle(), (float)area.centerX(), (float)area.centerY());
                                view.draw(canvas, dX, dY, zoom);
                                canvas.restore();
                            } else if (shapeAnim.getAnimationType() == 2) {
                                a = (double)((clip.bottom - area.top + 5) * 2) / Math.pow(frameCnt, 2.0);
                                y = (int)((double)(dY + (clip.bottom - area.top + 5)) - 0.5 * a * Math.pow((float)frameCnt * (1.0f - progress), 2.0));
                                if (view.intersection(clip, dX, y, zoom)) {
                                    view.draw(canvas, dX, y, zoom);
                                }
                            } else {
                                view.draw(canvas, dX, dY, zoom);
                            }
                        }
                    } else {
                        view.draw(canvas, dX, dY, zoom);
                    }
                }
                ++paraID;
            }
        } else {
            super.draw(canvas, originX, originY, zoom);
        }
    }

    @Override
    public boolean canBackLayout() {
        return false;
    }

    @Override
    public void backLayout() {
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        IView view = this.getView(offset, 5, isBack);
        if (view != null) {
            view.modelToView(offset, rect, isBack);
        }
        rect.x += this.getX();
        rect.y += this.getY();
        return rect;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        IView view;
        x -= this.getX();
        y -= this.getY();
        for (view = this.getChildView(); view != null && (y < view.getY() || y >= view.getY() + view.getLayoutSpan((byte)1)); view = view.getNextView()) {
        }
        if (view != null) {
            return view.viewToModel(x, y, isBack);
        }
        return -1L;
    }

    @Override
    public ViewContainer getViewContainer() {
        return null;
    }

    public void setWrapLine(boolean b) {
        this.isWrapLine = b;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.doc = null;
        this.container = null;
        this.pageAttr = null;
        this.paraAttr = null;
        this.docAttr = null;
    }
}

