/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.simpletext.view;

import android.graphics.Canvas;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IWord;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.util.List;

public abstract class AbstractView
implements IView {
    protected IElement elem;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int topIndent;
    protected int bottomIndent;
    protected int leftIndent;
    protected int rightIndent;
    protected long start;
    protected long end;
    protected IView parent;
    protected IView child;
    protected IView preView;
    protected IView nextView;

    @Override
    public IElement getElement() {
        return this.elem;
    }

    @Override
    public void setElement(IElement elem) {
        this.elem = elem;
    }

    @Override
    public short getType() {
        return -1;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public long getStartOffset(IDocument doc) {
        return this.start;
    }

    @Override
    public void setStartOffset(long start) {
        this.start = start;
    }

    @Override
    public long getElemStart(IDocument doc) {
        return this.elem.getStartOffset();
    }

    @Override
    public long getEndOffset(IDocument doc) {
        return this.end;
    }

    @Override
    public long getElemEnd(IDocument doc) {
        return this.elem.getEndOffset();
    }

    @Override
    public IView getParentView() {
        return this.parent;
    }

    @Override
    public void setParentView(IView parent) {
        this.parent = parent;
    }

    @Override
    public IView getChildView() {
        return this.child;
    }

    @Override
    public void setChildView(IView child) {
        this.child = child;
    }

    @Override
    public IView getPreView() {
        return this.preView;
    }

    @Override
    public void setPreView(IView preView) {
        this.preView = preView;
    }

    @Override
    public IView getNextView() {
        return this.nextView;
    }

    @Override
    public void setNextView(IView nextView) {
        this.nextView = nextView;
    }

    @Override
    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    @Override
    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setBound(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = y;
    }

    @Override
    public IWord getContainer() {
        IView parent = this.getParentView();
        if (parent != null) {
            return parent.getContainer();
        }
        return null;
    }

    @Override
    public IControl getControl() {
        IView parent = this.getParentView();
        if (parent != null) {
            return parent.getControl();
        }
        return null;
    }

    @Override
    public IDocument getDocument() {
        IView parent = this.getParentView();
        if (parent != null) {
            return parent.getDocument();
        }
        return null;
    }

    @Override
    public IView getLastView() {
        IView temp = this.getChildView();
        if (temp == null) {
            return null;
        }
        while (temp.getNextView() != null) {
            temp = temp.getNextView();
        }
        return temp;
    }

    @Override
    public int getChildCount() {
        int count = 0;
        for (IView temp = this.getChildView(); temp != null; temp = temp.getNextView()) {
            ++count;
        }
        return count;
    }

    @Override
    public void appendChlidView(IView view) {
        view.setParentView(this);
        if (this.child == null) {
            this.child = view;
            return;
        }
        IView lastView = this.getLastView();
        view.setPreView(lastView);
        lastView.setNextView(view);
    }

    @Override
    public void insertView(IView view, IView newView) {
        newView.setParentView(this);
        if (view == null) {
            if (this.child == null) {
                this.child = newView;
            } else {
                newView.setNextView(this.child);
                this.child.setPreView(newView);
                this.child = newView;
            }
        }
    }

    @Override
    public void deleteView(IView view, boolean isDeleteChild) {
        view.setParentView(null);
        if (view == this.child) {
            this.child = null;
        } else {
            IView pre = view.getPreView();
            IView next = view.getNextView();
            pre.setNextView(next);
            if (next != null) {
                next.setPreView(pre);
            }
        }
        if (isDeleteChild) {
            view.dispose();
        }
    }

    @Override
    public void setEndOffset(long end) {
        this.end = end;
    }

    @Override
    public Rect getViewRect(int originX, int originY, float zoom) {
        int tw = (int)((float)this.getLayoutSpan((byte)0) * zoom);
        int th = (int)((float)this.getLayoutSpan((byte)1) * zoom);
        int tx = (int)((float)this.x * zoom) + originX;
        int ty = (int)((float)this.y * zoom) + originY;
        return new Rect(tx, ty, tx + tw, ty + th);
    }

    @Override
    public boolean intersection(Rect rect, int originX, int originY, float zoom) {
        int tw = (int)((float)this.getLayoutSpan((byte)0) * zoom);
        int th = (int)((float)this.getLayoutSpan((byte)1) * zoom);
        int rw = rect.right - rect.left;
        int rh = rect.bottom - rect.top;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = (int)((float)this.x * zoom) + originX;
        int ty = (int)((float)this.y * zoom) + originY;
        int rx = rect.left;
        int ry = rect.top;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    @Override
    public boolean contains(long offset, boolean isBack) {
        IDocument doc = this.getDocument();
        long start = this.getStartOffset(doc);
        long end = this.getEndOffset(doc);
        return offset >= start && (offset < end || offset == end && isBack);
    }

    @Override
    public boolean contains(int x, int y, boolean isBack) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.getHeight();
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        return null;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        return 0L;
    }

    @Override
    public long getNextForCoordinate(long offset, int dir, int x, int y) {
        return 0L;
    }

    @Override
    public long getNextForOffset(long offset, int dir, int x, int y) {
        return 0L;
    }

    @Override
    public int doLayout(int x, int y, int w, int h, long maxEnd, int flag) {
        return 0;
    }

    @Override
    public void draw(Canvas canvas, int originX, int originY, float zoom) {
        int dX = (int)((float)this.x * zoom) + originX;
        int dY = (int)((float)this.y * zoom) + originY;
        Rect clip = canvas.getClipBounds();
        for (IView view = this.getChildView(); view != null; view = view.getNextView()) {
            if (!view.intersection(clip, dX, dY, zoom)) continue;
            view.draw(canvas, dX, dY, zoom);
        }
    }

    public void getLineHeight(List<Integer> linesHeight) {
        IView view = this.getChildView();
        if (view != null) {
            while (view != null) {
                linesHeight.add(view.getHeight());
                view = view.getNextView();
            }
        }
    }

    @Override
    public int getTopIndent() {
        return this.topIndent;
    }

    @Override
    public void setTopIndent(int topIndent) {
        this.topIndent = topIndent;
    }

    @Override
    public int getBottomIndent() {
        return this.bottomIndent;
    }

    @Override
    public void setBottomIndent(int bottomIndent) {
        this.bottomIndent = bottomIndent;
    }

    @Override
    public int getLeftIndent() {
        return this.leftIndent;
    }

    @Override
    public void setLeftIndent(int leftIndent) {
        this.leftIndent = leftIndent;
    }

    @Override
    public int getRightIndent() {
        return this.rightIndent;
    }

    @Override
    public void setRightIndent(int rightIndent) {
        this.rightIndent = rightIndent;
    }

    @Override
    public int getLayoutSpan(byte axis) {
        if (axis == 0) {
            return this.rightIndent + this.width + this.leftIndent;
        }
        return this.topIndent + this.getHeight() + this.bottomIndent;
    }

    @Override
    public void setIndent(int left, int top, int right, int bottom) {
        this.leftIndent = left;
        this.topIndent = top;
        this.rightIndent = right;
        this.bottomIndent = bottom;
    }

    @Override
    public IView getView(long offset, int type, boolean isBack) {
        IView view;
        for (view = this.child; view != null && !view.contains(offset, isBack); view = view.getNextView()) {
        }
        if (view != null && view.getType() != type) {
            return view.getView(offset, type, isBack);
        }
        return view;
    }

    @Override
    public IView getView(int x, int y, int type, boolean isBack) {
        IView view;
        for (view = this.child; view != null && !view.contains(x, y, isBack); view = view.getNextView()) {
        }
        if (view != null && view.getType() != type) {
            return view.getView(x -= this.x, y -= this.y, type, isBack);
        }
        return view;
    }

    @Override
    public void dispose() {
        this.parent = null;
        this.elem = null;
        IView temp = this.child;
        while (temp != null) {
            IView next = temp.getNextView();
            temp.dispose();
            temp = next;
        }
        this.preView = null;
        this.nextView = null;
        this.child = null;
    }

    @Override
    public void free() {
    }
}

