/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.simpletext.font;

import android.graphics.Paint;
import android.graphics.Typeface;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.Font;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTableCellStyle;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FontKit {
    private static FontKit fontKit = new FontKit();
    private BreakIterator lineBreak = BreakIterator.getLineInstance();

    public static FontKit instance() {
        return fontKit;
    }

    public Paint getCellPaint(Cell cell, Workbook wb, SSTableCellStyle tableCellStyle) {
        Paint paint = PaintKit.instance().getPaint();
        paint.setAntiAlias(true);
        CellStyle s = cell.getCellStyle();
        Font font = wb.getFont(s.getFontIndex());
        boolean isbold = font.isBold();
        boolean isitalics = font.isItalic();
        if (isbold && isitalics) {
            paint.setTextSkewX(-0.2f);
            paint.setFakeBoldText(true);
        } else if (isbold) {
            paint.setFakeBoldText(true);
        } else if (isitalics) {
            paint.setTextSkewX(-0.2f);
        }
        if (font.isStrikeline()) {
            paint.setStrikeThruText(true);
        }
        if (font.getUnderline() != 0) {
            paint.setUnderlineText(true);
        }
        paint.setTypeface(Typeface.create((Typeface)Typeface.SANS_SERIF, (int)0));
        paint.setTextSize((float)(font.getFontSize() * 1.3333333730697632 + 0.5));
        int color2 = wb.getColor(font.getColorIndex());
        if ((color2 & 0xFFFFFF) == 0 && tableCellStyle != null) {
            color2 = tableCellStyle.getFontColor();
        }
        paint.setColor(color2);
        return paint;
    }

    public synchronized int findBreakOffset(String text, int pos) {
        this.lineBreak.setText(text);
        this.lineBreak.following(pos);
        int newPos = this.lineBreak.previous();
        return newPos == 0 ? pos : newPos;
    }

    public List<String> breakText(String content, int lineWidth, Paint paint) {
        String[] words = content.split("\\n");
        ArrayList<String> textList = new ArrayList<String>();
        for (int index = 0; index < words.length; ++index) {
            List<String> item = this.wrapText(words[index], lineWidth, paint);
            Iterator<String> iter = item.iterator();
            while (iter.hasNext()) {
                textList.add(iter.next());
            }
        }
        return textList;
    }

    public List<String> wrapText(String content, int lineWidth, Paint paint) {
        int wordIndex;
        String item = "";
        String restContent = content.substring(0);
        String[] words = restContent.split(" ");
        ArrayList<String> textList = new ArrayList<String>();
        int charIndex = 0;
        for (wordIndex = 0; wordIndex < words.length; ++wordIndex) {
            if (words[wordIndex].length() != 0) continue;
            words[wordIndex] = " ";
        }
        wordIndex = 0;
        while (wordIndex < words.length) {
            while (paint.measureText(words[wordIndex]) > (float)lineWidth) {
                char[] chars = words[wordIndex].toCharArray();
                charIndex = chars.length;
                item = words[wordIndex].substring(0, charIndex);
                while (charIndex > 0 && paint.measureText(item) > (float)lineWidth) {
                    item = words[wordIndex].substring(0, --charIndex);
                }
                textList.add(item);
                words[wordIndex] = words[wordIndex].substring(charIndex, words[wordIndex].length());
            }
            item = "";
            while (wordIndex < words.length) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!(paint.measureText(stringBuilder.append(item).append(words[wordIndex]).toString()) <= (float)lineWidth)) break;
                item = item + words[wordIndex] + " ";
                ++wordIndex;
            }
            textList.add(item.substring(0, item.length() - 1));
        }
        this.disposeString(words);
        return textList;
    }

    private void disposeString(String[] stringArray) {
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = null;
        }
        stringArray = null;
    }
}

