/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.simpletext.control;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IHighlight;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IWord;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.WPViewKit;

public class Highlight
implements IHighlight {
    private boolean isPaintHighlight = true;
    private long selectStart = 0L;
    private long selectEnd = 0L;
    private IWord word;
    private Paint paint;

    public Highlight(IWord word) {
        this.word = word;
        this.paint = new Paint(1);
        this.paint.setColor(-1598300673);
    }

    @Override
    public void draw(Canvas canvas, IView line, int originX, int originY, long start, long end, float zoom) {
        if (!this.isSelectText() || end <= this.selectStart || start > this.selectEnd || !this.isPaintHighlight) {
            return;
        }
        IView leaf = line.getView(start = Math.max(start, this.selectStart), 7, false);
        if (leaf == null) {
            return;
        }
        Rectangle sRect = new Rectangle();
        this.word.modelToView(start, sRect, false);
        long leafEnd = leaf.getEndOffset(null);
        long paintEnd = Math.min(end, this.selectEnd);
        int x = sRect.x;
        int y = originY;
        int w = leaf.getWidth();
        if (start == this.selectStart) {
            Rectangle leafRect = WPViewKit.instance().getAbsoluteCoordinate(leaf, 0, new Rectangle());
            if (this.word.getEditType() == 2 && this.word.getTextBox() != null) {
                leafRect.x += this.word.getTextBox().getBounds().x;
                leafRect.y += this.word.getTextBox().getBounds().y;
            }
            w -= sRect.x - leafRect.x;
        }
        int h = line.getLayoutSpan((byte)1);
        IView parent = line.getParentView();
        if (parent != null) {
            if (line.getPreView() == null) {
                y = (int)((float)y - (float)parent.getTopIndent() * zoom);
                h += parent.getTopIndent();
            }
            if (line.getNextView() == null) {
                h += parent.getBottomIndent();
            }
        }
        while (leafEnd <= paintEnd) {
            canvas.drawRect((float)x * zoom, (float)y, (float)(x + w) * zoom, (float)y + (float)h * zoom, this.paint);
            x += w;
            leaf = leaf.getNextView();
            if (leaf == null) break;
            w = leaf.getWidth();
            leafEnd = leaf.getEndOffset(null);
        }
        if (end >= this.selectEnd) {
            Rectangle eRect = new Rectangle();
            this.word.modelToView(this.selectEnd, eRect, false);
            if (eRect.x > x) {
                canvas.drawRect((float)x * zoom, (float)y, (float)eRect.x * zoom, (float)y + (float)h * zoom, this.paint);
            }
        }
    }

    @Override
    public String getSelectText() {
        if (this.isSelectText()) {
            return this.word.getDocument().getText(this.selectStart, this.selectEnd);
        }
        return "";
    }

    @Override
    public boolean isSelectText() {
        return this.selectStart != this.selectEnd;
    }

    @Override
    public void removeHighlight() {
        this.selectStart = 0L;
        this.selectEnd = 0L;
    }

    @Override
    public void addHighlight(long start, long end) {
        this.selectStart = start;
        this.selectEnd = end;
    }

    @Override
    public long getSelectStart() {
        return this.selectStart;
    }

    @Override
    public void setSelectStart(long selectStart) {
        this.selectStart = selectStart;
    }

    @Override
    public long getSelectEnd() {
        return this.selectEnd;
    }

    @Override
    public void setSelectEnd(long selectEnd) {
        this.selectEnd = selectEnd;
    }

    @Override
    public void setPaintHighlight(boolean isPaintHighlight) {
        this.isPaintHighlight = isPaintHighlight;
    }

    @Override
    public void dispose() {
        this.word = null;
        this.paint = null;
    }
}

