/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.common.BackgroundDrawer;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AChart;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.GroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.SmartArt;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TableCell;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TableShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectanglef;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.IAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.ShapeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGEditor;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.Presentation;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.STRoot;
import java.util.Map;

public class SlideDrawKit {
    private static SlideDrawKit kit;
    private Rect brRect = new Rect();

    public static SlideDrawKit instance() {
        if (kit == null) {
            kit = new SlideDrawKit();
        }
        return kit;
    }

    public void drawSlide(Canvas canvas, PGModel pgModel, PGEditor editor, PGSlide slide, float zoom) {
        this.drawSlide(canvas, pgModel, editor, slide, zoom, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSlide(Canvas canvas, PGModel pgModel, PGEditor editor, PGSlide slide, float zoom, Map<Integer, Map<Integer, IAnimation>> shapeVisible) {
        SlideDrawKit slideDrawKit = this;
        synchronized (slideDrawKit) {
            Dimension d = pgModel.getPageSize();
            this.brRect.set(0, 0, (int)((float)d.width * zoom), (int)((float)d.height * zoom));
            if (!BackgroundDrawer.drawBackground(canvas, editor.getControl(), slide.getSlideNo(), slide.getBackgroundAndFill(), this.brRect, null, zoom)) {
                canvas.drawColor(Color.white.getRGB());
            }
            int[] indexs = slide.getMasterIndexs();
            for (int i = 0; i < indexs.length; ++i) {
                this.drawShapes(canvas, pgModel, editor, pgModel.getSlideMaster(indexs[i]), slide.getSlideNo(), zoom, shapeVisible);
            }
            this.drawShapes(canvas, pgModel, editor, slide, slide.getSlideNo(), zoom, shapeVisible);
        }
    }

    private void drawShapes(Canvas canvas, PGModel pgModel, PGEditor editor, PGSlide slide, int slideNo, float zoom, Map<Integer, Map<Integer, IAnimation>> shapeVisible) {
        if (slide != null) {
            int count = slide.getShapeCount();
            for (int i = 0; i < count; ++i) {
                IShape shape = slide.getShape(i);
                if (shape.isHidden()) continue;
                int placeHolderID = shape.getPlaceHolderID();
                boolean draw = false;
                if (slide.getSlideType() == 2) {
                    draw = true;
                } else if (placeHolderID == 0 || placeHolderID == 19 || placeHolderID == 20 || placeHolderID == 21 || placeHolderID == 22 || placeHolderID == 23 || placeHolderID == 24) {
                    draw = true;
                }
                if (!draw) continue;
                this.drawShape(canvas, pgModel, editor, slideNo, shape, zoom, shapeVisible);
            }
        }
    }

    private Rect getShapeRect(IShape shape, float zoom) {
        Rectangle shapeRect = shape.getBounds();
        int left = Math.round((float)shapeRect.x * zoom);
        int top = Math.round((float)shapeRect.y * zoom);
        int width = Math.round((float)shapeRect.width * zoom);
        int height = Math.round((float)shapeRect.height * zoom);
        return new Rect(left, top, left + width, top + height);
    }

    private void drawShape(Canvas canvas, PGModel pgModel, PGEditor editor, int slideNo, IShape shape, float zoom, Map<Integer, Map<Integer, IAnimation>> shapeVisible) {
        canvas.save();
        if (shape instanceof GroupShape) {
            Rect rect = this.getShapeRect(shape, zoom);
            if (shape.getFlipVertical()) {
                canvas.translate((float)rect.left, (float)rect.bottom);
                canvas.scale(1.0f, -1.0f);
                canvas.translate((float)(-rect.left), (float)(-rect.top));
            }
            if (shape.getFlipHorizontal()) {
                canvas.translate((float)rect.right, (float)rect.top);
                canvas.scale(-1.0f, 1.0f);
                canvas.translate((float)(-rect.left), (float)(-rect.top));
            }
            if (shape.getRotation() != 0.0f) {
                canvas.rotate(shape.getRotation(), rect.exactCenterX(), rect.exactCenterY());
            }
            IShape[] shapes = ((GroupShape)shape).getShapes();
            for (int i = 0; i < shapes.length; ++i) {
                IShape childShape = shapes[i];
                if (shape.isHidden()) continue;
                this.drawShape(canvas, pgModel, editor, slideNo, childShape, zoom, shapeVisible);
            }
        } else if (shape.getType() == 8) {
            IShape[] shapes;
            Rect rect = this.getShapeRect(shape, zoom);
            SmartArt smartArt = (SmartArt)shape;
            BackgroundDrawer.drawLineAndFill(canvas, editor.getControl(), slideNo, smartArt, rect, zoom);
            canvas.translate((float)rect.left, (float)rect.top);
            for (IShape item : shapes = smartArt.getShapes()) {
                this.drawShape(canvas, pgModel, editor, slideNo, item, zoom, shapeVisible);
            }
        } else if (shape.getType() == 1) {
            this.drawTextShape(canvas, pgModel, editor, slideNo, (TextBox)shape, zoom, shapeVisible);
        } else if (shape.getType() == 4 || shape.getType() == 2) {
            AutoShapeKit.instance().drawAutoShape(canvas, editor.getControl(), slideNo, (AutoShape)shape, zoom);
        } else if (shape.getType() == 0) {
            this.drawPicture(canvas, editor, slideNo, (PictureShape)shape, zoom);
        } else if (shape.getType() == 5) {
            this.drawChart(canvas, editor, (AChart)shape, zoom);
        } else if (shape.getType() == 6) {
            this.drawTable(canvas, pgModel, editor, slideNo, (TableShape)shape, zoom, shapeVisible);
        }
        canvas.restore();
    }

    private void drawTextShape(Canvas canvas, PGModel pgModel, PGEditor editor, int slideNo, TextBox shape, float zoom, Map<Integer, Map<Integer, IAnimation>> shapeVisible) {
        Rectangle rect = shape.getBounds();
        SectionElement elem = shape.getElement();
        if (elem == null || elem.getEndOffset() - elem.getStartOffset() == 0L) {
            return;
        }
        canvas.save();
        IDocument doc = null;
        STRoot root = shape.getRootView();
        Presentation pgView = editor.getPGView();
        if (pgView != null && root == null && (shape.getMCType() == 1 || shape.getPlaceHolderID() == 8)) {
            doc = pgModel.getRenderersDoc();
            doc.appendSection(elem);
            String pageNumber = elem.getText(null);
            if (pageNumber != null && pageNumber.contains("*")) {
                pageNumber = pageNumber.replace("*", String.valueOf(slideNo + pgView.getPGModel().getSlideNumberOffset()));
                elem = new SectionElement();
                elem.setStartOffset(0L);
                elem.setEndOffset(pageNumber.length());
                elem.setAttribute(shape.getElement().getAttribute().clone());
                ParagraphElement paraElem = (ParagraphElement)shape.getElement().getParaCollection().getElementForIndex(0);
                ParagraphElement paraElemNew = new ParagraphElement();
                paraElemNew.setStartOffset(0L);
                paraElemNew.setEndOffset(pageNumber.length());
                paraElemNew.setAttribute(paraElem.getAttribute().clone());
                elem.appendParagraph(paraElemNew, 0L);
                LeafElement leafElem = (LeafElement)paraElem.getElementForIndex(0);
                LeafElement leafElemNew = new LeafElement(pageNumber);
                leafElemNew.setStartOffset(0L);
                leafElemNew.setEndOffset(pageNumber.length());
                leafElemNew.setAttribute(leafElem.getAttribute().clone());
                paraElemNew.appendLeaf(leafElemNew);
                shape.setElement(elem);
            }
        }
        if (root == null) {
            doc = pgModel.getRenderersDoc();
            doc.appendSection(elem);
            root = new STRoot(editor, doc);
            root.setWrapLine(shape.isWrapLine());
            root.doLayout();
            shape.setRootView(root);
        }
        if (shapeVisible != null) {
            if (shape.getGroupShapeID() >= 0) {
                editor.setShapeAnimation(shapeVisible.get(shape.getGroupShapeID()));
            } else {
                editor.setShapeAnimation(shapeVisible.get(shape.getShapeID()));
            }
            root.draw(canvas, (int)((float)rect.x * zoom), (int)((float)rect.y * zoom), zoom);
        } else {
            editor.getHighlight().setPaintHighlight(shape == editor.getEditorTextBox());
            root.draw(canvas, (int)((float)rect.x * zoom), (int)((float)rect.y * zoom), zoom);
            editor.getHighlight().setPaintHighlight(false);
        }
        canvas.restore();
    }

    private void drawPicture(Canvas canvas, PGEditor editor, int slideNo, PictureShape pictureShape, float zoom) {
        canvas.save();
        this.processRotation(canvas, pictureShape, zoom);
        Rectangle r = pictureShape.getBounds();
        Rect rect = this.getShapeRect(pictureShape, zoom);
        BackgroundDrawer.drawLineAndFill(canvas, editor.getControl(), slideNo, pictureShape, rect, zoom);
        PictureKit.instance().drawPicture(canvas, editor.getControl(), slideNo, pictureShape.getPicture(editor.getControl()), (float)r.x * zoom, (float)r.y * zoom, zoom, (float)r.width * zoom, (float)r.height * zoom, pictureShape.getPictureEffectInfor(), pictureShape.getAnimation());
        canvas.restore();
    }

    private void drawChart(Canvas canvas, PGEditor editor, AChart chart, float zoom) {
        IAnimation animation = chart.getAnimation();
        if (animation != null && animation.getCurrentAnimationInfor().getAlpha() == 0) {
            return;
        }
        canvas.save();
        Rectangle rect = chart.getBounds();
        Paint paint = PaintKit.instance().getPaint();
        if (animation != null) {
            ShapeAnimation shapeAnim = animation.getShapeAnimation();
            int paraBegin = shapeAnim.getParagraphBegin();
            int paraEnd = shapeAnim.getParagraphEnd();
            if (paraBegin == -2 && paraEnd == -2 || paraBegin == -1 && paraEnd == -1) {
                int a = animation.getCurrentAnimationInfor().getAlpha();
                paint.setAlpha(a);
                float rate = (float)a / 255.0f * 0.5f;
                double centerX = rect.getCenterX();
                double centerY = rect.getCenterY();
                rect = new Rectangle(rect);
                rect.x = Math.round((float)(centerX - (double)((float)rect.width * rate)));
                rect.y = Math.round((float)(centerY - (double)((float)rect.height * rate)));
                rect.width = (int)((float)rect.width * (rate * 2.0f));
                rect.height = (int)((float)rect.height * (rate * 2.0f));
                float zoomT = zoom * rate * 2.0f;
                this.processRotation(canvas, chart, zoomT);
                chart.getAChart().setZoomRate(zoomT);
                chart.getAChart().draw(canvas, editor.getControl(), (int)((float)rect.x * zoom), (int)((float)rect.y * zoom), (int)((float)rect.width * zoom), (int)((float)rect.height * zoom), paint);
                return;
            }
        }
        this.processRotation(canvas, chart, zoom);
        chart.getAChart().setZoomRate(zoom);
        chart.getAChart().draw(canvas, editor.getControl(), (int)((float)rect.x * zoom), (int)((float)rect.y * zoom), (int)((float)rect.width * zoom), (int)((float)rect.height * zoom), paint);
        canvas.restore();
    }

    private void drawTable(Canvas canvas, PGModel pGModel, PGEditor pGEditor, int i, TableShape tableShape, float f, Map<Integer, Map<Integer, IAnimation>> map) {
        int i2;
        Canvas canvas2 = canvas;
        TableShape tableShape2 = tableShape;
        float f2 = f;
        canvas.save();
        this.processRotation(canvas2, tableShape2, f2);
        if (tableShape.getAnimation() != null) {
            int alpha = tableShape.getAnimation().getCurrentAnimationInfor().getAlpha();
            if (alpha != 255) {
                tableShape.getBounds();
            }
            i2 = alpha;
        } else {
            i2 = 255;
        }
        int cellCount = tableShape.getCellCount();
        for (int i3 = 0; i3 < cellCount; ++i3) {
            TableCell cell = tableShape2.getCell(i3);
            if (cell == null) continue;
            Rectanglef bounds = cell.getBounds();
            this.brRect.set(Math.round(bounds.getX() * f2), Math.round(bounds.getY() * f2), Math.round((bounds.getX() + bounds.getWidth()) * f2), Math.round((bounds.getY() + bounds.getHeight()) * f2));
            BackgroundDrawer.drawBackground(canvas, pGEditor.getControl(), i, cell.getBackgroundAndFill(), this.brRect, null, f);
            this.drawCellBorder(canvas2, cell, bounds, f2);
            if (cell.getText() == null) continue;
            this.drawTextShape(canvas, pGModel, pGEditor, i, cell.getText(), f, map);
        }
        if (i2 != 255) {
            canvas.restore();
        }
        canvas.restore();
    }

    private void drawCellBorder(Canvas canvas, TableCell cell, Rectanglef rect, float zoom) {
        this.drawCellBorder(canvas, cell, rect, zoom, null);
    }

    private void drawCellBorder(Canvas canvas, TableCell cell, Rectanglef rect, float zoom, IAnimation animation) {
        Paint paint = PaintKit.instance().getPaint();
        int oldColor = paint.getColor();
        canvas.save();
        float addExd = Math.max(1.0f, zoom);
        Line line = cell.getLeftLine();
        if (line != null) {
            paint.setColor(line.getBackgroundAndFill().getForegroundColor());
            paint.setStrokeWidth((float)line.getLineWidth() * zoom);
            if (animation != null) {
                paint.setAlpha(animation.getCurrentAnimationInfor().getAlpha());
            }
            canvas.drawRect(rect.getX() * zoom, rect.getY() * zoom, rect.getX() * zoom + addExd, (rect.getY() + rect.getHeight()) * zoom, paint);
        }
        if ((line = cell.getTopLine()) != null) {
            paint.setColor(line.getBackgroundAndFill().getForegroundColor());
            paint.setStrokeWidth((float)line.getLineWidth() * zoom);
            if (animation != null) {
                paint.setAlpha(animation.getCurrentAnimationInfor().getAlpha());
            }
            canvas.drawRect(rect.getX() * zoom, rect.getY() * zoom, (rect.getX() + rect.getWidth()) * zoom, rect.getY() * zoom + addExd, paint);
        }
        if ((line = cell.getRightLine()) != null) {
            paint.setColor(line.getBackgroundAndFill().getForegroundColor());
            paint.setStrokeWidth((float)line.getLineWidth() * zoom);
            if (animation != null) {
                paint.setAlpha(animation.getCurrentAnimationInfor().getAlpha());
            }
            canvas.drawRect((rect.getX() + rect.getWidth()) * zoom, rect.getY() * zoom, (rect.getX() + rect.getWidth()) * zoom + addExd, (rect.getY() + rect.getHeight()) * zoom, paint);
        }
        if ((line = cell.getBottomLine()) != null) {
            paint.setColor(line.getBackgroundAndFill().getForegroundColor());
            paint.setStrokeWidth((float)line.getLineWidth() * zoom);
            if (animation != null) {
                paint.setAlpha(animation.getCurrentAnimationInfor().getAlpha());
            }
            canvas.drawRect(rect.getX() * zoom, (rect.getY() + rect.getHeight()) * zoom, (rect.getX() + rect.getWidth()) * zoom, (rect.getY() + rect.getHeight()) * zoom + addExd, paint);
        }
        paint.setColor(oldColor);
        canvas.restore();
    }

    private void processRotation(Canvas canvas, IShape shape, float zoom) {
        ShapeAnimation shapeAnim;
        IAnimation anim2;
        Rectangle rect = shape.getBounds();
        float angle = shape.getRotation();
        if (shape.getFlipVertical()) {
            angle += 180.0f;
        }
        if ((anim2 = shape.getAnimation()) != null && (shapeAnim = anim2.getShapeAnimation()).getAnimationType() == 1) {
            angle += (float)anim2.getCurrentAnimationInfor().getAngle();
        }
        if (angle != 0.0f) {
            float px = (float)rect.x + (float)rect.width / 2.0f;
            float py = (float)rect.y + (float)rect.height / 2.0f;
            canvas.rotate(angle, px * zoom, py * zoom);
        }
    }

    public Bitmap slideToImage(PGModel pgModel, PGEditor editor, PGSlide slide) {
        return this.slideToImage(pgModel, editor, slide, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap slideToImage(PGModel pgModel, PGEditor editor, PGSlide slide, Map<Integer, Map<Integer, IAnimation>> shapeVisible) {
        SlideDrawKit slideDrawKit = this;
        synchronized (slideDrawKit) {
            if (slide == null) {
                return null;
            }
            boolean b = PictureKit.instance().isDrawPictrue();
            PictureKit.instance().setDrawPictrue(true);
            Dimension d = pgModel.getPageSize();
            Bitmap bitmap = Bitmap.createBitmap((int)d.width, (int)d.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.brRect.set(0, 0, d.width, d.height);
            Canvas canvas = new Canvas(bitmap);
            if (!BackgroundDrawer.drawBackground(canvas, editor.getControl(), slide.getSlideNo(), slide.getBackgroundAndFill(), this.brRect, null, 1.0f)) {
                canvas.drawColor(Color.white.getRGB());
            }
            int[] indexs = slide.getMasterIndexs();
            for (int i = 0; i < indexs.length; ++i) {
                this.drawShapes(canvas, pgModel, editor, pgModel.getSlideMaster(indexs[i]), slide.getSlideNo(), 1.0f, null);
            }
            this.drawShapes(canvas, pgModel, editor, slide, slide.getSlideNo(), 1.0f, shapeVisible);
            PictureKit.instance().setDrawPictrue(b);
            return bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap slideAreaToImage(PGModel pgModel, PGEditor editor, PGSlide slide, int srcLeft, int srcTop, int srcWidth, int srcHeight, int desWidth, int desHeight) {
        SlideDrawKit slideDrawKit = this;
        synchronized (slideDrawKit) {
            if (slide == null) {
                return null;
            }
            boolean b = PictureKit.instance().isDrawPictrue();
            PictureKit.instance().setDrawPictrue(true);
            float paintZoom = Math.min((float)desWidth / (float)srcWidth, (float)desHeight / (float)srcHeight);
            Bitmap bitmap = null;
            try {
                bitmap = Bitmap.createBitmap((int)((int)((float)srcWidth * paintZoom)), (int)((int)((float)srcHeight * paintZoom)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError e) {
                return null;
            }
            if (bitmap == null) {
                return null;
            }
            Dimension d = pgModel.getPageSize();
            Canvas canvas = new Canvas(bitmap);
            this.brRect.set(0, 0, (int)(d.getWidth() * (double)paintZoom), (int)(d.getHeight() * (double)paintZoom));
            canvas.translate((float)(-srcLeft) * paintZoom, (float)(-srcTop) * paintZoom);
            canvas.drawColor(Color.white.getRGB());
            if (!BackgroundDrawer.drawBackground(canvas, editor.getControl(), slide.getSlideNo(), slide.getBackgroundAndFill(), this.brRect, null, 1.0f)) {
                // empty if block
            }
            int[] indexs = slide.getMasterIndexs();
            for (int i = 0; i < indexs.length; ++i) {
                this.drawShapes(canvas, pgModel, editor, pgModel.getSlideMaster(indexs[i]), slide.getSlideNo(), paintZoom, null);
            }
            this.drawShapes(canvas, pgModel, editor, slide, slide.getSlideNo(), paintZoom, null);
            PictureKit.instance().setDrawPictrue(b);
            return bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getThumbnail(PGModel pgModel, PGEditor editor, PGSlide slide, float zoom) {
        SlideDrawKit slideDrawKit = this;
        synchronized (slideDrawKit) {
            if (slide == null) {
                return null;
            }
            boolean b = PictureKit.instance().isDrawPictrue();
            PictureKit.instance().setDrawPictrue(true);
            Dimension d = pgModel.getPageSize();
            int w = (int)((float)d.width * zoom);
            int h = (int)((float)d.height * zoom);
            Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            this.brRect.set(0, 0, w, h);
            canvas.drawColor(Color.white.getRGB());
            if (!BackgroundDrawer.drawBackground(canvas, editor.getControl(), slide.getSlideNo(), slide.getBackgroundAndFill(), this.brRect, null, 1.0f)) {
                // empty if block
            }
            int[] indexs = slide.getMasterIndexs();
            for (int i = 0; i < indexs.length; ++i) {
                this.drawShapes(canvas, pgModel, editor, pgModel.getSlideMaster(indexs[i]), slide.getSlideNo(), zoom, null);
            }
            this.drawShapes(canvas, pgModel, editor, slide, slide.getSlideNo(), zoom, null);
            PictureKit.instance().setDrawPictrue(b);
            return bitmap;
        }
    }

    public void disposeOldSlideView(PGModel pgModel, PGSlide slide) {
        if (slide != null) {
            int count = slide.getShapeCount();
            for (int i = 0; i < count; ++i) {
                IShape shape = slide.getShape(i);
                if (shape.getType() == 1) {
                    STRoot root = ((TextBox)shape).getRootView();
                    if (root == null) continue;
                    root.dispose();
                    ((TextBox)shape).setRootView(null);
                    continue;
                }
                if (shape.getType() != 6) continue;
                int cellCount = ((TableShape)shape).getCellCount();
                for (int j = 0; j < cellCount; ++j) {
                    STRoot root;
                    TextBox tb;
                    TableCell cell = ((TableShape)shape).getCell(j);
                    if (cell == null || (tb = cell.getText()) == null || (root = tb.getRootView()) == null) continue;
                    root.dispose();
                    tb.setRootView(null);
                }
            }
        }
    }
}

