/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.control;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.ahmadullahpk.alldocumentreader.xs.common.IOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGEditor;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGFind;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGPageListItem;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.Presentation;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.pg.view.SlideDrawKit;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.STRoot;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.SysKit;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListItem;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListView;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.IPageListViewListener;

public class PGPrintMode
extends FrameLayout
implements IPageListViewListener {
    private int preShowPageIndex = -1;
    private IControl control;
    private APageListView listView;
    private Paint paint;
    private PGModel pgModel;
    private PGEditor editor;
    private Rect pageSize = new Rect();

    public PGPrintMode(Context context) {
        super(context);
    }

    public PGPrintMode(Context context, IControl control, PGModel pgModel, PGEditor editor) {
        super(context);
        this.control = control;
        this.pgModel = pgModel;
        this.editor = editor;
        this.listView = new APageListView(context, this);
        this.addView((View)this.listView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setTypeface(Typeface.SANS_SERIF);
        this.paint.setTextSize(24.0f);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.listView.setVisibility(0);
        } else {
            this.listView.setVisibility(8);
        }
    }

    public void setBackgroundColor(int color2) {
        super.setBackgroundColor(color2);
        if (this.listView != null) {
            this.listView.setBackgroundColor(color2);
        }
    }

    public void setBackgroundResource(int resid) {
        super.setBackgroundResource(resid);
        if (this.listView != null) {
            this.listView.setBackgroundResource(resid);
        }
    }

    public void setBackgroundDrawable(Drawable d) {
        super.setBackgroundDrawable(d);
        if (this.listView != null) {
            this.listView.setBackgroundDrawable(d);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            // empty if block
        }
        this.exportImage(this.listView.getCurrentPageView(), null);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.drawPageNubmer(canvas);
    }

    public void init() {
        if ((int)(this.getZoom() * 100.0f) == 100) {
            this.setZoom(this.getFitZoom(), Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
    }

    public void setZoom(float zoom, int pointX, int pointY) {
        this.listView.setZoom(zoom, pointX, pointY);
    }

    public void setFitSize(int value) {
        this.listView.setFitSize(value);
    }

    public int getFitSizeState() {
        return this.listView.getFitSizeState();
    }

    public float getZoom() {
        return this.listView.getZoom();
    }

    public float getFitZoom() {
        return this.listView.getFitZoom();
    }

    public int getCurrentPageNumber() {
        return this.listView.getCurrentPageNumber();
    }

    public APageListView getListView() {
        return this.listView;
    }

    public void nextPageView() {
        this.listView.nextPageView();
    }

    public void previousPageview() {
        this.listView.previousPageview();
    }

    public void showSlideForIndex(int index) {
        this.listView.showPDFPageForIndex(index);
    }

    @Override
    public int getPageCount() {
        return Math.max(this.pgModel.getSlideCount(), 1);
    }

    @Override
    public APageListItem getPageListItem(int position, View convertView, ViewGroup parent) {
        Rect rect = this.getPageSize(position);
        return new PGPageListItem(this.listView, this.control, this.editor, rect.width(), rect.height());
    }

    @Override
    public Rect getPageSize(int pageIndex) {
        Dimension d = this.pgModel.getPageSize();
        if (d == null) {
            this.pageSize.set(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.pageSize.set(0, 0, d.width, d.height);
        }
        return this.pageSize;
    }

    @Override
    public void exportImage(final APageListItem pageItem, Bitmap srcBitmap) {
        if (this.getControl() == null || !(this.getParent() instanceof Presentation)) {
            return;
        }
        PGFind find = (PGFind)this.control.getFind();
        if (find.isSetPointToVisible()) {
            find.setSetPointToVisible(false);
            Rectangle rect = this.editor.modelToView(this.editor.getHighlight().getSelectStart(), new Rectangle(), false);
            if (!this.listView.isPointVisibleOnScreen(rect.x, rect.y)) {
                this.listView.setItemPointVisibleOnScreen(rect.x, rect.y);
                return;
            }
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                try {
                    IOfficeToPicture otp;
                    PGSlide slide = PGPrintMode.this.pgModel.getSlide(pageItem.getPageIndex());
                    if (slide != null && (otp = PGPrintMode.this.getControl().getOfficeToPicture()) != null && otp.getModeType() == 1) {
                        int rH;
                        int rW = Math.min(PGPrintMode.this.getWidth(), pageItem.getWidth());
                        Bitmap dstBitmap = otp.getBitmap(rW, rH = Math.min(PGPrintMode.this.getHeight(), pageItem.getHeight()));
                        if (dstBitmap == null) {
                            return;
                        }
                        if (dstBitmap.getWidth() == rW && dstBitmap.getHeight() == rH) {
                            Canvas canvas = new Canvas(dstBitmap);
                            canvas.drawColor(-1);
                            float zoom = PGPrintMode.this.listView.getZoom();
                            int left = pageItem.getLeft();
                            int top = pageItem.getTop();
                            canvas.translate((float)(-(Math.max(left, 0) - left)), (float)(-(Math.max(top, 0) - top)));
                            SlideDrawKit.instance().drawSlide(canvas, PGPrintMode.this.pgModel, PGPrintMode.this.editor, slide, zoom);
                            PGPrintMode.this.control.getSysKit().getCalloutManager().drawPath(canvas, pageItem.getPageIndex(), zoom);
                        } else {
                            float paintZoom = Math.min((float)dstBitmap.getWidth() / (float)rW, (float)dstBitmap.getHeight() / (float)rH);
                            float zoom = PGPrintMode.this.listView.getZoom() * paintZoom;
                            int left = (int)((float)pageItem.getLeft() * paintZoom);
                            int top = (int)((float)pageItem.getTop() * paintZoom);
                            Canvas canvas = new Canvas(dstBitmap);
                            canvas.drawColor(-1);
                            canvas.translate((float)(-(Math.max(left, 0) - left)), (float)(-(Math.max(top, 0) - top)));
                            SlideDrawKit.instance().drawSlide(canvas, PGPrintMode.this.pgModel, PGPrintMode.this.editor, slide, zoom);
                            PGPrintMode.this.control.getSysKit().getCalloutManager().drawPath(canvas, pageItem.getPageIndex(), zoom);
                        }
                        otp.callBack(dstBitmap);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public Bitmap getSnapshot(Bitmap dstBitmap) {
        if (this.getControl() == null || !(this.getParent() instanceof Presentation)) {
            return null;
        }
        PGPageListItem pageItem = (PGPageListItem)this.getListView().getCurrentPageView();
        if (pageItem == null) {
            return null;
        }
        PGSlide slide = this.pgModel.getSlide(pageItem.getPageIndex());
        if (slide != null) {
            int rW = Math.min(this.getWidth(), pageItem.getWidth());
            int rH = Math.min(this.getHeight(), pageItem.getHeight());
            if (dstBitmap.getWidth() == rW && dstBitmap.getHeight() == rH) {
                Canvas canvas = new Canvas(dstBitmap);
                canvas.drawColor(-1);
                float zoom = this.listView.getZoom();
                int left = pageItem.getLeft();
                int top = pageItem.getTop();
                canvas.translate((float)(-(Math.max(left, 0) - left)), (float)(-(Math.max(top, 0) - top)));
                SlideDrawKit.instance().drawSlide(canvas, this.pgModel, this.editor, slide, zoom);
            } else {
                float paintZoom = Math.min((float)dstBitmap.getWidth() / (float)rW, (float)dstBitmap.getHeight() / (float)rH);
                float zoom = this.listView.getZoom() * paintZoom;
                int left = (int)((float)pageItem.getLeft() * paintZoom);
                int top = (int)((float)pageItem.getTop() * paintZoom);
                Canvas canvas = new Canvas(dstBitmap);
                canvas.drawColor(-1);
                canvas.translate((float)(-(Math.max(left, 0) - left)), (float)(-(Math.max(top, 0) - top)));
                SlideDrawKit.instance().drawSlide(canvas, this.pgModel, this.editor, slide, zoom);
            }
        }
        return dstBitmap;
    }

    @Override
    public boolean isInit() {
        return true;
    }

    @Override
    public boolean isIgnoreOriginalSize() {
        return this.control.getMainFrame().isIgnoreOriginalSize();
    }

    @Override
    public byte getPageListViewMovingPosition() {
        return this.control.getMainFrame().getPageListViewMovingPosition();
    }

    @Override
    public Object getModel() {
        return this.pgModel;
    }

    public IControl getControl() {
        return this.control;
    }

    @Override
    public boolean onEventMethod(View v, MotionEvent e1, MotionEvent e2, float velocityX, float velocityY, byte eventMethodType) {
        APageListItem item;
        if (eventMethodType == 3 && e1 != null && e1.getAction() == 1 && (item = this.listView.getCurrentPageView()) != null) {
            Hyperlink hylink;
            int hyID;
            IElement leaf;
            ParagraphElement paraElem;
            long offset;
            TextBox textBox;
            STRoot root;
            float zoom = this.listView.getZoom();
            int x = (int)((e1.getX() - (float)item.getLeft()) / zoom);
            int y = (int)((e1.getY() - (float)item.getTop()) / zoom);
            IShape shape = this.pgModel.getSlide(item.getPageIndex()).getTextboxShape(x, y);
            if (shape != null && shape.getType() == 1 && (root = (textBox = (TextBox)shape).getRootView()) != null && (offset = root.viewToModel(x - shape.getBounds().x, y - shape.getBounds().y, false)) >= 0L && (paraElem = (ParagraphElement)textBox.getElement().getElement(offset)) != null && (leaf = paraElem.getLeaf(offset)) != null && (hyID = AttrManage.instance().getHperlinkID(leaf.getAttribute())) >= 0 && (hylink = this.control.getSysKit().getHyperlinkManage().getHyperlink(hyID)) != null) {
                this.control.actionEvent(0x20000008, hylink);
                return true;
            }
        }
        return this.control.getMainFrame().onEventMethod(v, e1, e2, velocityX, velocityY, eventMethodType);
    }

    @Override
    public void updateStutus(Object obj) {
        this.control.actionEvent(20, obj);
    }

    @Override
    public void resetSearchResult(APageListItem pageItem) {
        Presentation pg;
        if (this.getParent() instanceof Presentation && (pg = (Presentation)this.getParent()).getFind().getPageIndex() != pageItem.getPageIndex()) {
            pg.getEditor().getHighlight().removeHighlight();
        }
    }

    @Override
    public boolean isTouchZoom() {
        return this.control.getMainFrame().isTouchZoom();
    }

    @Override
    public boolean isShowZoomingMsg() {
        return this.control.getMainFrame().isShowZoomingMsg();
    }

    @Override
    public void changeZoom() {
        this.control.getMainFrame().changeZoom();
    }

    @Override
    public void setDrawPictrue(boolean isDrawPictrue) {
        PictureKit.instance().setDrawPictrue(isDrawPictrue);
    }

    public PGSlide getCurrentPGSlide() {
        APageListItem item = this.listView.getCurrentPageView();
        if (item != null) {
            return this.pgModel.getSlide(item.getPageIndex());
        }
        return this.pgModel.getSlide(0);
    }

    private void drawPageNubmer(Canvas canvas) {
        if (this.control.getMainFrame().isDrawPageNumber()) {
            String pn = String.valueOf(this.listView.getCurrentPageNumber() + " / " + this.pgModel.getSlideCount());
            int w = (int)this.paint.measureText(pn);
            int h = (int)(this.paint.descent() - this.paint.ascent());
            int x = (this.getWidth() - w) / 2;
            int y = this.getHeight() - h - 20;
            Drawable drawable2 = SysKit.getPageNubmerDrawable();
            drawable2.setBounds(x - 10, y - 10, x + w + 10, y + h + 10);
            drawable2.draw(canvas);
            y = (int)((float)y - this.paint.ascent());
            canvas.drawText(pn, (float)x, (float)y, this.paint);
        }
        if (this.preShowPageIndex != this.listView.getCurrentPageNumber()) {
            this.changePage();
            this.preShowPageIndex = this.listView.getCurrentPageNumber();
        }
    }

    public void changePage() {
        this.control.getMainFrame().changePage();
    }

    @Override
    public boolean isChangePage() {
        return this.control.getMainFrame().isChangePage();
    }

    public void dispose() {
        this.control = null;
        if (this.listView != null) {
            this.listView.dispose();
        }
        this.pgModel = null;
        this.pageSize = null;
    }
}

