/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.control;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.AsyncTask;
import android.view.View;
import android.widget.ProgressBar;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGEditor;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.pg.view.SlideDrawKit;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListItem;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListView;

public class PGPageListItem
extends APageListItem {
    public static final int BUSY_SIZE = 60;
    private static final int BACKGROUND_COLOR = -1;
    private ProgressBar mBusyIndicator;
    private PGModel pgModel;
    private PGEditor editor;

    public PGPageListItem(APageListView listView, IControl control, PGEditor editor, int pageWidth, int pageHeight) {
        super(listView, pageWidth, pageHeight);
        this.control = control;
        this.pgModel = (PGModel)listView.getModel();
        this.editor = editor;
        this.setBackgroundColor(-1);
    }

    public void onDraw(Canvas canvas) {
        PGSlide slide = this.pgModel.getSlide(this.pageIndex);
        if (slide != null) {
            float zoom = this.listView.getZoom();
            SlideDrawKit.instance().drawSlide(canvas, this.pgModel, this.editor, slide, zoom);
        }
    }

    @Override
    public void setPageItemRawData(int pIndex, int pageWidth, int pageHeight) {
        super.setPageItemRawData(pIndex, pageWidth, pageHeight);
        if (this.pageIndex >= this.pgModel.getRealSlideCount()) {
            AsyncTask<Void, Void, Void> asyncTask = new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... v) {
                    while (PGPageListItem.this.pgModel != null && PGPageListItem.this.pageIndex >= PGPageListItem.this.pgModel.getRealSlideCount()) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    return null;
                }

                protected void onPreExecute() {
                    if (PGPageListItem.this.mBusyIndicator == null) {
                        PGPageListItem.this.mBusyIndicator = new ProgressBar(PGPageListItem.this.getContext());
                        PGPageListItem.this.mBusyIndicator.setIndeterminate(true);
                        PGPageListItem.this.mBusyIndicator.setBackgroundResource(17301612);
                        PGPageListItem.this.addView((View)PGPageListItem.this.mBusyIndicator);
                        PGPageListItem.this.mBusyIndicator.setVisibility(0);
                    } else {
                        PGPageListItem.this.mBusyIndicator.setVisibility(0);
                    }
                }

                protected void onPostExecute(Void v) {
                    if (PGPageListItem.this.mBusyIndicator != null) {
                        PGPageListItem.this.mBusyIndicator.setVisibility(4);
                    }
                    PGPageListItem.this.postInvalidate();
                    if (PGPageListItem.this.listView != null) {
                        if (PGPageListItem.this.pageIndex == PGPageListItem.this.listView.getCurrentPageNumber() - 1) {
                            PGPageListItem.this.listView.exportImage(PGPageListItem.this.listView.getCurrentPageView(), null);
                        }
                        PGPageListItem.this.isInit = false;
                    }
                }
            };
            asyncTask.execute((Object[])new Void[1]);
        } else {
            if ((int)(this.listView.getZoom() * 100.0f) == 100 || this.isInit && pIndex == 0) {
                this.listView.exportImage(this, null);
            }
            this.isInit = false;
            if (this.mBusyIndicator != null) {
                this.mBusyIndicator.setVisibility(4);
            }
        }
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        SlideDrawKit.instance().disposeOldSlideView(this.pgModel, this.pgModel.getSlide(this.pageIndex));
    }

    @Override
    public void blank(int pIndex) {
        super.blank(pIndex);
    }

    @Override
    protected void addRepaintImageView(Bitmap bmp) {
        this.postInvalidate();
        this.listView.exportImage(this, bmp);
    }

    @Override
    protected void removeRepaintImageView() {
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int w = right - left;
        int h = bottom - top;
        if (this.mBusyIndicator != null) {
            int x = w > this.listView.getWidth() ? (this.listView.getWidth() - 60) / 2 - left : (w - 60) / 2;
            int y = h > this.listView.getHeight() ? (this.listView.getHeight() - 60) / 2 - top : (h - 60) / 2;
            this.mBusyIndicator.layout(x, y, x + 60, y + 60);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.control = null;
        this.pgModel = null;
    }
}

