/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.control;

import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.IAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.Presentation;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.Highlight;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IHighlight;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IWord;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.STRoot;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.util.Map;

public class PGEditor
implements IWord {
    private TextBox editorTextBox;
    private IHighlight highlight;
    private Presentation pgView;
    private Map<Integer, IAnimation> paraAnimation;

    public PGEditor(Presentation pgView) {
        this.pgView = pgView;
        this.highlight = new Highlight(this);
    }

    @Override
    public IHighlight getHighlight() {
        return this.highlight;
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        if (this.editorTextBox != null) {
            STRoot root = this.editorTextBox.getRootView();
            if (root != null) {
                root.modelToView(offset, rect, isBack);
            }
            rect.x += this.editorTextBox.getBounds().x;
            rect.y += this.editorTextBox.getBounds().y;
        }
        return rect;
    }

    @Override
    public IDocument getDocument() {
        return null;
    }

    @Override
    public String getText(long start, long end) {
        String str;
        SectionElement elem;
        if (this.editorTextBox != null && (elem = this.editorTextBox.getElement()).getEndOffset() - elem.getStartOffset() > 0L && (str = elem.getText(null)) != null) {
            return str.substring((int)Math.max(start, elem.getStartOffset()), (int)Math.min(end, elem.getEndOffset()));
        }
        return null;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        STRoot root;
        if (this.pgView == null) {
            return -1L;
        }
        IShape shape = this.pgView.getCurrentSlide().getShape(x, y);
        if (shape != null && shape.getType() == 1 && (root = ((TextBox)shape).getRootView()) != null) {
            return root.viewToModel(x -= shape.getBounds().x, y -= shape.getBounds().y, isBack);
        }
        return -1L;
    }

    public TextBox getEditorTextBox() {
        return this.editorTextBox;
    }

    public void setEditorTextBox(TextBox editorBox) {
        this.editorTextBox = editorBox;
    }

    @Override
    public byte getEditType() {
        return 2;
    }

    public void setShapeAnimation(Map<Integer, IAnimation> paraAnimation) {
        this.paraAnimation = paraAnimation;
    }

    @Override
    public IAnimation getParagraphAnimation(int paragraphID) {
        if (this.pgView != null && this.paraAnimation != null) {
            IAnimation animation = this.paraAnimation.get(paragraphID);
            if (animation == null) {
                animation = this.paraAnimation.get(-2);
            }
            if (animation == null) {
                animation = this.paraAnimation.get(-1);
            }
            return animation;
        }
        return null;
    }

    @Override
    public IShape getTextBox() {
        return this.editorTextBox;
    }

    public void clearAnimation() {
        if (this.paraAnimation != null) {
            this.paraAnimation.clear();
        }
    }

    @Override
    public IControl getControl() {
        if (this.pgView != null) {
            return this.pgView.getControl();
        }
        return null;
    }

    public Presentation getPGView() {
        return this.pgView;
    }

    @Override
    public void dispose() {
        this.editorTextBox = null;
        if (this.highlight != null) {
            this.highlight.dispose();
            this.highlight = null;
        }
        this.pgView = null;
        if (this.paraAnimation != null) {
            this.paraAnimation.clear();
            this.paraAnimation = null;
        }
    }
}

