/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.animate;

import com.ahmadullahpk.alldocumentreader.xs.pg.animate.Animation;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.IAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.ShapeAnimation;

public class FadeAnimation
extends Animation {
    public FadeAnimation(ShapeAnimation shapeAnim) {
        super(shapeAnim);
        this.initAnimationKeyPoint();
    }

    public FadeAnimation(ShapeAnimation shapeAnim, int duration) {
        super(shapeAnim, duration);
        this.initAnimationKeyPoint();
    }

    public FadeAnimation(ShapeAnimation shapeAnim, int duration, int fps) {
        super(shapeAnim, duration, fps);
        this.initAnimationKeyPoint();
    }

    private void initAnimationKeyPoint() {
        if (this.shapeAnim != null) {
            this.begin = new IAnimation.AnimationInformation(null, this.shapeAnim.getAnimationType() == 0 ? 0 : 255, 0);
            this.end = new IAnimation.AnimationInformation(null, this.shapeAnim.getAnimationType() == 0 ? 255 : 0, 0);
            this.current = new IAnimation.AnimationInformation(null, this.shapeAnim.getAnimationType() == 0 ? 0 : 255, 0);
        } else {
            this.begin = new IAnimation.AnimationInformation(null, 0, 0);
            this.end = new IAnimation.AnimationInformation(null, 255, 0);
            this.current = new IAnimation.AnimationInformation(null, 0, 0);
        }
    }

    @Override
    public void animation(int frameIndex) {
        if (this.shapeAnim != null && this.current != null) {
            switch (this.shapeAnim.getAnimationType()) {
                case 0: {
                    this.fadeIn(frameIndex * this.delay);
                    break;
                }
                case 1: {
                    this.fadeIn(frameIndex * this.delay);
                    break;
                }
                case 2: {
                    this.fadeOut(frameIndex * this.delay);
                    break;
                }
            }
        }
    }

    @Override
    public void start() {
        super.start();
        this.current.setProgress(0.0f);
    }

    @Override
    public void stop() {
        super.stop();
        if (this.current != null) {
            this.current.setAngle(0);
            this.current.setProgress(1.0f);
            if (this.shapeAnim != null) {
                switch (this.shapeAnim.getAnimationType()) {
                    case 0: {
                        this.current.setAlpha(255);
                        break;
                    }
                    case 2: {
                        this.current.setAlpha(0);
                        break;
                    }
                }
            }
        }
    }

    private void fadeIn(int time) {
        if ((float)time < this.duration) {
            float progress = (float)time / this.duration;
            this.current.setProgress(progress);
            this.current.setAlpha((int)(255.0f * progress));
        } else {
            this.status = (byte)2;
            this.current.setProgress(1.0f);
            this.current.setAlpha(255);
        }
    }

    private void fadeOut(int time) {
        if ((float)time < this.duration) {
            float progress = (float)time / this.duration;
            this.current.setProgress(progress);
            this.current.setAlpha((int)(255.0f * (1.0f - progress)));
        } else {
            this.status = (byte)2;
            this.current.setProgress(1.0f);
            this.current.setAlpha(0);
        }
    }
}

