/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.officereader.search;

import com.ahmadullahpk.alldocumentreader.xs.fc.doc.DOCReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.doc.DOCXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.doc.TXTReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.pdf.PDFReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.PPTReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.PPTXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.XLSReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.XLSXReader;
import com.ahmadullahpk.alldocumentreader.xs.officereader.search.ISearchResult;
import com.ahmadullahpk.alldocumentreader.xs.system.AbortReaderError;
import com.ahmadullahpk.alldocumentreader.xs.system.FileKit;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IReader;
import java.io.File;

public class Search {
    public static final byte SEARCH_BY_NAME = 0;
    public static final byte SEARCH_BY_CONTENT = 1;
    public static final byte SEARCH_BY_AUTHOR = 2;
    private boolean stopSearch;
    private boolean searching;
    private ISearchResult searchResult;
    private IControl control;
    private IReader reader;

    public Search(IControl control, ISearchResult searchResult) {
        this.control = control;
        this.searchResult = searchResult;
        this.reader = null;
    }

    public void doSearch(File directory, String key, byte searchType) {
        this.stopSearch = false;
        if (this.searching) {
            return;
        }
        this.searching = true;
        new SearchThread(directory, key, searchType).start();
    }

    public void stopSearch() {
        if (this.reader != null) {
            this.reader.abortReader();
        }
        this.stopSearch = true;
    }

    public void dispose() {
        this.control = null;
        this.searchResult = null;
        this.reader = null;
    }

    class SearchThread
    extends Thread {
        private byte searchType;
        private File directory;
        private String key;

        public SearchThread(File directory, String key, byte searchType) {
            this.directory = directory;
            this.key = key;
            this.searchType = searchType;
        }

        @Override
        public void run() {
            this.searchFiles(this.directory, this.key);
            Search.this.searching = false;
            if (Search.this.searchResult != null) {
                Search.this.searchResult.searchFinish();
            }
        }

        private void searchFiles(File directory, String key) {
            key = key.toLowerCase();
            File[] files = directory.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (Search.this.stopSearch) {
                    return;
                }
                if (file.isDirectory()) {
                    this.searchFiles(file, key);
                    continue;
                }
                String fileName = file.getName();
                if (!FileKit.instance().isSupport(fileName)) continue;
                if (this.searchType == 0) {
                    if (fileName.toLowerCase().indexOf(key) <= -1) continue;
                    Search.this.searchResult.onResult(file);
                    continue;
                }
                if (this.searchType != 1) continue;
                try {
                    this.searchContent(file);
                }
                catch (AbortReaderError e) {
                    if (Search.this.reader == null) break;
                    Search.this.reader.dispose();
                    Search.this.reader = null;
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        private void searchContent(File file) throws Exception {
            String fileName = file.getName().toLowerCase();
            if (fileName.endsWith("doc") || fileName.endsWith("dot")) {
                Search.this.reader = new DOCReader(null, file.getAbsolutePath());
            } else if (fileName.endsWith("docx") || fileName.endsWith("dotx") || fileName.endsWith("dotm")) {
                Search.this.reader = new DOCXReader(null, file.getAbsolutePath());
            } else if (fileName.endsWith("txt")) {
                Search.this.reader = new TXTReader(null, file.getAbsolutePath(), "GBK");
                Search.this.reader.dispose();
            } else if (fileName.endsWith("xls") || fileName.endsWith("xlt")) {
                Search.this.reader = new XLSReader(Search.this.control, file.getAbsolutePath());
            } else if (fileName.endsWith("xlsx") || fileName.endsWith("xltx") || fileName.endsWith("xltm") || fileName.endsWith("xlsm")) {
                Search.this.reader = new XLSXReader(Search.this.control, file.getAbsolutePath());
            } else if (fileName.endsWith("ppt") || fileName.endsWith("pot")) {
                Search.this.reader = new PPTReader(Search.this.control, file.getAbsolutePath());
            } else if (fileName.endsWith("pptx") || fileName.endsWith("pptm") || fileName.endsWith("potx") || fileName.endsWith("potm")) {
                Search.this.reader = new PPTXReader(Search.this.control, file.getAbsolutePath());
            } else if (fileName.endsWith("pdf")) {
                Search.this.reader = new PDFReader(Search.this.control, file.getAbsolutePath());
            }
            Search.this.reader.dispose();
            Search.this.reader = null;
        }
    }
}

