/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.officereader.filelist;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.xs.officereader.filelist.FileNameDialog;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IDialogAction;
import com.ahmadullahpk.alldocumentreader.xs.system.dialog.MessageDialog;
import java.io.File;
import java.util.Vector;

public class NewFolderDialog
extends FileNameDialog {
    private TextWatcher watcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            NewFolderDialog.this.ok.setEnabled(NewFolderDialog.this.isFileNameOK(s.toString()));
        }

        public void afterTextChanged(Editable s) {
        }
    };

    public NewFolderDialog(IControl control, Context context, IDialogAction action, Vector<Object> model, int dialogID, int titleResID) {
        super(control, context, action, model, dialogID, titleResID);
        this.initDialog();
    }

    public void initDialog() {
        this.textView.setText(R.string.dialog_folder_name);
        this.editText.addTextChangedListener(this.watcher);
    }

    @Override
    public void onClick(View v) {
        if (v == this.ok) {
            if (this.model == null) {
                this.dismiss();
                return;
            }
            String filePath = this.model.get(0).toString();
            String name = this.editText.getText().toString().trim();
            File newFolder = filePath.endsWith(File.separator) ? new File(filePath + name) : new File(filePath + File.separator + name);
            Vector<Object> vector = new Vector<Object>();
            vector.add(newFolder);
            if (!newFolder.exists()) {
                this.action.doAction(this.dialogID, vector);
                this.dismiss();
            } else {
                CharSequence text = this.getContext().getResources().getText(R.string.dialog_name_error);
                String message = text.toString().replace("%s", name);
                new MessageDialog(this.control, this.getContext(), this.action, null, 0, R.string.dialog_create_folder_error, message).show();
            }
        } else {
            this.dismiss();
        }
    }
}

