/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.officereader.filelist;

import android.content.Context;
import android.content.res.Configuration;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IDialogAction;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.ADialog;
import java.util.Vector;

public class FileNameDialog
extends ADialog {
    protected TextView textView;
    protected EditText editText;

    public FileNameDialog(IControl control, Context context, IDialogAction action, Vector<Object> model, int dialogID, int titleResID) {
        super(control, context, action, model, dialogID, titleResID);
        this.init(context);
    }

    public void init(Context context) {
        int mWidth = this.getContext().getResources().getDisplayMetrics().widthPixels - 60;
        this.textView = new TextView(context);
        this.textView.setGravity(48);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.leftMargin = 5;
        params.rightMargin = 5;
        params.topMargin = 5;
        params.bottomMargin = 5;
        params.gravity = 17;
        this.dialogFrame.addView((View)this.textView, (ViewGroup.LayoutParams)params);
        this.editText = new EditText(context);
        this.editText.setGravity(48);
        this.editText.setSingleLine();
        params = new LinearLayout.LayoutParams(mWidth, -2);
        params.leftMargin = 5;
        params.rightMargin = 5;
        this.dialogFrame.addView((View)this.editText, (ViewGroup.LayoutParams)params);
        LinearLayout linearLayoutBtn = new LinearLayout(context);
        linearLayoutBtn.setGravity(17);
        linearLayoutBtn.setOrientation(0);
        params = new LinearLayout.LayoutParams(mWidth / 2, -2);
        this.ok = new Button(context);
        this.ok.setText(R.string.sys_button_ok);
        this.ok.setOnClickListener((View.OnClickListener)this);
        this.ok.setEnabled(false);
        linearLayoutBtn.addView((View)this.ok, (ViewGroup.LayoutParams)params);
        this.cancel = new Button(context);
        this.cancel.setText(R.string.sys_button_cancel);
        this.cancel.setOnClickListener((View.OnClickListener)this);
        linearLayoutBtn.addView((View)this.cancel, (ViewGroup.LayoutParams)params);
        this.dialogFrame.addView((View)linearLayoutBtn);
    }

    @Override
    public void onClick(View v) {
    }

    @Override
    public void doLayout() {
        int mWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        mWidth = this.control.getSysKit().isVertical(this.getContext()) ? (mWidth -= 60) : (mWidth -= 240);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.leftMargin = 5;
        params.rightMargin = 5;
        params.topMargin = 5;
        params.bottomMargin = 5;
        this.textView.setLayoutParams((ViewGroup.LayoutParams)params);
        params = new LinearLayout.LayoutParams(mWidth, -2);
        params.leftMargin = 5;
        params.rightMargin = 5;
        this.editText.setLayoutParams((ViewGroup.LayoutParams)params);
        params = new LinearLayout.LayoutParams(mWidth / 2, -2);
        this.ok.setLayoutParams((ViewGroup.LayoutParams)params);
        this.cancel.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.doLayout();
    }

    public boolean isFileNameOK(String fileName) {
        if (fileName == null || fileName.length() < 1 || fileName.length() > 255) {
            return false;
        }
        String invalidateChars = "\\/:*?\"<>|";
        int len = invalidateChars.length();
        for (int index = 0; index < len; ++index) {
            if (fileName.indexOf(invalidateChars.charAt(index)) <= -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.editText = null;
        this.textView = null;
    }
}

