/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.macro;

import android.graphics.Bitmap;
import com.ahmadullahpk.alldocumentreader.xs.fc.ReaderThumbnail;

public class ThumbnailKit {
    private static ThumbnailKit kit = new ThumbnailKit();

    public static ThumbnailKit instance() {
        return kit;
    }

    public Bitmap getPPTThumbnail(String filePath, int width, int height) {
        try {
            String lowerCase = filePath.toLowerCase();
            if (lowerCase.indexOf(".") > 0 && width > 0 && height > 0 && (lowerCase.endsWith("ppt") || lowerCase.endsWith("pot"))) {
                return ReaderThumbnail.instance().getThumbnailForPPT(filePath, width, height);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Bitmap getPPTXThumbnail(String filePath) {
        try {
            String lowerCase = filePath.toLowerCase();
            if (lowerCase.indexOf(".") > 0 && (lowerCase.endsWith("pptx") || lowerCase.endsWith("pptm") || lowerCase.endsWith("potx") || lowerCase.endsWith("potm"))) {
                return ReaderThumbnail.instance().getThumbnailForPPTX(filePath);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Bitmap getPDFThumbnail(String filePath, int zoom) {
        try {
            String lowerCase = filePath.toLowerCase();
            if (lowerCase.indexOf(".") > 0 && lowerCase.endsWith("pdf") && zoom > 0 && zoom <= 5000) {
                return ReaderThumbnail.instance().getThumbnailForPDF(filePath, (float)zoom / 10000.0f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

