/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.RecordStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.BoolErrRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CellValueRecordInterface;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.NameRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.NumberRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DirectoryNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DocumentInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.POIFSFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.SSReader;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ACell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.system.AbortReaderError;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.List;

public class XLSReader
extends SSReader {
    private String filePath;

    public XLSReader(IControl control, String filePath) {
        this.control = control;
        this.filePath = filePath;
    }

    @Override
    public Object getModel() throws Exception {
        FileInputStream is = new FileInputStream(this.filePath);
        AWorkbook book = new AWorkbook(is, this);
        return book;
    }

    @Override
    public boolean searchContent(File file, String key) throws Exception {
        try {
            key = key.toLowerCase();
            FileInputStream is = new FileInputStream(file.getAbsolutePath());
            DirectoryNode directory = new POIFSFileSystem(is).getRoot();
            String workbookName = AWorkbook.getWorkbookDirEntryName(directory);
            DocumentInputStream stream = directory.createDocumentInputStream(workbookName);
            List<Record> records = RecordFactory.createRecords(stream, this);
            InternalWorkbook workbook = InternalWorkbook.createWorkbook(records, this);
            int numSheets = workbook.getNumSheets();
            int sheetIndex = 0;
            while (sheetIndex < numSheets) {
                if (!workbook.getSheetName(sheetIndex++).toLowerCase().contains(key)) continue;
                return true;
            }
            int size = workbook.getSSTUniqueStringSize();
            for (int i = 0; i < size; ++i) {
                this.checkAbortReader();
                if (!workbook.getSSTString(i).getString().toLowerCase().contains(key)) continue;
                return true;
            }
            int recOffset = workbook.getNumRecords();
            RecordStream rs = new RecordStream(records, recOffset);
            sheetIndex = 0;
            while (rs.hasNext()) {
                InternalSheet internalSheet = InternalSheet.createSheet(rs, this);
                if (!this.search_Sheet(internalSheet, key)) continue;
                return true;
            }
            for (int i = 0; i < workbook.getNumNames(); ++i) {
                NameRecord nameRecord = workbook.getNameRecord(i);
                if (!nameRecord.getNameText().toLowerCase().contains(key)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean search_Sheet(InternalSheet sheet, String key) {
        Iterator<CellValueRecordInterface> iter = sheet.getCellValueIterator();
        while (iter.hasNext()) {
            CellValueRecordInterface cval = iter.next();
            this.checkAbortReader();
            if (!this.search_Cell(cval, key)) continue;
            return true;
        }
        return false;
    }

    private boolean search_Cell(CellValueRecordInterface cval, String key) {
        short cellType = (short)ACell.determineType(cval);
        switch (cellType) {
            case 0: {
                return String.valueOf(((NumberRecord)cval).getValue()).contains(key);
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                return String.valueOf(((BoolErrRecord)cval).getBooleanValue()).toLowerCase().contains(key);
            }
            case 5: {
                return ErrorEval.getText(((BoolErrRecord)cval).getErrorValue()).toLowerCase().contains(key);
            }
        }
        return false;
    }

    private void checkAbortReader() {
        if (this.abortReader) {
            throw new AbortReaderError("abort Reader");
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.filePath = null;
    }
}

