/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.table;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTable;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ReferenceUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.InputStream;

public class TableReader {
    private static TableReader reader = new TableReader();

    public static TableReader instance() {
        return reader;
    }

    public void read(IControl control, PackagePart tablePart, Sheet sheet) throws Exception {
        SAXReader saxreader = new SAXReader();
        try {
            Element tableStyleInfo;
            String totalsRowShown;
            String totalsRowCount;
            String headerRowCount;
            String str;
            InputStream in = tablePart.getInputStream();
            Document talbeDoc = saxreader.read(in);
            in.close();
            SSTable table = new SSTable();
            Element root = talbeDoc.getRootElement();
            String ref = root.attributeValue("ref");
            String[] rang = ref.split(":");
            if (rang != null && rang.length == 2) {
                table.setTableReference(new CellRangeAddress(ReferenceUtil.instance().getRowIndex(rang[0]), ReferenceUtil.instance().getColumnIndex(rang[0]), ReferenceUtil.instance().getRowIndex(rang[1]), ReferenceUtil.instance().getColumnIndex(rang[1])));
            }
            if ((str = root.attributeValue("totalsRowDxfId")) != null) {
                table.setTotalsRowDxfId(Integer.parseInt(str));
            }
            if ((str = root.attributeValue("totalsRowBorderDxfId")) != null) {
                table.setTotalsRowBorderDxfId(Integer.parseInt(str));
            }
            if ((str = root.attributeValue("headerRowDxfId")) != null) {
                table.setHeaderRowDxfId(Integer.parseInt(str));
            }
            if ((str = root.attributeValue("headerRowBorderDxfId")) != null) {
                table.setHeaderRowBorderDxfId(Integer.parseInt(str));
            }
            if ((str = root.attributeValue("tableBorderDxfId")) != null) {
                table.setTableBorderDxfId(Integer.parseInt(str));
            }
            if ("0".equalsIgnoreCase(headerRowCount = root.attributeValue("headerRowCount"))) {
                table.setHeaderRowShown(false);
            }
            if ((totalsRowCount = root.attributeValue("totalsRowCount")) == null) {
                totalsRowCount = "0";
            }
            if (!"0".equalsIgnoreCase(totalsRowShown = root.attributeValue("totalsRowShown")) && "1".equalsIgnoreCase(totalsRowCount)) {
                table.setTotalRowShown(true);
            }
            if ((tableStyleInfo = root.element("tableStyleInfo")) != null) {
                String showColumnStripes;
                String showRowStripes;
                String showLastColumn;
                String name = tableStyleInfo.attributeValue("name");
                table.setName(name);
                String showFirstColumn = tableStyleInfo.attributeValue("showFirstColumn");
                if (!"0".equalsIgnoreCase(showFirstColumn)) {
                    table.setShowFirstColumn(true);
                }
                if (!"0".equalsIgnoreCase(showLastColumn = tableStyleInfo.attributeValue("showLastColumn"))) {
                    table.setShowLastColumn(true);
                }
                if (!"0".equalsIgnoreCase(showRowStripes = tableStyleInfo.attributeValue("showRowStripes"))) {
                    table.setShowRowStripes(true);
                }
                if (!"0".equalsIgnoreCase(showColumnStripes = tableStyleInfo.attributeValue("showColumnStripes"))) {
                    table.setShowColumnStripes(true);
                }
                sheet.addTable(table);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            saxreader.resetHandlers();
        }
    }
}

