/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.shared;

import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.Gradient;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.LinearGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.RadialGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementHandler;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementPath;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.Font;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.BorderStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.BuiltinFormats;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellBorder;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.NumberFormat;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.TableFormatManager;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.AbortReaderError;
import com.ahmadullahpk.alldocumentreader.xs.system.IReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StyleReader {
    private static StyleReader reader = new StyleReader();
    private Workbook book;
    private IReader iReader;
    private Map<Integer, NumberFormat> numFmts;
    private Map<Integer, CellBorder> cellBorders;
    private Map<Integer, BackgroundAndFill> fills;
    private TableFormatManager tableFormatManager;
    private int fontIndex;
    private int fillIndex;
    private int borderIndex;
    private int styleIndex;
    private int indexedColor;

    public static StyleReader instance() {
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWorkBookStyle(PackagePart styleParts, Workbook book, IReader iReader) throws Exception {
        this.book = book;
        this.iReader = iReader;
        this.fontIndex = 0;
        this.fillIndex = 0;
        this.borderIndex = 0;
        this.styleIndex = 0;
        this.indexedColor = 0;
        this.fills = new HashMap<Integer, BackgroundAndFill>(5);
        this.cellBorders = new HashMap<Integer, CellBorder>(5);
        this.getBuiltinNumberFormats();
        SAXReader saxreader = new SAXReader();
        try {
            StyleSaxHandler handler = new StyleSaxHandler();
            saxreader.addHandler("/styleSheet/numFmts/numFmt", handler);
            saxreader.addHandler("/styleSheet/fonts/font", handler);
            saxreader.addHandler("/styleSheet/fills/fill", handler);
            saxreader.addHandler("/styleSheet/borders/border", handler);
            saxreader.addHandler("/styleSheet/cellXfs/xf", handler);
            saxreader.addHandler("/styleSheet/colors/indexedColors/rgbColor", handler);
            saxreader.addHandler("/styleSheet/dxfs/dxf", handler);
            InputStream in = styleParts.getInputStream();
            saxreader.read(in);
            in.close();
            this.dispose();
        }
        finally {
            saxreader.resetHandlers();
        }
    }

    private void getBuiltinNumberFormats() {
        String[] formats = BuiltinFormats.getAll();
        int count = formats.length;
        this.numFmts = new HashMap<Integer, NumberFormat>(count + 20);
        for (int i = 0; i < count; ++i) {
            this.numFmts.put(i, new NumberFormat((short)i, formats[i]));
        }
    }

    private short getColorIndex(Element clrElement) {
        int index = 0;
        if (clrElement != null) {
            if (clrElement.attribute("theme") != null) {
                int themeIndex = Integer.parseInt(clrElement.attributeValue("theme"));
                index = this.book.getThemeColorIndex(themeIndex);
                if (clrElement.attribute("tint") != null) {
                    double tint = Double.parseDouble(clrElement.attributeValue("tint"));
                    int color2 = this.book.getColor(index);
                    color2 = ColorUtil.instance().getColorWithTint(color2, tint);
                    index = this.book.addColor(color2);
                }
            } else if (clrElement.attribute("rgb") != null) {
                String val = clrElement.attributeValue("rgb");
                if (val.length() > 6) {
                    val = val.substring(val.length() - 6);
                }
                index = Integer.parseInt(val, 16);
                index = this.book.addColor(0xFF000000 | index);
            } else if (clrElement.attribute("indexed") != null) {
                index = Integer.parseInt(clrElement.attributeValue("indexed"));
                if (index == 64) {
                    index = 0;
                } else if (index > 64) {
                    index = 9;
                }
            }
        }
        return (short)index;
    }

    private NumberFormat processNumberFormat(Element numFmt) {
        int Id = Integer.parseInt(numFmt.attribute("numFmtId").getValue());
        String formatCode = numFmt.attribute("formatCode").getValue();
        return new NumberFormat((short)Id, formatCode);
    }

    private Font processFont(Element fontElement) {
        double sz = 12.0;
        Font font = new Font();
        font.setIndex(this.fontIndex);
        Element e = fontElement.element("fontElement");
        if (e != null) {
            String val = e.attributeValue("val");
            if (val.equalsIgnoreCase("superscript")) {
                font.setSuperSubScript((byte)1);
            } else if (val.equalsIgnoreCase("subscript")) {
                font.setSuperSubScript((byte)2);
            } else {
                font.setSuperSubScript((byte)0);
            }
        } else {
            font.setSuperSubScript((byte)0);
        }
        e = fontElement.element("sz");
        if (e != null) {
            sz = Double.parseDouble(e.attributeValue("val"));
        }
        font.setFontSize(sz);
        e = fontElement.element("color");
        font.setColorIndex(this.getColorIndex(e));
        if (fontElement.element("name") != null) {
            String name = fontElement.element("name").attributeValue("val");
            font.setName(name);
        }
        if ((e = fontElement.element("b")) != null) {
            font.setBold(e.attributeValue("val") == null ? true : Boolean.parseBoolean(e.attributeValue("val")));
        }
        if ((e = fontElement.element("i")) != null) {
            font.setItalic(e.attributeValue("val") == null ? true : Boolean.parseBoolean(e.attributeValue("val")));
        }
        if ((e = fontElement.element("u")) != null) {
            if (e.attributeValue("val") != null) {
                font.setUnderline(e.attributeValue("val"));
            } else {
                font.setUnderline(1);
            }
        }
        if ((e = fontElement.element("strike")) != null) {
            font.setStrikeline(e.attributeValue("val") == null ? true : Boolean.parseBoolean(e.attributeValue("val")));
        }
        return font;
    }

    private BackgroundAndFill processFill(Element fillElement) {
        Element patternFill = fillElement.element("patternFill");
        if (patternFill != null) {
            BackgroundAndFill fill = new BackgroundAndFill();
            String str = patternFill.attributeValue("patternType");
            byte type = 0;
            if ("none".equalsIgnoreCase(str)) {
                return null;
            }
            Element ele = patternFill.element("fgColor");
            if (ele != null) {
                fill.setForegroundColor(this.book.getColor(this.getColorIndex(ele)));
                fill.setFillType(type);
            }
            if ((ele = patternFill.element("bgColor")) != null) {
                fill.setBackgoundColor(this.book.getColor(this.getColorIndex(ele)));
            }
            return fill;
        }
        if (fillElement.element("gradientFill") != null) {
            Element gradientFill = fillElement.element("gradientFill");
            List gsLst = gradientFill.elements("stop");
            int[] colors = new int[gsLst.size()];
            float[] positions = new float[gsLst.size()];
            for (int i = 0; i < gsLst.size(); ++i) {
                Element stop = (Element)gsLst.get(i);
                positions[i] = Float.parseFloat(stop.attributeValue("position"));
                colors[i] = this.book.getColor(this.getColorIndex(stop.element("color")));
            }
            BackgroundAndFill fill = new BackgroundAndFill();
            Gradient shader = null;
            if (!"path".equalsIgnoreCase(gradientFill.attributeValue("type"))) {
                fill.setFillType((byte)7);
                int degree = 0;
                if (gradientFill.attributeValue("degree") != null) {
                    degree = Integer.parseInt(gradientFill.attributeValue("degree"));
                }
                shader = new LinearGradientShader(degree, colors, positions);
            } else {
                fill.setFillType((byte)4);
                shader = new RadialGradientShader(StyleReader.getRadialCenterType(gradientFill), colors, positions);
            }
            fill.setShader(shader);
            return fill;
        }
        return null;
    }

    private static int getRadialCenterType(Element fillToRect) {
        if (fillToRect != null) {
            String l = fillToRect.attributeValue("left");
            String t = fillToRect.attributeValue("top");
            String r = fillToRect.attributeValue("right");
            String b = fillToRect.attributeValue("bottom");
            if ("1".equalsIgnoreCase(l) && "1".equalsIgnoreCase(r) && "1".equalsIgnoreCase(b) && "1".equalsIgnoreCase(t)) {
                return 3;
            }
            if ("1".equalsIgnoreCase(b) && "1".equalsIgnoreCase(t)) {
                return 2;
            }
            if ("1".equalsIgnoreCase(l) && "1".equalsIgnoreCase(r)) {
                return 1;
            }
            if ("0.5".equalsIgnoreCase(l) && "0.5".equalsIgnoreCase(t) && "0.5".equalsIgnoreCase(r) && "0.5".equalsIgnoreCase(b)) {
                return 4;
            }
        }
        return 0;
    }

    private CellBorder processBorder(Element cellBorderElement) {
        BorderStyle boderStyle;
        short colorIdx;
        String style2;
        CellBorder cellBorder = new CellBorder();
        Element ele = cellBorderElement.element("left");
        if (ele != null) {
            style2 = ele.attributeValue("style");
            colorIdx = this.getColorIndex(ele.element("color"));
            boderStyle = new BorderStyle(style2, colorIdx);
            cellBorder.setLeftBorder(boderStyle);
        }
        if ((ele = cellBorderElement.element("top")) != null) {
            style2 = ele.attributeValue("style");
            colorIdx = this.getColorIndex(ele.element("color"));
            boderStyle = new BorderStyle(style2, colorIdx);
            cellBorder.setTopBorder(boderStyle);
        }
        if ((ele = cellBorderElement.element("right")) != null) {
            style2 = ele.attributeValue("style");
            colorIdx = this.getColorIndex(ele.element("color"));
            boderStyle = new BorderStyle(style2, colorIdx);
            cellBorder.setRightBorder(boderStyle);
        }
        if ((ele = cellBorderElement.element("bottom")) != null) {
            style2 = ele.attributeValue("style");
            colorIdx = this.getColorIndex(ele.element("color"));
            boderStyle = new BorderStyle(style2, colorIdx);
            cellBorder.setBottomBorder(boderStyle);
        }
        return cellBorder;
    }

    private void processCellStyleAlignment(CellStyle cellStyle, Element alignment) {
        if (alignment.attributeValue("vertical") != null) {
            cellStyle.setVerticalAlign(alignment.attributeValue("vertical"));
        }
        if (alignment.attributeValue("horizontal") != null) {
            cellStyle.setHorizontalAlign(alignment.attributeValue("horizontal"));
        }
        if (alignment.attributeValue("textRotation") != null) {
            cellStyle.setRotation((short)Integer.parseInt(alignment.attributeValue("textRotation")));
        }
        if (alignment.attributeValue("wrapText") != null) {
            cellStyle.setWrapText(Integer.parseInt(alignment.attributeValue("wrapText")) != 0);
        }
        if (alignment.attributeValue("indent") != null) {
            cellStyle.setIndent((short)Integer.parseInt(alignment.attributeValue("indent")));
        }
    }

    private CellStyle processCellStyle(Element styleElement) {
        int idx;
        CellStyle cellStyle = new CellStyle();
        String value = styleElement.attributeValue("numFmtId");
        int n = idx = value == null ? 0 : Integer.parseInt(value);
        if (this.numFmts.get(idx) != null) {
            cellStyle.setNumberFormat(this.numFmts.get(idx));
        }
        idx = (value = styleElement.attributeValue("fontId")) == null ? 0 : Integer.parseInt(value);
        cellStyle.setFontIndex((short)idx);
        value = styleElement.attributeValue("fillId");
        idx = value == null ? 0 : Integer.parseInt(value);
        cellStyle.setFillPattern(this.fills.get(idx));
        value = styleElement.attributeValue("borderId");
        idx = value == null ? 0 : Integer.parseInt(value);
        cellStyle.setBorder(this.cellBorders.get(idx));
        Element ele = styleElement.element("alignment");
        if (ele != null) {
            this.processCellStyleAlignment(cellStyle, ele);
        }
        return cellStyle;
    }

    private int processIndexedColors(Element rgbColor) {
        String val = rgbColor.attributeValue("rgb");
        if (val.length() > 6) {
            val = val.substring(val.length() - 6);
        }
        int color2 = Integer.parseInt(val, 16);
        return 0xFF000000 | color2;
    }

    private void processTableFormat(Element dfx) {
        if (this.tableFormatManager == null) {
            this.tableFormatManager = new TableFormatManager(5);
            this.book.setTableFormatManager(this.tableFormatManager);
        }
        CellStyle cellStyle = new CellStyle();
        Element ele = dfx.element("numFmt");
        if (ele != null) {
            cellStyle.setNumberFormat(this.processNumberFormat(ele));
        }
        if ((ele = dfx.element("font")) != null) {
            this.book.addFont(this.fontIndex, this.processFont(ele));
            cellStyle.setFontIndex((short)this.fontIndex++);
        }
        if ((ele = dfx.element("fill")) != null) {
            cellStyle.setFillPattern(this.processFill(ele));
        }
        if ((ele = dfx.element("border")) != null) {
            cellStyle.setBorder(this.processBorder(ele));
        }
        if ((ele = dfx.element("alignment")) != null) {
            this.processCellStyleAlignment(cellStyle, ele);
        }
        this.tableFormatManager.addFormat(cellStyle);
    }

    private void dispose() {
        this.book = null;
        this.iReader = null;
        this.tableFormatManager = null;
        if (this.numFmts != null) {
            this.numFmts.clear();
            this.numFmts = null;
        }
        if (this.cellBorders != null) {
            this.cellBorders.clear();
            this.cellBorders = null;
        }
        if (this.fills != null) {
            this.fills.clear();
            this.fills = null;
        }
    }

    class StyleSaxHandler
    implements ElementHandler {
        StyleSaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            if (StyleReader.this.iReader.isAborted()) {
                throw new AbortReaderError("abort Reader");
            }
            Element elem = elementPath.getCurrent();
            String name = elem.getName();
            if (name.equals("numFmt")) {
                NumberFormat numFmt = StyleReader.this.processNumberFormat(elem);
                StyleReader.this.numFmts.put(Integer.valueOf(numFmt.getNumberFormatID()), numFmt);
            } else if (name.equals("font")) {
                StyleReader.this.book.addFont(StyleReader.this.fontIndex++, StyleReader.this.processFont(elem));
            } else if (name.equals("fill")) {
                StyleReader.this.fills.put(StyleReader.this.fillIndex++, StyleReader.this.processFill(elem));
            } else if (name.equals("border")) {
                StyleReader.this.cellBorders.put(StyleReader.this.borderIndex++, StyleReader.this.processBorder(elem));
            } else if (name.equals("xf")) {
                StyleReader.this.book.addCellStyle(StyleReader.this.styleIndex++, StyleReader.this.processCellStyle(elem));
            } else if (name.equals("rgbColor")) {
                StyleReader.this.book.addColor(StyleReader.this.indexedColor++, StyleReader.this.processIndexedColors(elem));
            } else if (name.equals("dxf")) {
                StyleReader.this.processTableFormat(elem);
            }
            elem.detach();
        }
    }
}

