/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.drawing;

import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeDataKit;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.SmartArt;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.fc.LineKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.RunAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.SectionAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SmartArtReader {
    private static SmartArtReader reader = new SmartArtReader();
    private Sheet sheet;
    private int offset;

    public static SmartArtReader instance() {
        return reader;
    }

    public SmartArt read(IControl control, ZipPackage zipPackage, PackagePart slidePart, PackagePart dataPart, Map<String, Integer> schemeColor, Sheet sheet) throws Exception {
        String relId;
        this.sheet = sheet;
        SAXReader saxreader = new SAXReader();
        InputStream in = dataPart.getInputStream();
        Document dataDoc = saxreader.read(in);
        in.close();
        Element root = dataDoc.getRootElement();
        BackgroundAndFill fill = AutoShapeDataKit.processBackground(control, zipPackage, dataPart, root.element("bg"), schemeColor);
        Line line = LineKit.createLine(control, zipPackage, dataPart, root.element("whole").element("ln"), schemeColor);
        PackagePart drawingPart = null;
        Element e = null;
        e = root.element("extLst");
        if (e != null && (e = e.element("ext")) != null && (e = e.element("dataModelExt")) != null && (relId = e.attributeValue("relId")) != null) {
            PackageRelationship smartArDrawingRel = slidePart.getRelationship(relId);
            drawingPart = zipPackage.getPart(smartArDrawingRel.getTargetURI());
        }
        if (drawingPart == null) {
            return null;
        }
        in = drawingPart.getInputStream();
        Document smartArtDoc = saxreader.read(in);
        in.close();
        SmartArt smartArt = new SmartArt();
        smartArt.setBackgroundAndFill(fill);
        smartArt.setLine(line);
        root = smartArtDoc.getRootElement();
        Element spTree = root.element("spTree");
        Iterator it = spTree.elementIterator("sp");
        while (it.hasNext()) {
            e = (Element)it.next();
            AbstractShape shape = null;
            Element temp = e.element("spPr");
            Rectangle rect = null;
            if (temp != null) {
                rect = ReaderKit.instance().getShapeAnchor(temp.element("xfrm"), 1.0f, 1.0f);
            }
            if ((shape = AutoShapeDataKit.getAutoShape(control, zipPackage, dataPart, e, rect, schemeColor, 1)) != null) {
                smartArt.appendShapes(shape);
            }
            if ((shape = this.getTextBoxData(control, e)) == null) continue;
            smartArt.appendShapes(shape);
        }
        sheet = null;
        return smartArt;
    }

    private TextBox getTextBoxData(IControl control, Element sp) {
        Element txBody;
        Element temp = sp.element("txXfrm");
        Rectangle rect = null;
        if (temp != null) {
            rect = ReaderKit.instance().getShapeAnchor(temp, 1.0f, 1.0f);
        }
        if ((txBody = sp.element("txBody")) != null) {
            TextBox tb = new TextBox();
            SectionElement secElem = new SectionElement();
            secElem.setStartOffset(0L);
            tb.setElement(secElem);
            IAttributeSet attr = secElem.getAttribute();
            AttrManage.instance().setPageWidth(attr, Math.round((float)rect.width * 15.0f));
            AttrManage.instance().setPageHeight(attr, Math.round((float)rect.height * 15.0f));
            AttrManage.instance().setPageMarginLeft(attr, Math.round(30.0f));
            AttrManage.instance().setPageMarginRight(attr, Math.round(30.0f));
            AttrManage.instance().setPageMarginTop(attr, 0);
            AttrManage.instance().setPageMarginBottom(attr, 0);
            Element bodyPr = temp.element("bodyPr");
            SectionAttr.instance().setSectionAttribute(bodyPr, attr, null, null, false);
            if (bodyPr != null) {
                String value = bodyPr.attributeValue("wrap");
                tb.setWrapLine(value == null || "square".equalsIgnoreCase(value));
            }
            int offset = this.processParagraph(control, secElem, txBody);
            secElem.setEndOffset(offset);
            tb.setBounds(rect);
            if (tb.getElement() != null && tb.getElement().getText(null) != null && tb.getElement().getText(null).length() > 0 && !"\n".equals(tb.getElement().getText(null))) {
                ReaderKit.instance().processRotation(tb, sp.element("txXfrm"));
            }
            return tb;
        }
        return null;
    }

    private int processParagraph(IControl control, SectionElement secElem, Element txBody) {
        this.offset = 0;
        List ps = txBody.elements("p");
        for (Element p : ps) {
            Element pPr = p.element("pPr");
            ParagraphElement paraElem = new ParagraphElement();
            paraElem.setStartOffset(this.offset);
            IAttributeSet attrLayout = null;
            ParaAttr.instance().setParaAttribute(control, pPr, paraElem.getAttribute(), attrLayout, -1, -1, 0, false, false);
            paraElem = this.processRun(control, secElem, paraElem, p, attrLayout);
            paraElem.setEndOffset(this.offset);
            secElem.appendParagraph(paraElem, 0L);
        }
        return this.offset;
    }

    private ParagraphElement processRun(IControl control, SectionElement secElem, ParagraphElement paraElem, Element p, IAttributeSet attrLayout) {
        List rs = p.elements("r");
        LeafElement leaf = null;
        if (rs.size() == 0) {
            leaf = new LeafElement("\n");
            Element ele = p.element("pPr");
            if (ele != null && (ele = ele.element("rPr")) != null) {
                RunAttr.instance().setRunAttribute(this.sheet, ele, leaf.getAttribute(), attrLayout);
            }
            leaf.setStartOffset(this.offset);
            ++this.offset;
            leaf.setEndOffset(this.offset);
            paraElem.appendLeaf(leaf);
            return paraElem;
        }
        for (Element r : rs) {
            if (r.getName().equalsIgnoreCase("r")) {
                String text;
                int len;
                Element t = r.element("t");
                if (t == null || (len = (text = t.getText()).length()) < 0) continue;
                leaf = new LeafElement(text);
                RunAttr.instance().setRunAttribute(this.sheet, r.element("rPr"), leaf.getAttribute(), attrLayout);
                leaf.setStartOffset(this.offset);
                this.offset += len;
                leaf.setEndOffset(this.offset);
                paraElem.appendLeaf(leaf);
                continue;
            }
            if (!r.getName().equalsIgnoreCase("br")) continue;
            if (leaf != null) {
                leaf.setText(leaf.getText(null) + "\n");
                ++this.offset;
            }
            paraElem.setEndOffset(this.offset);
            secElem.appendParagraph(paraElem, 0L);
            paraElem = new ParagraphElement();
            paraElem.setStartOffset(this.offset);
            attrLayout = null;
            Element pPr = p.element("pPr");
            ParaAttr.instance().setParaAttribute(control, pPr, paraElem.getAttribute(), attrLayout, -1, -1, 0, false, false);
        }
        if (leaf != null) {
            leaf.setText(leaf.getText(null) + "\n");
            ++this.offset;
        }
        return paraElem;
    }
}

