/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.RunAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttributeSetImpl;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ReferenceUtil;
import java.util.List;

public class CellReader {
    private static final short CELLTYPE_BOOLEAN = 0;
    private static final short CELLTYPE_NUMBER = 1;
    private static final short CELLTYPE_ERROR = 2;
    private static final short CELLTYPE_SHAREDSTRING = 3;
    private static final short CELLTYPE_STRING = 4;
    private static final short CELLTYPE_INLINESTRING = 5;
    private static CellReader reader = new CellReader();
    private int offset;
    private ParagraphElement paraElem;
    private AttributeSetImpl attrLayout;
    private LeafElement leaf;

    public static CellReader instance() {
        return reader;
    }

    private boolean isValidateCell(Sheet sheet, Element cellElement) {
        if (cellElement.attributeValue("t") != null) {
            return true;
        }
        Element v = cellElement.element("v");
        if (v != null) {
            return true;
        }
        Workbook book = sheet.getWorkbook();
        if (cellElement.attributeValue("s") != null) {
            int styleIndex = Integer.parseInt(cellElement.attributeValue("s"));
            CellStyle cellStyle = book.getCellStyle(styleIndex);
            if (Workbook.isValidateStyle(cellStyle)) {
                return true;
            }
        } else {
            String ref = cellElement.attributeValue("r");
            int col = ReferenceUtil.instance().getColumnIndex(ref);
            Row row = sheet.getRow(ReferenceUtil.instance().getRowIndex(ref));
            if (row != null && Workbook.isValidateStyle(book.getCellStyle(row.getRowStyle())) || Workbook.isValidateStyle(book.getCellStyle(col))) {
                return true;
            }
        }
        return false;
    }

    public Cell getCell(Sheet sheet, Element cellElement) {
        if (!this.isValidateCell(sheet, cellElement)) {
            return null;
        }
        short cellType = this.getCellType(cellElement.attributeValue("t"));
        Cell cell = switch (cellType) {
            case 0 -> new Cell(4);
            case 1 -> new Cell(0);
            case 2, 3, 4, 5 -> new Cell(1);
            default -> new Cell(3);
        };
        String ref = cellElement.attributeValue("r");
        cell.setColNumber(ReferenceUtil.instance().getColumnIndex(ref));
        cell.setRowNumber(ReferenceUtil.instance().getRowIndex(ref));
        Workbook book = sheet.getWorkbook();
        int styleIndex = 0;
        styleIndex = cellElement.attributeValue("s") != null ? Integer.parseInt(cellElement.attributeValue("s")) : sheet.getColumnStyle(cell.getColNumber());
        cell.setCellStyle(styleIndex);
        Element v = cellElement.element("v");
        if (v != null) {
            String value = v.getText();
            if (cellType == 3) {
                int sstIndex = Integer.parseInt(value);
                Object sst = book.getSharedItem(sstIndex);
                if (sst instanceof Element) {
                    cell.setSheet(sheet);
                    SectionElement secElement = this.processComplexSST(cell, (Element)sst);
                    sstIndex = book.addSharedString(secElement);
                }
                cell.setCellValue(sstIndex);
            } else if (cellType == 4 || cellType == 2) {
                cell.setCellValue(book.addSharedString(value));
            } else if (cellType == 1) {
                cell.setCellValue(Double.parseDouble(value));
            } else if (cellType == 0) {
                cell.setCellValue(Integer.parseInt(value) != 0);
            } else {
                cell.setCellValue(value);
            }
        }
        return cell;
    }

    private short getCellType(String type) {
        if (type == null || type.equalsIgnoreCase("n")) {
            return 1;
        }
        if (type.equalsIgnoreCase("b")) {
            return 0;
        }
        if (type.equalsIgnoreCase("s")) {
            return 3;
        }
        if (type.equalsIgnoreCase("str")) {
            return 4;
        }
        if (type.equalsIgnoreCase("inlineStr")) {
            return 5;
        }
        return 2;
    }

    private SectionElement processComplexSST(Cell cell, Element si) {
        SectionElement secElem = new SectionElement();
        secElem.setStartOffset(0L);
        IAttributeSet attr = secElem.getAttribute();
        AttrManage.instance().setPageMarginLeft(attr, Math.round(30.0f));
        AttrManage.instance().setPageMarginRight(attr, Math.round(30.0f));
        AttrManage.instance().setPageMarginTop(attr, 0);
        AttrManage.instance().setPageMarginBottom(attr, 0);
        AttrManage.instance().setPageVerticalAlign(attr, switch (cell.getCellStyle().getVerticalAlign()) {
            case 0 -> 0;
            case 1 -> 1;
            case 3 -> 3;
            case 2 -> 2;
            default -> 0;
        });
        short font = cell.getCellStyle().getFontIndex();
        this.offset = 0;
        this.paraElem = new ParagraphElement();
        this.paraElem.setStartOffset(this.offset);
        this.attrLayout = new AttributeSetImpl();
        ParaAttr.instance().setParaAttribute(cell.getCellStyle(), this.paraElem.getAttribute(), this.attrLayout);
        this.paraElem = this.processRun(cell, secElem, si, font);
        this.paraElem.setEndOffset(this.offset);
        secElem.appendParagraph(this.paraElem, 0L);
        secElem.setEndOffset(this.offset);
        this.offset = 0;
        this.paraElem = null;
        this.attrLayout = null;
        this.leaf = null;
        return secElem;
    }

    private ParagraphElement processRun(Cell cell, SectionElement secElem, Element si, int fontID) {
        Workbook book = cell.getSheet().getWorkbook();
        List rs = si.elements();
        CellStyle cellStyle = cell.getCellStyle();
        boolean ignoreNewline = false;
        if (!cellStyle.isWrapText()) {
            ignoreNewline = true;
        }
        if (rs.size() == 0) {
            this.leaf = new LeafElement("\n");
            RunAttr.instance().setRunAttribute(book, fontID, null, this.leaf.getAttribute(), this.attrLayout);
            this.leaf.setStartOffset(this.offset);
            ++this.offset;
            this.leaf.setEndOffset(this.offset);
            this.paraElem.appendLeaf(this.leaf);
            return this.paraElem;
        }
        for (Element r : rs) {
            String text;
            int len;
            Element t;
            if (!r.getName().equalsIgnoreCase("r") || (t = r.element("t")) == null || (len = (text = t.getText()).length()) <= 0) continue;
            if (ignoreNewline) {
                text = text.replace("\n", "");
                this.leaf = new LeafElement(text);
                RunAttr.instance().setRunAttribute(book, fontID, r.element("rPr"), this.leaf.getAttribute(), this.attrLayout);
                this.leaf.setStartOffset(this.offset);
                this.offset += text.length();
                this.leaf.setEndOffset(this.offset);
                this.paraElem.appendLeaf(this.leaf);
                continue;
            }
            if (!text.contains("\n")) {
                this.leaf = new LeafElement(text);
                RunAttr.instance().setRunAttribute(book, fontID, r.element("rPr"), this.leaf.getAttribute(), this.attrLayout);
                this.leaf.setStartOffset(this.offset);
                this.offset += text.length();
                this.leaf.setEndOffset(this.offset);
                this.paraElem.appendLeaf(this.leaf);
                continue;
            }
            this.processBreakLine(cell, secElem, fontID, r, text);
        }
        if (this.leaf != null) {
            this.leaf.setText(this.leaf.getText(null) + "\n");
            ++this.offset;
        }
        return this.paraElem;
    }

    private void processBreakLine(Cell cell, SectionElement secElem, int fontID, Element r, String text) {
        Workbook book = cell.getSheet().getWorkbook();
        if (text == null || text.length() == 0) {
            return;
        }
        int len = text.length();
        if (text.charAt(0) == '\n') {
            if (this.leaf != null) {
                this.leaf.setText(this.leaf.getText(null) + "\n");
                ++this.offset;
            } else {
                this.leaf = new LeafElement("\n");
                RunAttr.instance().setRunAttribute(book, fontID, r.element("rPr"), this.leaf.getAttribute(), this.attrLayout);
                this.leaf.setStartOffset(this.offset);
                ++this.offset;
                this.leaf.setEndOffset(this.offset);
                this.paraElem.appendLeaf(this.leaf);
            }
            this.paraElem.setEndOffset(this.offset);
            secElem.appendParagraph(this.paraElem, 0L);
            this.leaf = null;
            text = text.substring(1);
            this.paraElem = new ParagraphElement();
            this.paraElem.setStartOffset(this.offset);
            this.attrLayout = new AttributeSetImpl();
            ParaAttr.instance().setParaAttribute(cell.getCellStyle(), this.paraElem.getAttribute(), this.attrLayout);
            this.processBreakLine(cell, secElem, fontID, r, text);
        } else if (text.charAt(len - 1) == '\n') {
            this.leaf = new LeafElement(text.substring(0, text.indexOf("\n") + 1));
            RunAttr.instance().setRunAttribute(book, fontID, r.element("rPr"), this.leaf.getAttribute(), this.attrLayout);
            this.leaf.setStartOffset(this.offset);
            this.offset += this.leaf.getText(null).length();
            this.leaf.setEndOffset(this.offset);
            this.paraElem.appendLeaf(this.leaf);
            this.paraElem.setEndOffset(this.offset);
            secElem.appendParagraph(this.paraElem, 0L);
            text = text.substring(text.indexOf("\n") + 1);
            this.processBreakLine(cell, secElem, fontID, r, text);
        } else {
            String[] items = text.split("\n");
            int cnt = items.length;
            text = items[0] + "\n";
            this.leaf = new LeafElement(text);
            RunAttr.instance().setRunAttribute(book, fontID, r.element("rPr"), this.leaf.getAttribute(), this.attrLayout);
            this.leaf.setStartOffset(this.offset);
            this.offset += text.length();
            this.leaf.setEndOffset(this.offset);
            this.paraElem.appendLeaf(this.leaf);
            this.paraElem.setEndOffset(this.offset);
            secElem.appendParagraph(this.paraElem, 0L);
            for (int index = 1; index < cnt - 1; ++index) {
                this.paraElem = new ParagraphElement();
                this.paraElem.setStartOffset(this.offset);
                this.attrLayout = new AttributeSetImpl();
                ParaAttr.instance().setParaAttribute(cell.getCellStyle(), this.paraElem.getAttribute(), this.attrLayout);
                text = items[index] + "\n";
                this.leaf = new LeafElement(text);
                RunAttr.instance().setRunAttribute(book, fontID, r.element("rPr"), this.leaf.getAttribute(), this.attrLayout);
                this.leaf.setStartOffset(this.offset);
                this.offset += text.length();
                this.leaf.setEndOffset(this.offset);
                this.paraElem.appendLeaf(this.leaf);
                this.paraElem.setEndOffset(this.offset);
                secElem.appendParagraph(this.paraElem, 0L);
            }
            this.paraElem = new ParagraphElement();
            this.paraElem.setStartOffset(this.offset);
            this.attrLayout = new AttributeSetImpl();
            ParaAttr.instance().setParaAttribute(cell.getCellStyle(), this.paraElem.getAttribute(), this.attrLayout);
            text = items[cnt - 1];
            this.leaf = new LeafElement(text);
            RunAttr.instance().setRunAttribute(book, fontID, r.element("rPr"), this.leaf.getAttribute(), this.attrLayout);
            this.leaf.setStartOffset(this.offset);
            this.offset += text.length();
            this.leaf.setEndOffset(this.offset);
            this.paraElem.appendLeaf(this.leaf);
        }
    }

    public boolean searchContent(Element cellElement, String key) {
        Element v = cellElement.element("v");
        return v != null && this.getCellType(cellElement.attributeValue("t")) != 3 && v.getText().toLowerCase().contains(key);
    }
}

