/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.EvaluationWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.AreaEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.NumberEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.Area3DPtg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.MemFuncPtg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.NameXPtg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.Ptg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.Ref3DPtg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.ObjectLinkRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.SeriesTextRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.ValueRangeRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFChart;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFDataFormat;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFFormulaEvaluator;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFName;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ACell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ARow;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ASheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.format.NumericFormatter;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.ChartFactory;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.ColumnBarChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.PointStyle;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.CategorySeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYMultipleSeriesDataset;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYSeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DefaultRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYSeriesRenderer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChartConverter {
    private static ChartConverter converter = new ChartConverter();
    private InternalWorkbook workbook;
    private AbstractChart chart;
    private Map<SeriesTextRecord, Record> chartSeriesText;
    double minY;
    double maxY;

    public static ChartConverter instance() {
        return converter;
    }

    public AbstractChart converter(ASheet sheet, HSSFChart chart) {
        this.workbook = sheet.getAWorkbook().getInternalWorkbook();
        this.minY = Double.MAX_VALUE;
        this.maxY = -1.7976931348623157E308;
        this.chartSeriesText = chart.getSeriesText();
        AbstractChart abstractChart = this.convertToAChart(sheet, chart);
        this.dispose();
        return abstractChart;
    }

    public short getChartType(HSSFChart chart) {
        int ordinal = chart.getType().ordinal();
        if (ordinal == HSSFChart.HSSFChartType.Area.ordinal()) {
            return 0;
        }
        if (ordinal == HSSFChart.HSSFChartType.Bar.ordinal()) {
            return 1;
        }
        if (ordinal == HSSFChart.HSSFChartType.Line.ordinal()) {
            return 2;
        }
        if (ordinal == HSSFChart.HSSFChartType.Pie.ordinal()) {
            return 3;
        }
        if (ordinal == HSSFChart.HSSFChartType.Scatter.ordinal()) {
            return 4;
        }
        return 10;
    }

    private String getFormatContents(Sheet sheet, Cell cell) {
        CellStyle style2 = cell.getCellStyle();
        String value = "";
        String key = "";
        switch (cell.getCellType()) {
            case 4: {
                value = String.valueOf(cell.getBooleanValue());
                break;
            }
            case 0: {
                key = HSSFDataFormat.getFormatCode(this.workbook, style2.getNumberFormatID());
                short numericType = NumericFormatter.instance().getNumericCellType(key);
                if (numericType == 10) {
                    value = NumericFormatter.instance().getFormatContents(key, cell.getDateCellValue(sheet.getWorkbook().isUsing1904DateWindowing()));
                    break;
                }
                value = NumericFormatter.instance().getFormatContents(key, cell.getNumberValue(), numericType);
                break;
            }
            case 1: {
                Object si = sheet.getWorkbook().getSharedItem(cell.getStringCellValueIndex());
                if (si instanceof SectionElement) {
                    value = ((SectionElement)si).getText(null);
                    break;
                }
                value = (String)si;
                break;
            }
            case 2: {
                break;
            }
        }
        return value;
    }

    private double getCellNumericValue(Sheet sheet, Cell cell) {
        if (cell == null) {
            return 0.0;
        }
        if (cell.getCellType() == 0) {
            return cell.getNumberValue();
        }
        if (cell.getCellType() == 3) {
            return 0.0;
        }
        return 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Double> getData(ASheet sheet, Ptg[] valuePtg) {
        if (valuePtg == null || valuePtg.length <= 0) {
            return null;
        }
        ArrayList<Double> dataList = new ArrayList<Double>();
        if (valuePtg[0] instanceof Area3DPtg) {
            Sheet cursheet;
            Area3DPtg area3DPtg = (Area3DPtg)valuePtg[0];
            EvaluationWorkbook.ExternalSheet externalSheet = this.workbook.getExternalSheet(area3DPtg.getExternSheetIndex());
            if (externalSheet == null) {
                int otherIndex = this.workbook.getSheetIndexFromExternSheetIndex(area3DPtg.getExternSheetIndex());
                cursheet = sheet.getWorkbook().getSheet(otherIndex);
            } else {
                cursheet = sheet.getWorkbook().getSheet(externalSheet.getSheetName());
            }
            double value = 0.0;
            if (area3DPtg.getFirstRow() == area3DPtg.getLastRow()) {
                Row row = cursheet.getRow(area3DPtg.getFirstRow());
                for (int k = area3DPtg.getFirstColumn(); k <= area3DPtg.getLastColumn(); ++k) {
                    value = 0.0;
                    if (row != null) {
                        value = this.getCellNumericValue(cursheet, row.getCell(k));
                    }
                    dataList.add(value);
                }
                return dataList;
            } else {
                if (area3DPtg.getFirstColumn() != area3DPtg.getLastColumn()) return dataList;
                for (int j = area3DPtg.getFirstRow(); j <= area3DPtg.getLastRow(); ++j) {
                    Row row = cursheet.getRow(j);
                    value = 0.0;
                    if (row != null) {
                        value = this.getCellNumericValue(cursheet, row.getCell(area3DPtg.getFirstColumn()));
                    }
                    dataList.add(value);
                }
            }
            return dataList;
        } else if (valuePtg[0] instanceof MemFuncPtg) {
            for (int index = 0; index < valuePtg.length; ++index) {
                Sheet cursheet;
                if (!(valuePtg[index] instanceof Ref3DPtg)) continue;
                Ref3DPtg ref = (Ref3DPtg)valuePtg[index];
                EvaluationWorkbook.ExternalSheet externalSheet = this.workbook.getExternalSheet(ref.getExternSheetIndex());
                if (externalSheet == null) {
                    int otherIndex = this.workbook.getSheetIndexFromExternSheetIndex(ref.getExternSheetIndex());
                    cursheet = sheet.getWorkbook().getSheet(otherIndex);
                } else {
                    cursheet = sheet.getWorkbook().getSheet(externalSheet.getSheetName());
                }
                Row row = cursheet.getRow(ref.getRow());
                double value = 0.0;
                value = 0.0;
                if (row != null) {
                    value = this.getCellNumericValue(cursheet, row.getCell(ref.getColumn()));
                }
                dataList.add(value);
            }
            return dataList;
        } else if (valuePtg[0] instanceof NameXPtg) {
            try {
                NameXPtg namePtg = (NameXPtg)valuePtg[0];
                HSSFName hssfName = ((AWorkbook)sheet.getWorkbook()).getNameAt(namePtg.getNameIndex());
                ValueEval valueEval = this.evaluate(sheet, hssfName);
                if (!(valueEval instanceof AreaEval)) return dataList;
                AreaEval area = (AreaEval)valueEval;
                double value = 0.0;
                if (area.getFirstRow() == area.getLastRow()) {
                    for (int k = area.getFirstColumn(); k <= area.getLastColumn(); ++k) {
                        value = ((NumberEval)area.getAbsoluteValue(area.getFirstRow(), k)).getNumberValue();
                        dataList.add(value);
                    }
                    return dataList;
                }
                if (area.getFirstColumn() != area.getLastColumn()) return dataList;
                for (int j = area.getFirstRow(); j <= area.getLastRow(); ++j) {
                    value = ((NumberEval)area.getAbsoluteValue(j, area.getFirstColumn())).getNumberValue();
                    dataList.add(value);
                }
                return dataList;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        } else {
            Sheet cursheet;
            if (valuePtg.length <= 0 || !(valuePtg[0] instanceof Ref3DPtg)) return dataList;
            Ref3DPtg ref = (Ref3DPtg)valuePtg[0];
            EvaluationWorkbook.ExternalSheet externalSheet = this.workbook.getExternalSheet(ref.getExternSheetIndex());
            if (externalSheet == null) {
                int otherIndex = this.workbook.getSheetIndexFromExternSheetIndex(ref.getExternSheetIndex());
                cursheet = sheet.getWorkbook().getSheet(otherIndex);
            } else {
                cursheet = sheet.getWorkbook().getSheet(externalSheet.getSheetName());
            }
            Row row = cursheet.getRow(ref.getRow());
            double value = 0.0;
            value = 0.0;
            if (row != null) {
                value = this.getCellNumericValue(cursheet, row.getCell(ref.getColumn()));
            }
            dataList.add(value);
        }
        return dataList;
    }

    private XYMultipleSeriesDataset getXYMultipleSeriesDataset(ASheet sheet, HSSFChart chart, XYMultipleSeriesRenderer renderer, short chartType) {
        XYMultipleSeriesDataset dataset = new XYMultipleSeriesDataset();
        HSSFChart.HSSFSeries[] series = chart.getSeries();
        SimpleSeriesRenderer[] seriesRenderers = renderer.getSeriesRenderers();
        int seriesCount = series.length;
        for (int i = 0; i < seriesCount; ++i) {
            Serializable aSeries;
            Ptg[] valuePtg;
            String seriesName = null;
            seriesName = series[i].getSeriesTitle() != null ? series[i].getSeriesTitle() : "Series " + (i + 1);
            List<Object> xList = null;
            boolean isValidateXList = true;
            if (chartType == 4) {
                xList = new ArrayList();
                valuePtg = series[i].getDataCategoryLabels().getFormulaOfLink();
                if (valuePtg.length > 0) {
                    xList = this.getData(sheet, valuePtg);
                    for (int j = 0; j < xList.size() - 1; ++j) {
                        if (!(Math.abs((Double)xList.get(j) - (Double)xList.get(j + 1)) < (double)1.0E-9f)) continue;
                        isValidateXList = false;
                        break;
                    }
                }
            }
            if ((valuePtg = series[i].getDataValues().getFormulaOfLink()).length <= 0) {
                renderer.removeSeriesRenderer(seriesRenderers[i]);
                chart.removeSeries(series[i]);
                continue;
            }
            List<Double> yList = this.getData(sheet, valuePtg);
            if (chartType == 4 && isValidateXList) {
                if (xList == null || yList == null || xList.size() != yList.size()) continue;
                aSeries = new XYSeries(seriesName);
                for (int j = 0; j < xList.size(); ++j) {
                    ((XYSeries)aSeries).add((Double)xList.get(j), yList.get(j));
                    this.minY = Math.min(yList.get(j), this.minY);
                    this.maxY = Math.max(yList.get(j), this.maxY);
                }
                dataset.addSeries((XYSeries)aSeries);
                continue;
            }
            aSeries = new CategorySeries(seriesName);
            for (Double value : yList) {
                ((CategorySeries)aSeries).add(value);
                this.minY = Math.min(value, this.minY);
                this.maxY = Math.max(value, this.maxY);
            }
            dataset.addSeries(((CategorySeries)aSeries).toXYSeries());
        }
        return dataset;
    }

    private ValueEval evaluate(ASheet sheet, HSSFName name) {
        ACell cell = null;
        int e = sheet.getLastRowNum();
        for (int s = sheet.getFirstRowNum(); s <= e; ++s) {
            ARow row = (ARow)sheet.getRow(sheet.getLastRowNum());
            short col = -1;
            if (row.getFirstCol() > 0) {
                col = (short)(row.getFirstCol() - 1);
            } else if (row.getLastCol() < HSSFCell.LAST_COLUMN_NUMBER) {
                col = (short)(row.getLastCol() + 1);
            }
            if (col < 0) continue;
            cell = new ACell((AWorkbook)sheet.getWorkbook(), sheet, s, col);
            break;
        }
        if (cell != null) {
            cell.setCellFormula(name.getRefersToFormulaDefinition());
            HSSFFormulaEvaluator evaluator = new HSSFFormulaEvaluator((AWorkbook)sheet.getWorkbook());
            ValueEval value = evaluator.evaluateFormulaValueEval(cell);
            cell.dispose();
            cell = null;
            evaluator = null;
            return value;
        }
        return null;
    }

    private XYMultipleSeriesRenderer buildXYMultipleSeriesRenderer(ASheet sheet, HSSFChart chart) {
        return this.buildXYMultipleSeriesRenderer(sheet, chart, null);
    }

    private XYMultipleSeriesRenderer buildXYMultipleSeriesRenderer(ASheet sheet, HSSFChart chart, PointStyle[] styles) {
        Ptg[] categoryLabelsPtg;
        Object r;
        XYMultipleSeriesRenderer renderer = new XYMultipleSeriesRenderer();
        renderer.setXTitleTextSize(16.0f);
        renderer.setYTitleTextSize(16.0f);
        renderer.setChartTitleTextSize(20.0f);
        renderer.setLabelsTextSize(15.0f);
        renderer.setLegendTextSize(15.0f);
        renderer.setShowGridH(true);
        int colorOffSet = 0;
        switch (this.getChartType(chart)) {
            case 0: 
            case 1: 
            case 3: {
                colorOffSet = 24;
                break;
            }
            case 2: 
            case 4: {
                colorOffSet = 32;
            }
        }
        HSSFChart.HSSFSeries[] series = chart.getSeries();
        if (styles != null && styles.length > 0) {
            int pointStyleIndex = 0;
            for (int i = 0; i < series.length; ++i) {
                r = new XYSeriesRenderer();
                ((XYSeriesRenderer)r).setPointStyle(styles[pointStyleIndex]);
                pointStyleIndex = (pointStyleIndex + 1) % styles.length;
                int color2 = 0x808080;
                color2 = sheet.getWorkbook().getColor(i + colorOffSet);
                ((SimpleSeriesRenderer)r).setColor(color2);
                renderer.addSeriesRenderer((SimpleSeriesRenderer)r);
            }
        } else {
            for (int i = 0; i < series.length; ++i) {
                XYSeriesRenderer r2 = new XYSeriesRenderer();
                int color3 = 0x808080;
                color3 = sheet.getWorkbook().getColor(i + 24);
                r2.setColor(color3);
                renderer.addSeriesRenderer(r2);
            }
        }
        if (series.length > 0 && (categoryLabelsPtg = series[0].getDataCategoryLabels().getFormulaOfLink()).length > 0 && categoryLabelsPtg[0] instanceof Area3DPtg) {
            Sheet cursheet;
            Area3DPtg area3DPtg = (Area3DPtg)categoryLabelsPtg[0];
            EvaluationWorkbook.ExternalSheet externalSheet = this.workbook.getExternalSheet(area3DPtg.getExternSheetIndex());
            if (externalSheet == null) {
                int otherIndex = this.workbook.getSheetIndexFromExternSheetIndex(area3DPtg.getExternSheetIndex());
                cursheet = sheet.getWorkbook().getSheet(otherIndex);
            } else {
                cursheet = sheet.getWorkbook().getSheet(externalSheet.getSheetName());
            }
            int xTextLabel = 1;
            if (area3DPtg.getFirstRow() == area3DPtg.getLastRow()) {
                Row row = cursheet.getRow(area3DPtg.getFirstRow());
                for (int k = area3DPtg.getFirstColumn(); k <= area3DPtg.getLastColumn(); ++k) {
                    textLabel = row != null && row.getCell(k) != null ? this.getFormatContents(cursheet, row.getCell(k)) : String.valueOf(k - area3DPtg.getFirstColumn() + 1);
                    renderer.addXTextLabel(xTextLabel++, textLabel);
                }
            } else if (area3DPtg.getFirstColumn() == area3DPtg.getLastColumn()) {
                for (int j = area3DPtg.getFirstRow(); j <= area3DPtg.getLastRow(); ++j) {
                    Row row = cursheet.getRow(j);
                    textLabel = row != null && row.getCell(area3DPtg.getFirstColumn()) != null ? this.getFormatContents(cursheet, row.getCell(area3DPtg.getFirstColumn())) : String.valueOf(j - area3DPtg.getFirstRow() + 1);
                    renderer.addXTextLabel(xTextLabel++, textLabel);
                }
            }
        }
        for (SeriesTextRecord seriesTextRecord : this.chartSeriesText.keySet()) {
            r = this.chartSeriesText.get(seriesTextRecord);
            if (!(r instanceof ObjectLinkRecord)) continue;
            switch (((ObjectLinkRecord)r).getAnchorId()) {
                case 1: {
                    renderer.setChartTitle(seriesTextRecord.getText());
                    break;
                }
                case 2: {
                    renderer.setYTitle(seriesTextRecord.getText());
                    break;
                }
                case 3: {
                    renderer.setXTitle(seriesTextRecord.getText());
                    break;
                }
                case 4: {
                    break;
                }
                case 7: {
                    break;
                }
            }
        }
        return renderer;
    }

    private void setChartSettings(XYMultipleSeriesRenderer renderer, XYMultipleSeriesDataset dataset, HSSFChart chart) {
        int seriesItemCount = -1;
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            seriesItemCount = Math.max(seriesItemCount, dataset.getSeriesAt(i).getItemCount());
        }
        List<ValueRangeRecord> valueRangeList = chart.getValueRangeRecord();
        if (valueRangeList.size() > 0) {
            ValueRangeRecord valueRangeRecord;
            if (this.getChartType(chart) != 4) {
                renderer.setXAxisMin(0.5);
                renderer.setXAxisMax((double)seriesItemCount + 0.5);
                valueRangeRecord = valueRangeList.get(0);
            } else {
                double minX = dataset.getSeriesAt(0).getMinX();
                double maxX = dataset.getSeriesAt(0).getMaxX();
                valueRangeRecord = valueRangeList.get(0);
                if (!valueRangeRecord.isAutomaticMinimum()) {
                    minX = valueRangeRecord.getMinimumAxisValue();
                }
                if (!valueRangeRecord.isAutomaticMaximum()) {
                    maxX = valueRangeRecord.getMaximumAxisValue();
                }
                renderer.setXAxisMin(minX);
                renderer.setXAxisMax(maxX);
                valueRangeRecord = valueRangeList.get(1);
            }
            if (!valueRangeRecord.isAutomaticMinimum()) {
                this.minY = valueRangeRecord.getMinimumAxisValue();
            }
            if (!valueRangeRecord.isAutomaticMaximum()) {
                this.maxY = valueRangeRecord.getMaximumAxisValue();
            }
        } else if (this.getChartType(chart) != 4) {
            renderer.setXAxisMin(0.5);
            renderer.setXAxisMax((double)seriesItemCount + 0.5);
        } else {
            double minX = dataset.getSeriesAt(0).getMinX();
            double maxX = dataset.getSeriesAt(0).getMaxX();
            renderer.setXAxisMin(minX);
            renderer.setXAxisMax(maxX);
        }
        renderer.setYAxisMin(this.minY);
        renderer.setYAxisMax(this.maxY);
    }

    protected DefaultRenderer buildDefaultRenderer(Sheet sheet, HSSFChart chart) {
        Ptg[] valuePtg;
        HSSFChart.HSSFSeries[] series;
        int seriesCount;
        DefaultRenderer renderer = new DefaultRenderer();
        renderer.setLabelsTextSize(15.0f);
        renderer.setLegendTextSize(15.0f);
        renderer.setShowGridH(true);
        if (chart.getMarginColorFormat() != null) {
            int color2 = sheet.getWorkbook().getColor(chart.getMarginColorFormat().getForecolorIndex());
            renderer.setBackgroundColor(color2);
        }
        if ((seriesCount = (series = chart.getSeries()).length) > 0 && (valuePtg = series[0].getDataValues().getFormulaOfLink()).length > 0 && valuePtg[0] instanceof Area3DPtg) {
            Area3DPtg area3DPtg = (Area3DPtg)valuePtg[0];
            if (area3DPtg.getFirstColumn() == area3DPtg.getLastColumn()) {
                for (j = area3DPtg.getFirstRow(); j <= area3DPtg.getLastRow(); ++j) {
                    r = new SimpleSeriesRenderer();
                    color = sheet.getWorkbook().getColor(j - area3DPtg.getFirstRow() + 24);
                    r.setColor(color);
                    renderer.addSeriesRenderer(r);
                }
            } else if (area3DPtg.getFirstRow() == area3DPtg.getLastRow()) {
                for (j = area3DPtg.getFirstColumn(); j <= area3DPtg.getLastColumn(); ++j) {
                    r = new SimpleSeriesRenderer();
                    color = sheet.getWorkbook().getColor(j - area3DPtg.getFirstColumn() + 24);
                    r.setColor(color);
                    renderer.addSeriesRenderer(r);
                }
            }
        }
        for (SeriesTextRecord seriesTextRecord : this.chartSeriesText.keySet()) {
            Record r = this.chartSeriesText.get(seriesTextRecord);
            if (!(r instanceof ObjectLinkRecord)) continue;
            switch (((ObjectLinkRecord)r).getAnchorId()) {
                case 1: {
                    renderer.setChartTitle(seriesTextRecord.getText());
                }
            }
        }
        return renderer;
    }

    private String getCategory(Sheet sheet, Area3DPtg catPtg, int offIncrement) {
        String name = "";
        if (catPtg.getFirstColumn() == catPtg.getLastColumn()) {
            Cell cell;
            Row row = sheet.getRow(catPtg.getFirstRow() + offIncrement);
            name = row != null && (cell = row.getCell(catPtg.getFirstColumn())) != null ? this.getFormatContents(sheet, cell) : String.valueOf(offIncrement + 1);
        } else if (catPtg.getFirstRow() == catPtg.getLastRow()) {
            Cell cell;
            Row row = sheet.getRow(catPtg.getFirstRow());
            name = row != null && (cell = row.getCell(catPtg.getFirstColumn() + offIncrement)) != null ? this.getFormatContents(sheet, cell) : String.valueOf(offIncrement + 1);
        }
        return name;
    }

    protected CategorySeries buildCategoryDataset(Sheet sheet, HSSFChart chart) {
        CategorySeries aSeries = new CategorySeries("");
        if (chart.getSeries().length > 0) {
            Sheet cursheet;
            HSSFChart.HSSFSeries series = chart.getSeries()[0];
            aSeries = series.getSeriesTitle() != null ? new CategorySeries(series.getSeriesTitle()) : new CategorySeries("");
            Ptg[] categoryLabelsPtg = series.getDataCategoryLabels().getFormulaOfLink();
            Ptg[] dataValuesPtg = series.getDataValues().getFormulaOfLink();
            if (dataValuesPtg.length <= 0 || !(dataValuesPtg[0] instanceof Area3DPtg)) {
                return null;
            }
            Area3DPtg valuePtg = (Area3DPtg)dataValuesPtg[0];
            EvaluationWorkbook.ExternalSheet externalSheet = this.workbook.getExternalSheet(valuePtg.getExternSheetIndex());
            if (externalSheet == null) {
                int otherIndex = this.workbook.getSheetIndexFromExternSheetIndex(valuePtg.getExternSheetIndex());
                cursheet = sheet.getWorkbook().getSheet(otherIndex);
            } else {
                cursheet = sheet.getWorkbook().getSheet(externalSheet.getSheetName());
            }
            if (categoryLabelsPtg.length > 0 && categoryLabelsPtg[0] instanceof Area3DPtg) {
                Area3DPtg catPtg = (Area3DPtg)categoryLabelsPtg[0];
                double value = 0.0;
                if (valuePtg.getFirstColumn() == valuePtg.getLastColumn()) {
                    for (int j = valuePtg.getFirstRow(); j <= valuePtg.getLastRow(); ++j) {
                        String name = this.getCategory(cursheet, catPtg, j - valuePtg.getFirstRow());
                        value = 0.0;
                        Row dataRow = cursheet.getRow(j);
                        if (dataRow != null) {
                            value = this.getCellNumericValue(cursheet, dataRow.getCell(valuePtg.getFirstColumn()));
                        }
                        aSeries.add(name, value);
                    }
                } else if (valuePtg.getFirstRow() == valuePtg.getLastRow()) {
                    Row dataRow = cursheet.getRow(valuePtg.getFirstRow());
                    for (int j = valuePtg.getFirstColumn(); j <= valuePtg.getLastColumn(); ++j) {
                        String name = this.getCategory(cursheet, catPtg, j - valuePtg.getFirstColumn());
                        value = 0.0;
                        if (dataRow != null) {
                            value = this.getCellNumericValue(cursheet, dataRow.getCell(j));
                        }
                        aSeries.add(name, value);
                    }
                }
            } else {
                double value = 0.0;
                if (valuePtg.getFirstColumn() == valuePtg.getLastColumn()) {
                    for (int j = valuePtg.getFirstRow(); j <= valuePtg.getLastRow(); ++j) {
                        value = 0.0;
                        Row row = cursheet.getRow(j);
                        if (row != null) {
                            value = this.getCellNumericValue(cursheet, row.getCell(valuePtg.getFirstColumn()));
                        }
                        aSeries.add(value);
                    }
                } else if (valuePtg.getFirstRow() == valuePtg.getLastRow()) {
                    Row row = cursheet.getRow(valuePtg.getFirstRow());
                    for (int j = valuePtg.getFirstColumn(); j <= valuePtg.getLastColumn(); ++j) {
                        value = 0.0;
                        if (row != null) {
                            value = this.getCellNumericValue(cursheet, row.getCell(j));
                        }
                        aSeries.add(value);
                    }
                }
            }
            return aSeries;
        }
        return null;
    }

    private AbstractChart convertToAChart(ASheet sheet, HSSFChart chart) {
        PointStyle[] styles = new PointStyle[]{PointStyle.DIAMOND, PointStyle.SQUARE, PointStyle.TRIANGLE, PointStyle.X, PointStyle.CIRCLE};
        switch (this.getChartType(chart)) {
            case 2: {
                XYMultipleSeriesRenderer renderer = this.buildXYMultipleSeriesRenderer(sheet, chart, styles);
                if (renderer == null) {
                    return null;
                }
                XYMultipleSeriesDataset dataset = this.getXYMultipleSeriesDataset(sheet, chart, renderer, (short)2);
                if (dataset == null) {
                    return null;
                }
                this.setChartSettings(renderer, dataset, chart);
                renderer.setYLabels(10);
                return ChartFactory.getLineChart(dataset, renderer);
            }
            case 3: {
                DefaultRenderer renderer = this.buildDefaultRenderer(sheet, chart);
                if (renderer == null) {
                    return null;
                }
                renderer.setZoomEnabled(true);
                CategorySeries categoryDataset = this.buildCategoryDataset(sheet, chart);
                if (categoryDataset == null) {
                    return null;
                }
                return ChartFactory.getPieChart(categoryDataset, renderer);
            }
            case 4: {
                XYMultipleSeriesRenderer renderer = this.buildXYMultipleSeriesRenderer(sheet, chart, styles);
                if (renderer == null) {
                    return null;
                }
                XYMultipleSeriesDataset dataset = this.getXYMultipleSeriesDataset(sheet, chart, renderer, (short)4);
                if (dataset == null) {
                    return null;
                }
                this.setChartSettings(renderer, dataset, chart);
                for (int i = 0; i < renderer.getSeriesRendererCount(); ++i) {
                    ((XYSeriesRenderer)renderer.getSeriesRendererAt(i)).setFillPoints(true);
                }
                return ChartFactory.getScatterChart(dataset, renderer);
            }
        }
        try {
            XYMultipleSeriesRenderer renderer = this.buildXYMultipleSeriesRenderer(sheet, chart);
            if (renderer == null) {
                return null;
            }
            XYMultipleSeriesDataset dataset = this.getXYMultipleSeriesDataset(sheet, chart, renderer, (short)1);
            if (dataset == null) {
                return null;
            }
            this.setChartSettings(renderer, dataset, chart);
            return ChartFactory.getColumnBarChart(dataset, renderer, ColumnBarChart.Type.DEFAULT);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AbstractChart getAChart() {
        return this.chart;
    }

    private void dispose() {
        this.workbook = null;
        this.chart = null;
        this.chartSeriesText = null;
    }
}

