/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ss.util;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.SheetNameFormatter;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.CellRangeAddressBase;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.CellReference;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianByteArrayOutputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianOutput;

public class HSSFCellRangeAddress
extends CellRangeAddressBase {
    public static final int ENCODED_SIZE = 8;

    public HSSFCellRangeAddress(int firstRow, int lastRow, int firstCol, int lastCol) {
        super(firstRow, lastRow, firstCol, lastCol);
    }

    public int serialize(int offset, byte[] data) {
        this.serialize(new LittleEndianByteArrayOutputStream(data, offset, 8));
        return 8;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.getFirstRow());
        out.writeShort(this.getLastRow());
        out.writeShort(this.getFirstColumn());
        out.writeShort(this.getLastColumn());
    }

    public HSSFCellRangeAddress(RecordInputStream in) {
        super(HSSFCellRangeAddress.readUShortAndCheck(in), in.readUShort(), in.readUShort(), in.readUShort());
    }

    private static int readUShortAndCheck(RecordInputStream in) {
        if (in.remaining() < 8) {
            throw new RuntimeException("Ran out of data reading CellRangeAddress");
        }
        return in.readUShort();
    }

    public HSSFCellRangeAddress copy() {
        return new HSSFCellRangeAddress(this.getFirstRow(), this.getLastRow(), this.getFirstColumn(), this.getLastColumn());
    }

    public static int getEncodedSize(int numberOfItems) {
        return numberOfItems * 8;
    }

    public String formatAsString() {
        return this.formatAsString(null, false);
    }

    public String formatAsString(String sheetName, boolean useAbsoluteAddress) {
        StringBuffer sb = new StringBuffer();
        if (sheetName != null) {
            sb.append(SheetNameFormatter.format(sheetName));
            sb.append("!");
        }
        CellReference cellRefFrom = new CellReference(this.getFirstRow(), this.getFirstColumn(), useAbsoluteAddress, useAbsoluteAddress);
        CellReference cellRefTo = new CellReference(this.getLastRow(), this.getLastColumn(), useAbsoluteAddress, useAbsoluteAddress);
        sb.append(cellRefFrom.formatAsString());
        if (!cellRefFrom.equals(cellRefTo)) {
            sb.append(':');
            sb.append(cellRefTo.formatAsString());
        }
        return sb.toString();
    }

    public static HSSFCellRangeAddress valueOf(String ref) {
        CellReference b;
        CellReference a;
        int sep = ref.indexOf(":");
        if (sep == -1) {
            b = a = new CellReference(ref);
        } else {
            a = new CellReference(ref.substring(0, sep));
            b = new CellReference(ref.substring(sep + 1));
        }
        return new HSSFCellRangeAddress(a.getRow(), b.getRow(), a.getCol(), b.getCol());
    }
}

