/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader;

import android.graphics.Color;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ThemeReader {
    private static ThemeReader themeReader = new ThemeReader();

    public static ThemeReader instance() {
        return themeReader;
    }

    public Map<String, Integer> getThemeColorMap(PackagePart themePart) throws Exception {
        Element themeElements;
        SAXReader saxreader = new SAXReader();
        InputStream in = themePart.getInputStream();
        Document poiTheme = saxreader.read(in);
        Element root = poiTheme.getRootElement();
        if (root != null && (themeElements = root.element("themeElements")) != null) {
            Element clrScheme = themeElements.element("clrScheme");
            HashMap<String, Integer> colorMap = new HashMap<String, Integer>();
            Iterator it = clrScheme.elementIterator();
            while (it.hasNext()) {
                Element clr = (Element)it.next();
                String name = clr.getName();
                Element srgbClr = clr.element("srgbClr");
                Element sysClr = clr.element("sysClr");
                if (srgbClr != null) {
                    colorMap.put(name, Color.parseColor((String)("#" + srgbClr.attributeValue("val"))));
                    continue;
                }
                if (sysClr != null) {
                    colorMap.put(name, Color.parseColor((String)("#" + sysClr.attributeValue("lastClr"))));
                    continue;
                }
                colorMap.put(name, -1);
            }
            return colorMap;
        }
        in.close();
        return null;
    }
}

