/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementHandler;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementPath;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.tableStyle.TableCellBorders;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.tableStyle.TableCellStyle;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.tableStyle.TableStyle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttributeSetImpl;
import java.io.InputStream;

public class TableStyleReader {
    private static TableStyleReader tableStyleReader = new TableStyleReader();
    private PGModel pgModel = null;
    private int defaultFontSize = 12;

    public static TableStyleReader instance() {
        return tableStyleReader;
    }

    public void read(PGModel pgModel, PackagePart tableStyle, int defaultFontSize) throws Exception {
        this.pgModel = pgModel;
        this.defaultFontSize = defaultFontSize;
        SAXReader saxreader = new SAXReader();
        try {
            InputStream in = tableStyle.getInputStream();
            TableStyleSaxHandler preSaxHandler = new TableStyleSaxHandler();
            saxreader.addHandler("/tblStyleLst/tblStyle", preSaxHandler);
            saxreader.read(in);
            in.close();
            pgModel = null;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            saxreader.resetHandlers();
        }
    }

    private void processTableStyle(Element tablestyleElement) {
        TableStyle tableStyle = new TableStyle();
        String styleId = tablestyleElement.attributeValue("styleId");
        Element element = tablestyleElement.element("wholeTbl");
        if (element != null) {
            tableStyle.setWholeTable(this.processTableCellStyle(element));
        }
        if ((element = tablestyleElement.element("band1H")) != null) {
            tableStyle.setBand1H(this.processTableCellStyle(element));
        }
        if ((element = tablestyleElement.element("band2H")) != null) {
            tableStyle.setBand2H(this.processTableCellStyle(element));
        }
        if ((element = tablestyleElement.element("band1V")) != null) {
            tableStyle.setBand1V(this.processTableCellStyle(element));
        }
        if ((element = tablestyleElement.element("band2V")) != null) {
            tableStyle.setBand2V(this.processTableCellStyle(element));
        }
        if ((element = tablestyleElement.element("lastCol")) != null) {
            tableStyle.setLastCol(this.processTableCellStyle(element));
        }
        if ((element = tablestyleElement.element("firstCol")) != null) {
            tableStyle.setFirstCol(this.processTableCellStyle(element));
        }
        if ((element = tablestyleElement.element("lastRow")) != null) {
            tableStyle.setLastRow(this.processTableCellStyle(element));
        }
        if ((element = tablestyleElement.element("firstRow")) != null) {
            tableStyle.setFirstRow(this.processTableCellStyle(element));
        }
        this.pgModel.putTableStyle(styleId, tableStyle);
    }

    private TableCellStyle processTableCellStyle(Element tableStyleElement) {
        Element cellStyleElement;
        Element ele;
        TableCellStyle tableCellStyle = new TableCellStyle();
        Element cellTextStyleElement = tableStyleElement.element("tcTxStyle");
        if (cellTextStyleElement != null) {
            AttributeSetImpl attr = new AttributeSetImpl();
            String str = cellTextStyleElement.attributeValue("b");
            if ("on".equals(str)) {
                AttrManage.instance().setFontBold(attr, true);
            }
            if ("on".equals(str = cellTextStyleElement.attributeValue("i"))) {
                AttrManage.instance().setFontItalic(attr, true);
            }
            AttrManage.instance().setFontSize(attr, this.defaultFontSize);
            tableCellStyle.setFontAttributeSet(attr);
        }
        if ((ele = (cellStyleElement = tableStyleElement.element("tcStyle")).element("tcBdr")) != null) {
            tableCellStyle.setTableCellBorders(this.getTableCellBorders(ele));
        }
        tableCellStyle.setTableCellBgFill(cellStyleElement.element("fill"));
        return tableCellStyle;
    }

    private TableCellBorders getTableCellBorders(Element tcBrdElement) {
        TableCellBorders tableCellBorders = new TableCellBorders();
        Element ele = tcBrdElement.element("left");
        if (ele != null) {
            tableCellBorders.setLeftBorder(ele.element("ln"));
        }
        if ((ele = tcBrdElement.element("right")) != null) {
            tableCellBorders.setRightBorder(ele.element("ln"));
        }
        if ((ele = tcBrdElement.element("top")) != null) {
            tableCellBorders.setTopBorder(ele.element("ln"));
        }
        if ((ele = tcBrdElement.element("bottom")) != null) {
            tableCellBorders.setBottomBorder(ele.element("ln"));
        }
        return tableCellBorders;
    }

    class TableStyleSaxHandler
    implements ElementHandler {
        TableStyleSaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            Element elem = elementPath.getCurrent();
            String name = elem.getName();
            try {
                if (name.equals("tblStyle")) {
                    TableStyleReader.this.processTableStyle(elem);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            elem.detach();
        }
    }
}

