/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader;

import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ArbitraryPolygonShapePath;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeTypes;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.ArbitraryPolygonShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.Arrow;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.LineShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.SmartArt;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.fc.LineKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.SectionAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.BackgroundReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGLayout;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGMaster;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

public class SmartArtReader {
    private static SmartArtReader reader = new SmartArtReader();

    public static SmartArtReader instance() {
        return reader;
    }

    public SmartArt read(IControl control, ZipPackage zipPackage, PGModel pgModel, PGMaster pgMaster, PGLayout pgLayout, PGSlide pgSlide, PackagePart slidePart, PackagePart dataPart) throws Exception {
        PackageRelationship smartArDrawingRel;
        String relId;
        SAXReader saxreader = new SAXReader();
        InputStream in = dataPart.getInputStream();
        Document dataDoc = saxreader.read(in);
        in.close();
        Element root = dataDoc.getRootElement();
        BackgroundAndFill fill = BackgroundReader.instance().processBackground(control, zipPackage, dataPart, pgMaster, root.element("bg"));
        Line line = LineKit.createLine(control, zipPackage, dataPart, pgMaster, root.element("whole").element("ln"));
        PackagePart drawingPart = null;
        Element e = null;
        e = root.element("extLst");
        if (e != null && (e = e.element("ext")) != null && (e = e.element("dataModelExt")) != null && (relId = e.attributeValue("relId")) != null && (smartArDrawingRel = slidePart.getRelationship(relId)) != null) {
            drawingPart = zipPackage.getPart(smartArDrawingRel.getTargetURI());
        }
        if (drawingPart == null) {
            return null;
        }
        in = drawingPart.getInputStream();
        Document smartArtDoc = saxreader.read(in);
        in.close();
        SmartArt smartArt = new SmartArt();
        smartArt.setBackgroundAndFill(fill);
        smartArt.setLine(line);
        root = smartArtDoc.getRootElement();
        Element spTree = root.element("spTree");
        if (spTree != null) {
            Iterator it = spTree.elementIterator("sp");
            while (it.hasNext()) {
                Element sp = (Element)it.next();
                IShape shape = null;
                shape = this.processAutoShape(control, zipPackage, drawingPart, pgModel, pgMaster, pgLayout, pgSlide, sp);
                if (shape != null) {
                    shape.setParent(smartArt);
                    smartArt.appendShapes(shape);
                }
                if ((shape = this.getTextBoxData(control, pgMaster, pgLayout, sp)) == null) continue;
                smartArt.appendShapes(shape);
            }
        }
        return smartArt;
    }

    private BackgroundAndFill getBackgrouond(IControl control, ZipPackage zipPackage, PackagePart smartArtPart, PGModel pgModel, PGMaster pgMaster, PGLayout pgLayout, PGSlide pgSlide, Element sp, int shapeType) throws Exception {
        String val;
        BackgroundAndFill fill = null;
        if (sp.attribute("useBgFill") != null && (val = sp.attributeValue("useBgFill")) != null && val.length() > 0 && Integer.parseInt(val) > 0 && (fill = pgSlide.getBackgroundAndFill()) == null) {
            if (pgLayout != null) {
                fill = pgLayout.getBackgroundAndFill();
            }
            if (fill == null && pgMaster != null) {
                fill = pgMaster.getBackgroundAndFill();
            }
        }
        Element spPr = sp.element("spPr");
        String spName = sp.getName();
        if (fill == null && spPr.element("noFill") == null && !spName.equals("cxnSp") && (fill = BackgroundReader.instance().processBackground(control, zipPackage, smartArtPart, pgMaster, spPr)) == null && shapeType != 19 && shapeType != 185 && shapeType != 85 && shapeType != 86 && shapeType != 186 && shapeType != 87 && shapeType != 88 && shapeType != 233) {
            fill = BackgroundReader.instance().processBackground(control, zipPackage, smartArtPart, pgMaster, sp.element("style"));
        }
        return fill;
    }

    private void processGrpRotation(IShape shape, Element spPr) {
        ReaderKit.instance().processRotation(spPr, shape);
    }

    private IShape processAutoShape(IControl control, ZipPackage zipPackage, PackagePart smartArtPart, PGModel pgModel, PGMaster pgMaster, PGLayout pgLayout, PGSlide pgSlide, Element sp) throws Exception {
        Element spPr = sp.element("spPr");
        Rectangle rect = null;
        if (spPr == null) {
            return null;
        }
        rect = ReaderKit.instance().getShapeAnchor(spPr.element("xfrm"), 1.0f, 1.0f);
        int shapeType = 0;
        Float[] values = null;
        boolean border = true;
        String name = ReaderKit.instance().getPlaceholderName(sp);
        String spName = sp.getName();
        if (spName.equals("cxnSp")) {
            border = true;
            shapeType = 20;
        } else if (name.contains("Text Box") || name.contains("TextBox")) {
            shapeType = 1;
        }
        Element prstGeom = spPr.element("prstGeom");
        if (prstGeom != null) {
            List gds;
            Element avLst;
            String val;
            if (prstGeom.attribute("prst") != null && (val = prstGeom.attributeValue("prst")) != null && val.length() > 0) {
                shapeType = AutoShapeTypes.instance().getAutoShapeType(val);
            }
            if ((avLst = prstGeom.element("avLst")) != null && (gds = avLst.elements("gd")) != null && gds.size() > 0) {
                values = new Float[gds.size()];
                for (int i = 0; i < gds.size(); ++i) {
                    Element gd = (Element)gds.get(i);
                    val = gd.attributeValue("fmla");
                    val = val.substring(4);
                    values[i] = Float.valueOf(Float.parseFloat(val) / 100000.0f);
                }
            }
        } else if (spPr.element("custGeom") != null) {
            shapeType = 233;
        }
        BackgroundAndFill fill = this.getBackgrouond(control, zipPackage, smartArtPart, pgModel, pgMaster, pgLayout, pgSlide, sp, shapeType);
        Line line = LineKit.createShapeLine(control, zipPackage, smartArtPart, pgMaster, sp);
        Element ln = spPr.element("ln");
        Element style2 = sp.element("style");
        if (ln != null) {
            if (ln.element("noFill") != null) {
                border = false;
            }
        } else if (border && (style2 == null || style2.element("lnRef") == null)) {
            border = false;
        }
        if (shapeType == 20 || shapeType == 32 || shapeType == 34 || shapeType == 38) {
            LineShape lineShape = new LineShape();
            lineShape.setShapeType(shapeType);
            lineShape.setBounds(rect);
            lineShape.setAdjustData(values);
            lineShape.setLine(line);
            if (ln != null) {
                byte arrowType;
                Element temp = ln.element("headEnd");
                if (temp != null && temp.attribute("type") != null && (arrowType = Arrow.getArrowType(temp.attributeValue("type"))) != 0) {
                    lineShape.createStartArrow(arrowType, Arrow.getArrowSize(temp.attributeValue("w")), Arrow.getArrowSize(temp.attributeValue("len")));
                }
                if ((temp = ln.element("tailEnd")) != null && temp.attribute("type") != null && (arrowType = Arrow.getArrowType(temp.attributeValue("type"))) != 0) {
                    lineShape.createStartArrow(arrowType, Arrow.getArrowSize(temp.attributeValue("w")), Arrow.getArrowSize(temp.attributeValue("len")));
                }
            }
            this.processGrpRotation(lineShape, spPr);
            return lineShape;
        }
        if (shapeType == 233) {
            ArbitraryPolygonShape arbitraryPolygonShape = new ArbitraryPolygonShape();
            BackgroundAndFill lineFill = null;
            if (line != null) {
                lineFill = line.getBackgroundAndFill();
            }
            ArbitraryPolygonShapePath.processArbitraryPolygonShape(arbitraryPolygonShape, sp, fill, border, lineFill, ln, rect);
            arbitraryPolygonShape.setShapeType(shapeType);
            this.processGrpRotation(arbitraryPolygonShape, spPr);
            arbitraryPolygonShape.setLine(line);
            return arbitraryPolygonShape;
        }
        if (fill != null || line != null) {
            AutoShape autoShape = new AutoShape(shapeType);
            autoShape.setBounds(rect);
            if (fill != null) {
                autoShape.setBackgroundAndFill(fill);
            }
            if (line != null) {
                autoShape.setLine(line);
            }
            autoShape.setAdjustData(values);
            this.processGrpRotation(autoShape, spPr);
            return autoShape;
        }
        return null;
    }

    private IShape getTextBoxData(IControl control, PGMaster pgMaster, PGLayout pgLayout, Element sp) {
        Element txBody;
        Element temp = sp.element("txXfrm");
        Rectangle rect = null;
        if (temp != null) {
            rect = ReaderKit.instance().getShapeAnchor(temp, 1.0f, 1.0f);
        }
        if ((txBody = sp.element("txBody")) != null) {
            Element wrap;
            TextBox tb = new TextBox();
            tb.setBounds(rect);
            SectionElement secElem = new SectionElement();
            secElem.setStartOffset(0L);
            tb.setElement(secElem);
            IAttributeSet attr = secElem.getAttribute();
            AttrManage.instance().setPageWidth(attr, (int)((float)rect.width * 15.0f));
            AttrManage.instance().setPageHeight(attr, (int)((float)rect.height * 15.0f));
            IAttributeSet attrLayout = null;
            IAttributeSet attrMaster = null;
            String type = "dgm";
            int idx = 0;
            if (pgLayout != null) {
                attrLayout = pgLayout.getSectionAttr(null, idx);
            }
            if (pgMaster != null) {
                attrMaster = pgMaster.getSectionAttr(null, idx);
            }
            SectionAttr.instance().setSectionAttribute(txBody.element("bodyPr"), attr, attrLayout, attrMaster, false);
            int offset = ParaAttr.instance().processParagraph(control, pgMaster, pgLayout, null, secElem, sp.element("style"), txBody, type, idx);
            secElem.setEndOffset(offset);
            if (tb.getElement() != null && tb.getElement().getText(null) != null && tb.getElement().getText(null).length() > 0 && !"\n".equals(tb.getElement().getText(null))) {
                ReaderKit.instance().processRotation(tb, sp.element("txXfrm"));
            }
            if ((wrap = txBody.element("bodyPr")) != null) {
                String value = wrap.attributeValue("wrap");
                tb.setWrapLine(value == null || "square".equalsIgnoreCase(value));
            }
            return tb;
        }
        return null;
    }
}

