/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.HyperlinkReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.SchemeColorUtil;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGMaster;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.Font;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.FontTypefaceManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.Style;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.StyleManage;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.format.NumericFormatter;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class RunAttr {
    private static RunAttr kit = new RunAttr();
    private int maxFontSize = 0;
    private boolean table;
    private boolean slide;

    public static RunAttr instance() {
        return kit;
    }

    public int processRun(PGMaster pgMaster, ParagraphElement paraElem, Element p, IAttributeSet attrLayout, int offset, int fontScale, int styleID) {
        this.maxFontSize = 0;
        LeafElement leaf = null;
        Element pPr = p.element("pPr");
        if (p.elements("r").size() == 0 && p.elements("fld").size() == 0 && p.elements("br").size() == 0) {
            leaf = new LeafElement("\n");
            if (pPr != null) {
                pPr = pPr.element("rPr");
            }
            if (pPr == null) {
                pPr = p.element("endParaRPr");
            }
            this.setRunAttribute(pgMaster, pPr, leaf.getAttribute(), attrLayout, fontScale, styleID, true);
            this.setMaxFontSize(AttrManage.instance().getFontSize(paraElem.getAttribute(), leaf.getAttribute()));
            leaf.setStartOffset(offset);
            leaf.setEndOffset(++offset);
            paraElem.appendLeaf(leaf);
            return offset;
        }
        Iterator it = p.elementIterator();
        while (it.hasNext()) {
            int len;
            Element r = (Element)it.next();
            String name = r.getName();
            if (!name.equals("r") && !name.equals("fld") && !name.equals("br")) continue;
            String text = null;
            if (name.equals("fld") && r.attributeValue("type") != null && r.attributeValue("type").contains("datetime")) {
                text = NumericFormatter.instance().getFormatContents("yyyy/m/d", new Date(System.currentTimeMillis()));
            } else {
                Element t = r.element("t");
                if (name.equals("br")) {
                    text = String.valueOf('\u000b');
                } else if (t != null) {
                    text = t.getText();
                }
            }
            if (text == null || (len = (text = text.replace('\u00a0', ' ')).length()) <= 0) continue;
            leaf = new LeafElement(text);
            this.setRunAttribute(pgMaster, r.element("rPr"), leaf.getAttribute(), attrLayout, fontScale, styleID, "\n".equals(text));
            this.setMaxFontSize(AttrManage.instance().getFontSize(paraElem.getAttribute(), leaf.getAttribute()));
            leaf.setStartOffset(offset);
            leaf.setEndOffset(offset += len);
            paraElem.appendLeaf(leaf);
        }
        if (leaf != null) {
            leaf.setText(leaf.getText(null) + "\n");
            ++offset;
        }
        return offset;
    }

    private void setFontSize(IAttributeSet attrFrom, IAttributeSet attrTo) {
        if (attrFrom != null && AttrManage.instance().hasAttribute(attrFrom, (short)1)) {
            AttrManage.instance().setFontSize(attrTo, AttrManage.instance().getFontSize(null, attrFrom));
        }
    }

    private void setFontTypeface(IAttributeSet attrFrom, IAttributeSet attrTo) {
        if (attrFrom != null && AttrManage.instance().hasAttribute(attrFrom, (short)2)) {
            AttrManage.instance().setFontName(attrTo, AttrManage.instance().getFontName(null, attrFrom));
        }
    }

    private void setFontColor(IAttributeSet attrFrom, IAttributeSet attrTo) {
        if (attrFrom != null && AttrManage.instance().hasAttribute(attrFrom, (short)3)) {
            AttrManage.instance().setFontColor(attrTo, AttrManage.instance().getFontColor(null, attrFrom));
        }
    }

    private void setFontBold(IAttributeSet attrFrom, IAttributeSet attrTo) {
        if (attrFrom != null && AttrManage.instance().hasAttribute(attrFrom, (short)4)) {
            AttrManage.instance().setFontBold(attrTo, AttrManage.instance().getFontBold(null, attrFrom));
        }
    }

    private void setFontItalic(IAttributeSet attrFrom, IAttributeSet attrTo) {
        if (attrFrom != null && AttrManage.instance().hasAttribute(attrFrom, (short)5)) {
            AttrManage.instance().setFontItalic(attrTo, AttrManage.instance().getFontItalic(null, attrFrom));
        }
    }

    private void setFontStrike(IAttributeSet attrFrom, IAttributeSet attrTo) {
        if (attrFrom != null && AttrManage.instance().hasAttribute(attrFrom, (short)6)) {
            AttrManage.instance().setFontStrike(attrTo, AttrManage.instance().getFontStrike(null, attrFrom));
        }
    }

    private void setFontDoubleStrike(IAttributeSet attrFrom, IAttributeSet attrTo) {
        if (attrFrom != null && AttrManage.instance().hasAttribute(attrFrom, (short)7)) {
            AttrManage.instance().setFontDoubleStrike(attrTo, AttrManage.instance().getFontDoubleStrike(null, attrFrom));
        }
    }

    private void setFontUnderline(IAttributeSet attrFrom, IAttributeSet attrTo) {
        if (attrFrom != null && AttrManage.instance().hasAttribute(attrFrom, (short)8)) {
            AttrManage.instance().setFontUnderline(attrTo, AttrManage.instance().getFontUnderline(null, attrFrom));
            if (AttrManage.instance().hasAttribute(attrFrom, (short)9)) {
                AttrManage.instance().setFontUnderlineColr(attrTo, AttrManage.instance().getFontUnderlineColor(null, attrFrom));
            } else if (AttrManage.instance().hasAttribute(attrFrom, (short)3)) {
                AttrManage.instance().setFontUnderlineColr(attrTo, AttrManage.instance().getFontColor(null, attrFrom));
            }
        }
    }

    private void setFontScript(IAttributeSet attrFrom, IAttributeSet attrTo) {
        if (attrFrom != null && AttrManage.instance().hasAttribute(attrFrom, (short)10)) {
            AttrManage.instance().setFontScript(attrTo, AttrManage.instance().getFontScript(null, attrFrom));
        }
    }

    private void setHyperlinkID(IAttributeSet attrFrom, IAttributeSet attrTo) {
        if (attrFrom != null && AttrManage.instance().hasAttribute(attrFrom, (short)12)) {
            AttrManage.instance().setHyperlinkID(attrTo, AttrManage.instance().getHperlinkID(attrFrom));
        }
    }

    public void setRunAttribute(PGMaster master, Element rPr, IAttributeSet attr, IAttributeSet attrLayout, int fontScale, int styleID, boolean newLine) {
        if (rPr != null) {
            String val;
            if (rPr.attribute("sz") != null) {
                val = rPr.attributeValue("sz");
                if (val != null && val.length() > 0) {
                    AttrManage.instance().setFontSize(attr, (int)(Float.parseFloat(val) / 100.0f));
                }
            } else {
                this.setFontSize(attrLayout, attr);
            }
            if (!newLine) {
                Element temp = rPr.element("latin");
                if (temp != null || rPr.element("ea") != null) {
                    int index;
                    if (temp == null) {
                        temp = rPr.element("ea");
                    }
                    if ((val = temp.attributeValue("typeface")) != null && (index = FontTypefaceManage.instance().addFontName(val)) >= 0) {
                        AttrManage.instance().setFontName(attr, index);
                    }
                } else {
                    this.setFontTypeface(attrLayout, attr);
                }
                temp = rPr.element("solidFill");
                Integer fontColor = null;
                if (temp != null) {
                    fontColor = ReaderKit.instance().getColor(master, temp);
                    AttrManage.instance().setFontColor(attr, fontColor);
                } else {
                    temp = rPr.element("gradFill");
                    if (temp != null) {
                        Element gsLst = temp.element("gsLst");
                        if (gsLst != null) {
                            fontColor = ReaderKit.instance().getColor(master, gsLst.element("gs"));
                            AttrManage.instance().setFontColor(attr, fontColor);
                        }
                    } else {
                        this.setFontColor(attrLayout, attr);
                    }
                }
                if (rPr.attribute("b") != null) {
                    val = rPr.attributeValue("b");
                    if (val != null && val.length() > 0 && Integer.parseInt(val) > 0) {
                        AttrManage.instance().setFontBold(attr, true);
                    }
                } else {
                    this.setFontBold(attrLayout, attr);
                }
                if (rPr.attribute("i") != null) {
                    val = rPr.attributeValue("i");
                    if (val != null && val.length() > 0) {
                        AttrManage.instance().setFontItalic(attr, Integer.parseInt(val) > 0);
                    }
                } else {
                    this.setFontItalic(attrLayout, attr);
                }
                if (rPr.attribute("u") != null) {
                    val = rPr.attributeValue("u");
                    if (val != null && val.length() > 0 && !val.equalsIgnoreCase("none")) {
                        AttrManage.instance().setFontUnderline(attr, 1);
                        Element uFill = rPr.element("uFill");
                        if (uFill != null && (temp = uFill.element("solidFill")) != null) {
                            AttrManage.instance().setFontUnderlineColr(attr, ReaderKit.instance().getColor(master, temp));
                        } else if (fontColor != null) {
                            AttrManage.instance().setFontUnderlineColr(attr, fontColor);
                        }
                    }
                } else {
                    this.setFontUnderline(attrLayout, attr);
                }
                if (rPr.attribute("strike") != null) {
                    val = rPr.attributeValue("strike");
                    if (val.equals("dblStrike")) {
                        AttrManage.instance().setFontDoubleStrike(attr, true);
                    } else if (val.equals("sngStrike")) {
                        AttrManage.instance().setFontStrike(attr, true);
                    }
                } else {
                    this.setFontStrike(attrLayout, attr);
                    this.setFontDoubleStrike(attrLayout, attr);
                }
                if (rPr.attribute("baseline") != null) {
                    int value;
                    val = rPr.attributeValue("baseline");
                    if (val != null && val.length() > 0 && (value = Integer.parseInt(val)) != 0) {
                        AttrManage.instance().setFontScript(attr, value > 0 ? 1 : 2);
                    }
                } else {
                    this.setFontScript(attrLayout, attr);
                }
                if ((temp = rPr.element("hlinkClick")) != null) {
                    int color2 = -16776961;
                    if (master != null) {
                        color2 = master.getSchemeColor().get("hlink");
                    }
                    AttrManage.instance().setFontColor(attr, color2);
                    AttrManage.instance().setFontUnderline(attr, 1);
                    AttrManage.instance().setFontUnderlineColr(attr, color2);
                    val = temp.attributeValue("id");
                    if (val != null && val.length() > 0) {
                        AttrManage.instance().setHyperlinkID(attr, HyperlinkReader.instance().getLinkIndex(val));
                    }
                } else {
                    this.setHyperlinkID(attrLayout, attr);
                }
            }
        } else if (attrLayout != null) {
            this.setFontSize(attrLayout, attr);
            if (!newLine) {
                this.setFontTypeface(attrLayout, attr);
                this.setFontColor(attrLayout, attr);
                this.setFontBold(attrLayout, attr);
                this.setFontItalic(attrLayout, attr);
                this.setFontUnderline(attrLayout, attr);
                this.setFontStrike(attrLayout, attr);
                this.setFontDoubleStrike(attrLayout, attr);
                this.setFontScript(attrLayout, attr);
                this.setHyperlinkID(attrLayout, attr);
            }
        }
        AttrManage.instance().setFontScale(attr, fontScale);
        if (!AttrManage.instance().hasAttribute(attr, (short)1)) {
            Style style2 = StyleManage.instance().getStyle(styleID);
            if (style2 != null && style2.getAttrbuteSet() != null && AttrManage.instance().hasAttribute(style2.getAttrbuteSet(), (short)1)) {
                return;
            }
            if (!this.table && this.slide) {
                AttrManage.instance().setFontSize(attr, 18);
            }
        }
    }

    private int getRunPropColor(Workbook book, Element clr) {
        int color2 = -1;
        if (clr.attributeValue("indexed") != null) {
            String val = clr.attributeValue("indexed");
            color2 = book.getColor(Integer.parseInt(val));
        } else if (clr.attributeValue("theme") != null) {
            String val = clr.attributeValue("theme");
            color2 = SchemeColorUtil.getThemeColor(book, Integer.parseInt(val));
        } else if (clr.attributeValue("rgb") != null) {
            String val = clr.attributeValue("rgb");
            color2 = (int)Long.parseLong(val, 16);
        }
        if (clr.attributeValue("tint") != null) {
            double tint = Double.parseDouble(clr.attributeValue("tint"));
            color2 = ColorUtil.instance().getColorWithTint(color2, tint);
        }
        return color2;
    }

    public int getColor(Workbook book, Element solidFillElement) {
        int color2 = -1;
        if (solidFillElement.element("srgbClr") != null) {
            Element clr = solidFillElement.element("srgbClr");
            color2 = (int)Long.parseLong(clr.attributeValue("val"), 16);
            color2 = 0xFF000000 | color2;
        } else if (solidFillElement.element("schemeClr") != null) {
            String val;
            Element clr = solidFillElement.element("schemeClr");
            Map<String, Integer> schemeColor = SchemeColorUtil.getSchemeColor(book);
            color2 = schemeColor.get(clr.attributeValue("val"));
            if (clr.element("tint") != null) {
                color2 = ColorUtil.instance().getColorWithTint(color2, (double)Integer.parseInt(clr.element("tint").attributeValue("val")) / 100000.0);
            } else if (clr.element("lumOff") != null) {
                color2 = ColorUtil.instance().getColorWithTint(color2, (double)Integer.parseInt(clr.element("lumOff").attributeValue("val")) / 100000.0);
            } else if (clr.element("lumMod") != null) {
                color2 = ColorUtil.instance().getColorWithTint(color2, (double)Integer.parseInt(clr.element("lumMod").attributeValue("val")) / 100000.0 - 1.0);
            } else if (clr.element("shade") != null) {
                color2 = ColorUtil.instance().getColorWithTint(color2, (double)(-Integer.parseInt(clr.element("shade").attributeValue("val"))) / 200000.0);
            }
            if (clr.element("alpha") != null && (val = clr.element("alpha").attributeValue("val")) != null) {
                int alpha = (int)((float)Integer.parseInt(val) / 100000.0f * 255.0f);
                color2 = 0xFFFFFF & color2 | alpha << 24;
            }
        } else if (solidFillElement.element("sysClr") != null) {
            Element clr = solidFillElement.element("sysClr");
            color2 = Integer.parseInt(clr.attributeValue("lastClr"), 16);
            color2 = 0xFF000000 | color2;
        }
        return color2;
    }

    public void setRunAttribute(Sheet sheet, Element rPr, IAttributeSet attr, IAttributeSet attrLayout) {
        if (rPr != null) {
            Element temp;
            String val;
            if (rPr.attribute("sz") != null) {
                val = rPr.attributeValue("sz");
                if (val != null && val.length() > 0) {
                    AttrManage.instance().setFontSize(attr, (int)(Float.parseFloat(val) / 100.0f));
                }
            } else {
                this.setFontSize(attrLayout, attr);
            }
            if ((temp = rPr.element("solidFill")) != null) {
                AttrManage.instance().setFontColor(attr, this.getColor(sheet.getWorkbook(), temp));
            } else {
                this.setFontColor(attrLayout, attr);
            }
            if (rPr.attribute("b") != null) {
                AttrManage.instance().setFontBold(attr, Integer.parseInt(rPr.attributeValue("b")) == 1);
            } else {
                this.setFontBold(attrLayout, attr);
            }
            if (rPr.attribute("i") != null) {
                AttrManage.instance().setFontItalic(attr, Integer.parseInt(rPr.attributeValue("i")) == 1);
            } else {
                this.setFontItalic(attrLayout, attr);
            }
            if (rPr.attributeValue("u") != null && !rPr.attributeValue("u").equalsIgnoreCase("none")) {
                AttrManage.instance().setFontUnderline(attr, 1);
                Element uFill = rPr.element("uFill");
                if (uFill != null && (temp = uFill.element("solidFill")) != null) {
                    AttrManage.instance().setFontUnderlineColr(attr, this.getColor(sheet.getWorkbook(), temp));
                }
            } else {
                this.setFontUnderline(attrLayout, attr);
            }
            if (rPr.attribute("strike") != null) {
                val = rPr.attributeValue("strike");
                if (val.equals("dblStrike")) {
                    AttrManage.instance().setFontDoubleStrike(attr, true);
                } else if (val.equals("sngStrike")) {
                    AttrManage.instance().setFontStrike(attr, true);
                }
            } else {
                this.setFontStrike(attrLayout, attr);
                this.setFontDoubleStrike(attrLayout, attr);
            }
            if (rPr.attribute("baseline") != null) {
                val = rPr.attributeValue("baseline");
                if (val != null && !val.equalsIgnoreCase("0")) {
                    AttrManage.instance().setFontScript(attr, Integer.parseInt(val) > 0 ? 1 : 2);
                }
            } else {
                this.setFontScript(attrLayout, attr);
            }
            if ((temp = rPr.element("hlinkClick")) != null && temp.attribute("id") != null) {
                val = temp.attributeValue("id");
                if (val != null && val.length() > 0) {
                    AttrManage.instance().setFontColor(attr, -16776961);
                    AttrManage.instance().setFontUnderline(attr, 1);
                    AttrManage.instance().setFontUnderlineColr(attr, -16776961);
                    AttrManage.instance().setHyperlinkID(attr, HyperlinkReader.instance().getLinkIndex(val));
                }
            } else {
                this.setHyperlinkID(attrLayout, attr);
            }
        } else if (attrLayout != null) {
            this.setFontSize(attrLayout, attr);
            this.setFontColor(attrLayout, attr);
            this.setFontBold(attrLayout, attr);
            this.setFontItalic(attrLayout, attr);
            this.setFontUnderline(attrLayout, attr);
            this.setFontStrike(attrLayout, attr);
            this.setFontDoubleStrike(attrLayout, attr);
            this.setFontScript(attrLayout, attr);
            this.setHyperlinkID(attrLayout, attr);
        }
    }

    public void setRunAttribute(Workbook book, int fontID, Element rPr, IAttributeSet attr, IAttributeSet attrLayout) {
        if (rPr != null) {
            String val;
            Element temp = rPr.element("sz");
            if (temp != null) {
                val = temp.attributeValue("val");
                if (val != null && val.length() > 0) {
                    AttrManage.instance().setFontSize(attr, (int)Float.parseFloat(val));
                }
            } else {
                this.setFontSize(attrLayout, attr);
            }
            if ((temp = rPr.element("color")) != null) {
                AttrManage.instance().setFontColor(attr, this.getRunPropColor(book, temp));
            } else {
                this.setFontColor(attrLayout, attr);
            }
            temp = rPr.element("b");
            if (temp != null) {
                AttrManage.instance().setFontBold(attr, true);
            } else {
                this.setFontBold(attrLayout, attr);
            }
            temp = rPr.element("i");
            if (temp != null) {
                AttrManage.instance().setFontItalic(attr, true);
            } else {
                this.setFontItalic(attrLayout, attr);
            }
            temp = rPr.element("u");
            if (temp != null) {
                AttrManage.instance().setFontUnderline(attr, 1);
            } else {
                this.setFontUnderline(attrLayout, attr);
            }
            temp = rPr.element("strike");
            if (temp != null) {
                AttrManage.instance().setFontStrike(attr, true);
                this.setFontDoubleStrike(attrLayout, attr);
            } else {
                this.setFontStrike(attrLayout, attr);
                this.setFontDoubleStrike(attrLayout, attr);
            }
            temp = rPr.element("vertAlign");
            if (temp != null) {
                val = temp.attributeValue("val");
                if (val.equalsIgnoreCase("superscript")) {
                    AttrManage.instance().setFontScript(attr, 1);
                } else if (val.equalsIgnoreCase("subscript")) {
                    AttrManage.instance().setFontScript(attr, 2);
                } else {
                    AttrManage.instance().setFontScript(attr, 0);
                }
            } else {
                this.setFontScript(attrLayout, attr);
            }
            this.setHyperlinkID(attrLayout, attr);
        } else if (attrLayout != null) {
            Font font = book.getFont(fontID);
            if (font != null) {
                AttrManage.instance().setFontSize(attr, (int)font.getFontSize());
                AttrManage.instance().setFontColor(attr, book.getColor(font.getColorIndex()));
                AttrManage.instance().setFontBold(attr, font.isBold());
                AttrManage.instance().setFontItalic(attr, font.isItalic());
                AttrManage.instance().setFontUnderline(attr, font.getUnderline());
                AttrManage.instance().setFontStrike(attr, font.isStrikeline());
                this.setFontDoubleStrike(attrLayout, attr);
                AttrManage.instance().setFontScript(attr, font.getSuperSubScript());
                this.setHyperlinkID(attrLayout, attr);
            } else {
                this.setFontSize(attrLayout, attr);
                this.setFontColor(attrLayout, attr);
                this.setFontBold(attrLayout, attr);
                this.setFontItalic(attrLayout, attr);
                this.setFontUnderline(attrLayout, attr);
                this.setFontStrike(attrLayout, attr);
                this.setFontDoubleStrike(attrLayout, attr);
                this.setFontScript(attrLayout, attr);
                this.setHyperlinkID(attrLayout, attr);
            }
        }
    }

    public void setRunAttribute(Sheet sheet, Cell cell, IAttributeSet attr, IAttributeSet attrLayout) {
        if (cell != null) {
            CellStyle style2 = cell.getCellStyle();
            Workbook book = sheet.getWorkbook();
            Font font = book.getFont(style2.getFontIndex());
            AttrManage.instance().setFontSize(attr, (int)(font.getFontSize() + 0.5));
            AttrManage.instance().setFontColor(attr, book.getColor(font.getColorIndex()));
            AttrManage.instance().setFontBold(attr, font.isBold());
            AttrManage.instance().setFontItalic(attr, font.isItalic());
            AttrManage.instance().setFontUnderline(attr, font.getUnderline());
            AttrManage.instance().setFontStrike(attr, font.isStrikeline());
        } else if (attrLayout != null) {
            this.setFontSize(attrLayout, attr);
            this.setFontColor(attrLayout, attr);
            this.setFontBold(attrLayout, attr);
            this.setFontItalic(attrLayout, attr);
            this.setFontUnderline(attrLayout, attr);
            this.setFontStrike(attrLayout, attr);
            this.setFontDoubleStrike(attrLayout, attr);
            this.setFontScript(attrLayout, attr);
            this.setHyperlinkID(attrLayout, attr);
        }
    }

    public void setRunAttribute(Sheet sheet, Font font, IAttributeSet attr, IAttributeSet attrLayout) {
        if (font != null) {
            Workbook book = sheet.getWorkbook();
            AttrManage.instance().setFontSize(attr, (int)(font.getFontSize() + 0.5));
            AttrManage.instance().setFontColor(attr, book.getColor(font.getColorIndex()));
            AttrManage.instance().setFontBold(attr, font.isBold());
            AttrManage.instance().setFontItalic(attr, font.isItalic());
            AttrManage.instance().setFontUnderline(attr, font.getUnderline());
            AttrManage.instance().setFontStrike(attr, font.isStrikeline());
        } else if (attrLayout != null) {
            this.setFontSize(attrLayout, attr);
            this.setFontColor(attrLayout, attr);
            this.setFontBold(attrLayout, attr);
            this.setFontItalic(attrLayout, attr);
            this.setFontUnderline(attrLayout, attr);
            this.setFontStrike(attrLayout, attr);
            this.setFontDoubleStrike(attrLayout, attr);
            this.setFontScript(attrLayout, attr);
            this.setHyperlinkID(attrLayout, attr);
        }
    }

    public int getMaxFontSize() {
        return this.maxFontSize;
    }

    public void setMaxFontSize(int size) {
        if (size > this.maxFontSize) {
            this.maxFontSize = size;
        }
    }

    public void resetMaxFontSize() {
        this.maxFontSize = 0;
    }

    public void setTable(boolean table) {
        this.table = table;
    }

    public void setSlide(boolean slide) {
        this.slide = slide;
    }

    public boolean isTable() {
        return this.table;
    }

    public boolean isSlide() {
        return this.slide;
    }

    public void dispose() {
        this.maxFontSize = 0;
    }
}

