/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt;

import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ArbitraryPolygonShapePath;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeTypes;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfo;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfoFactory;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AChart;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.ArbitraryPolygonShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.Arrow;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.GroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.LineShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.SmartArt;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TableShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.fc.LineKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.RunAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.SectionAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.BackgroundReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.PictureReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.TableReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.drawing.ChartReader;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGLayout;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGMaster;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGPlaceholderUtil;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGStyle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ShapeManage {
    private static ShapeManage kit = new ShapeManage();

    public static ShapeManage instance() {
        return kit;
    }

    public Integer processShape(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGModel pgModel, PGMaster pgMaster, PGLayout pgLayout, PGStyle defaultStyle, PGSlide pgSlide, byte slideType, Element sp, GroupShape parent, float zoomX, float zoomY) throws Exception {
        if (ReaderKit.instance().isHidden(sp)) {
            return null;
        }
        boolean addShape = packagePart.getPartName().getName().contains("/ppt/slides/");
        addShape = addShape || !addShape && ReaderKit.instance().isUserDrawn(sp);
        RunAttr.instance().setSlide(addShape);
        String name = sp.getName();
        if (name.equals("sp") || name.equals("cxnSp")) {
            return this.processAutoShapeAndTextShape(control, zipPackage, packagePart, pgModel, pgMaster, pgLayout, defaultStyle, pgSlide, slideType, sp, parent, zoomX, zoomY, addShape);
        }
        if (name.equals("pic")) {
            if (addShape) {
                return this.processPicture(control, zipPackage, packagePart, pgMaster, pgLayout, pgSlide, sp, parent, zoomX, zoomY);
            }
        } else if (name.equals("graphicFrame")) {
            if (addShape) {
                return this.processGraphicFrame(control, zipPackage, packagePart, pgModel, pgMaster, pgLayout, pgSlide, sp, parent, zoomX, zoomY);
            }
        } else {
            Element choice;
            if (name.equals("grpSp")) {
                Element e = sp.element("nvGrpSpPr");
                int grpShapeID = 0;
                if (e != null && (e = e.element("cNvPr")) != null) {
                    grpShapeID = Integer.parseInt(e.attributeValue("id"));
                }
                GroupShape groupShape = null;
                float[] zoomXY = null;
                Element grpSpPr = sp.element("grpSpPr");
                if (grpSpPr != null) {
                    Rectangle rect = null;
                    Rectangle childRect = null;
                    rect = ReaderKit.instance().getShapeAnchor(grpSpPr.element("xfrm"), zoomX, zoomY);
                    rect = this.processGrpSpRect(parent, rect);
                    zoomXY = ReaderKit.instance().getAnchorFitZoom(grpSpPr.element("xfrm"));
                    childRect = ReaderKit.instance().getChildShapeAnchor(grpSpPr.element("xfrm"), zoomXY[0] * zoomX, zoomXY[1] * zoomY);
                    groupShape = new GroupShape();
                    groupShape.setOffPostion(rect.x - childRect.x, rect.y - childRect.y);
                    groupShape.setShapeID(grpShapeID);
                    groupShape.setBounds(rect);
                    groupShape.setParent(parent);
                    this.processGrpRotation(parent, groupShape, grpSpPr);
                }
                ArrayList<Integer> childShapeLst = new ArrayList<Integer>();
                Iterator it = sp.elementIterator();
                while (it.hasNext()) {
                    Integer shapeId = this.processShape(control, zipPackage, packagePart, pgModel, pgMaster, pgLayout, defaultStyle, pgSlide, slideType, (Element)it.next(), groupShape, zoomXY[0] * zoomX, zoomXY[1] * zoomY);
                    if (shapeId == null) continue;
                    childShapeLst.add(shapeId);
                }
                if (parent == null) {
                    pgSlide.appendShapes(groupShape);
                } else {
                    parent.appendShapes(groupShape);
                }
                pgSlide.addGroupShape(grpShapeID, childShapeLst);
                return grpShapeID;
            }
            if (name.equals("AlternateContent") && (choice = sp.element("Fallback")) != null) {
                Iterator it = choice.elementIterator();
                while (it.hasNext()) {
                    this.processShape(control, zipPackage, packagePart, pgModel, pgMaster, pgLayout, defaultStyle, pgSlide, slideType, (Element)it.next(), parent, zoomX, zoomY);
                }
            }
        }
        RunAttr.instance().setSlide(false);
        return null;
    }

    public int processAutoShapeAndTextShape(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGModel pgModel, PGMaster pgMaster, PGLayout pgLayout, PGStyle defaultStyle, PGSlide pgSlide, byte slideType, Element sp, GroupShape parent, float zoomX, float zoomY, boolean addShape) throws Exception {
        int id2 = 0;
        Element temp = sp.element("nvSpPr");
        if (temp == null) {
            temp = sp.element("nvCxnSpPr");
        }
        temp = temp.element("cNvPr");
        id2 = Integer.parseInt(temp.attributeValue("id"));
        String type = ReaderKit.instance().getPlaceholderType(sp);
        int idx = ReaderKit.instance().getPlaceholderIdx(sp);
        if (slideType == 1) {
            pgLayout.addShapeType(idx, type);
        } else if (type == null && pgMaster != null && idx >= 0) {
            type = pgLayout.getShapeType(idx);
        }
        int placeHolderID = -1;
        if (PGPlaceholderUtil.instance().isTitleOrBody(type)) {
            if (slideType == 0) {
                pgMaster.addTitleBodyID(idx, idx);
            } else if (slideType == 1) {
                pgLayout.addTitleBodyID(idx, id2);
            }
        } else if ((slideType == 0 || slideType == 1) && ReaderKit.instance().isUserDrawn(sp)) {
            placeHolderID = 0;
        }
        Rectangle rect = null;
        temp = sp.element("spPr");
        if (temp != null) {
            rect = ReaderKit.instance().getShapeAnchor(temp.element("xfrm"), zoomX, zoomY);
        }
        if (rect == null && pgLayout != null && (rect = pgLayout.getAnchor(type, idx)) == null && pgMaster != null) {
            rect = pgMaster.getAnchor(type, idx);
        }
        if (rect != null) {
            rect = this.processGrpSpRect(parent, rect);
            AbstractShape shape = null;
            if (addShape || !addShape && !PGPlaceholderUtil.instance().isHeaderFooter(type)) {
                shape = this.processAutoShape(control, zipPackage, packagePart, pgModel, pgMaster, pgLayout, pgSlide, sp, id2, idx, rect, this.isRect(type, idx), parent, slideType, type, !addShape && PGPlaceholderUtil.instance().isTitleOrBody(type));
            }
            if (shape != null) {
                if (parent == null) {
                    pgSlide.appendShapes(shape);
                } else {
                    parent.appendShapes(shape);
                }
                shape.setPlaceHolderID(placeHolderID);
                this.processGrpRotation(parent, shape, sp.element("spPr"));
            }
            if ((temp = sp.element("txBody")) != null && addShape) {
                TextBox tb = new TextBox();
                tb.setBounds(rect);
                tb.setPlaceHolderID(placeHolderID);
                tb.setShapeID(id2);
                SectionElement secElem = new SectionElement();
                secElem.setStartOffset(0L);
                tb.setElement(secElem);
                IAttributeSet attr = secElem.getAttribute();
                AttrManage.instance().setPageWidth(attr, (int)((float)rect.width * 15.0f));
                AttrManage.instance().setPageHeight(attr, (int)((float)rect.height * 15.0f));
                IAttributeSet attrLayout = null;
                IAttributeSet attrMaster = null;
                if (pgLayout != null) {
                    attrLayout = pgLayout.getSectionAttr(type, idx);
                }
                if (pgMaster != null) {
                    attrMaster = pgMaster.getSectionAttr(type, idx);
                }
                SectionAttr.instance().setSectionAttribute(temp.element("bodyPr"), attr, attrLayout, attrMaster, false);
                int offset = ParaAttr.instance().processParagraph(control, pgMaster, pgLayout, defaultStyle, secElem, sp.element("style"), temp, type, idx);
                secElem.setEndOffset(offset);
                if (tb.getElement() != null && tb.getElement().getText(null) != null && tb.getElement().getText(null).length() > 0 && !"\n".equals(tb.getElement().getText(null))) {
                    this.processGrpRotation(parent, tb, sp.element("spPr"));
                    if (parent == null) {
                        pgSlide.appendShapes(tb);
                    } else {
                        parent.appendShapes(tb);
                    }
                } else if (shape != null) {
                    this.processGrpRotation(parent, shape, sp.element("spPr"));
                }
                Element wrap = temp.element("bodyPr");
                if (wrap != null) {
                    String value = wrap.attributeValue("wrap");
                    tb.setWrapLine(value == null || "square".equalsIgnoreCase(value));
                }
            }
        }
        return id2;
    }

    public int processPicture(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGMaster pgMaster, PGLayout pgLayout, PGSlide pgSlide, Element sp, GroupShape parent, float zoomX, float zoomY) throws Exception {
        Element spPr;
        String id2;
        Element blip;
        Element fallback;
        Element alternateContent;
        Element blipFill;
        Element e = sp.element("nvPicPr");
        int shapeID = 0;
        if (e != null && (e = e.element("cNvPr")) != null) {
            shapeID = Integer.parseInt(e.attributeValue("id"));
        }
        if ((blipFill = sp.element("blipFill")) == null && (alternateContent = sp.element("AlternateContent")) != null && (fallback = alternateContent.element("Fallback")) != null) {
            blipFill = fallback.element("blipFill");
        }
        if (blipFill != null && (blip = blipFill.element("blip")) != null && blip.attribute("embed") != null && (id2 = blip.attributeValue("embed")) != null && (spPr = sp.element("spPr")) != null) {
            int idx;
            String type;
            Rectangle rect = ReaderKit.instance().getShapeAnchor(spPr.element("xfrm"), zoomX, zoomY);
            if (rect == null && pgLayout != null && (rect = pgLayout.getAnchor(type = ReaderKit.instance().getPlaceholderType(sp), idx = ReaderKit.instance().getPlaceholderIdx(sp))) == null && pgMaster != null) {
                rect = pgMaster.getAnchor(type, idx);
            }
            if (rect != null) {
                rect = this.processGrpSpRect(parent, rect);
                PackageRelationship imageShip = packagePart.getRelationship(id2);
                if (imageShip != null) {
                    BackgroundAndFill fill = BackgroundReader.instance().processBackground(control, zipPackage, packagePart, pgMaster, spPr);
                    Line line = LineKit.createShapeLine(control, zipPackage, packagePart, pgMaster, sp);
                    PackagePart picPart = zipPackage.getPart(imageShip.getTargetURI());
                    PictureShape picShape = this.addPicture(control, picPart, pgSlide, shapeID, rect, sp.element("spPr"), parent, PictureEffectInfoFactory.getPictureEffectInfor(blipFill));
                    if (picShape != null) {
                        picShape.setBackgroundAndFill(fill);
                        picShape.setLine(line);
                    }
                }
            }
        }
        return shapeID;
    }

    public PictureShape addPicture(IControl control, PackagePart picPart, PGSlide pgSlide, int shapeID, Rectangle rect, Element spPr, GroupShape parent, PictureEffectInfo effectInfor) throws Exception {
        PictureShape picShape = null;
        if (picPart != null) {
            picShape = new PictureShape();
            picShape.setPictureIndex(control.getSysKit().getPictureManage().addPicture(picPart));
            picShape.setBounds(rect);
            this.processGrpRotation(parent, picShape, spPr);
            picShape.setShapeID(shapeID);
            picShape.setPictureEffectInfor(effectInfor);
            if (parent == null) {
                pgSlide.appendShapes(picShape);
            } else {
                parent.appendShapes(picShape);
            }
        }
        return picShape;
    }

    public int processGraphicFrame(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGModel pgModel, PGMaster pgMaster, PGLayout pgLayout, PGSlide pgSlide, Element sp, GroupShape parent, float zoomX, float zoomY) throws Exception {
        int idx;
        String type;
        Element nvGraphicFramePr = sp.element("nvGraphicFramePr");
        int shapeId = 0;
        if (nvGraphicFramePr != null && (nvGraphicFramePr = nvGraphicFramePr.element("cNvPr")) != null) {
            shapeId = Integer.parseInt(nvGraphicFramePr.attributeValue("id"));
        }
        Element xfrm = sp.element("xfrm");
        Rectangle rect = ReaderKit.instance().getShapeAnchor(xfrm, zoomX, zoomY);
        if (rect == null && pgLayout != null && (rect = pgLayout.getAnchor(type = ReaderKit.instance().getPlaceholderType(sp), idx = ReaderKit.instance().getPlaceholderIdx(sp))) == null && pgMaster != null) {
            rect = pgMaster.getAnchor(type, idx);
        }
        if (rect != null) {
            Element graphicData;
            rect = this.processGrpSpRect(parent, rect);
            Element graphic = sp.element("graphic");
            if (graphic != null && (graphicData = graphic.element("graphicData")) != null && graphicData.attribute("uri") != null) {
                String uri = graphicData.attributeValue("uri");
                if (uri.equals("http://schemas.openxmlformats.org/presentationml/2006/ole")) {
                    Element oleObj = graphicData.element("oleObj");
                    if (oleObj == null) {
                        Element pic;
                        Element fallback;
                        Element alternateContent = graphicData.element("AlternateContent");
                        if (alternateContent != null && (fallback = alternateContent.element("Fallback")) != null && (oleObj = fallback.element("oleObj")) != null && (pic = oleObj.element("pic")) != null) {
                            this.processPicture(control, zipPackage, packagePart, pgMaster, pgLayout, pgSlide, pic, parent, zoomX, zoomY);
                        }
                    } else if (oleObj.attribute("spid") != null) {
                        String spid = oleObj.attributeValue("spid");
                        PackagePart picPart = PictureReader.instance().getOLEPart(zipPackage, packagePart, spid, false);
                        this.addPicture(control, picPart, pgSlide, shapeId, rect, sp.element("spPr"), parent, null);
                    }
                } else if (uri.equals("http://schemas.openxmlformats.org/drawingml/2006/chart")) {
                    String id2;
                    PackageRelationship ship;
                    Element chart = graphicData.element("chart");
                    if (chart != null && chart.attribute("id") != null && (ship = packagePart.getRelationship(id2 = chart.attributeValue("id"))) != null) {
                        PackagePart chartPart = zipPackage.getPart(ship.getTargetURI());
                        AbstractChart abstrChart = ChartReader.instance().read(control, zipPackage, chartPart, pgMaster.getSchemeColor(), (byte)2);
                        if (abstrChart != null) {
                            AChart shape = new AChart();
                            shape.setAChart(abstrChart);
                            shape.setBounds(rect);
                            shape.setShapeID(shapeId);
                            pgSlide.appendShapes(shape);
                        }
                    }
                } else if (uri.equals("http://schemas.openxmlformats.org/drawingml/2006/table")) {
                    TableShape table;
                    Element temp;
                    Element tbl = graphicData.element("tbl");
                    if (tbl != null && (temp = tbl.element("tblPr")) != null && (table = TableReader.instance().getTable(control, zipPackage, packagePart, pgModel, pgMaster, tbl, rect)) != null) {
                        table.setBounds(rect);
                        table.setShapeID(shapeId);
                        pgSlide.appendShapes(table);
                    }
                } else if (uri.equals("http://schemas.openxmlformats.org/drawingml/2006/diagram")) {
                    this.processSmartArt(pgSlide, graphicData, rect);
                }
            }
        }
        return shapeId;
    }

    private Rectangle processGrpSpRect(GroupShape parent, Rectangle rect) {
        if (parent != null) {
            rect.x += parent.getOffX();
            rect.y += parent.getOffY();
        }
        return rect;
    }

    private void processGrpRotation(IShape parent, IShape shape, Element spPr) {
        ReaderKit.instance().processRotation(spPr, shape);
    }

    private boolean isRect(String type, int idx) {
        if (type != null && (type.contains("Title") || type.contains("title") || type.contains("ctrTitle") || type.contains("subTitle") || type.contains("body") || type.contains("body") || type.contains("half") || type.contains("dt") || type.contains("ftr") || type.contains("sldNum"))) {
            return true;
        }
        return idx > 0;
    }

    private BackgroundAndFill getBackgrouond(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGModel pgModel, PGMaster pgMaster, PGLayout pgLayout, PGSlide pgSlide, Element sp, int shapeIDX, byte slideType, String phType, int shapeType) throws Exception {
        int i;
        IShape[] shapes;
        String val;
        BackgroundAndFill fill = null;
        if (sp.attribute("useBgFill") != null && (val = sp.attributeValue("useBgFill")) != null && val.length() > 0 && "1".equals(val)) {
            fill = pgSlide.getBackgroundAndFill();
            if (fill == null) {
                if (pgLayout != null) {
                    fill = pgLayout.getBackgroundAndFill();
                }
                if (fill == null && pgMaster != null) {
                    fill = pgMaster.getBackgroundAndFill();
                }
            }
            if (fill != null) {
                fill.setSlideBackgroundFill(true);
            }
            return fill;
        }
        Element spPr = sp.element("spPr");
        String spName = sp.getName();
        if (fill == null && spPr.element("noFill") == null && !spName.equals("cxnSp") && (fill = BackgroundReader.instance().processBackground(control, zipPackage, packagePart, pgMaster, spPr)) == null && shapeType != 19 && shapeType != 185 && shapeType != 85 && shapeType != 86 && shapeType != 186 && shapeType != 87 && shapeType != 88 && shapeType != 233 && (fill = BackgroundReader.instance().processBackground(control, zipPackage, packagePart, pgMaster, sp.element("style"))) != null && fill.getFillType() == 0 && (fill.getForegroundColor() & 0xFFFFFF) == 0) {
            fill = null;
        }
        Integer shapeID = null;
        if (fill == null && slideType == 2 && PGPlaceholderUtil.instance().isTitleOrBody(phType) && pgLayout != null && pgLayout.getSlideMasterIndex() >= 0 && shapeIDX >= 0) {
            PGSlide layoutSlide = pgModel.getSlideMaster(pgLayout.getSlideMasterIndex());
            shapeID = pgLayout.getTitleBodyID(shapeIDX);
            if (shapeID != null) {
                shapes = layoutSlide.getShapes();
                for (i = 0; i < shapes.length; ++i) {
                    if (shapeID.intValue() != shapes[i].getShapeID() || !(shapes[i] instanceof AutoShape)) continue;
                    fill = ((AutoShape)shapes[i]).getBackgroundAndFill();
                    break;
                }
            }
        }
        if (fill == null && slideType == 2 && pgMaster != null && pgMaster.getSlideMasterIndex() >= 0 && shapeIDX >= 0) {
            PGSlide masterSlide = pgModel.getSlideMaster(pgMaster.getSlideMasterIndex());
            shapes = masterSlide.getShapes();
            if (pgMaster.getTitleBodyID(shapeIDX) != null && (shapeID = pgMaster.getTitleBodyID(shapeIDX)) != null) {
                for (i = 0; i < shapes.length; ++i) {
                    if (shapeID.intValue() != shapes[i].getShapeID() || !(shapes[i] instanceof AutoShape)) continue;
                    fill = ((AutoShape)shapes[i]).getBackgroundAndFill();
                    break;
                }
            }
        }
        return fill;
    }

    public AbstractShape processAutoShape(IControl control, ZipPackage zipPackage, PackagePart packagePart, PGModel pgModel, PGMaster pgMaster, PGLayout pgLayout, PGSlide pgSlide, Element sp, int id2, int idx, Rectangle rect, boolean isRect, GroupShape parent, byte slideType, String phType, boolean hidden) throws Exception {
        AutoShape shape = null;
        int shapeType = 0;
        Element spPr = sp.element("spPr");
        if (spPr != null) {
            Float[] values = null;
            boolean border = true;
            String name = ReaderKit.instance().getPlaceholderName(sp);
            String spName = sp.getName();
            if (spName.equals("cxnSp")) {
                border = true;
                shapeType = 32;
            } else if (isRect || name.contains("Text Box") || name.contains("TextBox")) {
                shapeType = 1;
            }
            Element prstGeom = spPr.element("prstGeom");
            if (prstGeom != null) {
                List gds;
                Element avLst;
                String val;
                if (prstGeom.attribute("prst") != null && (val = prstGeom.attributeValue("prst")) != null && val.length() > 0) {
                    shapeType = AutoShapeTypes.instance().getAutoShapeType(val);
                }
                if ((avLst = prstGeom.element("avLst")) != null && (gds = avLst.elements("gd")).size() > 0) {
                    values = new Float[gds.size()];
                    for (int i = 0; i < gds.size(); ++i) {
                        Element gd = (Element)gds.get(i);
                        val = gd.attributeValue("fmla");
                        val = val.substring(4);
                        values[i] = Float.valueOf(Float.parseFloat(val) / 100000.0f);
                    }
                }
            } else if (spPr.element("custGeom") != null) {
                shapeType = 233;
            } else if (isRect) {
                shapeType = 1;
            }
            BackgroundAndFill fill = this.getBackgrouond(control, zipPackage, packagePart, pgModel, pgMaster, pgLayout, pgSlide, sp, idx, slideType, phType, shapeType);
            Line line = LineKit.createShapeLine(control, zipPackage, packagePart, pgMaster, sp);
            Element ln = spPr.element("ln");
            Element style2 = sp.element("style");
            if (ln != null) {
                if (ln.element("noFill") != null) {
                    border = false;
                }
            } else if (border && (style2 == null || style2.element("lnRef") == null)) {
                border = false;
            }
            if (shapeType == 20 || shapeType == 32 || shapeType == 33 || shapeType == 34 || shapeType == 37 || shapeType == 38 || shapeType == 39 || shapeType == 40) {
                if (!border) {
                    return shape;
                }
                LineShape lineShape = new LineShape();
                lineShape.setShapeType(shapeType);
                lineShape.setBounds(rect);
                lineShape.setShapeID(id2);
                lineShape.setHidden(hidden);
                lineShape.setAdjustData(values);
                lineShape.setLine(line);
                if (ln != null) {
                    byte arrowType;
                    Element temp = ln.element("headEnd");
                    if (temp != null && temp.attribute("type") != null && (arrowType = Arrow.getArrowType(temp.attributeValue("type"))) != 0) {
                        lineShape.createStartArrow(arrowType, Arrow.getArrowSize(temp.attributeValue("w")), Arrow.getArrowSize(temp.attributeValue("len")));
                    }
                    if ((temp = ln.element("tailEnd")) != null && temp.attribute("type") != null && (arrowType = Arrow.getArrowType(temp.attributeValue("type"))) != 0) {
                        lineShape.createEndArrow(arrowType, Arrow.getArrowSize(temp.attributeValue("w")), Arrow.getArrowSize(temp.attributeValue("len")));
                    }
                }
                shape = lineShape;
                return shape;
            }
            if (shapeType == 233) {
                ArbitraryPolygonShape arbitraryPolygonShape = new ArbitraryPolygonShape();
                BackgroundAndFill lineFill = null;
                if (line != null) {
                    lineFill = line.getBackgroundAndFill();
                }
                ArbitraryPolygonShapePath.processArbitraryPolygonShape(arbitraryPolygonShape, sp, fill, border, lineFill, ln, rect);
                arbitraryPolygonShape.setShapeType(shapeType);
                arbitraryPolygonShape.setShapeID(id2);
                this.processGrpRotation(parent, arbitraryPolygonShape, spPr);
                arbitraryPolygonShape.setHidden(hidden);
                arbitraryPolygonShape.setLine(line);
                shape = arbitraryPolygonShape;
                return shape;
            }
            if (fill != null || line != null) {
                AutoShape autoShape = new AutoShape(shapeType);
                autoShape.setBounds(rect);
                autoShape.setShapeID(id2);
                autoShape.setHidden(hidden);
                if (fill != null) {
                    autoShape.setBackgroundAndFill(fill);
                }
                if (line != null) {
                    autoShape.setLine(line);
                }
                autoShape.setAdjustData(values);
                shape = autoShape;
                return shape;
            }
        }
        return shape;
    }

    private void processSmartArt(PGSlide pgslide, Element graphicData, Rectangle rect) {
        try {
            if (graphicData != null) {
                SmartArt smartArt;
                Element relIds = graphicData.element("relIds");
                String cs = relIds.attributeValue("dm");
                int id2 = Integer.parseInt(cs.substring("rId".length()));
                if (cs != null && (smartArt = pgslide.getSmartArt(cs)) != null) {
                    IShape[] shapes;
                    smartArt.setBounds(rect);
                    for (IShape shape : shapes = smartArt.getShapes()) {
                        shape.setShapeID(id2);
                    }
                    pgslide.appendShapes(smartArt);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

