/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage;

import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.common.POIFSBigBlockSize;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.BATManaged;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.BATBlock;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.BlockWritable;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.HeaderBlockWriter;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.IntList;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class BlockAllocationTableWriter
implements BlockWritable,
BATManaged {
    private IntList _entries;
    private BATBlock[] _blocks;
    private int _start_block;
    private POIFSBigBlockSize _bigBlockSize;

    public BlockAllocationTableWriter(POIFSBigBlockSize bigBlockSize) {
        this._bigBlockSize = bigBlockSize;
        this._start_block = -2;
        this._entries = new IntList();
        this._blocks = new BATBlock[0];
    }

    public int createBlocks() {
        int xbat_blocks = 0;
        int bat_blocks = 0;
        while (true) {
            int calculated_bat_blocks = BATBlock.calculateStorageRequirements(this._bigBlockSize, bat_blocks + xbat_blocks + this._entries.size());
            int calculated_xbat_blocks = HeaderBlockWriter.calculateXBATStorageRequirements(this._bigBlockSize, calculated_bat_blocks);
            if (bat_blocks == calculated_bat_blocks && xbat_blocks == calculated_xbat_blocks) break;
            bat_blocks = calculated_bat_blocks;
            xbat_blocks = calculated_xbat_blocks;
        }
        int startBlock = this.allocateSpace(bat_blocks);
        this.allocateSpace(xbat_blocks);
        this.simpleCreateBlocks();
        return startBlock;
    }

    public int allocateSpace(int blockCount) {
        int startBlock = this._entries.size();
        if (blockCount > 0) {
            int limit = blockCount - 1;
            int index = startBlock + 1;
            for (int k = 0; k < limit; ++k) {
                this._entries.add(index++);
            }
            this._entries.add(-2);
        }
        return startBlock;
    }

    public int getStartBlock() {
        return this._start_block;
    }

    void simpleCreateBlocks() {
        this._blocks = BATBlock.createBATBlocks(this._bigBlockSize, this._entries.toArray());
    }

    @Override
    public void writeBlocks(OutputStream stream) throws IOException {
        for (int j = 0; j < this._blocks.length; ++j) {
            this._blocks[j].writeBlocks(stream);
        }
    }

    public static void writeBlock(BATBlock bat, ByteBuffer block) throws IOException {
        bat.writeData(block);
    }

    @Override
    public int countBlocks() {
        return this._blocks.length;
    }

    @Override
    public void setStartBlock(int start_block) {
        this._start_block = start_block;
    }
}

