/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.poifs.property;

import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.common.POIFSBigBlockSize;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.NPOIFSFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.NPOIFSStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.property.Property;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.property.PropertyFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.property.PropertyTableBase;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.HeaderBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class NPropertyTable
extends PropertyTableBase {
    private POIFSBigBlockSize _bigBigBlockSize;

    public NPropertyTable(HeaderBlock headerBlock) {
        super(headerBlock);
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
    }

    public NPropertyTable(HeaderBlock headerBlock, NPOIFSFileSystem filesystem) throws IOException {
        super(headerBlock, NPropertyTable.buildProperties(new NPOIFSStream(filesystem, headerBlock.getPropertyStart()).iterator(), headerBlock.getBigBlockSize()));
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
    }

    private static List<Property> buildProperties(Iterator<ByteBuffer> dataSource, POIFSBigBlockSize bigBlockSize) throws IOException {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (dataSource.hasNext()) {
            byte[] data;
            ByteBuffer bb = dataSource.next();
            if (bb.hasArray() && bb.arrayOffset() == 0 && bb.array().length == bigBlockSize.getBigBlockSize()) {
                data = bb.array();
            } else {
                data = new byte[bigBlockSize.getBigBlockSize()];
                bb.get(data, 0, data.length);
            }
            PropertyFactory.convertToProperties(data, properties);
        }
        return properties;
    }

    @Override
    public int countBlocks() {
        int size = this._properties.size() * 128;
        return (int)Math.ceil(size / this._bigBigBlockSize.getBigBlockSize());
    }

    public void write(NPOIFSStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Property property : this._properties) {
            if (property == null) continue;
            property.writeData(baos);
        }
        stream.updateContents(baos.toByteArray());
        if (this.getStartBlock() != stream.getStartBlock()) {
            this.setStartBlock(stream.getStartBlock());
        }
    }
}

